#region License
/* 
 * Copyright (C) 1999-2024 John Källén.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#endregion

using Reko.Core.Loading;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Reko.ImageLoaders.Elf
{
    public class ElfSegment
    {
        public ProgramHeaderType p_type;
        public uint p_flags;
        public ulong p_offset;
        public ulong p_vaddr;
        public ulong p_paddr;
        public ulong p_filesz;
        public ulong p_pmemsz;
        public ulong p_align;

        public AccessMode GetAccessMode()
        {
            return (AccessMode) (p_flags & 7);
        }

        public bool IsValidAddress(ulong uAddr)
        {
            return p_vaddr <= uAddr && uAddr < p_vaddr + p_pmemsz;
        }

        public override string ToString()
        {
            return $"[{p_vaddr:X} - 0x{p_pmemsz:X}] - {p_type}";
        }


    }
}
