#region License
/* 
 * Copyright (C) 1999-2024 John Källén.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#endregion

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Reko.ImageLoaders.WebAssembly
{
    public enum Mnemonic
    {
        unreachable = 0x00,
        nop = 0x01,
        block = 0x02,
        loop = 0x03,
        @if = 0x04,
        @else = 0x05,
        end = 0x0b,
        br = 0x0c,
        br_if = 0x0d,
        br_table = 0x0e,
        @return = 0x0f,

        call = 0x10,
        call_indirect = 0x11,

        drop = 0x1a,
        select = 0x1b,
        get_local = 0x20,
        set_local = 0x21,
        tee_local = 0x22,
        get_global = 0x23,
        set_global = 0x24,
        table_get = 0x25,
        table_set = 0x26,
        i32_load = 0x28,
        i64_load = 0x29,
        f32_load = 0x2a,
        f64_load = 0x2b,
        i32_load8_s = 0x2c,
        i32_load8_u = 0x2d,
        i32_load16_s = 0x2e,
        i32_load16_u = 0x2f,
        i64_load8_s = 0x30,
        i64_load8_u = 0x31,
        i64_load16_s = 0x32,
        i64_load16_u = 0x33,
        i64_load32_s = 0x34,
        i64_load32_u = 0x35,
        i32_store = 0x36,
        i64_store = 0x37,
        f32_store = 0x38,
        f64_store = 0x39,
        i32_store8 = 0x3a,
        i32_store16 = 0x3b,
        i64_store8 = 0x3c,
        i64_store16 = 0x3d,
        i64_store32 = 0x3e,
        current_memory = 0x3f,
        grow_memory = 0x40,
        i32_const = 0x41,
        i64_const = 0x42,
        f32_const = 0x43,
        f64_const = 0x44,
        i32_eqz = 0x45,
        i32_eq = 0x46,
        i32_ne = 0x47,
        i32_lt_s = 0x48,
        i32_lt_u = 0x49,
        i32_gt_s = 0x4a,
        i32_gt_u = 0x4b,
        i32_le_s = 0x4c,
        i32_le_u = 0x4d,
        i32_ge_s = 0x4e,
        i32_ge_u = 0x4f,
        i64_eqz = 0x50,
        i64_eq = 0x51,
        i64_ne = 0x52,
        i64_lt_s = 0x53,
        i64_lt_u = 0x54,
        i64_gt_s = 0x55,
        i64_gt_u = 0x56,
        i64_le_s = 0x57,
        i64_le_u = 0x58,
        i64_ge_s = 0x59,
        i64_ge_u = 0x5a,
        f32_eq = 0x5b,
        f32_ne = 0x5c,
        f32_lt = 0x5d,
        f32_gt = 0x5e,
        f32_le = 0x5f,
        f32_ge = 0x60,
        f64_eq = 0x61,
        f64_ne = 0x62,
        f64_lt = 0x63,
        f64_gt = 0x64,
        f64_le = 0x65,
        f64_ge = 0x66,

        i32_clz = 0x67,
        i32_ctz = 0x68,
        i32_popcnt = 0x69,
        i32_add = 0x6a,
        i32_sub = 0x6b,
        i32_mul = 0x6c,
        i32_div_s = 0x6d,
        i32_div_u = 0x6e,
        i32_rem_s = 0x6f,
        i32_rem_u = 0x70,
        i32_and = 0x71,
        i32_or = 0x72,
        i32_xor = 0x73,
        i32_shl = 0x74,
        i32_shr_s = 0x75,
        i32_shr_u = 0x76,
        i32_rotl = 0x77,
        i32_rotr = 0x78,
        i64_clz = 0x79,
        i64_ctz = 0x7a,
        i64_popcnt = 0x7b,
        i64_add = 0x7c,
        i64_sub = 0x7d,
        i64_mul = 0x7e,
        i64_div_s = 0x7f,
        i64_div_u = 0x80,
        i64_rem_s = 0x81,
        i64_rem_u = 0x82,
        i64_and = 0x83,
        i64_or = 0x84,
        i64_xor = 0x85,
        i64_shl = 0x86,
        i64_shr_s = 0x87,
        i64_shr_u = 0x88,
        i64_rotl = 0x89,
        i64_rotr = 0x8a,
        f32_abs = 0x8b,
        f32_neg = 0x8c,
        f32_ceil = 0x8d,
        f32_floor = 0x8e,
        f32_trunc = 0x8f,
        f32_nearest = 0x90,
        f32_sqrt = 0x91,
        f32_add = 0x92,
        f32_sub = 0x93,
        f32_mul = 0x94,
        f32_div = 0x95,
        f32_min = 0x96,
        f32_max = 0x97,
        f32_copysign = 0x98,
        f64_abs = 0x99,
        f64_neg = 0x9a,
        f64_ceil = 0x9b,
        f64_floor = 0x9c,
        f64_trunc = 0x9d,
        f64_nearest = 0x9e,
        f64_sqrt = 0x9f,
        f64_add = 0xa0,
        f64_sub = 0xa1,
        f64_mul = 0xa2,
        f64_div = 0xa3,
        f64_min = 0xa4,
        f64_max = 0xa5,
        f64_copysign = 0xa6,

        i32_wrap_i64 = 0xa7,
        i32_trunc_s_f32 = 0xa8,
        i32_trunc_u_f32 = 0xa9,
        i32_trunc_s_f64 = 0xaa,
        i32_trunc_u_f64 = 0xab,
        i64_extend_s_i32 = 0xac,
        i64_extend_u_i32 = 0xad,
        i64_trunc_s_f32 = 0xae,
        i64_trunc_u_f32 = 0xaf,
        i64_trunc_s_f64 = 0xb0,
        i64_trunc_u_f64 = 0xb1,
        f32_convert_s_i32 = 0xb2,
        f32_convert_u_i32 = 0xb3,
        f32_convert_s_i64 = 0xb4,
        f32_convert_u_i64 = 0xb5,
        f32_demote_f64 = 0xb6,
        f64_convert_s_i32 = 0xb7,
        f64_convert_u_i32 = 0xb8,
        f64_convert_s_i64 = 0xb9,
        f64_convert_u_i64 = 0xba,
        f64_promote_f32 = 0xbb,

        i32_reinterpret_f32 = 0xbc,
        i64_reinterpret_f64 = 0xbd,
        f32_reinterpret_i32 = 0xbe,
        f64_reinterpret_i64 = 0xbf,

        i32_extend8_s = 0xC0,
        i32_extend16_s = 0xC1,
        i64_extend8_s  = 0xC2,
        i64_extend16_s = 0xC3,
        i64_extend32_s = 0xC4,

        i32_trunc_sat_f32_s = 0xFC00, 
        i32_trunc_sat_f32_u = 0xFC01, 
        i32_trunc_sat_f64_s = 0xFC02, 
        i32_trunc_sat_f64_u = 0xFC03, 
        i64_trunc_sat_f32_s = 0xFC04, 
        i64_trunc_sat_f32_u = 0xFC05, 
        i64_trunc_sat_f64_s = 0xFC06, 
        i64_trunc_sat_f64_u = 0xFC07,

        memory_init = 0xFC08,
        data_drop  = 0xFC09,
        memory_copy = 0xFC0A,
        memory_fill = 0xFC0B,

        table_init = 0xFC0C,
        elem_drop = 0xFC0D,
        table_copy = 0xFC0E,
        table_grow = 0xFC0F,
        table_size = 0xFC10,
        table_fill = 0xFC11,

        v128_load = 0xFD00,
        v128_load8x8_s = 0xFD01,
        v128_load8x8_u = 0xFD02,
        v128_load16x4_s = 0xFD03,
        v128_load16x4_u = 0xFD04,
        v128_load32x2_s = 0xFD05,
        v128_load32x2_u = 0xFD06,
        v128_load8_splat = 0xFD07,
        v128_load16_splat = 0xFD08,
        v128_load32_splat = 0xFD09,
        v128_load64_splat = 0xFD0A,
        v128_load32_zero = 0xFD5C,
        v128_load64_zero = 0xFD5D,
        v128_store = 0xFD0B,
        v128_load8_lane = 0xFD54,
        v128_load16_lane = 0xFD55,
        v128_load32_lane = 0xFD56,
        v128_load64_lane = 0xFD57,
        v128_store8_lane = 0xFD58,
        v128_store16_lane = 0xFD59,
        v128_store32_lane = 0xFD5A,
        v128_store64_lane = 0xFD5B,
    }
}
