## Packaging Reko

Reko is distributed as an MSI installer file, for Windows users, and as a NuGet, for developers to use in their own projects. To manage complexity, the list of files to be distributed in all distributions is maintained in `reko-files.xml`. This file contains entries of the following form:
```#xml
<File Source="$(var.SolutionDir)..\external\wine\gdi.exe16.spec" nuget_target="c:" />
```
which are similar in syntax to the one used by WiX, but has been augmented with the new optional XML attribute `nuget_target`. If this attribute is present, the file will be included into the NuGet package. The `nuget_target` attribute has a specific format: `f:`, `c:`, or `c:/subdirectory`. If you specify `f:`, the file will be used as a reference assembly in the target project. If you specify `c:` or `c:/subdirectory`, the file will be simply copied as content to the target project.

## Updating the packaging scripts

When new assemblies or metadata files are added to the Reko solution, they must be added to the `reko-files.xml` file as well. The new files are then combined with the `*.template` files in this directory to generate the WiX installer and NuGet spec files. The script file `update_pacakgers.py` does this. Executing it from this directory will cause it to generate new WiX installer and NuGet spec files based on the contents of `reko-files.xml`.

## Building the WiX installer

The WiX installer is integrated into the Reko build. By default it's only built in the `Release` configuration.

## Building a nupkg file

The `nupkg` file is build by running the following command in this directory:
```
nuget pack -Properties Configuration=Release;Platform=x64
```
This will use the `NuGetPackage.nuspec` file which was generated by `update_packagers.py`. The result is a `Reko.Decompiler.Runtime.$version-number$.nupkg` file. This can be uploaded to a NuGet repository.
