/*
 * Copyright 2019 Red Hat, Inc. and/or its affiliates
 * and other contributors as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.shamrock.creator.outcome.test;

import static org.junit.Assert.assertEquals;

import org.jboss.shamrock.creator.AppCreatorException;
import org.jboss.shamrock.creator.outcome.OutcomeMap;
import org.jboss.shamrock.creator.outcome.OutcomeProvider;
import org.jboss.shamrock.creator.outcome.OutcomeProviderRegistration;
import org.jboss.shamrock.creator.outcome.OutcomeResolver;
import org.jboss.shamrock.creator.outcome.OutcomeResolverFactory;
import org.junit.Test;

/**
 *
 * @author Alexey Loubyansky
 */
public class SinglePhaseTestCase {

    @Test
    public void testMain() throws Exception {

        final TestResult outcome = new TestResult("handler");

        final OutcomeResolver<OutcomeMap> router = OutcomeResolverFactory.<OutcomeMap>getInstance()
                .addProvider(new OutcomeProvider<OutcomeMap>() {
                    @Override
                    public void register(OutcomeProviderRegistration registration) throws AppCreatorException {
                        registration.provides(TestResult.class);
                    }
                    @Override
                    public void provideOutcome(OutcomeMap ctx) throws AppCreatorException {
                        ctx.pushOutcome(outcome);
                    }})
                .build();

        final OutcomeMap resolver = new OutcomeMap(router);
        assertEquals(outcome, resolver.resolveOutcome(TestResult.class));
    }
}
