/*
 * Copyright 2018 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.shamrock.jdbc.mariadb.deployment;

import org.jboss.shamrock.deployment.annotations.BuildProducer;
import org.jboss.shamrock.deployment.annotations.BuildStep;
import org.jboss.shamrock.deployment.builditem.substrate.ReflectiveClassBuildItem;

public final class MariaDBJDBCReflections {

	@BuildStep
	void build(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
		//Not strictly necessary when using Agroal, as it also registers
		//any JDBC driver being configured explicitly through its configuration.
		//We register it for the sake of people not using Agroal.
		final String driverName = "org.mariadb.jdbc.Driver";
		reflectiveClass.produce(new ReflectiveClassBuildItem(false, false, driverName));

		//MariaDB's connection process requires reflective read to all fields of Options:
		reflectiveClass.produce(new ReflectiveClassBuildItem(true, true, "org.mariadb.jdbc.internal.util.Options"));
	}
}
