package org.jboss.shamrock.example.infinispanclient;

import java.util.Objects;

/**
 * @author William Burns
 */
public class Author {
   private final String name;
   private final String surname;

   public Author(String name, String surname) {
      this.name = Objects.requireNonNull(name);
      this.surname = Objects.requireNonNull(surname);
   }

   public String getName() {
      return name;
   }

   public String getSurname() {
      return surname;
   }

   @Override
   public boolean equals(Object o) {
      if (this == o) return true;
      if (o == null || getClass() != o.getClass()) return false;
      Author author = (Author) o;
      return name.equals(author.name) &&
            surname.equals(author.surname);
   }

   @Override
   public int hashCode() {
      return Objects.hash(name, surname);
   }
}
