/*
 * @(#)SummaryToolBar.java
 *
 * Copyright (c) 2007-2008 by the original authors of JHotDraw and all its
 * contributors. All rights reserved.
 *
 * You may not use, copy or modify this file, except in compliance with the 
 * license agreement you entered into with the copyright holders. For details
 * see accompanying license terms.
 */

package org.jhotdraw.samples.svg.gui;

import java.beans.*;
import java.util.prefs.*;
import javax.swing.border.*;
import org.jhotdraw.gui.*;
import org.jhotdraw.samples.svg.*;
import org.jhotdraw.undo.*;
import org.jhotdraw.util.*;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import org.jhotdraw.app.action.*;
import org.jhotdraw.draw.*;
import org.jhotdraw.draw.action.*;
import org.jhotdraw.samples.svg.action.*;
import org.jhotdraw.samples.svg.figures.*;
import static org.jhotdraw.samples.svg.SVGAttributeKeys.*;
/**
 * SummaryToolBar.
 *
 * @author Werner Randelshofer
 * @version $Id: SummaryToolBar.java 717 2010-11-21 12:30:57Z rawcoder $
 */
public class SummaryToolBar extends JToolBar {
    private ResourceBundleUtil labels;
    
    /** Creates new instance. */
    public SummaryToolBar() {
        labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
        initComponents();
        
        GridBagLayout layout = new GridBagLayout();
        setLayout(layout);
        
        GridBagConstraints gbc;
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(0,10,0,0);
        gbc.weightx = 1d;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        layout.setConstraints(summaryField, gbc);
    }
    
    public String getSummary() {
        return summaryField.getText();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        summaryLabel = new javax.swing.JLabel();
        summaryField = new javax.swing.JTextField();

        setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        setFloatable(false);
        setOpaque(false);

        summaryLabel.setFont(new java.awt.Font("Dialog", 0, 11));
        summaryLabel.setText(labels.getString("summary")); // NOI18N
        add(summaryLabel);

        summaryField.setFont(new java.awt.Font("DialogInput", 0, 11));
        add(summaryField);
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField summaryField;
    private javax.swing.JLabel summaryLabel;
    // End of variables declaration//GEN-END:variables
    
}
