/*PLEASE DO NOT EDIT THIS CODE*/
/*This code was generated using the UMPLE 1.15.0.963 modeling language!*/

package net.n3.nanoxml;
import java.io.IOException;
import java.io.Reader;
import java.util.Stack;

public class StdXMLBuilder
{

  //------------------------
  // MEMBER VARIABLES
  //------------------------

  //------------------------
  // CONSTRUCTOR
  //------------------------

  public StdXMLBuilder()
  {}

  //------------------------
  // INTERFACE
  //------------------------

  public void delete()
  {}
  
  //------------------------
  // DEVELOPER CODE - PROVIDED AS-IS
  //------------------------
  
  private Stack stack;
/**
    * The root element of the parsed XML tree.
    */
   private IXMLElement root;
/**
    * Prototype element for creating the tree.
    */
   private IXMLElement prototype;
/**
    * Cleans up the object when it's destroyed.
    */
   protected void finalize()
      throws Throwable
   {
      this.prototype = null;
      this.root = null;
      this.stack.clear();
      this.stack = null;
      super.finalize();
   }
/**
    * This method is called before the parser starts processing its input.
    *
    * @param systemID the system ID of the XML data source.
    * @param lineNr   the line on which the parsing starts.
    */
   public void startBuilding(String systemID,
                             int    lineNr)
   {
      this.stack = new Stack();
      this.root = null;
   }
/**
    * This method is called when a processing instruction is encountered.
    * PIs with target "xml" are handled by the parser.
    *
    * @param target the PI target.
    * @param reader to read the data from the PI.
    */
   public void newProcessingInstruction(String target,
                                        Reader reader)
   {
      // nothing to do
   }
/**
    * This method is called when a new XML element is encountered.
    *
    * @see #endElement
    *
    * @param name       the name of the element.
    * @param nsPrefix   the prefix used to identify the namespace. If no
    *                   namespace has been specified, this parameter is null.
    * @param nsURI      the URI associated with the namespace. If no
    *                   namespace has been specified, or no URI is
    *                   associated with nsPrefix, this parameter is null.
    * @param systemID   the system ID of the XML data source.
    * @param lineNr     the line in the source where the element starts.
    */
   public void startElement(String name,
                            String nsPrefix,
                            String nsURI,
                            String systemID,
                            int    lineNr)
   {
      String fullName = name;

      if (nsPrefix != null) {
         fullName = nsPrefix + ':' + name;
      }

      IXMLElement elt = this.prototype.createElement(fullName, nsURI,
                                                     systemID, lineNr);

      if (this.stack.empty()) {
         this.root = elt;
      } else {
         IXMLElement top = (IXMLElement) this.stack.peek();
         top.addChild(elt);
      }

      this.stack.push(elt);
   }
/**
    * This method is called when the attributes of an XML element have been
    * processed.
    *
    * @see #startElement
    * @see #addAttribute
    *
    * @param name       the name of the element.
    * @param nsPrefix   the prefix used to identify the namespace. If no
    *                   namespace has been specified, this parameter is null.
    * @param nsURI      the URI associated with the namespace. If no
    *                   namespace has been specified, or no URI is
    *                   associated with nsPrefix, this parameter is null.
    */
   public void elementAttributesProcessed(String name,
                                          String nsPrefix,
                                          String nsURI)
   {
      // nothing to do
   }
/**
    * This method is called when the end of an XML elemnt is encountered.
    *
    * @see #startElement
    *
    * @param name       the name of the element.
    * @param nsPrefix   the prefix used to identify the namespace. If no
    *                   namespace has been specified, this parameter is null.
    * @param nsURI      the URI associated with the namespace. If no
    *                   namespace has been specified, or no URI is
    *                   associated with nsPrefix, this parameter is null.
    */
   public void endElement(String name,
                          String nsPrefix,
                          String nsURI)
   {
      IXMLElement elt = (IXMLElement) this.stack.pop();

      if (elt.getChildrenCount() == 1) {
         IXMLElement child = elt.getChildAtIndex(0);

         if (child.getName() == null) {
            elt.setContent(child.getContent());
            elt.removeChildAtIndex(0);
         }
      }
   }
/**
    * This method is called when a new attribute of an XML element is
    * encountered.
    *
    * @param key        the key (name) of the attribute.
    * @param nsPrefix   the prefix used to identify the namespace. If no
    *                   namespace has been specified, this parameter is null.
    * @param nsURI      the URI associated with the namespace. If no
    *                   namespace has been specified, or no URI is
    *                   associated with nsPrefix, this parameter is null.
    * @param value      the value of the attribute.
    * @param type       the type of the attribute. If no type is known,
    *                   "CDATA" is returned.
    *
    * @throws java.lang.Exception
    *     If an exception occurred while processing the event.
    */
   public void addAttribute(String key,
                            String nsPrefix,
                            String nsURI,
                            String value,
                            String type)
      throws Exception
   {
      String fullName = key;

      if (nsPrefix != null) {
         fullName = nsPrefix + ':' + key;
      }

      IXMLElement top = (IXMLElement) this.stack.peek();

      if (top.hasAttribute(fullName)) {
         throw new XMLParseException(top.getSystemID(),
                                     top.getLineNr(),
                                     "Duplicate attribute: " + key);
      }

      if (nsPrefix != null) {
         top.setAttribute(fullName, nsURI, value);
      } else {
         top.setAttribute(fullName, value);
      }
   }
/**
    * This method is called when a PCDATA element is encountered. A Java
    * reader is supplied from which you can read the data. The reader will
    * only read the data of the element. You don't need to check for
    * boundaries. If you don't read the full element, the rest of the data
    * is skipped. You also don't have to care about entities; they are
    * resolved by the parser.
    *
    * @param reader   the Java reader from which you can retrieve the data.
    * @param systemID the system ID of the XML data source.
    * @param lineNr   the line in the source where the element starts.
    */
   public void addPCData(Reader reader,
                         String systemID,
                         int    lineNr)
   {
      int bufSize = 2048;
      int sizeRead = 0;
      StringBuffer str = new StringBuffer(bufSize);
      char[] buf = new char[bufSize];

      for (;;) {
         if (sizeRead >= bufSize) {
            bufSize *= 2;
            str.ensureCapacity(bufSize);
         }

         int size;

         try {
            size = reader.read(buf);
         } catch (IOException e) {
            break;
         }

         if (size < 0) {
            break;
         }

         str.append(buf, 0, size);
         sizeRead += size;
      }

      IXMLElement elt = this.prototype.createElement(null, systemID, lineNr);
      elt.setContent(str.toString());

      if (! this.stack.empty()) {
         IXMLElement top = (IXMLElement) this.stack.peek();
         top.addChild(elt);
      }
   }
/**
    * Returns the result of the building process. This method is called just
    * before the <I>parse</I> method of IXMLParser returns.
    *
    * @see net.n3.nanoxml.IXMLParser#parse
    *
    * @return the result of the building process.
    */
   public Object getResult()
   {
      return this.root;
   }
}