/*******************************************************************************
* Copyright (c) 2013 Ahmed M.Orabi, Mahmoud M.Orabi.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Ahmed M.Orabi
*     Mahmoud M.Orabi
*
* Please refer to the code authors before making any changes. 
* For any code reuse or copy, contact the authors and it is a MUST 
* to refer author names.
*
* @author -Ahmed M.Orabi {@link ahmedvc@hotmail.com}
* @author Mahmoud M.Orabi {@link mahmoud_3rabi@hotmail.com}
*******************************************************************************/
package cruise.umple.core;

/**
 * The common  constants for code generation 
 */
public interface CommonConstants {

	public static final String BLANK= ""; 				//$NON-NLS-1$
	public static final String LESS_THAN= "<"; 				//$NON-NLS-1$
	public static final String LESS_THAN_OR_EQUAL= "<="; 				//$NON-NLS-1$
	public static final String MORE_THAN= ">"; 				//$NON-NLS-1$
	public static final String EQUAL= "="; 				//$NON-NLS-1$
	public static final String TAB= "\t"; 				//$NON-NLS-1$
	public static final String ASTERISK= "*"; 				//$NON-NLS-1$
	public static final String COLON= ":"; 				//$NON-NLS-1$
	public static final String TILDE= "~"; 				//$NON-NLS-1$
	public static final String UNDERSCORE= "_";			//$NON-NLS-1$
	public static final String DOT= "."; 				//$NON-NLS-1$
	public static final String STRICT_DOT= "\\."; 				//$NON-NLS-1$
	public static final String NOT= "!"; 				//$NON-NLS-1$
	
	public static final String PLUS= "+"; 				//$NON-NLS-1$
	public static final String MINUS= "-"; 				//$NON-NLS-1$
	public static final String PLUS_SEPARATOR= "\\+"; 				//$NON-NLS-1$
	
	public static final String SPACE= " "; 				//$NON-NLS-1$
	public static final String SEMI_COLON= ";";			//$NON-NLS-1$
	public static final String FORWARD_SLASH= "/"; 		//$NON-NLS-1$
	public static final String BACK_SLASH= "\\"; 		//$NON-NLS-1$
	public static final String COMMA_SEPARATOR= ", "; 	//$NON-NLS-1$
	public static final String NEW_LINE= System.getProperties().getProperty("line.separator"); 			//$NON-NLS-1$
	public static final String OPEN_BRACE= "{"; 			//$NON-NLS-1$
	public static final String CLOSE_BRACE= "}"; 			//$NON-NLS-1$
	
	public static final String OPEN_SQUARE_BRACKET= "["; 			//$NON-NLS-1$
	public static final String CLOSE_SQUARE_BRACKET= "]"; 			//$NON-NLS-1$
	
	public static final String OPEN_BRACKET= "("; 			//$NON-NLS-1$
	public static final String CLOSE_BRACKET= ")"; 			//$NON-NLS-1$
	
	public static final String QUOTATION= "\"";			//$NON-NLS-1$
	
}
