/*******************************************************************************
* Copyright (c) 2013 Ahmed M.Orabi, Mahmoud M.Orabi.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Ahmed M.Orabi
*     Mahmoud M.Orabi
*
* Please refer to the code authors before making any changes. 
* For any code reuse or copy, contact the authors and it is a MUST 
* to refer author names.
*
* @author -Ahmed M.Orabi {@link ahmedvc@hotmail.com}
* @author Mahmoud M.Orabi {@link mahmoud_3rabi@hotmail.com}
*******************************************************************************/
package cruise.umple.templates;

import cruise.umple.core.CommonConstants;
import cruise.umple.core.GenerationPolicyRegistry;


public class GenerationTemplateDelegator implements IGenerationTemplateRegistry{
	
	private GenerationPolicyRegistry fRegistry;
	
	public GenerationTemplateDelegator(GenerationPolicyRegistry registry) {
		this.fRegistry= registry;
	}

	@Override
	public String generate(String id, Object element, Object... arguments) {
		if(element!= null){
			String val= this.fRegistry.generator.generate(id, element, arguments);
			if(val!= null){
				if(val.contains("#include <model/Some.h>")){
					System.out.println();
				}
				return val;
			}
		}else{
			String val= this.fRegistry.generator.generate(id, arguments);
			if(val!= null){
				return val;
			}
		}

		return CommonConstants.BLANK;
	}
	
}
