# Improving Editing of Software Models in Umple

## Involved GitHub Issues: [#221](https://github.com/umple/umple/issues/221) and [\#222](https://github.com/umple/umple/issues/222)

This project is to improve the editing experience in the UmpleOnline text editor by implementing syntax-directed highlighting and auto-completion using CodeMirror 6 and Lezer's parser system .

1. [CodeMirror 6 Extensible Code Editor](https://codemirror.net/)
2. [The Lezer Parser System](https://lezer.codemirror.net/)

In the LezerGenerator branch, a new folder named 'codemirror6-plugins' has been introduced to the 'umple/umpleonline/scripts/' directory. This folder comprises two subdirectories: 'lang-umple' and 'umpleLezerTest.' The 'lang-umple' subdirectory contains the plugin designated for integration with UmpleOnline, whereas 'umpleLezerTest' functions as a testing environment for experimentation with the CM6 Test Editor, facilitating syntax-aware highlighting and auto-completion features.

## Table of Contents

1. [Folder Structure](#folder-structure)
2. [Getting Started](#getting-started)
3. [Building the Parser](#building-the-parser)
4. [Bundling the Project](#bundling-the-project)
5. [Running the Testing Editor](#running-the-testing-editor)

## Folder Structure

The 'umpleLezerTest' folder contains the following files and directories:

- `Lezer_Generator_Command.txt`: A text file containing the command to generate the parser using the Lezer generator.
- `RollUp_Command.txt`: A text file containing the command to bundle the project using Rollup.
- `rollup.config.mjs`: The Rollup configuration file for bundling the project.
- `editor.bundle.js`: The bundled JavaScript file for the editor.
- `editor.mjs`: The main JavaScript file for the editor.
- `index.html`: The HTML file for a specific testing editor.
- `style.css`: The CSS file for styling the editor.
- `umple.grammar`: The Umple Lezer grammar file for the custom parser.
- `parser.js`: The generated JavaScript parser file.
- `parser.terms.js`: The generated JavaScript file containing the parser's terminal symbols.
- `umple.js`: The JavaScript file containing the language support components for CodeMirror 6 for Umple.
- `node_modules`: The directory containing the project's dependencies. **\[Note: This directory is not being included in the repo. Namely, it's gitignored as one can easily install the required 'node_modules'by executing the command 'npm install'..\]**
- `package-lock.json`: The file generated by npm to lock the dependency versions.
- `package.json`: The file containing the project's metadata and dependencies.

## Getting Started

Before you can build and run the project, you need to install the dependencies. To do this, navigate to the project folder, which contains the 'package.json' file, in your terminal and run the following command:

```sh
npm install
```

This command installs all the necessary dependencies listed in the 'package.json' file. They will be in a directory named 'node_modules', and 'node_modules' will be parallel with 'package.json'.

## Building the Parser

To build the custom parser for Umple using the Lezer generator, open the Lezer_Generator_Command.txt file and copy the command provided. Then, run the command in your terminal:

```sh
npx lezer-generator umple.grammar -o parser.js
```

This command generates the parser.js and parser.terms.js files, which contain the JavaScript parser and the terminal symbols, respectively.

## Bundling the Project

To bundle the project using Rollup, open the RollUp_Command.txt file and copy the command provided. Then, run the command in your terminal:

```sh
node_modules/.bin/rollup editor.mjs -f iife -o editor.bundle.js \
  -p @rollup/plugin-node-resolve
```

This command bundles the project using the rollup.config.mjs configuration file and generates the editor.bundle.js file, which contains the bundled JavaScript code for the editor.

## Running the Testing Editor

To run the testing editor, open the index.html file in your web browser. The testing editor demonstrates the usage of the custom parser for Umple and CodeMirror 6 with the language support components defined in the umple.js file. You can interact with the editor and see the custom Umple syntax-aware highlighting, auto-completion, and other language features in action.
