# Release Notes

## .NET Core March 2017 Update - 1.1.1 Released 3/7/2017

.NET Core 1.1.1 and SDK 1.0.1 are available for download from our [site](https://www.microsoft.com/net/core). Have a look at the [.NET announcement blog post](https://blogs.msdn.microsoft.com/dotnet/) for details and great context around the release. Visual Studio 2017 is also releasing today and you can read about it in their [announcement](https://blogs.msdn.microsoft.com/visualstudio/).

### .NET Core SDK 1.0.0 and 1.0.1

**.NET Core SDK 1.0.0** is releasing with Visual Studio 2017. The [announcement blog](https://blogs.msdn.microsoft.com/dotnet/) linked above as well as the [RC4 blog post](https://blogs.msdn.microsoft.com/dotnet/2017/02/07/announcing-net-core-tools-updates-in-vs-2017-rc) have great details on what is available in this final release. You can read about the Visual Studio 2017 in their [announcement](https://blogs.msdn.microsoft.com/visualstudio/).

**.NET Core SDK 1.0.1**, available for download from the [.NET Core download page](https://www.microsoft.com/net/core), also includes support for Fedora 24 and OpenSUSE 42.1.

### Distro Updates

Each Distro version has a lifecycle at the end of which the maintainers cease providing support and updates. When a Distro comes to the end of its life as defined by the maintainer, we will also adjust the supported list for .NET Core. Support will not be actively blocked so .NET Core will likely continue to work but no support or updates for .NET Core will be offered.

Support for the following distros have been withdrawn to align with the respective OS support policy.

### Docker Image Name Changes

The latest .NET Core runtime and tools are available from [Docker](https://hub.docker.com/r/microsoft/dotnet/) in the following Docker SDK images:

* 1.0.4-sdk
* 1.0.4-sdk-nanoserver
* 1.1.1-sdk
* 1.1.1-sdk-nanoserver

You can also use the .NET For runtime images, which contain the latest runtime updates:

* 1.0.4-runtime
* 1.0.4-runtime-nanoserver
* 1.1.1-runtime
* 1.1.1-runtime-nanoserver

### .NET Core 1.1.1 Symbol Packages

Symbol packages for .NET 1.1.1 are available for download from the following locations.

* [CoreCLR](https://go.microsoft.com/fwlink/?LinkID=843434)
* [CoreFX](https://go.microsoft.com/fwlink/?LinkID=843438)

### ASP.NET Core

* Please see the [ASP.NET Core release page](https://github.com/aspnet/home/releases/1.1.1) for details on fixes from ASP.NET Core, MVC, Entity Framework Core and others.

### Closed Issues for 1.1.1

#### CoreCLR

* [`[d2cae54e4]`](https://github.com/dotnet/coreclr/commit/d2cae54e4) Filter RefEmit modules in SendEventsForNgenMethods (#9418) (#9421)
* [`[94ed316fc]`](https://github.com/dotnet/coreclr/commit/94ed316fc) Use fallback load context when dynamic assembly triggers load
* [`[2cc476701]`](https://github.com/dotnet/coreclr/commit/2cc476701) Fix debugger launch race hitting breakpoints in startup code. (#8951) (#9060)
* [`[542d14278]`](https://github.com/dotnet/coreclr/commit/542d14278) Fix XMM register count in CONTEXT_SetThreadContextOnPort in PAL
* [`[1ea673030]`](https://github.com/dotnet/coreclr/commit/1ea673030) Save registers xmm8..15 on Mac OSX
* [`[37f3140ec]`](https://github.com/dotnet/coreclr/commit/37f3140ec) Disable CER code that causes crashes (#8230)
* [`[c3c71f9ad]`](https://github.com/dotnet/coreclr/commit/c3c71f9ad) Port: Invoke correct pinvoke resolution override for dynamically generated assembly
* [`[13ea22b2e]`](https://github.com/dotnet/coreclr/commit/13ea22b2e) Add some extra checks to BinaryReader/Writer buffers
* [`[12661afe7]`](https://github.com/dotnet/coreclr/commit/12661afe7) Fix passing struct with four floats in registers via reflection (#7716)
* [`[1bd0ce6ba]`](https://github.com/dotnet/coreclr/commit/1bd0ce6ba) Disable CER code that is causing access violation

#### CoreFX

* [`[3ac33e4df7]`](https://github.com/dotnet/corefx/commit/3ac33e4df7) [Port 1.1] Fix System.Net.Http.HttpClientHandler for net46 build (#15659)
* [`[9a8ff32ed5]`](https://github.com/dotnet/corefx/commit/9a8ff32ed5) Remove SSRP for TCP connections without port and Instance name
* [`[dfa46f3d53]`](https://github.com/dotnet/corefx/commit/dfa46f3d53) Resolved connection leak in SNI by adding dispose for underlying TCPstream in SNITcpHandle.Dispose() (#15431)
* [`[4d1af962ca]`](https://github.com/dotnet/corefx/commit/4d1af962ca) Fix SslStream.WriteAsync with 0-byte write (#13384)
* [`[1f89ccb778]`](https://github.com/dotnet/corefx/commit/1f89ccb778) Fix RID for runtime.native.System.IO.Compression
* [`[e2a2174033]`](https://github.com/dotnet/corefx/commit/e2a2174033) Block zero-byte calls to encrypt for Unix SslStream
* [`[60d1b3d22e]`](https://github.com/dotnet/corefx/commit/60d1b3d22e) Fix handling of flock in FileStream on Unix
* [`[7ddc57aaa8]`](https://github.com/dotnet/corefx/commit/7ddc57aaa8) Fixed JsonDataContract.GetGeneratedReadWriteDelegates. (#12906)
* [`[110fdf322b]`](https://github.com/dotnet/corefx/commit/110fdf322b) Fixed Reflection on XmlConvert Not Working in Net Native. (#12907)
* [`[0210c365c0]`](https://github.com/dotnet/corefx/commit/0210c365c0) Add downlevel ValueTuple configuration
* [`[16210da2e9]`](https://github.com/dotnet/corefx/commit/16210da2e9) Mandatory http response status should be 100..1000 (#12938)
* [`[1bf819113e]`](https://github.com/dotnet/corefx/commit/1bf819113e) Fix ValueTask behavior as async return type
* [`[e7d55c8b95]`](https://github.com/dotnet/corefx/commit/e7d55c8b95) Fix parsing of procfs stat files when comm name contains spaces
* [`[69ebf34c36]`](https://github.com/dotnet/corefx/commit/69ebf34c36) Make derived types of SymmetricAlgorithm use field assignment in ctors.
* [`[7af20725d4]`](https://github.com/dotnet/corefx/commit/7af20725d4) Remove unnecessary comparison in SequencePointCollection
* [`[2501e76d1e]`](https://github.com/dotnet/corefx/commit/2501e76d1e) Clean up type provider interface factoring
* [`[28acba251f]`](https://github.com/dotnet/corefx/commit/28acba251f) Rename GenericInstance to GenericInstantiation throughout
* [`[ba0a2d63fc]`](https://github.com/dotnet/corefx/commit/ba0a2d63fc) Add generic context to signature decoder
* [`[b1de2afcda]`](https://github.com/dotnet/corefx/commit/b1de2afcda) Replace SkipBytes and SeekOffset with Offset setter (#12375)
* [`[48b8423fd2]`](https://github.com/dotnet/corefx/commit/48b8423fd2) Implements BlobReader.IndexOf(byte) (#12308)
* [`[acdfab6eec]`](https://github.com/dotnet/corefx/commit/acdfab6eec) Use constants instead of literal numbers (#11547)