---
name: Bug Report
about: Report a bug encountered while developing with Uno
labels: kind/bug, triage/untriaged
---

<!-- Please use this template while reporting a bug and provide as much info as possible. Not doing so may result in your bug not being addressed in a timely manner. Thanks!

If the matter is security related, please disclose it privately via https://github.com/nventive/Uno/security/
-->

## Current behavior

<!-- Describe how the issue manifests. -->

## Expected behavior

<!-- Describe what the desired behavior would be. -->

## How to reproduce it (as minimally and precisely as possible)

<!-- Please provide a **MINIMAL REPRO PROJECT** and the **STEPS TO REPRODUCE**-->

## Environment

<!-- For bug reports Check one or more of the following options with "x" -->

Nuget Package (s):

Package Version(s):

Affected platform(s):

- [ ] iOS
- [ ] macOS (AppKit)
- [ ] Mac Catalyst
- [ ] Android
- [ ] WebAssembly
- [ ] Windows
- [ ] Skia (WPF)
- [ ] Skia (GTK on Linux/macOS/Windows)
- [ ] Skia (Linux Framebuffer)
- [ ] Build tasks

Visual Studio:

- [ ] 2019 (version: )
- [ ] 2022 (version: )
- [ ] Visual Studio Code (version: )
- [ ] Rider Windows (version: )
- [ ] Rider macOS (version: )

Relevant plugins:

- [ ] Resharper (version: )

## Anything else we need to know?

<!-- We would love to know of any friction, apart from knowledge, that prevented you from sending in a pull-request -->
