---
uid: Uno.Extensions.Overview
---
# Get to a fully functional project in minutes

Uno.Extensions is a series of NuGet packages designed to encapsulate common functions when building multi-platform mobile, desktop, and web applications using Uno Platform. Thoughtfully designed components and features retain easy extensibility and customization while providing a solid foundation for your application.

The Uno.Extensions follows the Microsoft.Extensions model that creates a host environment where you can register additional dependencies. The registered dependencies are then available throughout the application via the Services (`IServiceProvider`) property on the `IHost` instance.

## Learn about Uno.Extensions features

Alongside Uno, the app template references a lineup of battle-tested packages providing key features. The resources below are available to help you get started with them in your project.

|Feature|Description|
|---|---|
|[Authentication](xref:Uno.Extensions.Authentication.HowToAuthentication)|The Uno.Extensions.Authentication package provides authentication services.|
|[Configuration](xref:Uno.Extensions.Configuration.HowToConfiguration)|The Uno.Extensions.Configuration package provides a way to configure an application based on a list of name-value pairs.|
|[Dependency injection](xref:Uno.Extensions.DependencyInjection.HowToDependencyInjection)|The Uno.Extensions.DependencyInjection package provides a simple and lightweight dependency injection system for .NET.|
|[Http](xref:Uno.Extensions.Http.Overview)|The Uno.Extensions.Http package provides configuration for native Http handlers and registration of endpoints.|
|[Localization](xref:Uno.Extensions.Localization.HowToUseLocalization)|The Uno.Extensions.Localization package provides access to localizable resources.|
|[Logging](xref:Uno.Extensions.Logging.UseLogging)|The Uno.Extensions.Logging package provides a way to log messages to a variety of output targets.|
|[Navigation](xref:Uno.Extensions.Navigation.HowToNavigateBetweenPages)|The Uno.Extensions.Navigation package provides a routing framework for navigation.|
|[Reactive](xref:Uno.Extensions.Reactive.General)|The Uno.Extensions.Reactive package provides a development framework for reactive applications.|
|[Serialization](xref:Uno.Extensions.Serialization.Overview)|The Uno.Extensions.Serialization package provides helpers for JSON serialization.|
|[Validation](xref:Uno.Extensions.Validation.Overview)|The Uno.Extensions.Validation package provides support for data validation.|

> [!TIP]
> To view more detailed information about the specific APIs leveraged in each topic, expand the Reference section in the navigation pane.
