---
uid: Reference.Navigation.Overview
---

# Navigation Reference Overview

Welcome to the Navigation Reference documentation! Here, you will find detailed information about the specific APIs utilized across various aspects of navigation. These topics will guide you through the design principles, navigation regions, qualifiers, and essential interfaces like `INavigator`. You'll also learn how to implement custom request handlers effectively. Use the table below to explore each topic further.

| **Topic**                | **Description**                                                                 |
|--------------------------|---------------------------------------------------------------------------------|
| [Design](xref:Reference.Navigation.Design) | Learn about the foundational design concepts behind the navigation system.        |
| [Navigation Region](xref:Reference.Navigation.Regions) | Understand how navigation regions work and how to leverage them in your app.      |
| [Qualifiers](xref:Reference.Navigation.Qualifiers) | Explore how qualifiers are used to influence navigation decisions.              |
| [INavigator](xref:Reference.Navigation.Navigator) | Discover the `INavigator` interface and how it orchestrates navigation.          |
| [Implement IRequestHandler](xref:Reference.Navigation.RequestHandler) | Learn how to implement custom request handlers for specific navigation scenarios. |

If you're looking for an introduction, How-Tos, or instructions on how to install navigation, please refer to the [Navigation Introduction documentation](xref:Uno.Extensions.Navigation.Overview).
