#ifndef GAMESCENE_H
#define GAMESCENE_H

#include "cocos2d.h"
#include "behaviac/base/core/container/vector_t.h"
USING_NS_CC;

class PlaneEnemy;
class PlaneHero;
class NPC;
class Hero;
namespace behaviac{
    class Agent;
}
//Ϸ
class GameScene : public Layer
{
    //ϷϢ
public:
    enum NodeTag
    {
        HERO_TAG = 100,
        ENEMY_TAG = 101,
        HERO_BULLET_TAG = 102,
        SCORE_LABEL = 103,
        PAUSE_MENU = 104,
        AI_TAG = 105,
    };

    //ײ¼bitλ
    enum ContactMaskBit
    {
        ENEMY_CONTACTMASKBIT = 0x01 || 0x02,
        HERO_BULLET_CONTACTMASKBIT = 0x01,
        HERO_CONTACTMASKBIT = 0x02
    };

    //ϷlevelԽlevelԽ
    enum Level
    {
        LEVEL1,
        LEVEL2,
        LEVEL3,
        LEVEL4,
        LEVEL5
    };

    ////levelķ
    //enum LevelUp_Score
    //{
    //       Level1Up_Score = 0,
    //	Level2Up_Score = 200,
    //	Level3Up_Score = 500,
    //	Level4Up_Score = 1000
    //};

    static const float refresh_delay[]; //սˢ¼

public:
    static Scene* createScene();
    CREATE_FUNC(GameScene);
    bool init();

public:
    static GameScene* sharedGameLayer() { return m_gamelayer; } //ȡϷ㵥

private:
    static GameScene* m_gamelayer; //Ϸĵ
public:
    SpriteBatchNode* getBulletBox() { return m_bulletBox; }	 //ȡӵȾ
    void AdjustHeroPosition(Node* hero);
    void gameover();
private:
    SpriteBatchNode *m_bulletBox; //ӵȾ

private:
    int m_level; //ǰϷlevel
    int m_score; //ǰϷ

private:
    void playBackground(); //ƶϷ
    void publishScore(); //洢Ϸ

    void pauseButtonCallBack(Ref* pSender); //ͣťص
    void AIButtonCallBack(Ref* pSender); //AIťص

    bool dealWithContact(PhysicsContact&); //ײ¼ص
    void hitEnemy(PlaneEnemy* enemy);
    void hitHero(PlaneHero* hero);

    void levelUp(Level level);//
    //ϷscheduleĻص
    void testLevel(float dt); //ÿһΣݵǰķϷlevel
    //hero Plane's position
    //void setHeroPlaneUnderPosition(CCPoint _targetPosition);
    //m_isAIʾǷʹAI
    bool m_isAI;
    //m_canBossRefreshʾɷˢbossÿdtˢһ
    void resetBoss(float dt);
    NPC * m_NPC;
    Hero* m_Hero;
public:
    // //create Update for behaviac
    void Update(float dt);
    static void addBehaviacAgentDeleteQueue(behaviac::Agent* pAgent);
private:
    static void cleanBehaviacAgentDeleteQueue();
private:
    /******************************************************************
    Date        : 2015-11-13 16:40:05
    Author      : Quinn Pan
    Desc        : add some behaviac into the queue , and delete it
    ******************************************************************/
    static behaviac::vector<behaviac::Agent*> m_bt_agent_delete_queue;
};

#endif

