/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Tencent is pleased to support the open source community by making behaviac available.
//
// Copyright (C) 2015 THL A29 Limited, a Tencent company. All rights reserved.
//
// Licensed under the BSD 3-Clause License (the "License"); you may not use this file except in compliance with
// the License. You may obtain a copy of the License at http://opensource.org/licenses/BSD-3-Clause
//
// Unless required by applicable law or agreed to in writing, software distributed under the License is
// distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and limitations under the License.
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////

using System.Collections.Generic;

namespace behaviac
{
    public class FSM : BehaviorNode
    {
        public FSM()
        {
        }

        ~FSM()
        {
        }

        public override bool decompose(BehaviorNode node, PlannerTaskComplex seqTask, int depth, Planner planner)
        {
            Debug.Check(false);

            return false;
        }


        protected override void load(int version, string agentType, List<property_t> properties)
        {
            base.load(version, agentType, properties);

            foreach (property_t p in properties)
            {
                if (p.name == "initialid")
                {
                    this.m_initialid = System.Convert.ToInt32(p.value);
                }
            }
        }
        public override bool IsValid(Agent pAgent, BehaviorTask pTask)
        {
            if (!(pTask.GetNode() is FSM))
            {
                return false;
            }

            return base.IsValid(pAgent, pTask);
        }

        private int m_initialid = -1;
        public int InitialId
        {
            get
            {
                return this.m_initialid;
            }
            set
            {
                this.m_initialid = value;
            }
        }

        protected override BehaviorTask createTask()
        {
            return new FSMTask();
        }

        public class FSMTask : CompositeTask
        {
            public FSMTask()
            {
            }

            ~FSMTask()
            {
            }

            public override void copyto(BehaviorTask target)
            {
                base.copyto(target);
            }

            public override void save(ISerializableNode node)
            {
                base.save(node);
            }

            public override void load(ISerializableNode node)
            {
                base.load(node);
            }

            //used for FSM
            private int m_currentNodeId = -1;

            protected override bool onenter(Agent pAgent)
            {
                Debug.Check(this.m_node != null);
                FSM fsm = (FSM)this.m_node;

                this.m_activeChildIndex = 0;

                this.m_currentNodeId = fsm.InitialId;

                return true;
            }

            protected override void onexit(Agent pAgent, EBTStatus s)
            {
                this.m_currentNodeId = -1;

                base.onexit(pAgent, s);
            }

            private EBTStatus UpdateFSM(Agent pAgent, EBTStatus childStatus)
            {
                Debug.Check(this.m_node != null);
                Debug.Check(this.m_currentNodeId != -1);

                EBTStatus status = childStatus;
                bool bLoop = true;

                while (bLoop)
                {
                    BehaviorTask currentState = this.GetChildById(this.m_currentNodeId);
                    currentState.exec(pAgent);

                    if (currentState is State.StateTask)
                    {
                        State.StateTask pStateTask = (State.StateTask)currentState;

                        if (pStateTask.IsEndState)
                        {
                            return EBTStatus.BT_SUCCESS;
                        }
                    }

                    int nextStateId = currentState.GetNextStateId();

                    if (nextStateId == -1)
                    {
                        //if not transitioned, don't go on next state, to exit
                        bLoop = false;
                    }
                    else
                    {
                        //if transitioned, go on next state
                        this.m_currentNodeId = nextStateId;
                    }
                }

                return status;
            }

            protected override EBTStatus update_current(Agent pAgent, EBTStatus childStatus)
            {
                EBTStatus status = this.update(pAgent, childStatus);

                return status;
            }

            protected override EBTStatus update(Agent pAgent, EBTStatus childStatus)
            {
                Debug.Check(this.m_activeChildIndex < this.m_children.Count);
                Debug.Check(this.m_node is FSM);

                EBTStatus s = this.UpdateFSM(pAgent, childStatus);

                return s;
            }
        }
    }
}
