/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Tencent is pleased to support the open source community by making behaviac available.
//
// Copyright (C) 2015 THL A29 Limited, a Tencent company. All rights reserved.
//
// Licensed under the BSD 3-Clause License (the "License"); you may not use this file except in compliance with
// the License. You may obtain a copy of the License at http://opensource.org/licenses/BSD-3-Clause
//
// Unless required by applicable law or agreed to in writing, software distributed under the License is
// distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and limitations under the License.
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "behaviac/base/base.h"
#include "behaviac/behaviortree/nodes/actions/noop.h"

namespace behaviac
{
    Noop::Noop()
    {}

    Noop::~Noop()
    {}

    void Noop::load(int version, const char* agentType, const properties_t& properties)
    {
        super::load(version, agentType, properties);
    }

    bool Noop::IsValid(Agent* pAgent, BehaviorTask* pTask) const
    {
        BEHAVIAC_UNUSED_VAR(pAgent);
        BEHAVIAC_UNUSED_VAR(pTask);

        if (!Noop::DynamicCast(pTask->GetNode()))
        {
            return false;
        }

        //used in unittest
        //return super::IsValid(pAgent, pTask);
        return true;
    }

    BehaviorTask* Noop::createTask() const
    {
        NoopTask* pTask = BEHAVIAC_NEW NoopTask();

        return pTask;
    }

    void NoopTask::copyto(BehaviorTask* target) const
    {
        super::copyto(target);
    }

    void NoopTask::save(ISerializableNode* node) const
    {
        super::save(node);
    }

    void NoopTask::load(ISerializableNode* node)
    {
        super::load(node);
    }

    bool NoopTask::onenter(Agent* pAgent)
    {
        BEHAVIAC_UNUSED_VAR(pAgent);
        return true;
    }

    void NoopTask::onexit(Agent* pAgent, EBTStatus s)
    {
        BEHAVIAC_UNUSED_VAR(pAgent);
        BEHAVIAC_UNUSED_VAR(s);
    }

    EBTStatus NoopTask::update(Agent* pAgent, EBTStatus childStatus)
    {
        BEHAVIAC_UNUSED_VAR(pAgent);
        BEHAVIAC_UNUSED_VAR(childStatus);
        //...
        return BT_SUCCESS;
    }
}
