
<div align="center" min-width=519px>
  <img src=".resources/rmcl_logo_landscape_small.png" alt="RMCL" height=150 />  
</div>


<!-- ![RMCL](.resources/rmcl_logo_landscape_small.png) -->
<div align="center">
<h4 align="center">Software Tools for Mobile Robot Localization in 3D Meshes</h4>
</div>

<div align="center">
  <a href="https://github.com/uos/rmcl">Code</a>
  <span>&nbsp;&nbsp;•&nbsp;&nbsp;</span>
  <a href="https://github.com/uos/rmcl/wiki">Documentation</a>
  <span>&nbsp;&nbsp;•&nbsp;&nbsp;</span>
  <a href="https://youtube.com/playlist?list=PL9wBuzh6ev07O2YzbjP4qbcretntl5axI">Videos</a>
  <span>&nbsp;&nbsp;•&nbsp;&nbsp;</span>
  <a href="https://github.com/uos/rmcl/issues">Issues</a>
  <span>&nbsp;&nbsp;•&nbsp;&nbsp;</span>
  <a href="https://github.com/amock/rmcl_examples">Examples</a>
  <br />
</div>

<br/>

This repository contains algorithms designed for map-based robot localization, specifically when dealing with maps composed of triangle meshes or complete scene graphs. These maps may be provided by architects who have designed the building in which the robot operates, or they can be autonomously generated by the robot through Simultaneous Localization and Mapping (SLAM) methods. It's crucial to note that map-based localization differs from SLAM; it focuses on estimating the robot's pose within a potentially large map, whether the initial pose is roughly known (tracking) or entirely unknown from the start aka kidnapped robot problem. Map-based localization is essential for precisely planning the robot's missions on a given map.

## MICP-L - Pose Tracking in Meshes

MICP-L: Mesh-based ICP for Robot Localization Using Hardware-Accelerated Ray Casting.
An approach to directly register range sensor data to a mesh in order to localize a mobile robot using hardware-accelerated ray casting correspondences (See publications).

[![Teaser](.resources/micp.gif)](http://www.youtube.com/watch?v=G-Z5K0bPFFU)

|  Hilti: 6DoF Localization  | MulRan: Large-scale scenes |
|:--:|:--:|
| <a href="http://www.youtube.com/watch?v=5pubwlbrpro" target="_blank" ><img src="https://i.ytimg.com/vi/5pubwlbrpro/maxresdefault.jpg" alt="MICP-L Hilti Video" width="100%" style="max-width: 500px" height="auto" /></a> | <a href="http://www.youtube.com/watch?v=8j6ZtYPnFzw" target="_blank" ><img src="https://i.ytimg.com/vi/8j6ZtYPnFzw/maxresdefault.jpg" alt="MICP-L MulRan Video" width="100%" style="max-width: 500px" height="auto" /></a> |

Requirements:
- At least one range sensor is equipped and running
- Triangle mesh as map
- Prior odometry estimation of the robot given as TF

IMU prior is also possible as long as it is integrated as TF-Transform, e.g. with [Madgwick Filter](http://wiki.ros.org/imu_filter_madgwick).

Read more details [here](./docs/MICPL.md) or if you seek for a quick start and you have no robot available, go to our hands-on examples: [https://github.com/amock/rmcl_examples](https://github.com/amock/rmcl_examples).

### Publication

Please reference the following paper when using the MICP-L method in your scientific work.

```bib
@inproceedings{mock2024micpl,
  title={{MICP-L}: Mesh-based ICP for Robot Localization Using Hardware-Accelerated Ray Casting}, 
  author={Mock, Alexander and Wiemann, Thomas and Pütz, Sebastian and Hertzberg, Joachim},
  booktitle={2024 IEEE/RSJ International Conference on Intelligent Robots and Systems (IROS)}, 
  year={2024},
  pages={10664-10671},
  doi={10.1109/IROS58592.2024.10802360}
}
```

The paper is available on [IEEE Xplore](https://ieeexplore.ieee.org/document/10802360) and as preprint on [arXiv](https://arxiv.org/abs/2210.13904). The experiments are available at [https://github.com/amock/micp_experiments](https://github.com/amock/micp_experiments), but they are primarily compatible with the ROS 1 version.  
See the older branches or commits for reference.

## RMCL - Global 6D Localization in Meshes from 1D Range Measurements 

Ray Casting Monte Carlo Localization (RMCL) provides a practical, real-time implementation of Monte Carlo Localization (MCL) for global robot localization, accelerated by high-performance ray tracing over triangle meshes and geometric scene graphs. MCL has a decades-long track record; our focus is making it easy to deploy and tune on real robots. The pipeline scales across diverse hardware with parameters to meet tight compute and memory budgets (including for our smallest robots). The documentation begins with hands-on usage and configuration of `rmcl_localization_node`, followed by a concise overview of the underlying concepts and design choices.

![Teaser](.resources/rmcl.gif)

Read more details [here](./docs/RMCL.md).


# RMCL - Project

## Installation

Dependencies:
- ROS 2 (check compatible branches)
- Download and put [Rmagine](https://github.com/uos/rmagine) (v >= 2.3.2) into your ROS workspace.
  - Recommended: Install OptiX backend if NVIDIA GPU is available.
- Optional for functionality, but required for visualizations: [mesh_tools](https://github.com/naturerobots/mesh_tools).

Clone this repository into your ROS workspace and build it.

```console
colcon build
```

### Branch Compatibility

|  RMCL Branch    |  Supported ROS 2 versions    |
|:----|:----|
|  main   |  humble, jazzy |

## Mesh Navigation

To navigate a robot automatically and safely through uneven terrain, the combination RMCL + MeshNav is very suitable: [https://github.com/naturerobots/mesh_navigation](https://github.com/naturerobots/mesh_navigation). As we presented at [ROSCon 2023](https://vimeo.com/879000775):

<a href="https://vimeo.com/879000775" target="_blank" ><img src=".resources/ROSCon2023.png" alt="MICP-L ROSCon 2023 Video" width="300px" /></a>

