# OptiX NVidia Driver Compatibility
# See here: https://github.com/NVIDIA/optix-dev/releases

# Usage: 
# max_optix_version(NVIDIA_DRIVER_VERSION MAX_OPTIX_VERSION)
# message(STATUS "Maximum allowed optix version for the current nvidia driver is: ${MAX_OPTIX_VERSION}")
function(max_optix_version _NVIDIA_DRIVER_VERSION _MAX_OPTIX_VERSION)

if(${_NVIDIA_DRIVER_VERSION} VERSION_GREATER_EQUAL 570.0.0)
  set(${_MAX_OPTIX_VERSION} 9.0.0 PARENT_SCOPE)
elseif(${_NVIDIA_DRIVER_VERSION} VERSION_GREATER_EQUAL 555.0.0)
  set(${_MAX_OPTIX_VERSION} 8.1.0 PARENT_SCOPE)
elseif(${_NVIDIA_DRIVER_VERSION} VERSION_GREATER_EQUAL 535.0.0)
  set(${_MAX_OPTIX_VERSION} 8.0.0 PARENT_SCOPE)
elseif(${_NVIDIA_DRIVER_VERSION} VERSION_GREATER_EQUAL 530.41.0)
  set(${_MAX_OPTIX_VERSION} 7.7.0 PARENT_SCOPE)
elseif(${_NVIDIA_DRIVER_VERSION} VERSION_GREATER_EQUAL 522.25.0)
  set(${_MAX_OPTIX_VERSION} 7.6.0 PARENT_SCOPE)
elseif(${_NVIDIA_DRIVER_VERSION} VERSION_GREATER_EQUAL 515.48.0)
  set(${_MAX_OPTIX_VERSION} 7.5.0 PARENT_SCOPE)
elseif(${_NVIDIA_DRIVER_VERSION} VERSION_GREATER_EQUAL 495.89.0)
  set(${_MAX_OPTIX_VERSION} 7.4.0 PARENT_SCOPE)
elseif(${_NVIDIA_DRIVER_VERSION} VERSION_GREATER_EQUAL 465.84.0)
  set(${_MAX_OPTIX_VERSION} 7.3.0 PARENT_SCOPE)
elseif(${_NVIDIA_DRIVER_VERSION} VERSION_GREATER_EQUAL 456.71.0)
  set(${_MAX_OPTIX_VERSION} 7.2.0 PARENT_SCOPE)
elseif(${_NVIDIA_DRIVER_VERSION} VERSION_GREATER_EQUAL 450.0.0)
  set(${_MAX_OPTIX_VERSION} 7.1.0 PARENT_SCOPE)
elseif(${_NVIDIA_DRIVER_VERSION} VERSION_GREATER_EQUAL 435.80.0)
  set(${_MAX_OPTIX_VERSION} 7.0.0 PARENT_SCOPE)
endif()

endfunction()