# Release Notes - v1.2.0

## 🎉 New Features

### Configuration Options

Two new configuration parameters are now available in `check-projects.yml`:

#### 1. `use_tui_by_default`

Set the default mode for check-projects.

```yaml
use_tui_by_default: false  # Set to true to always launch in TUI mode
```

- **Default:** `false`
- **CLI Override:** `--tui` flag
- When set to `true`, check-projects will automatically launch in interactive TUI mode
- Command line flag still overrides the config setting

#### 2. `fetch`

Automatically fetch from remote repositories before checking status.

```yaml
fetch: false  # Set to true to always fetch from remote before checking
```

- **Default:** `false`
- **CLI Override:** `--fetch` / `-f` flag
- When set to `true`, runs `git fetch` on all repositories before checking status
- Updates local cache of remote branches to show accurate ahead/behind status
- Runs concurrently (max 10 repos at a time) for performance
- Command line flag overrides the config setting

### Remote Status Detection

#### Behind Remote Detection (↓)

Projects that are behind their remote branch now show with a **red ↓ symbol**.

```sh
x uralys/web
  ↓ www              # Requires pull
```

This indicates the remote has commits that aren't in your local branch - you need to pull.

#### Ahead Remote Detection (⬆)

Projects ahead of remote now show with a **green ⬆ symbol** (previously was red).

```sh
x coorpacademy
  ⬆ mobile           # Ready to push
```

This indicates you have local commits that aren't pushed yet.

### Enhanced TUI Remote Status Messages

When viewing clean projects in TUI mode, you now see detailed remote status:

**When local is clean and up to date:**

```sh
✔ No local changes
✔ Up to date with remote
```

**When local is clean but ahead:**

```sh
✔ No local changes
⬆ Ready to be pushed
```

**When local is clean but behind:**

```sh
✔ No local changes
↓ Remote is ahead: Requires pull
```

**When local has uncommitted changes:**

```sh
[tui]
M  file1.js
?? file2.js

↓ Remote is ahead: Requires pull
```

or

```sh
[tui]
M  file1.js

⬆ Also ahead of remote
```

## 🎨 Improvements

### Color Consistency

- **Green (⬆):** Projects ahead of remote - indicates commits ready to push
- **Red (↓):** Projects behind remote or with local changes - requires action
- Centralized color theme system for easier maintenance

### Messages

- Changed "No git changes to display" to "✔ No local changes" for clarity
- All status messages now use consistent checkmark (✔) and arrow (⬆/↓) symbols

## 📝 Configuration Examples

### Example 1: Always use TUI and fetch

```yaml
categories:
  - name: work
    root: ~/Projects/work

display:
  hide_clean: true

use_tui_by_default: true
fetch: true
```

With this config, running `check-projects` will:

1. Fetch all repositories from remote
2. Launch in TUI mode automatically
3. Show only projects with changes

### Example 2: CLI mode with manual fetch

```yaml
use_tui_by_default: false
fetch: false
```

Then use flags when needed:

```bash
check-projects --fetch -v    # Fetch and show all projects
check-projects --tui         # Launch TUI when you want it
```

## 🔧 Usage

### New Command Line Flags

```bash
# Fetch from remote before checking (short form)
check-projects -f

# Fetch from remote before checking (long form)
check-projects --fetch

# Combine with other flags
check-projects --fetch -v              # Fetch and show all
check-projects --fetch --category work # Fetch only work category
check-projects --fetch --tui           # Fetch and launch TUI
```

### Why Use Fetch?

Without fetching, git only knows about remote changes from the last time you ran `git fetch`. The `--fetch` option ensures you see the current state of remote branches:

**Without fetch:**

```bash
check-projects
# Shows status based on last fetch (might be outdated)
```

**With fetch:**

```bash
check-projects --fetch
# Fetches all repos first, then shows current remote status
```

## 📦 Updated Files

- `internal/config/config.go` - Added new config fields
- `internal/git/status.go` - Added `Fetch()` method and behind detection
- `cmd/check-projects/main.go` - Added fetch logic and flag handling
- `internal/tui/view.go` - Enhanced remote status display
- `README.md` - Updated documentation
- `check-projects.example.yml` - Added new options

## 🔄 Migration Guide

No breaking changes - all new features are opt-in. Existing configurations will work without modification.

To use the new features, add these optional lines to your `check-projects.yml`:

```yaml
use_tui_by_default: false
fetch: false
```

Both default to `false` to maintain backward compatibility.

## 🐛 Bug Fixes

- Fixed color of ⬆ symbol (now green instead of red)
- Improved remote status accuracy in TUI mode

## 💡 Tips

1. **Daily workflow:** Set `fetch: true` in your config to always see accurate remote status
2. **Fast checks:** Keep `fetch: false` and use `--fetch` only when you need remote status
3. **TUI lovers:** Set `use_tui_by_default: true` and enjoy the interactive mode by default
