# Release Notes - v1.2.3

## 🐛 Bug Fixes

### TUI: Fixed "All projects are clean!" Displaying Incorrectly

The TUI would incorrectly show "All projects are clean!" when viewing a clean category, even if other categories had pending changes. Now correctly checks all categories before showing the "all clean" view.

**Before:** Viewing "core" category (clean) → Shows "All projects are clean!" (even though "uralys/web" has changes)

**After:** Shows split view with all categories → User can navigate to see all categories with changes

### TUI: Fixed Unicode Character Handling

Fixed improper parsing of multi-byte UTF-8 characters (✱) by using proper string functions instead of byte slicing.

### Staged Changes Detection

Git status now explicitly detects and displays staged changes with colored symbols:

- **Staged renames:** `✱ R` (✱ in red, R in green)
- **Staged new files:** `✱ +` (✱ in red, + in green)
- **Other staged changes:** `✱` (red)

**Example:**

```sh
x uralys/web
  ✱ R www    # Staged renames
  ✱ + new-project # Staged new files
```

## 🎨 Improvements

### Colored Status Symbols

Both console and TUI modes now display colored symbols for better visibility:

- `✱` in **red** - Indicates changes requiring attention
- Status letter (R, +, M, etc.) in **green** - Indicates staged/ready state

### Enhanced Git Status Display

- **Console mode:** Project list shows colored symbols
- **TUI project list (left panel):** Colored status symbols
- **TUI details panel (right panel):** Colored symbols in git status output
