# v1.2.4 - 2025-11-22

## Bug Fixes

### TUI Category Selection

Fixed a critical bug in TUI mode where categories would display blank screens when selected.

**Issue**: When navigating between categories in TUI mode with `hide_clean=true` (default), some categories would show empty project lists even when they contained projects with changes.

**Root Cause**: The category selection logic was comparing indices from different arrays:

- `i` (index in filtered `visibleCategories`)
- `m.selectedCategory` (index in complete `m.categories` list)

This mismatch caused categories to never be properly marked as selected, resulting in empty displays.

**Fix**:

- Calculate the correct index (`currentIndex`) of the selected category within the filtered visible categories list
- Use this `currentIndex` for all selection comparisons
- Ensure a visible category is automatically selected when projects are loaded

**Impact**: TUI mode now correctly displays projects for all categories, especially when using the default `hide_clean=true` setting.

### UI Improvements

- Changed category navigation arrows (◀ ▶) from green to blue to match category styling
- Improved visual consistency in the TUI interface

## Technical Details

**Files Modified**:

- `internal/tui/view.go`: Fixed category selection logic in `renderCategoryTabsOnly()`
- `internal/tui/update.go`: Added automatic selection of first visible category on load
