---
title: "Compiler Error CS1703 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS1703"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1703"
ms.assetid: b17738e9-ed35-46b0-88b8-763ce24211d1
caps.latest.revision: 11
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Error CS1703
An assembly with the same simple name 'name' has already been imported. Try removing one of the references or sign them to enable side-by-side.  
  
 The compiler removes references that have the same path and file name, but it is possible that the same file exists in two places, or that you forgot to change the version number. This error points out that two references have the same assembly identity and thus the compiler has no way of distinguishing between them in metadata. Either remove one of the redundant references, or make the references unique somehow, such as by incrementing the assembly version number.  
  
 The following code generates error CS1703.  
  
## Example  
 This code creates assembly A in the .\bin1 directory.  
  
 Save this example in a file named CS1703a1.cs, and compile it with the following flags: `/t:library /out:.\bin1\cs1703.dll /keyfile:key.snk`  
  
```  
using System;  
public class A { }  
```  
  
## Example  
 This code creates a copy of assembly A in the .\bin2 directory.  
  
 Save this example in a file named CS1703a2.cs, and compile it with the following flags: `/t:library /out:.\bin2\cs1703.dll /keyfile:key.snk`  
  
```  
using System;  
public class A { }  
```  
  
## Example  
 This code references the assembly A in the two prior modules.  
  
 Save this example in a file named CS1703ref.cs, and compile it with the following flags: `/t:library /r:A2=.\bin2\cs1703.dll /r:A1=.\bin1\cs1703.dll`  
  
```  
extern alias A1;  
extern alias A2;  
```