---
title: "Compiler Error CS0837 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0837"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0837"
ms.assetid: cbde45dc-222c-4bfe-8814-856476319d37
caps.latest.revision: 8
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0837
The first operand of an "is" or "as" operator may not be a lambda expression or anonymous method.  
  
 Lambda expressions and anonymous methods may not be used on the left side of [is](../../csharp/language-reference/keywords/is.md) or [as](../../csharp/language-reference/keywords/as.md).  
  
## To correct this error  
  
-   If the error involves the `is` operator, remember that `is` takes a value and a type and tells you whether the value can be made into that type by a reference, boxing, or unboxing conversion. Because lambdas are not values and have no reference, boxing, or unboxing conversions, lambdas are not candidates for `is`.  
  
-   If the code misuses `as`, the correction is probably to change it to a cast.  
  
## Example  
 The following example generates CS0837:  
  
```  
// cs0837.cs  
namespace TestNamespace  
{  
    public delegate void Del();  
  
    class Test  
    {  
        static int Main()  
        {  
            bool b1 = (() => { }) is Del;   // CS0837  
            bool b2 = delegate() { } is Del;// CS0837  
            Del d1 = () => { } as Del;      // CS0837  
            Del d2 = delegate() { } as Del; // CS0837  
            return 1;  
        }  
    }  
}  
```