---
title: "Compiler Error CS1601 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS1601"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1601"
ms.assetid: 5efa1d2d-c70c-446d-a51f-d23d8a3be22e
caps.latest.revision: 10
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS1601
Method or delegate parameter cannot be of type 'type'  
  
 Some types in the .NET Framework class library, for example, <xref:System.TypedReference>, <xref:System.RuntimeArgumentHandle> and <xref:System.ArgIterator> cannot be used as [ref](../../csharp/language-reference/keywords/ref.md) or [out](../../csharp/language-reference/keywords/out.md) parameters because they could potentially be used to perform unsafe operations.  
  
 The following sample generates CS1601:  
  
```  
// CS1601.cs  
using System;  
  
class MyClass  
{  
   public void Test1 (ref TypedReference t)   // CS1601  
   {  
   }  
  
   public void Test2 (out ArgIterator t)   // CS1601  
   {  
   }  
}  
```