---
title: "Compiler Error CS5001 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS5001"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS5001"
ms.assetid: e1e26e75-84e0-47c7-be8a-3c4fd0d6f497
caps.latest.revision: 14
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS5001
Program 'program' does not contain a static 'Main' method suitable for an entry point  
  
 This error occurs when no static [Main](../../csharp/programming-guide/main-and-command-args/index.md) method with a correct signature is found in the code that produces an executable file. This error also occurs if the entry point function, `Main`, is defined with the wrong case, such as lower-case `main`.  
  
-   `Main` must be declared as static and it must return [void](../../csharp/language-reference/keywords/void.md) or [int](../../csharp/language-reference/keywords/int.md), and it must have either no parameters or else one parameter of type `string[]`.  
  
## Example  
 The following example generates CS5001:  
  
```  
// CS5001.cs  
// CS5001 expected  
public class a  
{  
   // Uncomment the following line to resolve.  
   // static void Main() {}  
}  
```  
  
## See Also  
 [Main() and Command-Line Arguments](../../csharp/programming-guide/main-and-command-args/index.md)