---
title: "Visual Basic settings | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net

ms.suite: ""
ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
dev_langs: 
  - "VB"
helpviewer_keywords: 
  - "settings, Visual Basic"
ms.assetid: 2712b3b1-18f2-430c-ae91-28468bbf5f32
caps.latest.revision: 19
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Visual Basic settings
Visual Basic settings are designed to optimize the user experience and to maximize the productivity of Visual Basic developers. It is part of the [Customizing Development Settings in Visual Studio](http://msdn.microsoft.com/en-us/22c4debb-4e31-47a8-8f19-16f328d7dcd3) feature, which enables you to customize and save your settings in the Visual Studio Integrated Development Environment (IDE).  
  
 You can also port or reload your IDE settings on other computers. For more information, see [How to: Share Settings Between Computers](http://msdn.microsoft.com/en-us/1131fb10-35c1-42da-9cd8-91aa3235b882).  
  
## Windows and views  
  
|Feature|Displayed by default?|Notes|  
|---|---|---|    
|[Class View](https://docs.microsoft.com/visualstudio/ide/viewing-the-structure-of-code)|No|Hides **Hidden Types and Members**|  
|[Command Window](https://docs.microsoft.com/visualstudio/ide/reference/command-window)|No||  
|**Dynamic Help** window|No|Does not appear when you press F1.|  
|[Immediate Window](https://docs.microsoft.com/visualstudio/ide/reference/immediate-window)|Yes, when debugging starts.||  
|[Object Browser](https://docs.microsoft.com/visualstudio/ide/viewing-the-structure-of-code)|No|Displays, by default:<br /><br /> -   Namespaces<br />-   Public members<br />-   Inherited members|  
|[Output Window](https://docs.microsoft.com/visualstudio/ide/reference/output-window)|Yes, when build starts.||  
|[Properties Window](https://docs.microsoft.com/visualstudio/ide/reference/properties-window)|Yes||  
|**Solution Explorer**|Yes||  
|**Server Explorer**|No|Displays data connections and available system services.|  
|[Start Page](https://docs.microsoft.com/visualstudio/ide/customizing-the-start-page-for-visual-studio)|Yes|Appears the first time you start the IDE. You can customize it.|  
|**Task List**|Yes, when compile errors or warnings exist.||  
|[Team Explorer](http://msdn.microsoft.com/library/1372e56c-b34f-42c2-b72c-94b57620c75c)|Yes|You can use Team Explorer to access your team projects and use the application lifecycle management features of Team Foundation. These include version control, builds, project management, integrated reports, and dashboards.|  
|[Toolbox](https://docs.microsoft.com/visualstudio/ide/reference/toolbox)|Yes|Displays controls and components in alphabetical order.|  
  
 In addition, the following elements have certain behaviors enabled when you select **Visual Basic Development Settings**.  
  
## Dialog boxes  
  
|Feature|Behavior|
|---|---|  
|**New Project** dialog box|When other platforms are installed on the computer, the IDE enables the combo box that allows you to specify the targeted platform.|  
|[Options Dialog Box](https://docs.microsoft.com/visualstudio/ide/reference/options-dialog-box-visual-studio)|Visual Basic enables simplified **Options** pages. Click the **Show All Settings** check box to see the full list of options.|  
  
## Keyboard  
  
|Feature|Behavior|  
|---|---|  
|Visual Basic 6.0 default shortcut keys|Supports typical Visual Basic 6 keyboard mapping.|  
  
## Miscellaneous IDE elements  
  
|Feature|Behavior|  
|---|---|  
|Tool tips|-   Appear for all menu items and toolbar buttons when the mouse hovers above them.|  
|[Visual Basic IntelliSense Code Snippets](../../../visual-basic/developing-apps/using-ide/intellisense-code-snippets.md)|Includes a library of code snippets that are ready to be inserted in your application.|  
|[Visual Basic-Specific IntelliSense](https://docs.microsoft.com/visualstudio/ide/visual-basic-specific-intellisense)|-   Provides all of the IntelliSense features with some productivity enhancements for Visual Basic developers.|  
  
## See Also  
 [How to: Change Select Settings](http://msdn.microsoft.com/en-us/ec70b520-a3e3-43c9-929b-bdc732cd2147)   
 [How to: Specify Settings for a Team](http://msdn.microsoft.com/en-us/89eeee3d-dd5e-4815-a45b-c48add63a8aa)   
 [How to: Share Settings Between Computers or Visual Studio Versions](http://msdn.microsoft.com/en-us/1131fb10-35c1-42da-9cd8-91aa3235b882)