---
title: "Visual Basic | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
dev_langs: 
  - "VB"
helpviewer_keywords: 
  - "programming, Visual Basic"
  - "Visual Basic"
ms.assetid: 5cc578fe-d9e5-4015-937d-b34b83207072
caps.latest.revision: 37
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Visual Basic
Visual Basic is engineered for productively building type-safe and object-oriented applications. Visual Basic enables developers to target Windows, Web, and mobile devices. As with all languages targeting the Microsoft .NET Framework, programs written in Visual Basic benefit from security and language interoperability.  
  
 This generation of Visual Basic continues the tradition of giving you a fast and easy way to create .NET Framework-based applications.  
  
 If you don't already have Visual Basic, you can acquire a version of Visual Studio that includes Visual Basic for free from the [Visual Studio](https://www.visualstudio.com/products/free-developer-offers-vs) site.  
  
## In This Section  
 [Getting Started](../visual-basic/getting-started/index.md)   
 Helps you begin working by listing what is new and what is available in various editions of the product.  
   
 [Programming Concepts](../visual-basic/programming-guide/concepts/index.md) 
 Presents the language concepts that are most useful to Visual Basic programmers.

 [Program Structure and Code Conventions](../visual-basic/programming-guide/program-structure/program-structure-and-code-conventions.md)  
 Contains documentation on the basic structure and code conventions of Visual Basic such as naming conventions, comments in code, and limitations within Visual Basic.  
  
 [Visual Basic Language Features](../visual-basic/programming-guide/language-features/index.md)  
 Provides links to topics that introduce and discuss important features of Visual Basic, including LINQ and XML literals.  
   
 [Visual Basic Reference](../visual-basic/reference/index.md)  
 Contains the Visual Basic language and compiler information.  

 [Developing Applications with Visual Basic](../visual-basic/developing-apps/index.md)  
 Discusses various aspects of development in Visual Basic, such as the code editor, security, exception handling, debugging, and using the [!INCLUDE[dnprdnshort](../csharp/getting-started/includes/dnprdnshort_md.md)] class library.

 [COM Interop](../visual-basic/programming-guide/com-interop/index.md)  
 Explains the interoperability issues associated with creating and using component object model (COM) objects with Visual Basic.  
  
 [Samples](../visual-basic/sample-applications.md)  
 Contains information about samples.  
  
 [Walkthroughs](../visual-basic/walkthroughs.md)  
 Provides links to step-by-step instructions for common scenarios.  
  
## Related Sections  
 [Get Started Developing with Visual Studio](https://docs.microsoft.com/visualstudio/ide/get-started-developing-with-visual-studio)  
 Provides links to topics that help you learn about the basics of Visual Studio.  
  
 [.NET Framework Class Library](http://go.microsoft.com/fwlink/?LinkID=227195)  
 Provides entry to the library of classes, interfaces, and value types that are included in the Microsoft [!INCLUDE[dnprdnshort](../csharp/getting-started/includes/dnprdnshort_md.md)] SDK.