// Copyright (c) 2014-2018, The Monero Project
// 
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
// 
// 1. Redistributions of source code must retain the above copyright notice, this list of
//    conditions and the following disclaimer.
// 
// 2. Redistributions in binary form must reproduce the above copyright notice, this list
//    of conditions and the following disclaimer in the documentation and/or other
//    materials provided with the distribution.
// 
// 3. Neither the name of the copyright holder nor the names of its contributors may be
//    used to endorse or promote products derived from this software without specific
//    prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
// THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
// THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

/*!
 * \file dutch.h
 * 
 * \brief New Dutch word list and map.
 */

#ifndef DUTCH_H
#define DUTCH_H

#include <vector>
#include <unordered_map>
#include "language_base.h"
#include <string>

/*!
 * \namespace Language
 * \brief Mnemonic language related namespace.
 */
namespace Language
{
  class Dutch: public Base
  {
  public:
    Dutch(): Base("Nederlands", std::vector<std::string>({
        "aalglad",
        "aalscholver",
        "aambeeld",
        "aangeef",
        "aanlandig",
        "aanvaard",
        "aanwakker",
        "aapmens",
        "aarten",
        "abdicatie",
        "abnormaal",
        "abrikoos",
        "accu",
        "acuut",
        "adjudant",
        "admiraal",
        "advies",
        "afbidding",
        "afdracht",
        "affaire",
        "affiche",
        "afgang",
        "afkick",
        "afknap",
        "aflees",
        "afmijner",
        "afname",
        "afpreekt",
        "afrader",
        "afspeel",
        "aftocht",
        "aftrek",
        "afzijdig",
        "ahornboom",
        "aktetas",
        "akzo",
        "alchemist",
        "alcohol",
        "aldaar",
        "alexander",
        "alfabet",
        "alfredo",
        "alice",
        "alikruik",
        "allrisk",
        "altsax",
        "alufolie",
        "alziend",
        "amai",
        "ambacht",
        "ambieer",
        "amina",
        "amnestie",
        "amok",
        "ampul",
        "amuzikaal",
        "angela",
        "aniek",
        "antje",
        "antwerpen",
        "anya",
        "aorta",
        "apache",
        "apekool",
        "appelaar",
        "arganolie",
        "argeloos",
        "armoede",
        "arrenslee",
        "artritis",
        "arubaan",
        "asbak",
        "ascii",
        "asgrauw",
        "asjes",
        "asml",
        "aspunt",
        "asurn",
        "asveld",
        "aterling",
        "atomair",
        "atrium",
        "atsma",
        "atypisch",
        "auping",
        "aura",
        "avifauna",
        "axiaal",
        "azoriaan",
        "azteek",
        "azuur",
        "bachelor",
        "badderen",
        "badhotel",
        "badmantel",
        "badsteden",
        "balie",
        "ballans",
        "balvers",
        "bamibal",
        "banneling",
        "barracuda",
        "basaal",
        "batelaan",
        "batje",
        "beambte",
        "bedlamp",
        "bedwelmd",
        "befaamd",
        "begierd",
        "begraaf",
        "behield",
        "beijaard",
        "bejaagd",
        "bekaaid",
        "beks",
        "bektas",
        "belaad",
        "belboei",
        "belderbos",
        "beloerd",
        "beluchten",
        "bemiddeld",
        "benadeeld",
        "benijd",
        "berechten",
        "beroemd",
        "besef",
        "besseling",
        "best",
        "betichten",
        "bevind",
        "bevochten",
        "bevraagd",
        "bewust",
        "bidplaats",
        "biefstuk",
        "biemans",
        "biezen",
        "bijbaan",
        "bijeenkom",
        "bijfiguur",
        "bijkaart",
        "bijlage",
        "bijpaard",
        "bijtgaar",
        "bijweg",
        "bimmel",
        "binck",
        "bint",
        "biobak",
        "biotisch",
        "biseks",
        "bistro",
        "bitter",
        "bitumen",
        "bizar",
        "blad",
        "bleken",
        "blender",
        "bleu",
        "blief",
        "blijven",
        "blozen",
        "bock",
        "boef",
        "boei",
        "boks",
        "bolder",
        "bolus",
        "bolvormig",
        "bomaanval",
        "bombarde",
        "bomma",
        "bomtapijt",
        "bookmaker",
        "boos",
        "borg",
        "bosbes",
        "boshuizen",
        "bosloop",
        "botanicus",
        "bougie",
        "bovag",
        "boxspring",
        "braad",
        "brasem",
        "brevet",
        "brigade",
        "brinckman",
        "bruid",
        "budget",
        "buffel",
        "buks",
        "bulgaar",
        "buma",
        "butaan",
        "butler",
        "buuf",
        "cactus",
        "cafeetje",
        "camcorder",
        "cannabis",
        "canyon",
        "capoeira",
        "capsule",
        "carkit",
        "casanova",
        "catalaan",
        "ceintuur",
        "celdeling",
        "celplasma",
        "cement",
        "censeren",
        "ceramisch",
        "cerberus",
        "cerebraal",
        "cesium",
        "cirkel",
        "citeer",
        "civiel",
        "claxon",
        "clenbuterol",
        "clicheren",
        "clijsen",
        "coalitie",
        "coassistentschap",
        "coaxiaal",
        "codetaal",
        "cofinanciering",
        "cognac",
        "coltrui",
        "comfort",
        "commandant",
        "condensaat",
        "confectie",
        "conifeer",
        "convector",
        "copier",
        "corfu",
        "correct",
        "coup",
        "couvert",
        "creatie",
        "credit",
        "crematie",
        "cricket",
        "croupier",
        "cruciaal",
        "cruijff",
        "cuisine",
        "culemborg",
        "culinair",
        "curve",
        "cyrano",
        "dactylus",
        "dading",
        "dagblind",
        "dagje",
        "daglicht",
        "dagprijs",
        "dagranden",
        "dakdekker",
        "dakpark",
        "dakterras",
        "dalgrond",
        "dambord",
        "damkat",
        "damlengte",
        "damman",
        "danenberg",
        "debbie",
        "decibel",
        "defect",
        "deformeer",
        "degelijk",
        "degradant",
        "dejonghe",
        "dekken",
        "deppen",
        "derek",
        "derf",
        "derhalve",
        "detineren",
        "devalueer",
        "diaken",
        "dicht",
        "dictaat",
        "dief",
        "digitaal",
        "dijbreuk",
        "dijkmans",
        "dimbaar",
        "dinsdag",
        "diode",
        "dirigeer",
        "disbalans",
        "dobermann",
        "doenbaar",
        "doerak",
        "dogma",
        "dokhaven",
        "dokwerker",
        "doling",
        "dolphijn",
        "dolven",
        "dombo",
        "dooraderd",
        "dopeling",
        "doping",
        "draderig",
        "drama",
        "drenkbak",
        "dreumes",
        "drol",
        "drug",
        "duaal",
        "dublin",
        "duplicaat",
        "durven",
        "dusdanig",
        "dutchbat",
        "dutje",
        "dutten",
        "duur",
        "duwwerk",
        "dwaal",
        "dweil",
        "dwing",
        "dyslexie",
        "ecostroom",
        "ecotaks",
        "educatie",
        "eeckhout",
        "eede",
        "eemland",
        "eencellig",
        "eeneiig",
        "eenruiter",
        "eenwinter",
        "eerenberg",
        "eerrover",
        "eersel",
        "eetmaal",
        "efteling",
        "egaal",
        "egtberts",
        "eickhoff",
        "eidooier",
        "eiland",
        "eind",
        "eisden",
        "ekster",
        "elburg",
        "elevatie",
        "elfkoppig",
        "elfrink",
        "elftal",
        "elimineer",
        "elleboog",
        "elma",
        "elodie",
        "elsa",
        "embleem",
        "embolie",
        "emoe",
        "emonds",
        "emplooi",
        "enduro",
        "enfin",
        "engageer",
        "entourage",
        "entstof",
        "epileer",
        "episch",
        "eppo",
        "erasmus",
        "erboven",
        "erebaan",
        "erelijst",
        "ereronden",
        "ereteken",
        "erfhuis",
        "erfwet",
        "erger",
        "erica",
        "ermitage",
        "erna",
        "ernie",
        "erts",
        "ertussen",
        "eruitzien",
        "ervaar",
        "erven",
        "erwt",
        "esbeek",
        "escort",
        "esdoorn",
        "essing",
        "etage",
        "eter",
        "ethanol",
        "ethicus",
        "etholoog",
        "eufonisch",
        "eurocent",
        "evacuatie",
        "exact",
        "examen",
        "executant",
        "exen",
        "exit",
        "exogeen",
        "exotherm",
        "expeditie",
        "expletief",
        "expres",
        "extase",
        "extinctie",
        "faal",
        "faam",
        "fabel",
        "facultair",
        "fakir",
        "fakkel",
        "faliekant",
        "fallisch",
        "famke",
        "fanclub",
        "fase",
        "fatsoen",
        "fauna",
        "federaal",
        "feedback",
        "feest",
        "feilbaar",
        "feitelijk",
        "felblauw",
        "figurante",
        "fiod",
        "fitheid",
        "fixeer",
        "flap",
        "fleece",
        "fleur",
        "flexibel",
        "flits",
        "flos",
        "flow",
        "fluweel",
        "foezelen",
        "fokkelman",
        "fokpaard",
        "fokvee",
        "folder",
        "follikel",
        "folmer",
        "folteraar",
        "fooi",
        "foolen",
        "forfait",
        "forint",
        "formule",
        "fornuis",
        "fosfaat",
        "foxtrot",
        "foyer",
        "fragiel",
        "frater",
        "freak",
        "freddie",
        "fregat",
        "freon",
        "frijnen",
        "fructose",
        "frunniken",
        "fuiven",
        "funshop",
        "furieus",
        "fysica",
        "gadget",
        "galder",
        "galei",
        "galg",
        "galvlieg",
        "galzuur",
        "ganesh",
        "gaswet",
        "gaza",
        "gazelle",
        "geaaid",
        "gebiecht",
        "gebufferd",
        "gedijd",
        "geef",
        "geflanst",
        "gefreesd",
        "gegaan",
        "gegijzeld",
        "gegniffel",
        "gegraaid",
        "gehikt",
        "gehobbeld",
        "gehucht",
        "geiser",
        "geiten",
        "gekaakt",
        "gekheid",
        "gekijf",
        "gekmakend",
        "gekocht",
        "gekskap",
        "gekte",
        "gelubberd",
        "gemiddeld",
        "geordend",
        "gepoederd",
        "gepuft",
        "gerda",
        "gerijpt",
        "geseald",
        "geshockt",
        "gesierd",
        "geslaagd",
        "gesnaaid",
        "getracht",
        "getwijfel",
        "geuit",
        "gevecht",
        "gevlagd",
        "gewicht",
        "gezaagd",
        "gezocht",
        "ghanees",
        "giebelen",
        "giechel",
        "giepmans",
        "gips",
        "giraal",
        "gistachtig",
        "gitaar",
        "glaasje",
        "gletsjer",
        "gleuf",
        "glibberen",
        "glijbaan",
        "gloren",
        "gluipen",
        "gluren",
        "gluur",
        "gnoe",
        "goddelijk",
        "godgans",
        "godschalk",
        "godzalig",
        "goeierd",
        "gogme",
        "goklustig",
        "gokwereld",
        "gonggrijp",
        "gonje",
        "goor",
        "grabbel",
        "graf",
        "graveer",
        "grif",
        "grolleman",
        "grom",
        "groosman",
        "grubben",
        "gruijs",
        "grut",
        "guacamole",
        "guido",
        "guppy",
        "haazen",
        "hachelijk",
        "haex",
        "haiku",
        "hakhout",
        "hakken",
        "hanegem",
        "hans",
        "hanteer",
        "harrie",
        "hazebroek",
        "hedonist",
        "heil",
        "heineken",
        "hekhuis",
        "hekman",
        "helbig",
        "helga",
        "helwegen",
        "hengelaar",
        "herkansen",
        "hermafrodiet",
        "hertaald",
        "hiaat",
        "hikspoors",
        "hitachi",
        "hitparade",
        "hobo",
        "hoeve",
        "holocaust",
        "hond",
        "honnepon",
        "hoogacht",
        "hotelbed",
        "hufter",
        "hugo",
        "huilbier",
        "hulk",
        "humus",
        "huwbaar",
        "huwelijk",
        "hype",
        "iconisch",
        "idema",
        "ideogram",
        "idolaat",
        "ietje",
        "ijker",
        "ijkheid",
        "ijklijn",
        "ijkmaat",
        "ijkwezen",
        "ijmuiden",
        "ijsbox",
        "ijsdag",
        "ijselijk",
        "ijskoud",
        "ilse",
        "immuun",
        "impliceer",
        "impuls",
        "inbijten",
        "inbuigen",
        "indijken",
        "induceer",
        "indy",
        "infecteer",
        "inhaak",
        "inkijk",
        "inluiden",
        "inmijnen",
        "inoefenen",
        "inpolder",
        "inrijden",
        "inslaan",
        "invitatie",
        "inwaaien",
        "ionisch",
        "isaac",
        "isolatie",
        "isotherm",
        "isra",
        "italiaan",
        "ivoor",
        "jacobs",
        "jakob",
        "jammen",
        "jampot",
        "jarig",
        "jehova",
        "jenever",
        "jezus",
        "joana",
        "jobdienst",
        "josua",
        "joule",
        "juich",
        "jurk",
        "juut",
        "kaas",
        "kabelaar",
        "kabinet",
        "kagenaar",
        "kajuit",
        "kalebas",
        "kalm",
        "kanjer",
        "kapucijn",
        "karregat",
        "kart",
        "katvanger",
        "katwijk",
        "kegelaar",
        "keiachtig",
        "keizer",
        "kenletter",
        "kerdijk",
        "keus",
        "kevlar",
        "kezen",
        "kickback",
        "kieviet",
        "kijken",
        "kikvors",
        "kilheid",
        "kilobit",
        "kilsdonk",
        "kipschnitzel",
        "kissebis",
        "klad",
        "klagelijk",
        "klak",
        "klapbaar",
        "klaver",
        "klene",
        "klets",
        "klijnhout",
        "klit",
        "klok",
        "klonen",
        "klotefilm",
        "kluif",
        "klumper",
        "klus",
        "knabbel",
        "knagen",
        "knaven",
        "kneedbaar",
        "knmi",
        "knul",
        "knus",
        "kokhals",
        "komiek",
        "komkommer",
        "kompaan",
        "komrij",
        "komvormig",
        "koning",
        "kopbal",
        "kopklep",
        "kopnagel",
        "koppejan",
        "koptekst",
        "kopwand",
        "koraal",
        "kosmisch",
        "kostbaar",
        "kram",
        "kraneveld",
        "kras",
        "kreling",
        "krengen",
        "kribbe",
        "krik",
        "kruid",
        "krulbol",
        "kuijper",
        "kuipbank",
        "kuit",
        "kuiven",
        "kutsmoes",
        "kuub",
        "kwak",
        "kwatong",
        "kwetsbaar",
        "kwezelaar",
        "kwijnen",
        "kwik",
        "kwinkslag",
        "kwitantie",
        "lading",
        "lakbeits",
        "lakken",
        "laklaag",
        "lakmoes",
        "lakwijk",
        "lamheid",
        "lamp",
        "lamsbout",
        "lapmiddel",
        "larve",
        "laser",
        "latijn",
        "latuw",
        "lawaai",
        "laxeerpil",
        "lebberen",
        "ledeboer",
        "leefbaar",
        "leeman",
        "lefdoekje",
        "lefhebber",
        "legboor",
        "legsel",
        "leguaan",
        "leiplaat",
        "lekdicht",
        "lekrijden",
        "leksteen",
        "lenen",
        "leraar",
        "lesbienne",
        "leugenaar",
        "leut",
        "lexicaal",
        "lezing",
        "lieten",
        "liggeld",
        "lijdzaam",
        "lijk",
        "lijmstang",
        "lijnschip",
        "likdoorn",
        "likken",
        "liksteen",
        "limburg",
        "link",
        "linoleum",
        "lipbloem",
        "lipman",
        "lispelen",
        "lissabon",
        "litanie",
        "liturgie",
        "lochem",
        "loempia",
        "loesje",
        "logheid",
        "lonen",
        "lonneke",
        "loom",
        "loos",
        "losbaar",
        "loslaten",
        "losplaats",
        "loting",
        "lotnummer",
        "lots",
        "louie",
        "lourdes",
        "louter",
        "lowbudget",
        "luijten",
        "luikenaar",
        "luilak",
        "luipaard",
        "luizenbos",
        "lulkoek",
        "lumen",
        "lunzen",
        "lurven",
        "lutjeboer",
        "luttel",
        "lutz",
        "luuk",
        "luwte",
        "luyendijk",
        "lyceum",
        "lynx",
        "maakbaar",
        "magdalena",
        "malheid",
        "manchet",
        "manfred",
        "manhaftig",
        "mank",
        "mantel",
        "marion",
        "marxist",
        "masmeijer",
        "massaal",
        "matsen",
        "matverf",
        "matze",
        "maude",
        "mayonaise",
        "mechanica",
        "meifeest",
        "melodie",
        "meppelink",
        "midvoor",
        "midweeks",
        "midzomer",
        "miezel",
        "mijnraad",
        "minus",
        "mirck",
        "mirte",
        "mispakken",
        "misraden",
        "miswassen",
        "mitella",
        "moker",
        "molecule",
        "mombakkes",
        "moonen",
        "mopperaar",
        "moraal",
        "morgana",
        "mormel",
        "mosselaar",
        "motregen",
        "mouw",
        "mufheid",
        "mutueel",
        "muzelman",
        "naaidoos",
        "naald",
        "nadeel",
        "nadruk",
        "nagy",
        "nahon",
        "naima",
        "nairobi",
        "napalm",
        "napels",
        "napijn",
        "napoleon",
        "narigheid",
        "narratief",
        "naseizoen",
        "nasibal",
        "navigatie",
        "nawijn",
        "negatief",
        "nekletsel",
        "nekwervel",
        "neolatijn",
        "neonataal",
        "neptunus",
        "nerd",
        "nest",
        "neuzelaar",
        "nihiliste",
        "nijenhuis",
        "nijging",
        "nijhoff",
        "nijl",
        "nijptang",
        "nippel",
        "nokkenas",
        "noordam",
        "noren",
        "normaal",
        "nottelman",
        "notulant",
        "nout",
        "nuance",
        "nuchter",
        "nudorp",
        "nulde",
        "nullijn",
        "nulmeting",
        "nunspeet",
        "nylon",
        "obelisk",
        "object",
        "oblie",
        "obsceen",
        "occlusie",
        "oceaan",
        "ochtend",
        "ockhuizen",
        "oerdom",
        "oergezond",
        "oerlaag",
        "oester",
        "okhuijsen",
        "olifant",
        "olijfboer",
        "omaans",
        "ombudsman",
        "omdat",
        "omdijken",
        "omdoen",
        "omgebouwd",
        "omkeer",
        "omkomen",
        "ommegaand",
        "ommuren",
        "omroep",
        "omruil",
        "omslaan",
        "omsmeden",
        "omvaar",
        "onaardig",
        "onedel",
        "onenig",
        "onheilig",
        "onrecht",
        "onroerend",
        "ontcijfer",
        "onthaal",
        "ontvallen",
        "ontzadeld",
        "onzacht",
        "onzin",
        "onzuiver",
        "oogappel",
        "ooibos",
        "ooievaar",
        "ooit",
        "oorarts",
        "oorhanger",
        "oorijzer",
        "oorklep",
        "oorschelp",
        "oorworm",
        "oorzaak",
        "opdagen",
        "opdien",
        "opdweilen",
        "opel",
        "opgebaard",
        "opinie",
        "opjutten",
        "opkijken",
        "opklaar",
        "opkuisen",
        "opkwam",
        "opnaaien",
        "opossum",
        "opsieren",
        "opsmeer",
        "optreden",
        "opvijzel",
        "opvlammen",
        "opwind",
        "oraal",
        "orchidee",
        "orkest",
        "ossuarium",
        "ostendorf",
        "oublie",
        "oudachtig",
        "oudbakken",
        "oudnoors",
        "oudshoorn",
        "oudtante",
        "oven",
        "over",
        "oxidant",
        "pablo",
        "pacht",
        "paktafel",
        "pakzadel",
        "paljas",
        "panharing",
        "papfles",
        "paprika",
        "parochie",
        "paus",
        "pauze",
        "paviljoen",
        "peek",
        "pegel",
        "peigeren",
        "pekela",
        "pendant",
        "penibel",
        "pepmiddel",
        "peptalk",
        "periferie",
        "perron",
        "pessarium",
        "peter",
        "petfles",
        "petgat",
        "peuk",
        "pfeifer",
        "picknick",
        "pief",
        "pieneman",
        "pijlkruid",
        "pijnacker",
        "pijpelink",
        "pikdonker",
        "pikeer",
        "pilaar",
        "pionier",
        "pipet",
        "piscine",
        "pissebed",
        "pitchen",
        "pixel",
        "plamuren",
        "plan",
        "plausibel",
        "plegen",
        "plempen",
        "pleonasme",
        "plezant",
        "podoloog",
        "pofmouw",
        "pokdalig",
        "ponywagen",
        "popachtig",
        "popidool",
        "porren",
        "positie",
        "potten",
        "pralen",
        "prezen",
        "prijzen",
        "privaat",
        "proef",
        "prooi",
        "prozawerk",
        "pruik",
        "prul",
        "publiceer",
        "puck",
        "puilen",
        "pukkelig",
        "pulveren",
        "pupil",
        "puppy",
        "purmerend",
        "pustjens",
        "putemmer",
        "puzzelaar",
        "queenie",
        "quiche",
        "raam",
        "raar",
        "raat",
        "raes",
        "ralf",
        "rally",
        "ramona",
        "ramselaar",
        "ranonkel",
        "rapen",
        "rapunzel",
        "rarekiek",
        "rarigheid",
        "rattenhol",
        "ravage",
        "reactie",
        "recreant",
        "redacteur",
        "redster",
        "reewild",
        "regie",
        "reijnders",
        "rein",
        "replica",
        "revanche",
        "rigide",
        "rijbaan",
        "rijdansen",
        "rijgen",
        "rijkdom",
        "rijles",
        "rijnwijn",
        "rijpma",
        "rijstafel",
        "rijtaak",
        "rijzwepen",
        "rioleer",
        "ripdeal",
        "riphagen",
        "riskant",
        "rits",
        "rivaal",
        "robbedoes",
        "robot",
        "rockact",
        "rodijk",
        "rogier",
        "rohypnol",
        "rollaag",
        "rolpaal",
        "roltafel",
        "roof",
        "roon",
        "roppen",
        "rosbief",
        "rosharig",
        "rosielle",
        "rotan",
        "rotleven",
        "rotten",
        "rotvaart",
        "royaal",
        "royeer",
        "rubato",
        "ruby",
        "ruche",
        "rudge",
        "ruggetje",
        "rugnummer",
        "rugpijn",
        "rugtitel",
        "rugzak",
        "ruilbaar",
        "ruis",
        "ruit",
        "rukwind",
        "rulijs",
        "rumoeren",
        "rumsdorp",
        "rumtaart",
        "runnen",
        "russchen",
        "ruwkruid",
        "saboteer",
        "saksisch",
        "salade",
        "salpeter",
        "sambabal",
        "samsam",
        "satelliet",
        "satineer",
        "saus",
        "scampi",
        "scarabee",
        "scenario",
        "schobben",
        "schubben",
        "scout",
        "secessie",
        "secondair",
        "seculair",
        "sediment",
        "seeland",
        "settelen",
        "setwinst",
        "sheriff",
        "shiatsu",
        "siciliaan",
        "sidderaal",
        "sigma",
        "sijben",
        "silvana",
        "simkaart",
        "sinds",
        "situatie",
        "sjaak",
        "sjardijn",
        "sjezen",
        "sjor",
        "skinhead",
        "skylab",
        "slamixen",
        "sleijpen",
        "slijkerig",
        "slordig",
        "slowaak",
        "sluieren",
        "smadelijk",
        "smiecht",
        "smoel",
        "smos",
        "smukken",
        "snackcar",
        "snavel",
        "sneaker",
        "sneu",
        "snijdbaar",
        "snit",
        "snorder",
        "soapbox",
        "soetekouw",
        "soigneren",
        "sojaboon",
        "solo",
        "solvabel",
        "somber",
        "sommatie",
        "soort",
        "soppen",
        "sopraan",
        "soundbar",
        "spanen",
        "spawater",
        "spijgat",
        "spinaal",
        "spionage",
        "spiraal",
        "spleet",
        "splijt",
        "spoed",
        "sporen",
        "spul",
        "spuug",
        "spuw",
        "stalen",
        "standaard",
        "star",
        "stefan",
        "stencil",
        "stijf",
        "stil",
        "stip",
        "stopdas",
        "stoten",
        "stoven",
        "straat",
        "strobbe",
        "strubbel",
        "stucadoor",
        "stuif",
        "stukadoor",
        "subhoofd",
        "subregent",
        "sudoku",
        "sukade",
        "sulfaat",
        "surinaams",
        "suus",
        "syfilis",
        "symboliek",
        "sympathie",
        "synagoge",
        "synchroon",
        "synergie",
        "systeem",
        "taanderij",
        "tabak",
        "tachtig",
        "tackelen",
        "taiwanees",
        "talman",
        "tamheid",
        "tangaslip",
        "taps",
        "tarkan",
        "tarwe",
        "tasman",
        "tatjana",
        "taxameter",
        "teil",
        "teisman",
        "telbaar",
        "telco",
        "telganger",
        "telstar",
        "tenant",
        "tepel",
        "terzet",
        "testament",
        "ticket",
        "tiesinga",
        "tijdelijk",
        "tika",
        "tiksel",
        "tilleman",
        "timbaal",
        "tinsteen",
        "tiplijn",
        "tippelaar",
        "tjirpen",
        "toezeggen",
        "tolbaas",
        "tolgeld",
        "tolhek",
        "tolo",
        "tolpoort",
        "toltarief",
        "tolvrij",
        "tomaat",
        "tondeuse",
        "toog",
        "tooi",
        "toonbaar",
        "toos",
        "topclub",
        "toppen",
        "toptalent",
        "topvrouw",
        "toque",
        "torment",
        "tornado",
        "tosti",
        "totdat",
        "toucheer",
        "toulouse",
        "tournedos",
        "tout",
        "trabant",
        "tragedie",
        "trailer",
        "traject",
        "traktaat",
        "trauma",
        "tray",
        "trechter",
        "tred",
        "tref",
        "treur",
        "troebel",
        "tros",
        "trucage",
        "truffel",
        "tsaar",
        "tucht",
        "tuenter",
        "tuitelig",
        "tukje",
        "tuktuk",
        "tulp",
        "tuma",
        "tureluurs",
        "twijfel",
        "twitteren",
        "tyfoon",
        "typograaf",
        "ugandees",
        "uiachtig",
        "uier",
        "uisnipper",
        "ultiem",
        "unitair",
        "uranium",
        "urbaan",
        "urendag",
        "ursula",
        "uurcirkel",
        "uurglas",
        "uzelf",
        "vaat",
        "vakantie",
        "vakleraar",
        "valbijl",
        "valpartij",
        "valreep",
        "valuatie",
        "vanmiddag",
        "vanonder",
        "varaan",
        "varken",
        "vaten",
        "veenbes",
        "veeteler",
        "velgrem",
        "vellekoop",
        "velvet",
        "veneberg",
        "venlo",
        "vent",
        "venusberg",
        "venw",
        "veredeld",
        "verf",
        "verhaaf",
        "vermaak",
        "vernaaid",
        "verraad",
        "vers",
        "veruit",
        "verzaagd",
        "vetachtig",
        "vetlok",
        "vetmesten",
        "veto",
        "vetrek",
        "vetstaart",
        "vetten",
        "veurink",
        "viaduct",
        "vibrafoon",
        "vicariaat",
        "vieux",
        "vieveen",
        "vijfvoud",
        "villa",
        "vilt",
        "vimmetje",
        "vindbaar",
        "vips",
        "virtueel",
        "visdieven",
        "visee",
        "visie",
        "vlaag",
        "vleugel",
        "vmbo",
        "vocht",
        "voesenek",
        "voicemail",
        "voip",
        "volg",
        "vork",
        "vorselaar",
        "voyeur",
        "vracht",
        "vrekkig",
        "vreten",
        "vrije",
        "vrozen",
        "vrucht",
        "vucht",
        "vugt",
        "vulkaan",
        "vulmiddel",
        "vulva",
        "vuren",
        "waas",
        "wacht",
        "wadvogel",
        "wafel",
        "waffel",
        "walhalla",
        "walnoot",
        "walraven",
        "wals",
        "walvis",
        "wandaad",
        "wanen",
        "wanmolen",
        "want",
        "warklomp",
        "warm",
        "wasachtig",
        "wasteil",
        "watt",
        "webhandel",
        "weblog",
        "webpagina",
        "webzine",
        "wedereis",
        "wedstrijd",
        "weeda",
        "weert",
        "wegmaaien",
        "wegscheer",
        "wekelijks",
        "wekken",
        "wekroep",
        "wektoon",
        "weldaad",
        "welwater",
        "wendbaar",
        "wenkbrauw",
        "wens",
        "wentelaar",
        "wervel",
        "wesseling",
        "wetboek",
        "wetmatig",
        "whirlpool",
        "wijbrands",
        "wijdbeens",
        "wijk",
        "wijnbes",
        "wijting",
        "wild",
        "wimpelen",
        "wingebied",
        "winplaats",
        "winter",
        "winzucht",
        "wipstaart",
        "wisgerhof",
        "withaar",
        "witmaker",
        "wokkel",
        "wolf",
        "wonenden",
        "woning",
        "worden",
        "worp",
        "wortel",
        "wrat",
        "wrijf",
        "wringen",
        "yoghurt",
        "ypsilon",
        "zaaijer",
        "zaak",
        "zacharias",
        "zakelijk",
        "zakkam",
        "zakwater",
        "zalf",
        "zalig",
        "zaniken",
        "zebracode",
        "zeeblauw",
        "zeef",
        "zeegaand",
        "zeeuw",
        "zege",
        "zegje",
        "zeil",
        "zesbaans",
        "zesenhalf",
        "zeskantig",
        "zesmaal",
        "zetbaas",
        "zetpil",
        "zeulen",
        "ziezo",
        "zigzag",
        "zijaltaar",
        "zijbeuk",
        "zijlijn",
        "zijmuur",
        "zijn",
        "zijwaarts",
        "zijzelf",
        "zilt",
        "zimmerman",
        "zinledig",
        "zinnelijk",
        "zionist",
        "zitdag",
        "zitruimte",
        "zitzak",
        "zoal",
        "zodoende",
        "zoekbots",
        "zoem",
        "zoiets",
        "zojuist",
        "zondaar",
        "zotskap",
        "zottebol",
        "zucht",
        "zuivel",
        "zulk",
        "zult",
        "zuster",
        "zuur",
        "zweedijk",
        "zwendel",
        "zwepen",
        "zwiep",
        "zwijmel",
        "zworen"
      }), 4)
    {
      populate_maps();
    }
  };
}

#endif
