//OPOA.cookieLast =false;
//Read url href attribute from the DOM
OPOA.Configs.url = "href";
// The content returned from the server, extract the contents of # content display html
OPOA.Configs.find = "#content";
// If you find the specified # content is not found, show all content
OPOA.Configs.notFound = "all";
// Load prompt treatment
OPOA.Configs.loading = {
	// ajax request start
	"start" : function() {
		$("#contentDIV").html("");
		$("#loadingDIV").show();
	},
	// ajax request success
	"success" : function() {
		$("#loadingDIV").hide();
	},
	"error" : function() {
		$("#contentDIV").html("<h2>Sorry, an error occurred request! Please try again later.</h2>");
	},
	// ajax request ends (regardless of success or failure will be called)
	"end" : function(hash) {
		$("#loadingDIV").hide();
		

		 // After finished loading a request, a request for a page Hash action instance initialization
		 // show list

		 if(hash.indexOf("list")!=-1){
			 //opoaInstance
			 var opoa={
				 "actions":"#show A[hash]",
				 "show":"#contentDIV"
			 };
								
			 EasyOPOA.start([opoa]);
		 }
		 //show now menu
		 showMenu();
	}
};

// HTTP code 
OPOA.Configs.urlErrors = {
	// 404 HTTP code
	404 : function() {
		$("#contentDIV").html("<h2>404, I'm sorry, the page you requested is not found! May have lapsed.</h2>");
	},
	// 500 HTTP code
	500 : function() {
		$("#contentDIV").html("<h2>500, I'm sorry, a server error! Please try again later.</h2>");
	}
};
// opoaInstance
var opoa = {
	"actions" : "#menuDIV .menu",
	"show" : "#contentDIV"
};
EasyOPOA.notHash = function() {
	$("#loadingDIV").hide();
	// show welcome
	OPOA.load("welcome");
};

//Registration home page Hash action page
EasyOPOA.addActionMap("list/:pageNo", "list.jsp?pageNo={pageNo}", opoa);
//Registration son of a reference Hash action page
EasyOPOA.addActionMap("show/:id", "show.jsp?pageNo=1&id={id}", opoa);
EasyOPOA.addActionMap("edit/:id", "edit.jsp?pageNo=1&id={id}", opoa);
EasyOPOA.addActionMap("delete/:id", "do/doDelete.jsp?pageNo=1&id={id}", opoa);

EasyOPOA.addActionMap("show/:pageNo/:id", "show.jsp?pageNo={pageNo}&id={id}", opoa);
EasyOPOA.addActionMap("edit/:pageNo/:id", "edit.jsp?pageNo={pageNo}&id={id}", opoa);
EasyOPOA.addActionMap("delete/:pageNo/:id", "do/doDelete.jsp?pageNo={pageNo}&id={id}", opoa);

//Modified form submission
EasyOPOA.addActionMap("doEdit", "do/doEdit.jsp", opoa);
EasyOPOA.addActionMap("doAdd", "do/doAdd.jsp", opoa);

//url,opoa,postData
//EasyOPOA.homeUrl("welcome.jsp", opoa);
//hash,postData
EasyOPOA.home("welcome");

//opoaInstance list
var opoaList = [ opoa ];
//Start using opoaList
EasyOPOA.start(opoaList);





//Processing menu display
var oldMenu = $("#menuDIV [class~='nowMenu']");

function showMenu() {
	var welcomeMenu=/.*welcome.*/g;
	var listMenu=/.*list.*|.*show.*|.*edit.*|.*doEdit.*|.*doDelete.*/g;
	var addMenu=/.*add.*/g;
	var aboutMenu=/.*about.*/g;
	
	var hash = window.location.hash;
	var nowMenu = $("#menuDIV [class~='defaultMenu']");
	if (hash) {
		hash=hash.substring(1);
		
		if(welcomeMenu.test(hash)){
			nowMenu= $("#menuDIV [hash='welcome']");
		}else if(listMenu.test(hash)){
			nowMenu= $("#menuDIV [hash='list']");
		}else if(addMenu.test(hash)){
			nowMenu= $("#menuDIV [hash='add']");
		}else if(aboutMenu.test(hash)){
			nowMenu= $("#menuDIV [hash='about']");
		}
		

	} else {
		nowMenu= $("#menuDIV [hash='welcome']");
	}
	oldMenu.removeClass("nowMenu");
	nowMenu.addClass("nowMenu");
	oldMenu = nowMenu;
}

$(function() {
	// show default menu
	showMenu();
	// Menu click change
	$("#menuDIV [class~='menu']").on("click", function() {
		var old = $("#menuDIV [class~='nowMenu']");
		oldMenu.removeClass("nowMenu");
		oldMenu = $(this);
		oldMenu.addClass("nowMenu");
	});
	$("#menuDIV [class~='menu']").on("focus", function() {
		this.blur();
	});

});