# Post Build Signing

In publishing v3, signing will be moved out of the build step and will be completed post-build in a release pipeline. This reduces the time required for builds that do not require signing and allows repos to have more control over when the signing process occurs.

Any repositories that wish to move to post-build signing should ensure that they're using v3 publishing, including Publish.proj. Repositories that produce wix installers (msi's, wixlabs, etc) are additionally required to use Microsoft.DotNet.Build.Tasks.SharedFramework.Sdk and ensure that ItemsToSign in the AssetManifest includes the generated *wixpack.zip files generated by the SDK.
If PostBuildSign==true then no other steps are needed, post-build signing is enabled and configured by default.

Steps to ensure that post-build signing is correctly set up for a repo: A manifest file is created as part of the build process, it can be found in AssetManifests/Manifest.xml. This file lists everything that will be signed once the build is complete. If this file has been created and the contents of the ItemsToSign section match the expected set of signed files for the build then no further action is needed.


More information about the file types that are signed and the certificates used to sign them can be found here:
https://github.com/dotnet/arcade/blob/master/src/Microsoft.DotNet.Arcade.Sdk/tools/Sign.props

Additional information about the publishing process in general can be found here:
https://github.com/dotnet/arcade/blob/master/Documentation/CorePackages/Publishing.md

Additional information about the legacy signing process can be found here:
https://github.com/dotnet/arcade/blob/master/Documentation/CorePackages/Signing.md
