<p align="center">
  <a href="https://vuefire.vuejs.org" target="_blank" rel="noopener noreferrer">
    <img width="100" src="https://vuefire.vuejs.org/logo.svg" alt="VueFire logo">
  </a>
</p>
<br/>
<p align="center">
  <a href="https://npmjs.com/package/vuefire"><img src="https://badgen.net/npm/v/vuefire" alt="npm package"></a>
  <a href="https://github.com/vuejs/vuefire/actions/workflows/test.yml"><img src="https://github.com/vuejs/vuefire/workflows/test/badge.svg?branch=main" alt="build status"></a>
  <a href="https://codecov.io/gh/vuejs/vuefire"><img src="https://codecov.io/gh/vuejs/vuefire/graph/badge.svg?token=CSDk1ePUQc"/></a>
</p>
<br/>

> Firebase for Vue made easy!

- Works with Vue >=2.7 and Vue 3
- Supports Composition and Options API
- Supports Vuex, Pinia, and anything that gives you a Vue `ref()`
- Built for Modular Firebase >=9 for optimal tree shaking
- Automatically listen for changes in nested references

[**📚 Documentation**](https://vuefire.vuejs.org/)

## Help me keep working on this project 💚

- [Become a Sponsor on GitHub](https://github.com/sponsors/posva)
- [One-time donation via PayPal](https://paypal.me/posva)

<!--sponsors start-->

<h4 align="center">Silver Sponsors</h4>
<p align="center">
    <a href="https://www.vuemastery.com/" target="_blank" rel="noopener noreferrer">
    <picture>
      <source srcset="https://posva-sponsors.pages.dev/logos/vuemastery-dark.png" media="(prefers-color-scheme: dark)" height="42px" alt="VueMastery" />
      <img src="https://posva-sponsors.pages.dev/logos/vuemastery-light.svg" height="42px" alt="VueMastery" />
    </picture>
  </a>
    <a href="https://www.prefect.io/" target="_blank" rel="noopener noreferrer">
    <picture>
      <source srcset="https://posva-sponsors.pages.dev/logos/prefectlogo-dark.svg" media="(prefers-color-scheme: dark)" height="42px" alt="Prefect" />
      <img src="https://posva-sponsors.pages.dev/logos/prefectlogo-light.svg" height="42px" alt="Prefect" />
    </picture>
  </a>
</p>

<h4 align="center">Bronze Sponsors</h4>
<p align="center">
    <a href="https://stormier.ninja" target="_blank" rel="noopener noreferrer">
    <picture>
      <source srcset="https://avatars.githubusercontent.com/u/2486424?u=7b0c73ae5d090ce53bf59473094e9606fe082c59&v=4" media="(prefers-color-scheme: dark)" height="26px" alt="Stanislas Ormières" />
      <img src="https://avatars.githubusercontent.com/u/2486424?u=7b0c73ae5d090ce53bf59473094e9606fe082c59&v=4" height="26px" alt="Stanislas Ormières" />
    </picture>
  </a>
    <a href="https://www.vuejs.de" target="_blank" rel="noopener noreferrer">
    <picture>
      <source srcset="https://avatars.githubusercontent.com/u/4183726?u=6b50a8ea16de29d2982f43c5640b1db9299ebcd1&v=4" media="(prefers-color-scheme: dark)" height="26px" alt="Antony Konstantinidis" />
      <img src="https://avatars.githubusercontent.com/u/4183726?u=6b50a8ea16de29d2982f43c5640b1db9299ebcd1&v=4" height="26px" alt="Antony Konstantinidis" />
    </picture>
  </a>
    <a href="https://storyblok.com" target="_blank" rel="noopener noreferrer">
    <picture>
      <source srcset="https://posva-sponsors.pages.dev/logos/storyblok.png" media="(prefers-color-scheme: dark)" height="26px" alt="Storyblok" />
      <img src="https://posva-sponsors.pages.dev/logos/storyblok.png" height="26px" alt="Storyblok" />
    </picture>
  </a>
    <a href="https://ui.nuxt.com/pro" target="_blank" rel="noopener noreferrer">
    <picture>
      <source srcset="https://avatars.githubusercontent.com/u/81570812?v=4" media="(prefers-color-scheme: dark)" height="26px" alt="Nuxt UI Pro Templates" />
      <img src="https://avatars.githubusercontent.com/u/81570812?v=4" height="26px" alt="Nuxt UI Pro Templates" />
    </picture>
  </a>
</p>

<!--sponsors end-->

---

## Status

- VueFire and Nuxt VueFire are both currently stable

## Roadmap

You can follow the progress and future plans on [the Roadmap issue](https://github.com/vuejs/vuefire/issues/1241).

## Installation

VueFire requires the `firebase` package to be installed as well as `vuefire`:

```bash
npm install vuefire firebase
```

Check [the documentation](https://vuefire.vuejs.org/nuxt/getting-started.html) for Nuxt instructions.

## Usage

- [Getting Started](https://vuefire.vuejs.org/guide/getting-started.html)
- [Vite Demo](https://github.com/posva/vuefire-vite-example)
- [Nuxt demo - Spark Plan](https://github.com/posva/nuxt--vuefire-example-spark-plan)
- [Nuxt demo - Blaze Plan](https://github.com/posva/nuxt--vuefire-example-blaze-plan)

## Related

- [Firebase Web Docs](https://firebase.google.com/docs/web/setup)
  - [Realtime database](https://firebase.google.com/docs/database/)
  - [Cloud Firestore](https://firebase.google.com/docs/firestore/)

## License

[MIT](http://opensource.org/licenses/MIT)
