---
layout: 'home'

title: VueFire
titleTemplate: Official Firebase bindings for Vue.js

hero:
  name: VueFire
  text: Official Firebase bindings for Vue.js
  tagline: Idiomatic composables for realtime data and other Firebase services
  image:
    src: /logo.svg
    alt: VueFire logo
  actions:
    - theme: brand
      text: Get Started
      link: /guide/getting-started
    - theme: alt
      text: View on GitHub
      link: https://github.com/vuejs/vuefire

features:
  - title: Idiomatic
    details: Use composables that align with the declarative approach of Vue. Everything that can be automatically handled by VueFire is. Nested Collections, Document References, and more, are all handled for you.
  - title: Performant
    details: VueFire only handles the binding for you so your state is always up to date with the server. You'll still be able to use the Firebase JS SDK to its full potential!
  - title: Flexible
    details: Use Firebase Database, Firestore, Authentication, etc. VueFire exposes tree-shakable APIs that are built on top of the Firebase modular JS SDK.

footer: MIT Licensed | Copyright © 2016-present Eduardo San Martin Morote
---

<script setup>
import HomeSponsors from './.vitepress/theme/components/HomeSponsors.vue'
</script>

<HomeSponsors />
