/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wrapper.cli;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.wrapper.cli.CommandLineOption;
import org.apache.maven.wrapper.cli.ParsedCommandLineOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParsedCommandLine {
    private final Map<String, ParsedCommandLineOption> optionsByString = new HashMap<String, ParsedCommandLineOption>();
    private final Set<String> presentOptions = new HashSet<String>();
    private final List<String> extraArguments = new ArrayList<String>();

    ParsedCommandLine(Iterable<CommandLineOption> options) {
        for (CommandLineOption option : options) {
            ParsedCommandLineOption parsedOption = new ParsedCommandLineOption();
            for (String optionStr : option.getOptions()) {
                this.optionsByString.put(optionStr, parsedOption);
            }
        }
    }

    public String toString() {
        return String.format("options: %s, extraArguments: %s", this.quoteAndJoin(this.presentOptions), this.quoteAndJoin(this.extraArguments));
    }

    private String quoteAndJoin(Iterable<String> strings) {
        StringBuilder output = new StringBuilder();
        boolean isFirst = true;
        for (String string : strings) {
            if (!isFirst) {
                output.append(", ");
            }
            output.append("'");
            output.append(string);
            output.append("'");
            isFirst = false;
        }
        return output.toString();
    }

    public boolean hasOption(String option) {
        this.option(option);
        return this.presentOptions.contains(option);
    }

    public boolean hasAnyOption(Collection<String> logLevelOptions) {
        for (String option : logLevelOptions) {
            if (!this.hasOption(option)) continue;
            return true;
        }
        return false;
    }

    public ParsedCommandLineOption option(String option) {
        ParsedCommandLineOption parsedOption = this.optionsByString.get(option);
        if (parsedOption == null) {
            throw new IllegalArgumentException(String.format("Option '%s' not defined.", option));
        }
        return parsedOption;
    }

    public List<String> getExtraArguments() {
        return this.extraArguments;
    }

    void addExtraValue(String value) {
        this.extraArguments.add(value);
    }

    ParsedCommandLineOption addOption(String optionStr, CommandLineOption option) {
        ParsedCommandLineOption parsedOption = this.optionsByString.get(optionStr);
        this.presentOptions.addAll(option.getOptions());
        return parsedOption;
    }
}

