#
# Copyright (c) 2006-2013 Wade Alcorn - wade@bindshell.net
# Browser Exploitation Framework (BeEF) - http://beefproject.com
# See the file 'doc/COPYING' for copying permission
#
class Zenoss_daemon_csrf < BeEF::Core::Command
  
	def self.options
		return [
			{ 'name' => 'base', 'ui_label' => 'Zenoss web root', 'value' => 'http://192.168.1.1:8080/'}, 
			{ 'name' => 'service',
				'type' => 'combobox',
				'ui_label' => 'Daemon',
				'store_type' => 'arraystore',
				'store_fields' => ['service', 'description'],
				'store_data' => [
					['zeoctl', 'zeoctl (Zope Enterprise Objects server - shares database between Zope instances)'],
					['zopectl', 'zopectl (The Zope open source web application server)'],
					['zenhub', 'zenhub (Broker between the data layer and the collection daemons)'],
					['zenjobs', 'zenjobs (Zenjobs)'],
					['zenping', 'zenping (ICMP ping status monitoring)'],
					['zensyslog', 'zensyslog (Collection of and classification of syslog events)'],
					['zenstatus', 'zenstatus (Active TCP connection testing of remote daemons)'],
					['zenactions', 'zenactions (Alerts - SMTP, SNPP and Maintenance Windows)'],
					['zentrap', 'zentrap (Receives SNMP traps and turns them into events)'],
					['zenmodeler', 'zenmodeler (Configuration collection and configuration)'],
					['zenperfsnmp', 'zenperfsnmp (High performance asynchronous SNMP performance collection)'],
					['zencommand', 'zencommand (Runs plug-ins on the local box or on remote boxes through SSH)'],
					['zenprocess', 'zenprocess (Process monitoring using SNMP host resources MIB)'],
					['zenwin', 'zenwin (Windows Service Monitoring (WMI))'],
					['zeneventlog', 'zeneventlog (Collect (WMI) event log events (aka NT Eventlog))'],
					['zenjmx', 'zenjmx (ZenJMX)']
				],
				'emptyText' => 'Select a daemon',
				'valueField' => 'service',
				'displayField' => 'service', #'description',
				'mode' => 'local',
				'autoWidth' => true
			},
			{ 'name' => 'action',
				'type' => 'combobox',
				'ui_label' => 'Action',
				'store_type' => 'arraystore',
				'store_fields' => ['action'],
				'store_data' => [
					['Start'],['Stop'],['Restart']
				],
				'valueField' => 'action',
				'displayField' => 'action',
				'mode' => 'local',
				'autoWidth' => true
			}
		]
	end

	def post_execute
		save({'result' => @datastore['result']})
	end

end
