/*
Copyright 2016 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package mockec2

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/ec2"
)

func (m *MockEC2) AcceptReservedInstancesExchangeQuote(*ec2.AcceptReservedInstancesExchangeQuoteInput) (*ec2.AcceptReservedInstancesExchangeQuoteOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) AcceptReservedInstancesExchangeQuoteWithContext(aws.Context, *ec2.AcceptReservedInstancesExchangeQuoteInput, ...request.Option) (*ec2.AcceptReservedInstancesExchangeQuoteOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) AcceptReservedInstancesExchangeQuoteRequest(*ec2.AcceptReservedInstancesExchangeQuoteInput) (*request.Request, *ec2.AcceptReservedInstancesExchangeQuoteOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) AcceptVpcPeeringConnection(*ec2.AcceptVpcPeeringConnectionInput) (*ec2.AcceptVpcPeeringConnectionOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) AcceptVpcPeeringConnectionWithContext(aws.Context, *ec2.AcceptVpcPeeringConnectionInput, ...request.Option) (*ec2.AcceptVpcPeeringConnectionOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) AcceptVpcPeeringConnectionRequest(*ec2.AcceptVpcPeeringConnectionInput) (*request.Request, *ec2.AcceptVpcPeeringConnectionOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) AllocateHosts(*ec2.AllocateHostsInput) (*ec2.AllocateHostsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) AllocateHostsWithContext(aws.Context, *ec2.AllocateHostsInput, ...request.Option) (*ec2.AllocateHostsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) AllocateHostsRequest(*ec2.AllocateHostsInput) (*request.Request, *ec2.AllocateHostsOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) AssignIpv6Addresses(*ec2.AssignIpv6AddressesInput) (*ec2.AssignIpv6AddressesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) AssignIpv6AddressesWithContext(aws.Context, *ec2.AssignIpv6AddressesInput, ...request.Option) (*ec2.AssignIpv6AddressesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) AssignIpv6AddressesRequest(*ec2.AssignIpv6AddressesInput) (*request.Request, *ec2.AssignIpv6AddressesOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) AssociateIamInstanceProfile(*ec2.AssociateIamInstanceProfileInput) (*ec2.AssociateIamInstanceProfileOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) AssociateIamInstanceProfileWithContext(aws.Context, *ec2.AssociateIamInstanceProfileInput, ...request.Option) (*ec2.AssociateIamInstanceProfileOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) AssociateIamInstanceProfileRequest(*ec2.AssociateIamInstanceProfileInput) (*request.Request, *ec2.AssociateIamInstanceProfileOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) AssociateSubnetCidrBlock(*ec2.AssociateSubnetCidrBlockInput) (*ec2.AssociateSubnetCidrBlockOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) AssociateSubnetCidrBlockWithContext(aws.Context, *ec2.AssociateSubnetCidrBlockInput, ...request.Option) (*ec2.AssociateSubnetCidrBlockOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) AssociateSubnetCidrBlockRequest(*ec2.AssociateSubnetCidrBlockInput) (*request.Request, *ec2.AssociateSubnetCidrBlockOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) AssociateVpcCidrBlock(*ec2.AssociateVpcCidrBlockInput) (*ec2.AssociateVpcCidrBlockOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) AssociateVpcCidrBlockWithContext(aws.Context, *ec2.AssociateVpcCidrBlockInput, ...request.Option) (*ec2.AssociateVpcCidrBlockOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) AssociateVpcCidrBlockRequest(*ec2.AssociateVpcCidrBlockInput) (*request.Request, *ec2.AssociateVpcCidrBlockOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) AttachClassicLinkVpc(*ec2.AttachClassicLinkVpcInput) (*ec2.AttachClassicLinkVpcOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) AttachClassicLinkVpcWithContext(aws.Context, *ec2.AttachClassicLinkVpcInput, ...request.Option) (*ec2.AttachClassicLinkVpcOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) AttachClassicLinkVpcRequest(*ec2.AttachClassicLinkVpcInput) (*request.Request, *ec2.AttachClassicLinkVpcOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) AttachNetworkInterface(*ec2.AttachNetworkInterfaceInput) (*ec2.AttachNetworkInterfaceOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) AttachNetworkInterfaceWithContext(aws.Context, *ec2.AttachNetworkInterfaceInput, ...request.Option) (*ec2.AttachNetworkInterfaceOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) AttachNetworkInterfaceRequest(*ec2.AttachNetworkInterfaceInput) (*request.Request, *ec2.AttachNetworkInterfaceOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) AttachVolume(*ec2.AttachVolumeInput) (*ec2.VolumeAttachment, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) AttachVolumeWithContext(aws.Context, *ec2.AttachVolumeInput, ...request.Option) (*ec2.VolumeAttachment, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) AttachVolumeRequest(*ec2.AttachVolumeInput) (*request.Request, *ec2.VolumeAttachment) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) AttachVpnGateway(*ec2.AttachVpnGatewayInput) (*ec2.AttachVpnGatewayOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) AttachVpnGatewayWithContext(aws.Context, *ec2.AttachVpnGatewayInput, ...request.Option) (*ec2.AttachVpnGatewayOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) AttachVpnGatewayRequest(*ec2.AttachVpnGatewayInput) (*request.Request, *ec2.AttachVpnGatewayOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) BundleInstance(*ec2.BundleInstanceInput) (*ec2.BundleInstanceOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) BundleInstanceWithContext(aws.Context, *ec2.BundleInstanceInput, ...request.Option) (*ec2.BundleInstanceOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) BundleInstanceRequest(*ec2.BundleInstanceInput) (*request.Request, *ec2.BundleInstanceOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CancelBundleTask(*ec2.CancelBundleTaskInput) (*ec2.CancelBundleTaskOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CancelBundleTaskWithContext(aws.Context, *ec2.CancelBundleTaskInput, ...request.Option) (*ec2.CancelBundleTaskOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CancelBundleTaskRequest(*ec2.CancelBundleTaskInput) (*request.Request, *ec2.CancelBundleTaskOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CancelConversionTask(*ec2.CancelConversionTaskInput) (*ec2.CancelConversionTaskOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CancelConversionTaskWithContext(aws.Context, *ec2.CancelConversionTaskInput, ...request.Option) (*ec2.CancelConversionTaskOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CancelConversionTaskRequest(*ec2.CancelConversionTaskInput) (*request.Request, *ec2.CancelConversionTaskOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CancelExportTask(*ec2.CancelExportTaskInput) (*ec2.CancelExportTaskOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CancelExportTaskWithContext(aws.Context, *ec2.CancelExportTaskInput, ...request.Option) (*ec2.CancelExportTaskOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CancelExportTaskRequest(*ec2.CancelExportTaskInput) (*request.Request, *ec2.CancelExportTaskOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CancelImportTask(*ec2.CancelImportTaskInput) (*ec2.CancelImportTaskOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CancelImportTaskWithContext(aws.Context, *ec2.CancelImportTaskInput, ...request.Option) (*ec2.CancelImportTaskOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CancelImportTaskRequest(*ec2.CancelImportTaskInput) (*request.Request, *ec2.CancelImportTaskOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CancelReservedInstancesListing(*ec2.CancelReservedInstancesListingInput) (*ec2.CancelReservedInstancesListingOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CancelReservedInstancesListingWithContext(aws.Context, *ec2.CancelReservedInstancesListingInput, ...request.Option) (*ec2.CancelReservedInstancesListingOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CancelReservedInstancesListingRequest(*ec2.CancelReservedInstancesListingInput) (*request.Request, *ec2.CancelReservedInstancesListingOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CancelSpotFleetRequests(*ec2.CancelSpotFleetRequestsInput) (*ec2.CancelSpotFleetRequestsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CancelSpotFleetRequestsWithContext(aws.Context, *ec2.CancelSpotFleetRequestsInput, ...request.Option) (*ec2.CancelSpotFleetRequestsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CancelSpotFleetRequestsRequest(*ec2.CancelSpotFleetRequestsInput) (*request.Request, *ec2.CancelSpotFleetRequestsOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CancelSpotInstanceRequests(*ec2.CancelSpotInstanceRequestsInput) (*ec2.CancelSpotInstanceRequestsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CancelSpotInstanceRequestsWithContext(aws.Context, *ec2.CancelSpotInstanceRequestsInput, ...request.Option) (*ec2.CancelSpotInstanceRequestsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CancelSpotInstanceRequestsRequest(*ec2.CancelSpotInstanceRequestsInput) (*request.Request, *ec2.CancelSpotInstanceRequestsOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ConfirmProductInstance(*ec2.ConfirmProductInstanceInput) (*ec2.ConfirmProductInstanceOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ConfirmProductInstanceWithContext(aws.Context, *ec2.ConfirmProductInstanceInput, ...request.Option) (*ec2.ConfirmProductInstanceOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ConfirmProductInstanceRequest(*ec2.ConfirmProductInstanceInput) (*request.Request, *ec2.ConfirmProductInstanceOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CopyImage(*ec2.CopyImageInput) (*ec2.CopyImageOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CopyImageWithContext(aws.Context, *ec2.CopyImageInput, ...request.Option) (*ec2.CopyImageOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CopyImageRequest(*ec2.CopyImageInput) (*request.Request, *ec2.CopyImageOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CopySnapshot(*ec2.CopySnapshotInput) (*ec2.CopySnapshotOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CopySnapshotWithContext(aws.Context, *ec2.CopySnapshotInput, ...request.Option) (*ec2.CopySnapshotOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CopySnapshotRequest(*ec2.CopySnapshotInput) (*request.Request, *ec2.CopySnapshotOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CreateCustomerGateway(*ec2.CreateCustomerGatewayInput) (*ec2.CreateCustomerGatewayOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreateCustomerGatewayWithContext(aws.Context, *ec2.CreateCustomerGatewayInput, ...request.Option) (*ec2.CreateCustomerGatewayOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreateCustomerGatewayRequest(*ec2.CreateCustomerGatewayInput) (*request.Request, *ec2.CreateCustomerGatewayOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CreateDefaultVpc(*ec2.CreateDefaultVpcInput) (*ec2.CreateDefaultVpcOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreateDefaultVpcWithContext(aws.Context, *ec2.CreateDefaultVpcInput, ...request.Option) (*ec2.CreateDefaultVpcOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreateDefaultVpcRequest(*ec2.CreateDefaultVpcInput) (*request.Request, *ec2.CreateDefaultVpcOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CreateEgressOnlyInternetGateway(*ec2.CreateEgressOnlyInternetGatewayInput) (*ec2.CreateEgressOnlyInternetGatewayOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreateEgressOnlyInternetGatewayWithContext(aws.Context, *ec2.CreateEgressOnlyInternetGatewayInput, ...request.Option) (*ec2.CreateEgressOnlyInternetGatewayOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreateEgressOnlyInternetGatewayRequest(*ec2.CreateEgressOnlyInternetGatewayInput) (*request.Request, *ec2.CreateEgressOnlyInternetGatewayOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CreateFlowLogs(*ec2.CreateFlowLogsInput) (*ec2.CreateFlowLogsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreateFlowLogsWithContext(aws.Context, *ec2.CreateFlowLogsInput, ...request.Option) (*ec2.CreateFlowLogsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreateFlowLogsRequest(*ec2.CreateFlowLogsInput) (*request.Request, *ec2.CreateFlowLogsOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CreateFpgaImage(*ec2.CreateFpgaImageInput) (*ec2.CreateFpgaImageOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreateFpgaImageWithContext(aws.Context, *ec2.CreateFpgaImageInput, ...request.Option) (*ec2.CreateFpgaImageOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreateFpgaImageRequest(*ec2.CreateFpgaImageInput) (*request.Request, *ec2.CreateFpgaImageOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CreateImage(*ec2.CreateImageInput) (*ec2.CreateImageOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreateImageWithContext(aws.Context, *ec2.CreateImageInput, ...request.Option) (*ec2.CreateImageOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreateImageRequest(*ec2.CreateImageInput) (*request.Request, *ec2.CreateImageOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CreateInstanceExportTask(*ec2.CreateInstanceExportTaskInput) (*ec2.CreateInstanceExportTaskOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreateInstanceExportTaskWithContext(aws.Context, *ec2.CreateInstanceExportTaskInput, ...request.Option) (*ec2.CreateInstanceExportTaskOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreateInstanceExportTaskRequest(*ec2.CreateInstanceExportTaskInput) (*request.Request, *ec2.CreateInstanceExportTaskOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CreateNetworkAcl(*ec2.CreateNetworkAclInput) (*ec2.CreateNetworkAclOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreateNetworkAclWithContext(aws.Context, *ec2.CreateNetworkAclInput, ...request.Option) (*ec2.CreateNetworkAclOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreateNetworkAclRequest(*ec2.CreateNetworkAclInput) (*request.Request, *ec2.CreateNetworkAclOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CreateNetworkAclEntry(*ec2.CreateNetworkAclEntryInput) (*ec2.CreateNetworkAclEntryOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreateNetworkAclEntryWithContext(aws.Context, *ec2.CreateNetworkAclEntryInput, ...request.Option) (*ec2.CreateNetworkAclEntryOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreateNetworkAclEntryRequest(*ec2.CreateNetworkAclEntryInput) (*request.Request, *ec2.CreateNetworkAclEntryOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CreateNetworkInterface(*ec2.CreateNetworkInterfaceInput) (*ec2.CreateNetworkInterfaceOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreateNetworkInterfaceWithContext(aws.Context, *ec2.CreateNetworkInterfaceInput, ...request.Option) (*ec2.CreateNetworkInterfaceOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreateNetworkInterfaceRequest(*ec2.CreateNetworkInterfaceInput) (*request.Request, *ec2.CreateNetworkInterfaceOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CreateNetworkInterfacePermission(*ec2.CreateNetworkInterfacePermissionInput) (*ec2.CreateNetworkInterfacePermissionOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreateNetworkInterfacePermissionWithContext(aws.Context, *ec2.CreateNetworkInterfacePermissionInput, ...request.Option) (*ec2.CreateNetworkInterfacePermissionOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreateNetworkInterfacePermissionRequest(*ec2.CreateNetworkInterfacePermissionInput) (*request.Request, *ec2.CreateNetworkInterfacePermissionOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CreatePlacementGroup(*ec2.CreatePlacementGroupInput) (*ec2.CreatePlacementGroupOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreatePlacementGroupWithContext(aws.Context, *ec2.CreatePlacementGroupInput, ...request.Option) (*ec2.CreatePlacementGroupOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreatePlacementGroupRequest(*ec2.CreatePlacementGroupInput) (*request.Request, *ec2.CreatePlacementGroupOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CreateReservedInstancesListing(*ec2.CreateReservedInstancesListingInput) (*ec2.CreateReservedInstancesListingOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreateReservedInstancesListingWithContext(aws.Context, *ec2.CreateReservedInstancesListingInput, ...request.Option) (*ec2.CreateReservedInstancesListingOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreateReservedInstancesListingRequest(*ec2.CreateReservedInstancesListingInput) (*request.Request, *ec2.CreateReservedInstancesListingOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CreateSnapshot(*ec2.CreateSnapshotInput) (*ec2.Snapshot, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreateSnapshotWithContext(aws.Context, *ec2.CreateSnapshotInput, ...request.Option) (*ec2.Snapshot, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreateSnapshotRequest(*ec2.CreateSnapshotInput) (*request.Request, *ec2.Snapshot) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CreateSpotDatafeedSubscription(*ec2.CreateSpotDatafeedSubscriptionInput) (*ec2.CreateSpotDatafeedSubscriptionOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreateSpotDatafeedSubscriptionWithContext(aws.Context, *ec2.CreateSpotDatafeedSubscriptionInput, ...request.Option) (*ec2.CreateSpotDatafeedSubscriptionOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreateSpotDatafeedSubscriptionRequest(*ec2.CreateSpotDatafeedSubscriptionInput) (*request.Request, *ec2.CreateSpotDatafeedSubscriptionOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CreateVpcEndpoint(*ec2.CreateVpcEndpointInput) (*ec2.CreateVpcEndpointOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreateVpcEndpointWithContext(aws.Context, *ec2.CreateVpcEndpointInput, ...request.Option) (*ec2.CreateVpcEndpointOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreateVpcEndpointRequest(*ec2.CreateVpcEndpointInput) (*request.Request, *ec2.CreateVpcEndpointOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CreateVpcPeeringConnection(*ec2.CreateVpcPeeringConnectionInput) (*ec2.CreateVpcPeeringConnectionOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreateVpcPeeringConnectionWithContext(aws.Context, *ec2.CreateVpcPeeringConnectionInput, ...request.Option) (*ec2.CreateVpcPeeringConnectionOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreateVpcPeeringConnectionRequest(*ec2.CreateVpcPeeringConnectionInput) (*request.Request, *ec2.CreateVpcPeeringConnectionOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CreateVpnConnection(*ec2.CreateVpnConnectionInput) (*ec2.CreateVpnConnectionOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreateVpnConnectionWithContext(aws.Context, *ec2.CreateVpnConnectionInput, ...request.Option) (*ec2.CreateVpnConnectionOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreateVpnConnectionRequest(*ec2.CreateVpnConnectionInput) (*request.Request, *ec2.CreateVpnConnectionOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CreateVpnConnectionRoute(*ec2.CreateVpnConnectionRouteInput) (*ec2.CreateVpnConnectionRouteOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreateVpnConnectionRouteWithContext(aws.Context, *ec2.CreateVpnConnectionRouteInput, ...request.Option) (*ec2.CreateVpnConnectionRouteOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreateVpnConnectionRouteRequest(*ec2.CreateVpnConnectionRouteInput) (*request.Request, *ec2.CreateVpnConnectionRouteOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CreateVpnGateway(*ec2.CreateVpnGatewayInput) (*ec2.CreateVpnGatewayOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreateVpnGatewayWithContext(aws.Context, *ec2.CreateVpnGatewayInput, ...request.Option) (*ec2.CreateVpnGatewayOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) CreateVpnGatewayRequest(*ec2.CreateVpnGatewayInput) (*request.Request, *ec2.CreateVpnGatewayOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DeleteCustomerGateway(*ec2.DeleteCustomerGatewayInput) (*ec2.DeleteCustomerGatewayOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeleteCustomerGatewayWithContext(aws.Context, *ec2.DeleteCustomerGatewayInput, ...request.Option) (*ec2.DeleteCustomerGatewayOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeleteCustomerGatewayRequest(*ec2.DeleteCustomerGatewayInput) (*request.Request, *ec2.DeleteCustomerGatewayOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DeleteEgressOnlyInternetGateway(*ec2.DeleteEgressOnlyInternetGatewayInput) (*ec2.DeleteEgressOnlyInternetGatewayOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeleteEgressOnlyInternetGatewayWithContext(aws.Context, *ec2.DeleteEgressOnlyInternetGatewayInput, ...request.Option) (*ec2.DeleteEgressOnlyInternetGatewayOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeleteEgressOnlyInternetGatewayRequest(*ec2.DeleteEgressOnlyInternetGatewayInput) (*request.Request, *ec2.DeleteEgressOnlyInternetGatewayOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DeleteFlowLogs(*ec2.DeleteFlowLogsInput) (*ec2.DeleteFlowLogsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeleteFlowLogsWithContext(aws.Context, *ec2.DeleteFlowLogsInput, ...request.Option) (*ec2.DeleteFlowLogsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeleteFlowLogsRequest(*ec2.DeleteFlowLogsInput) (*request.Request, *ec2.DeleteFlowLogsOutput) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeleteNetworkAcl(*ec2.DeleteNetworkAclInput) (*ec2.DeleteNetworkAclOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeleteNetworkAclWithContext(aws.Context, *ec2.DeleteNetworkAclInput, ...request.Option) (*ec2.DeleteNetworkAclOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeleteNetworkAclRequest(*ec2.DeleteNetworkAclInput) (*request.Request, *ec2.DeleteNetworkAclOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DeleteNetworkAclEntry(*ec2.DeleteNetworkAclEntryInput) (*ec2.DeleteNetworkAclEntryOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeleteNetworkAclEntryWithContext(aws.Context, *ec2.DeleteNetworkAclEntryInput, ...request.Option) (*ec2.DeleteNetworkAclEntryOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeleteNetworkAclEntryRequest(*ec2.DeleteNetworkAclEntryInput) (*request.Request, *ec2.DeleteNetworkAclEntryOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DeleteNetworkInterface(*ec2.DeleteNetworkInterfaceInput) (*ec2.DeleteNetworkInterfaceOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeleteNetworkInterfaceWithContext(aws.Context, *ec2.DeleteNetworkInterfaceInput, ...request.Option) (*ec2.DeleteNetworkInterfaceOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeleteNetworkInterfaceRequest(*ec2.DeleteNetworkInterfaceInput) (*request.Request, *ec2.DeleteNetworkInterfaceOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DeleteNetworkInterfacePermission(*ec2.DeleteNetworkInterfacePermissionInput) (*ec2.DeleteNetworkInterfacePermissionOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeleteNetworkInterfacePermissionWithContext(aws.Context, *ec2.DeleteNetworkInterfacePermissionInput, ...request.Option) (*ec2.DeleteNetworkInterfacePermissionOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeleteNetworkInterfacePermissionRequest(*ec2.DeleteNetworkInterfacePermissionInput) (*request.Request, *ec2.DeleteNetworkInterfacePermissionOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DeletePlacementGroup(*ec2.DeletePlacementGroupInput) (*ec2.DeletePlacementGroupOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeletePlacementGroupWithContext(aws.Context, *ec2.DeletePlacementGroupInput, ...request.Option) (*ec2.DeletePlacementGroupOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeletePlacementGroupRequest(*ec2.DeletePlacementGroupInput) (*request.Request, *ec2.DeletePlacementGroupOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DeleteRoute(*ec2.DeleteRouteInput) (*ec2.DeleteRouteOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeleteRouteWithContext(aws.Context, *ec2.DeleteRouteInput, ...request.Option) (*ec2.DeleteRouteOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeleteRouteRequest(*ec2.DeleteRouteInput) (*request.Request, *ec2.DeleteRouteOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DeleteSnapshot(*ec2.DeleteSnapshotInput) (*ec2.DeleteSnapshotOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeleteSnapshotWithContext(aws.Context, *ec2.DeleteSnapshotInput, ...request.Option) (*ec2.DeleteSnapshotOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeleteSnapshotRequest(*ec2.DeleteSnapshotInput) (*request.Request, *ec2.DeleteSnapshotOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DeleteSpotDatafeedSubscription(*ec2.DeleteSpotDatafeedSubscriptionInput) (*ec2.DeleteSpotDatafeedSubscriptionOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeleteSpotDatafeedSubscriptionWithContext(aws.Context, *ec2.DeleteSpotDatafeedSubscriptionInput, ...request.Option) (*ec2.DeleteSpotDatafeedSubscriptionOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeleteSpotDatafeedSubscriptionRequest(*ec2.DeleteSpotDatafeedSubscriptionInput) (*request.Request, *ec2.DeleteSpotDatafeedSubscriptionOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DeleteTags(*ec2.DeleteTagsInput) (*ec2.DeleteTagsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeleteTagsWithContext(aws.Context, *ec2.DeleteTagsInput, ...request.Option) (*ec2.DeleteTagsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeleteTagsRequest(*ec2.DeleteTagsInput) (*request.Request, *ec2.DeleteTagsOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DeleteVpcEndpoints(*ec2.DeleteVpcEndpointsInput) (*ec2.DeleteVpcEndpointsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeleteVpcEndpointsWithContext(aws.Context, *ec2.DeleteVpcEndpointsInput, ...request.Option) (*ec2.DeleteVpcEndpointsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeleteVpcEndpointsRequest(*ec2.DeleteVpcEndpointsInput) (*request.Request, *ec2.DeleteVpcEndpointsOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DeleteVpcPeeringConnection(*ec2.DeleteVpcPeeringConnectionInput) (*ec2.DeleteVpcPeeringConnectionOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeleteVpcPeeringConnectionWithContext(aws.Context, *ec2.DeleteVpcPeeringConnectionInput, ...request.Option) (*ec2.DeleteVpcPeeringConnectionOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeleteVpcPeeringConnectionRequest(*ec2.DeleteVpcPeeringConnectionInput) (*request.Request, *ec2.DeleteVpcPeeringConnectionOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DeleteVpnConnection(*ec2.DeleteVpnConnectionInput) (*ec2.DeleteVpnConnectionOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeleteVpnConnectionWithContext(aws.Context, *ec2.DeleteVpnConnectionInput, ...request.Option) (*ec2.DeleteVpnConnectionOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeleteVpnConnectionRequest(*ec2.DeleteVpnConnectionInput) (*request.Request, *ec2.DeleteVpnConnectionOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DeleteVpnConnectionRoute(*ec2.DeleteVpnConnectionRouteInput) (*ec2.DeleteVpnConnectionRouteOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeleteVpnConnectionRouteWithContext(aws.Context, *ec2.DeleteVpnConnectionRouteInput, ...request.Option) (*ec2.DeleteVpnConnectionRouteOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeleteVpnConnectionRouteRequest(*ec2.DeleteVpnConnectionRouteInput) (*request.Request, *ec2.DeleteVpnConnectionRouteOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DeleteVpnGateway(*ec2.DeleteVpnGatewayInput) (*ec2.DeleteVpnGatewayOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeleteVpnGatewayWithContext(aws.Context, *ec2.DeleteVpnGatewayInput, ...request.Option) (*ec2.DeleteVpnGatewayOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeleteVpnGatewayRequest(*ec2.DeleteVpnGatewayInput) (*request.Request, *ec2.DeleteVpnGatewayOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DeregisterImage(*ec2.DeregisterImageInput) (*ec2.DeregisterImageOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeregisterImageWithContext(aws.Context, *ec2.DeregisterImageInput, ...request.Option) (*ec2.DeregisterImageOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeregisterImageRequest(*ec2.DeregisterImageInput) (*request.Request, *ec2.DeregisterImageOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeAccountAttributes(*ec2.DescribeAccountAttributesInput) (*ec2.DescribeAccountAttributesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeAccountAttributesWithContext(aws.Context, *ec2.DescribeAccountAttributesInput, ...request.Option) (*ec2.DescribeAccountAttributesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeAccountAttributesRequest(*ec2.DescribeAccountAttributesInput) (*request.Request, *ec2.DescribeAccountAttributesOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeAggregateIdFormat(*ec2.DescribeAggregateIdFormatInput) (*ec2.DescribeAggregateIdFormatOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeAggregateIdFormatWithContext(aws.Context, *ec2.DescribeAggregateIdFormatInput, ...request.Option) (*ec2.DescribeAggregateIdFormatOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeAggregateIdFormatRequest(*ec2.DescribeAggregateIdFormatInput) (*request.Request, *ec2.DescribeAggregateIdFormatOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeAvailabilityZones(*ec2.DescribeAvailabilityZonesInput) (*ec2.DescribeAvailabilityZonesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeAvailabilityZonesWithContext(aws.Context, *ec2.DescribeAvailabilityZonesInput, ...request.Option) (*ec2.DescribeAvailabilityZonesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeAvailabilityZonesRequest(*ec2.DescribeAvailabilityZonesInput) (*request.Request, *ec2.DescribeAvailabilityZonesOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeBundleTasks(*ec2.DescribeBundleTasksInput) (*ec2.DescribeBundleTasksOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeBundleTasksWithContext(aws.Context, *ec2.DescribeBundleTasksInput, ...request.Option) (*ec2.DescribeBundleTasksOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeBundleTasksRequest(*ec2.DescribeBundleTasksInput) (*request.Request, *ec2.DescribeBundleTasksOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeClassicLinkInstances(*ec2.DescribeClassicLinkInstancesInput) (*ec2.DescribeClassicLinkInstancesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeClassicLinkInstancesWithContext(aws.Context, *ec2.DescribeClassicLinkInstancesInput, ...request.Option) (*ec2.DescribeClassicLinkInstancesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeClassicLinkInstancesRequest(*ec2.DescribeClassicLinkInstancesInput) (*request.Request, *ec2.DescribeClassicLinkInstancesOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeConversionTasks(*ec2.DescribeConversionTasksInput) (*ec2.DescribeConversionTasksOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeConversionTasksWithContext(aws.Context, *ec2.DescribeConversionTasksInput, ...request.Option) (*ec2.DescribeConversionTasksOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeConversionTasksRequest(*ec2.DescribeConversionTasksInput) (*request.Request, *ec2.DescribeConversionTasksOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeCustomerGateways(*ec2.DescribeCustomerGatewaysInput) (*ec2.DescribeCustomerGatewaysOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeCustomerGatewaysWithContext(aws.Context, *ec2.DescribeCustomerGatewaysInput, ...request.Option) (*ec2.DescribeCustomerGatewaysOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeCustomerGatewaysRequest(*ec2.DescribeCustomerGatewaysInput) (*request.Request, *ec2.DescribeCustomerGatewaysOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeEgressOnlyInternetGateways(*ec2.DescribeEgressOnlyInternetGatewaysInput) (*ec2.DescribeEgressOnlyInternetGatewaysOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeEgressOnlyInternetGatewaysWithContext(aws.Context, *ec2.DescribeEgressOnlyInternetGatewaysInput, ...request.Option) (*ec2.DescribeEgressOnlyInternetGatewaysOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeEgressOnlyInternetGatewaysRequest(*ec2.DescribeEgressOnlyInternetGatewaysInput) (*request.Request, *ec2.DescribeEgressOnlyInternetGatewaysOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeElasticGpus(*ec2.DescribeElasticGpusInput) (*ec2.DescribeElasticGpusOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeElasticGpusWithContext(aws.Context, *ec2.DescribeElasticGpusInput, ...request.Option) (*ec2.DescribeElasticGpusOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeElasticGpusRequest(*ec2.DescribeElasticGpusInput) (*request.Request, *ec2.DescribeElasticGpusOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeExportTasks(*ec2.DescribeExportTasksInput) (*ec2.DescribeExportTasksOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeExportTasksWithContext(aws.Context, *ec2.DescribeExportTasksInput, ...request.Option) (*ec2.DescribeExportTasksOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeExportTasksRequest(*ec2.DescribeExportTasksInput) (*request.Request, *ec2.DescribeExportTasksOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeFlowLogs(*ec2.DescribeFlowLogsInput) (*ec2.DescribeFlowLogsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeFlowLogsWithContext(aws.Context, *ec2.DescribeFlowLogsInput, ...request.Option) (*ec2.DescribeFlowLogsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeFlowLogsRequest(*ec2.DescribeFlowLogsInput) (*request.Request, *ec2.DescribeFlowLogsOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeFpgaImages(*ec2.DescribeFpgaImagesInput) (*ec2.DescribeFpgaImagesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeFpgaImagesWithContext(aws.Context, *ec2.DescribeFpgaImagesInput, ...request.Option) (*ec2.DescribeFpgaImagesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeFpgaImagesRequest(*ec2.DescribeFpgaImagesInput) (*request.Request, *ec2.DescribeFpgaImagesOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeHostReservationOfferings(*ec2.DescribeHostReservationOfferingsInput) (*ec2.DescribeHostReservationOfferingsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeHostReservationOfferingsWithContext(aws.Context, *ec2.DescribeHostReservationOfferingsInput, ...request.Option) (*ec2.DescribeHostReservationOfferingsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeHostReservationOfferingsRequest(*ec2.DescribeHostReservationOfferingsInput) (*request.Request, *ec2.DescribeHostReservationOfferingsOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeHostReservations(*ec2.DescribeHostReservationsInput) (*ec2.DescribeHostReservationsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeHostReservationsWithContext(aws.Context, *ec2.DescribeHostReservationsInput, ...request.Option) (*ec2.DescribeHostReservationsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeHostReservationsRequest(*ec2.DescribeHostReservationsInput) (*request.Request, *ec2.DescribeHostReservationsOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeHosts(*ec2.DescribeHostsInput) (*ec2.DescribeHostsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeHostsWithContext(aws.Context, *ec2.DescribeHostsInput, ...request.Option) (*ec2.DescribeHostsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeHostsRequest(*ec2.DescribeHostsInput) (*request.Request, *ec2.DescribeHostsOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeIamInstanceProfileAssociations(*ec2.DescribeIamInstanceProfileAssociationsInput) (*ec2.DescribeIamInstanceProfileAssociationsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeIamInstanceProfileAssociationsWithContext(aws.Context, *ec2.DescribeIamInstanceProfileAssociationsInput, ...request.Option) (*ec2.DescribeIamInstanceProfileAssociationsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeIamInstanceProfileAssociationsRequest(*ec2.DescribeIamInstanceProfileAssociationsInput) (*request.Request, *ec2.DescribeIamInstanceProfileAssociationsOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeIdFormat(*ec2.DescribeIdFormatInput) (*ec2.DescribeIdFormatOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeIdFormatWithContext(aws.Context, *ec2.DescribeIdFormatInput, ...request.Option) (*ec2.DescribeIdFormatOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeIdFormatRequest(*ec2.DescribeIdFormatInput) (*request.Request, *ec2.DescribeIdFormatOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeIdentityIdFormat(*ec2.DescribeIdentityIdFormatInput) (*ec2.DescribeIdentityIdFormatOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeIdentityIdFormatWithContext(aws.Context, *ec2.DescribeIdentityIdFormatInput, ...request.Option) (*ec2.DescribeIdentityIdFormatOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeIdentityIdFormatRequest(*ec2.DescribeIdentityIdFormatInput) (*request.Request, *ec2.DescribeIdentityIdFormatOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeImportSnapshotTasks(*ec2.DescribeImportSnapshotTasksInput) (*ec2.DescribeImportSnapshotTasksOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeImportSnapshotTasksWithContext(aws.Context, *ec2.DescribeImportSnapshotTasksInput, ...request.Option) (*ec2.DescribeImportSnapshotTasksOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeImportSnapshotTasksRequest(*ec2.DescribeImportSnapshotTasksInput) (*request.Request, *ec2.DescribeImportSnapshotTasksOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeInstanceAttribute(*ec2.DescribeInstanceAttributeInput) (*ec2.DescribeInstanceAttributeOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeInstanceAttributeWithContext(aws.Context, *ec2.DescribeInstanceAttributeInput, ...request.Option) (*ec2.DescribeInstanceAttributeOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeInstanceAttributeRequest(*ec2.DescribeInstanceAttributeInput) (*request.Request, *ec2.DescribeInstanceAttributeOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeInstanceStatus(*ec2.DescribeInstanceStatusInput) (*ec2.DescribeInstanceStatusOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeInstanceStatusWithContext(aws.Context, *ec2.DescribeInstanceStatusInput, ...request.Option) (*ec2.DescribeInstanceStatusOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeInstanceStatusRequest(*ec2.DescribeInstanceStatusInput) (*request.Request, *ec2.DescribeInstanceStatusOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeInstanceStatusPages(*ec2.DescribeInstanceStatusInput, func(*ec2.DescribeInstanceStatusOutput, bool) bool) error {
	panic("Not implemented")
	return nil
}
func (m *MockEC2) DescribeInstanceStatusPagesWithContext(aws.Context, *ec2.DescribeInstanceStatusInput, func(*ec2.DescribeInstanceStatusOutput, bool) bool, ...request.Option) error {
	panic("Not implemented")
	return nil
}

func (m *MockEC2) DescribeMovingAddresses(*ec2.DescribeMovingAddressesInput) (*ec2.DescribeMovingAddressesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeMovingAddressesWithContext(aws.Context, *ec2.DescribeMovingAddressesInput, ...request.Option) (*ec2.DescribeMovingAddressesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeMovingAddressesRequest(*ec2.DescribeMovingAddressesInput) (*request.Request, *ec2.DescribeMovingAddressesOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeNetworkAcls(*ec2.DescribeNetworkAclsInput) (*ec2.DescribeNetworkAclsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeNetworkAclsWithContext(aws.Context, *ec2.DescribeNetworkAclsInput, ...request.Option) (*ec2.DescribeNetworkAclsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeNetworkAclsRequest(*ec2.DescribeNetworkAclsInput) (*request.Request, *ec2.DescribeNetworkAclsOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeNetworkInterfaceAttribute(*ec2.DescribeNetworkInterfaceAttributeInput) (*ec2.DescribeNetworkInterfaceAttributeOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeNetworkInterfaceAttributeWithContext(aws.Context, *ec2.DescribeNetworkInterfaceAttributeInput, ...request.Option) (*ec2.DescribeNetworkInterfaceAttributeOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeNetworkInterfaceAttributeRequest(*ec2.DescribeNetworkInterfaceAttributeInput) (*request.Request, *ec2.DescribeNetworkInterfaceAttributeOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeNetworkInterfacePermissions(*ec2.DescribeNetworkInterfacePermissionsInput) (*ec2.DescribeNetworkInterfacePermissionsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeNetworkInterfacePermissionsWithContext(aws.Context, *ec2.DescribeNetworkInterfacePermissionsInput, ...request.Option) (*ec2.DescribeNetworkInterfacePermissionsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeNetworkInterfacePermissionsRequest(*ec2.DescribeNetworkInterfacePermissionsInput) (*request.Request, *ec2.DescribeNetworkInterfacePermissionsOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeNetworkInterfaces(*ec2.DescribeNetworkInterfacesInput) (*ec2.DescribeNetworkInterfacesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeNetworkInterfacesWithContext(aws.Context, *ec2.DescribeNetworkInterfacesInput, ...request.Option) (*ec2.DescribeNetworkInterfacesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeNetworkInterfacesRequest(*ec2.DescribeNetworkInterfacesInput) (*request.Request, *ec2.DescribeNetworkInterfacesOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribePlacementGroups(*ec2.DescribePlacementGroupsInput) (*ec2.DescribePlacementGroupsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribePlacementGroupsWithContext(aws.Context, *ec2.DescribePlacementGroupsInput, ...request.Option) (*ec2.DescribePlacementGroupsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribePlacementGroupsRequest(*ec2.DescribePlacementGroupsInput) (*request.Request, *ec2.DescribePlacementGroupsOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribePrefixLists(*ec2.DescribePrefixListsInput) (*ec2.DescribePrefixListsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribePrefixListsWithContext(aws.Context, *ec2.DescribePrefixListsInput, ...request.Option) (*ec2.DescribePrefixListsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribePrefixListsRequest(*ec2.DescribePrefixListsInput) (*request.Request, *ec2.DescribePrefixListsOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribePrincipalIdFormat(*ec2.DescribePrincipalIdFormatInput) (*ec2.DescribePrincipalIdFormatOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribePrincipalIdFormatWithContext(aws.Context, *ec2.DescribePrincipalIdFormatInput, ...request.Option) (*ec2.DescribePrincipalIdFormatOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribePrincipalIdFormatRequest(*ec2.DescribePrincipalIdFormatInput) (*request.Request, *ec2.DescribePrincipalIdFormatOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeRegions(*ec2.DescribeRegionsInput) (*ec2.DescribeRegionsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeRegionsWithContext(aws.Context, *ec2.DescribeRegionsInput, ...request.Option) (*ec2.DescribeRegionsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeRegionsRequest(*ec2.DescribeRegionsInput) (*request.Request, *ec2.DescribeRegionsOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeReservedInstances(*ec2.DescribeReservedInstancesInput) (*ec2.DescribeReservedInstancesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeReservedInstancesWithContext(aws.Context, *ec2.DescribeReservedInstancesInput, ...request.Option) (*ec2.DescribeReservedInstancesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeReservedInstancesRequest(*ec2.DescribeReservedInstancesInput) (*request.Request, *ec2.DescribeReservedInstancesOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeReservedInstancesListings(*ec2.DescribeReservedInstancesListingsInput) (*ec2.DescribeReservedInstancesListingsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeReservedInstancesListingsWithContext(aws.Context, *ec2.DescribeReservedInstancesListingsInput, ...request.Option) (*ec2.DescribeReservedInstancesListingsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeReservedInstancesListingsRequest(*ec2.DescribeReservedInstancesListingsInput) (*request.Request, *ec2.DescribeReservedInstancesListingsOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeReservedInstancesModifications(*ec2.DescribeReservedInstancesModificationsInput) (*ec2.DescribeReservedInstancesModificationsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeReservedInstancesModificationsWithContext(aws.Context, *ec2.DescribeReservedInstancesModificationsInput, ...request.Option) (*ec2.DescribeReservedInstancesModificationsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeReservedInstancesModificationsRequest(*ec2.DescribeReservedInstancesModificationsInput) (*request.Request, *ec2.DescribeReservedInstancesModificationsOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeReservedInstancesModificationsPages(*ec2.DescribeReservedInstancesModificationsInput, func(*ec2.DescribeReservedInstancesModificationsOutput, bool) bool) error {
	panic("Not implemented")
	return nil
}
func (m *MockEC2) DescribeReservedInstancesModificationsPagesWithContext(aws.Context, *ec2.DescribeReservedInstancesModificationsInput, func(*ec2.DescribeReservedInstancesModificationsOutput, bool) bool, ...request.Option) error {
	panic("Not implemented")
	return nil
}

func (m *MockEC2) DescribeReservedInstancesOfferings(*ec2.DescribeReservedInstancesOfferingsInput) (*ec2.DescribeReservedInstancesOfferingsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeReservedInstancesOfferingsWithContext(aws.Context, *ec2.DescribeReservedInstancesOfferingsInput, ...request.Option) (*ec2.DescribeReservedInstancesOfferingsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeReservedInstancesOfferingsRequest(*ec2.DescribeReservedInstancesOfferingsInput) (*request.Request, *ec2.DescribeReservedInstancesOfferingsOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeReservedInstancesOfferingsPages(*ec2.DescribeReservedInstancesOfferingsInput, func(*ec2.DescribeReservedInstancesOfferingsOutput, bool) bool) error {
	panic("Not implemented")
	return nil
}
func (m *MockEC2) DescribeReservedInstancesOfferingsPagesWithContext(aws.Context, *ec2.DescribeReservedInstancesOfferingsInput, func(*ec2.DescribeReservedInstancesOfferingsOutput, bool) bool, ...request.Option) error {
	panic("Not implemented")
	return nil
}

func (m *MockEC2) DescribeScheduledInstanceAvailability(*ec2.DescribeScheduledInstanceAvailabilityInput) (*ec2.DescribeScheduledInstanceAvailabilityOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeScheduledInstanceAvailabilityWithContext(aws.Context, *ec2.DescribeScheduledInstanceAvailabilityInput, ...request.Option) (*ec2.DescribeScheduledInstanceAvailabilityOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeScheduledInstanceAvailabilityRequest(*ec2.DescribeScheduledInstanceAvailabilityInput) (*request.Request, *ec2.DescribeScheduledInstanceAvailabilityOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeScheduledInstances(*ec2.DescribeScheduledInstancesInput) (*ec2.DescribeScheduledInstancesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeScheduledInstancesWithContext(aws.Context, *ec2.DescribeScheduledInstancesInput, ...request.Option) (*ec2.DescribeScheduledInstancesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeScheduledInstancesRequest(*ec2.DescribeScheduledInstancesInput) (*request.Request, *ec2.DescribeScheduledInstancesOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeSnapshotAttribute(*ec2.DescribeSnapshotAttributeInput) (*ec2.DescribeSnapshotAttributeOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeSnapshotAttributeWithContext(aws.Context, *ec2.DescribeSnapshotAttributeInput, ...request.Option) (*ec2.DescribeSnapshotAttributeOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeSnapshotAttributeRequest(*ec2.DescribeSnapshotAttributeInput) (*request.Request, *ec2.DescribeSnapshotAttributeOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeSnapshots(*ec2.DescribeSnapshotsInput) (*ec2.DescribeSnapshotsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeSnapshotsWithContext(aws.Context, *ec2.DescribeSnapshotsInput, ...request.Option) (*ec2.DescribeSnapshotsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeSnapshotsRequest(*ec2.DescribeSnapshotsInput) (*request.Request, *ec2.DescribeSnapshotsOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeSnapshotsPages(*ec2.DescribeSnapshotsInput, func(*ec2.DescribeSnapshotsOutput, bool) bool) error {
	panic("Not implemented")
	return nil
}
func (m *MockEC2) DescribeSnapshotsPagesWithContext(aws.Context, *ec2.DescribeSnapshotsInput, func(*ec2.DescribeSnapshotsOutput, bool) bool, ...request.Option) error {
	panic("Not implemented")
	return nil
}

func (m *MockEC2) DescribeSpotDatafeedSubscription(*ec2.DescribeSpotDatafeedSubscriptionInput) (*ec2.DescribeSpotDatafeedSubscriptionOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeSpotDatafeedSubscriptionWithContext(aws.Context, *ec2.DescribeSpotDatafeedSubscriptionInput, ...request.Option) (*ec2.DescribeSpotDatafeedSubscriptionOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeSpotDatafeedSubscriptionRequest(*ec2.DescribeSpotDatafeedSubscriptionInput) (*request.Request, *ec2.DescribeSpotDatafeedSubscriptionOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeSpotFleetInstances(*ec2.DescribeSpotFleetInstancesInput) (*ec2.DescribeSpotFleetInstancesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeSpotFleetInstancesWithContext(aws.Context, *ec2.DescribeSpotFleetInstancesInput, ...request.Option) (*ec2.DescribeSpotFleetInstancesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeSpotFleetInstancesRequest(*ec2.DescribeSpotFleetInstancesInput) (*request.Request, *ec2.DescribeSpotFleetInstancesOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeSpotFleetRequestHistory(*ec2.DescribeSpotFleetRequestHistoryInput) (*ec2.DescribeSpotFleetRequestHistoryOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeSpotFleetRequestHistoryWithContext(aws.Context, *ec2.DescribeSpotFleetRequestHistoryInput, ...request.Option) (*ec2.DescribeSpotFleetRequestHistoryOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeSpotFleetRequestHistoryRequest(*ec2.DescribeSpotFleetRequestHistoryInput) (*request.Request, *ec2.DescribeSpotFleetRequestHistoryOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeSpotFleetRequests(*ec2.DescribeSpotFleetRequestsInput) (*ec2.DescribeSpotFleetRequestsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeSpotFleetRequestsWithContext(aws.Context, *ec2.DescribeSpotFleetRequestsInput, ...request.Option) (*ec2.DescribeSpotFleetRequestsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeSpotFleetRequestsRequest(*ec2.DescribeSpotFleetRequestsInput) (*request.Request, *ec2.DescribeSpotFleetRequestsOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeSpotFleetRequestsPages(*ec2.DescribeSpotFleetRequestsInput, func(*ec2.DescribeSpotFleetRequestsOutput, bool) bool) error {
	panic("Not implemented")
	return nil
}
func (m *MockEC2) DescribeSpotFleetRequestsPagesWithContext(aws.Context, *ec2.DescribeSpotFleetRequestsInput, func(*ec2.DescribeSpotFleetRequestsOutput, bool) bool, ...request.Option) error {
	panic("Not implemented")
	return nil
}

func (m *MockEC2) DescribeSpotInstanceRequests(*ec2.DescribeSpotInstanceRequestsInput) (*ec2.DescribeSpotInstanceRequestsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeSpotInstanceRequestsWithContext(aws.Context, *ec2.DescribeSpotInstanceRequestsInput, ...request.Option) (*ec2.DescribeSpotInstanceRequestsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeSpotInstanceRequestsRequest(*ec2.DescribeSpotInstanceRequestsInput) (*request.Request, *ec2.DescribeSpotInstanceRequestsOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeSpotPriceHistory(*ec2.DescribeSpotPriceHistoryInput) (*ec2.DescribeSpotPriceHistoryOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeSpotPriceHistoryWithContext(aws.Context, *ec2.DescribeSpotPriceHistoryInput, ...request.Option) (*ec2.DescribeSpotPriceHistoryOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeSpotPriceHistoryRequest(*ec2.DescribeSpotPriceHistoryInput) (*request.Request, *ec2.DescribeSpotPriceHistoryOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeSpotPriceHistoryPages(*ec2.DescribeSpotPriceHistoryInput, func(*ec2.DescribeSpotPriceHistoryOutput, bool) bool) error {
	panic("Not implemented")
	return nil
}
func (m *MockEC2) DescribeSpotPriceHistoryPagesWithContext(aws.Context, *ec2.DescribeSpotPriceHistoryInput, func(*ec2.DescribeSpotPriceHistoryOutput, bool) bool, ...request.Option) error {
	panic("Not implemented")
	return nil
}

func (m *MockEC2) DescribeVpcClassicLink(*ec2.DescribeVpcClassicLinkInput) (*ec2.DescribeVpcClassicLinkOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeVpcClassicLinkWithContext(aws.Context, *ec2.DescribeVpcClassicLinkInput, ...request.Option) (*ec2.DescribeVpcClassicLinkOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeVpcClassicLinkRequest(*ec2.DescribeVpcClassicLinkInput) (*request.Request, *ec2.DescribeVpcClassicLinkOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeVpcClassicLinkDnsSupport(*ec2.DescribeVpcClassicLinkDnsSupportInput) (*ec2.DescribeVpcClassicLinkDnsSupportOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeVpcClassicLinkDnsSupportWithContext(aws.Context, *ec2.DescribeVpcClassicLinkDnsSupportInput, ...request.Option) (*ec2.DescribeVpcClassicLinkDnsSupportOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeVpcClassicLinkDnsSupportRequest(*ec2.DescribeVpcClassicLinkDnsSupportInput) (*request.Request, *ec2.DescribeVpcClassicLinkDnsSupportOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeVpcEndpointServices(*ec2.DescribeVpcEndpointServicesInput) (*ec2.DescribeVpcEndpointServicesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeVpcEndpointServicesWithContext(aws.Context, *ec2.DescribeVpcEndpointServicesInput, ...request.Option) (*ec2.DescribeVpcEndpointServicesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeVpcEndpointServicesRequest(*ec2.DescribeVpcEndpointServicesInput) (*request.Request, *ec2.DescribeVpcEndpointServicesOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeVpcEndpoints(*ec2.DescribeVpcEndpointsInput) (*ec2.DescribeVpcEndpointsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeVpcEndpointsWithContext(aws.Context, *ec2.DescribeVpcEndpointsInput, ...request.Option) (*ec2.DescribeVpcEndpointsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeVpcEndpointsRequest(*ec2.DescribeVpcEndpointsInput) (*request.Request, *ec2.DescribeVpcEndpointsOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeVpcPeeringConnections(*ec2.DescribeVpcPeeringConnectionsInput) (*ec2.DescribeVpcPeeringConnectionsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeVpcPeeringConnectionsWithContext(aws.Context, *ec2.DescribeVpcPeeringConnectionsInput, ...request.Option) (*ec2.DescribeVpcPeeringConnectionsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeVpcPeeringConnectionsRequest(*ec2.DescribeVpcPeeringConnectionsInput) (*request.Request, *ec2.DescribeVpcPeeringConnectionsOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeVpnConnections(*ec2.DescribeVpnConnectionsInput) (*ec2.DescribeVpnConnectionsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeVpnConnectionsWithContext(aws.Context, *ec2.DescribeVpnConnectionsInput, ...request.Option) (*ec2.DescribeVpnConnectionsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeVpnConnectionsRequest(*ec2.DescribeVpnConnectionsInput) (*request.Request, *ec2.DescribeVpnConnectionsOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeVpnGateways(*ec2.DescribeVpnGatewaysInput) (*ec2.DescribeVpnGatewaysOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeVpnGatewaysWithContext(aws.Context, *ec2.DescribeVpnGatewaysInput, ...request.Option) (*ec2.DescribeVpnGatewaysOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeVpnGatewaysRequest(*ec2.DescribeVpnGatewaysInput) (*request.Request, *ec2.DescribeVpnGatewaysOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DetachClassicLinkVpc(*ec2.DetachClassicLinkVpcInput) (*ec2.DetachClassicLinkVpcOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DetachClassicLinkVpcWithContext(aws.Context, *ec2.DetachClassicLinkVpcInput, ...request.Option) (*ec2.DetachClassicLinkVpcOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DetachClassicLinkVpcRequest(*ec2.DetachClassicLinkVpcInput) (*request.Request, *ec2.DetachClassicLinkVpcOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DetachNetworkInterface(*ec2.DetachNetworkInterfaceInput) (*ec2.DetachNetworkInterfaceOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DetachNetworkInterfaceWithContext(aws.Context, *ec2.DetachNetworkInterfaceInput, ...request.Option) (*ec2.DetachNetworkInterfaceOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DetachNetworkInterfaceRequest(*ec2.DetachNetworkInterfaceInput) (*request.Request, *ec2.DetachNetworkInterfaceOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DetachVolume(*ec2.DetachVolumeInput) (*ec2.VolumeAttachment, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DetachVolumeWithContext(aws.Context, *ec2.DetachVolumeInput, ...request.Option) (*ec2.VolumeAttachment, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DetachVolumeRequest(*ec2.DetachVolumeInput) (*request.Request, *ec2.VolumeAttachment) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DetachVpnGateway(*ec2.DetachVpnGatewayInput) (*ec2.DetachVpnGatewayOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DetachVpnGatewayWithContext(aws.Context, *ec2.DetachVpnGatewayInput, ...request.Option) (*ec2.DetachVpnGatewayOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DetachVpnGatewayRequest(*ec2.DetachVpnGatewayInput) (*request.Request, *ec2.DetachVpnGatewayOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DisableVgwRoutePropagation(*ec2.DisableVgwRoutePropagationInput) (*ec2.DisableVgwRoutePropagationOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DisableVgwRoutePropagationWithContext(aws.Context, *ec2.DisableVgwRoutePropagationInput, ...request.Option) (*ec2.DisableVgwRoutePropagationOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DisableVgwRoutePropagationRequest(*ec2.DisableVgwRoutePropagationInput) (*request.Request, *ec2.DisableVgwRoutePropagationOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DisableVpcClassicLink(*ec2.DisableVpcClassicLinkInput) (*ec2.DisableVpcClassicLinkOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DisableVpcClassicLinkWithContext(aws.Context, *ec2.DisableVpcClassicLinkInput, ...request.Option) (*ec2.DisableVpcClassicLinkOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DisableVpcClassicLinkRequest(*ec2.DisableVpcClassicLinkInput) (*request.Request, *ec2.DisableVpcClassicLinkOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DisableVpcClassicLinkDnsSupport(*ec2.DisableVpcClassicLinkDnsSupportInput) (*ec2.DisableVpcClassicLinkDnsSupportOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DisableVpcClassicLinkDnsSupportWithContext(aws.Context, *ec2.DisableVpcClassicLinkDnsSupportInput, ...request.Option) (*ec2.DisableVpcClassicLinkDnsSupportOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DisableVpcClassicLinkDnsSupportRequest(*ec2.DisableVpcClassicLinkDnsSupportInput) (*request.Request, *ec2.DisableVpcClassicLinkDnsSupportOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DisassociateAddress(*ec2.DisassociateAddressInput) (*ec2.DisassociateAddressOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DisassociateAddressWithContext(aws.Context, *ec2.DisassociateAddressInput, ...request.Option) (*ec2.DisassociateAddressOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DisassociateAddressRequest(*ec2.DisassociateAddressInput) (*request.Request, *ec2.DisassociateAddressOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DisassociateIamInstanceProfile(*ec2.DisassociateIamInstanceProfileInput) (*ec2.DisassociateIamInstanceProfileOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DisassociateIamInstanceProfileWithContext(aws.Context, *ec2.DisassociateIamInstanceProfileInput, ...request.Option) (*ec2.DisassociateIamInstanceProfileOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DisassociateIamInstanceProfileRequest(*ec2.DisassociateIamInstanceProfileInput) (*request.Request, *ec2.DisassociateIamInstanceProfileOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DisassociateRouteTable(*ec2.DisassociateRouteTableInput) (*ec2.DisassociateRouteTableOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DisassociateRouteTableWithContext(aws.Context, *ec2.DisassociateRouteTableInput, ...request.Option) (*ec2.DisassociateRouteTableOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DisassociateRouteTableRequest(*ec2.DisassociateRouteTableInput) (*request.Request, *ec2.DisassociateRouteTableOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DisassociateSubnetCidrBlock(*ec2.DisassociateSubnetCidrBlockInput) (*ec2.DisassociateSubnetCidrBlockOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DisassociateSubnetCidrBlockWithContext(aws.Context, *ec2.DisassociateSubnetCidrBlockInput, ...request.Option) (*ec2.DisassociateSubnetCidrBlockOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DisassociateSubnetCidrBlockRequest(*ec2.DisassociateSubnetCidrBlockInput) (*request.Request, *ec2.DisassociateSubnetCidrBlockOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DisassociateVpcCidrBlock(*ec2.DisassociateVpcCidrBlockInput) (*ec2.DisassociateVpcCidrBlockOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DisassociateVpcCidrBlockWithContext(aws.Context, *ec2.DisassociateVpcCidrBlockInput, ...request.Option) (*ec2.DisassociateVpcCidrBlockOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DisassociateVpcCidrBlockRequest(*ec2.DisassociateVpcCidrBlockInput) (*request.Request, *ec2.DisassociateVpcCidrBlockOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) EnableVgwRoutePropagation(*ec2.EnableVgwRoutePropagationInput) (*ec2.EnableVgwRoutePropagationOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) EnableVgwRoutePropagationWithContext(aws.Context, *ec2.EnableVgwRoutePropagationInput, ...request.Option) (*ec2.EnableVgwRoutePropagationOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) EnableVgwRoutePropagationRequest(*ec2.EnableVgwRoutePropagationInput) (*request.Request, *ec2.EnableVgwRoutePropagationOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) EnableVolumeIO(*ec2.EnableVolumeIOInput) (*ec2.EnableVolumeIOOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) EnableVolumeIOWithContext(aws.Context, *ec2.EnableVolumeIOInput, ...request.Option) (*ec2.EnableVolumeIOOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) EnableVolumeIORequest(*ec2.EnableVolumeIOInput) (*request.Request, *ec2.EnableVolumeIOOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) EnableVpcClassicLink(*ec2.EnableVpcClassicLinkInput) (*ec2.EnableVpcClassicLinkOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) EnableVpcClassicLinkWithContext(aws.Context, *ec2.EnableVpcClassicLinkInput, ...request.Option) (*ec2.EnableVpcClassicLinkOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) EnableVpcClassicLinkRequest(*ec2.EnableVpcClassicLinkInput) (*request.Request, *ec2.EnableVpcClassicLinkOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) EnableVpcClassicLinkDnsSupport(*ec2.EnableVpcClassicLinkDnsSupportInput) (*ec2.EnableVpcClassicLinkDnsSupportOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) EnableVpcClassicLinkDnsSupportWithContext(aws.Context, *ec2.EnableVpcClassicLinkDnsSupportInput, ...request.Option) (*ec2.EnableVpcClassicLinkDnsSupportOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) EnableVpcClassicLinkDnsSupportRequest(*ec2.EnableVpcClassicLinkDnsSupportInput) (*request.Request, *ec2.EnableVpcClassicLinkDnsSupportOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) GetConsoleOutput(*ec2.GetConsoleOutputInput) (*ec2.GetConsoleOutputOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) GetConsoleOutputWithContext(aws.Context, *ec2.GetConsoleOutputInput, ...request.Option) (*ec2.GetConsoleOutputOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) GetConsoleOutputRequest(*ec2.GetConsoleOutputInput) (*request.Request, *ec2.GetConsoleOutputOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) GetConsoleScreenshot(*ec2.GetConsoleScreenshotInput) (*ec2.GetConsoleScreenshotOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) GetConsoleScreenshotWithContext(aws.Context, *ec2.GetConsoleScreenshotInput, ...request.Option) (*ec2.GetConsoleScreenshotOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) GetConsoleScreenshotRequest(*ec2.GetConsoleScreenshotInput) (*request.Request, *ec2.GetConsoleScreenshotOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) GetHostReservationPurchasePreview(*ec2.GetHostReservationPurchasePreviewInput) (*ec2.GetHostReservationPurchasePreviewOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) GetHostReservationPurchasePreviewWithContext(aws.Context, *ec2.GetHostReservationPurchasePreviewInput, ...request.Option) (*ec2.GetHostReservationPurchasePreviewOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) GetHostReservationPurchasePreviewRequest(*ec2.GetHostReservationPurchasePreviewInput) (*request.Request, *ec2.GetHostReservationPurchasePreviewOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) GetPasswordData(*ec2.GetPasswordDataInput) (*ec2.GetPasswordDataOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) GetPasswordDataWithContext(aws.Context, *ec2.GetPasswordDataInput, ...request.Option) (*ec2.GetPasswordDataOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) GetPasswordDataRequest(*ec2.GetPasswordDataInput) (*request.Request, *ec2.GetPasswordDataOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) GetReservedInstancesExchangeQuote(*ec2.GetReservedInstancesExchangeQuoteInput) (*ec2.GetReservedInstancesExchangeQuoteOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) GetReservedInstancesExchangeQuoteWithContext(aws.Context, *ec2.GetReservedInstancesExchangeQuoteInput, ...request.Option) (*ec2.GetReservedInstancesExchangeQuoteOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) GetReservedInstancesExchangeQuoteRequest(*ec2.GetReservedInstancesExchangeQuoteInput) (*request.Request, *ec2.GetReservedInstancesExchangeQuoteOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ImportImage(*ec2.ImportImageInput) (*ec2.ImportImageOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ImportImageWithContext(aws.Context, *ec2.ImportImageInput, ...request.Option) (*ec2.ImportImageOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ImportImageRequest(*ec2.ImportImageInput) (*request.Request, *ec2.ImportImageOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ImportInstance(*ec2.ImportInstanceInput) (*ec2.ImportInstanceOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ImportInstanceWithContext(aws.Context, *ec2.ImportInstanceInput, ...request.Option) (*ec2.ImportInstanceOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ImportInstanceRequest(*ec2.ImportInstanceInput) (*request.Request, *ec2.ImportInstanceOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ImportSnapshot(*ec2.ImportSnapshotInput) (*ec2.ImportSnapshotOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ImportSnapshotWithContext(aws.Context, *ec2.ImportSnapshotInput, ...request.Option) (*ec2.ImportSnapshotOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ImportSnapshotRequest(*ec2.ImportSnapshotInput) (*request.Request, *ec2.ImportSnapshotOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ImportVolume(*ec2.ImportVolumeInput) (*ec2.ImportVolumeOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ImportVolumeWithContext(aws.Context, *ec2.ImportVolumeInput, ...request.Option) (*ec2.ImportVolumeOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ImportVolumeRequest(*ec2.ImportVolumeInput) (*request.Request, *ec2.ImportVolumeOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ModifyHosts(*ec2.ModifyHostsInput) (*ec2.ModifyHostsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ModifyHostsWithContext(aws.Context, *ec2.ModifyHostsInput, ...request.Option) (*ec2.ModifyHostsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ModifyHostsRequest(*ec2.ModifyHostsInput) (*request.Request, *ec2.ModifyHostsOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ModifyIdFormat(*ec2.ModifyIdFormatInput) (*ec2.ModifyIdFormatOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ModifyIdFormatWithContext(aws.Context, *ec2.ModifyIdFormatInput, ...request.Option) (*ec2.ModifyIdFormatOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ModifyIdFormatRequest(*ec2.ModifyIdFormatInput) (*request.Request, *ec2.ModifyIdFormatOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ModifyIdentityIdFormat(*ec2.ModifyIdentityIdFormatInput) (*ec2.ModifyIdentityIdFormatOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ModifyIdentityIdFormatWithContext(aws.Context, *ec2.ModifyIdentityIdFormatInput, ...request.Option) (*ec2.ModifyIdentityIdFormatOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ModifyIdentityIdFormatRequest(*ec2.ModifyIdentityIdFormatInput) (*request.Request, *ec2.ModifyIdentityIdFormatOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ModifyImageAttribute(*ec2.ModifyImageAttributeInput) (*ec2.ModifyImageAttributeOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ModifyImageAttributeWithContext(aws.Context, *ec2.ModifyImageAttributeInput, ...request.Option) (*ec2.ModifyImageAttributeOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ModifyImageAttributeRequest(*ec2.ModifyImageAttributeInput) (*request.Request, *ec2.ModifyImageAttributeOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ModifyInstanceAttribute(*ec2.ModifyInstanceAttributeInput) (*ec2.ModifyInstanceAttributeOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ModifyInstanceAttributeWithContext(aws.Context, *ec2.ModifyInstanceAttributeInput, ...request.Option) (*ec2.ModifyInstanceAttributeOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ModifyInstanceAttributeRequest(*ec2.ModifyInstanceAttributeInput) (*request.Request, *ec2.ModifyInstanceAttributeOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ModifyInstancePlacement(*ec2.ModifyInstancePlacementInput) (*ec2.ModifyInstancePlacementOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ModifyInstancePlacementWithContext(aws.Context, *ec2.ModifyInstancePlacementInput, ...request.Option) (*ec2.ModifyInstancePlacementOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ModifyInstancePlacementRequest(*ec2.ModifyInstancePlacementInput) (*request.Request, *ec2.ModifyInstancePlacementOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ModifyNetworkInterfaceAttribute(*ec2.ModifyNetworkInterfaceAttributeInput) (*ec2.ModifyNetworkInterfaceAttributeOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ModifyNetworkInterfaceAttributeWithContext(aws.Context, *ec2.ModifyNetworkInterfaceAttributeInput, ...request.Option) (*ec2.ModifyNetworkInterfaceAttributeOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ModifyNetworkInterfaceAttributeRequest(*ec2.ModifyNetworkInterfaceAttributeInput) (*request.Request, *ec2.ModifyNetworkInterfaceAttributeOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ModifyReservedInstances(*ec2.ModifyReservedInstancesInput) (*ec2.ModifyReservedInstancesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ModifyReservedInstancesWithContext(aws.Context, *ec2.ModifyReservedInstancesInput, ...request.Option) (*ec2.ModifyReservedInstancesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ModifyReservedInstancesRequest(*ec2.ModifyReservedInstancesInput) (*request.Request, *ec2.ModifyReservedInstancesOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ModifySnapshotAttribute(*ec2.ModifySnapshotAttributeInput) (*ec2.ModifySnapshotAttributeOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ModifySnapshotAttributeWithContext(aws.Context, *ec2.ModifySnapshotAttributeInput, ...request.Option) (*ec2.ModifySnapshotAttributeOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ModifySnapshotAttributeRequest(*ec2.ModifySnapshotAttributeInput) (*request.Request, *ec2.ModifySnapshotAttributeOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ModifySpotFleetRequest(*ec2.ModifySpotFleetRequestInput) (*ec2.ModifySpotFleetRequestOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ModifySpotFleetRequestWithContext(aws.Context, *ec2.ModifySpotFleetRequestInput, ...request.Option) (*ec2.ModifySpotFleetRequestOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ModifySpotFleetRequestRequest(*ec2.ModifySpotFleetRequestInput) (*request.Request, *ec2.ModifySpotFleetRequestOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ModifySubnetAttribute(*ec2.ModifySubnetAttributeInput) (*ec2.ModifySubnetAttributeOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ModifySubnetAttributeWithContext(aws.Context, *ec2.ModifySubnetAttributeInput, ...request.Option) (*ec2.ModifySubnetAttributeOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ModifySubnetAttributeRequest(*ec2.ModifySubnetAttributeInput) (*request.Request, *ec2.ModifySubnetAttributeOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ModifyVolume(*ec2.ModifyVolumeInput) (*ec2.ModifyVolumeOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ModifyVolumeWithContext(aws.Context, *ec2.ModifyVolumeInput, ...request.Option) (*ec2.ModifyVolumeOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ModifyVolumeRequest(*ec2.ModifyVolumeInput) (*request.Request, *ec2.ModifyVolumeOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ModifyVolumeAttribute(*ec2.ModifyVolumeAttributeInput) (*ec2.ModifyVolumeAttributeOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ModifyVolumeAttributeWithContext(aws.Context, *ec2.ModifyVolumeAttributeInput, ...request.Option) (*ec2.ModifyVolumeAttributeOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ModifyVolumeAttributeRequest(*ec2.ModifyVolumeAttributeInput) (*request.Request, *ec2.ModifyVolumeAttributeOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ModifyVpcEndpoint(*ec2.ModifyVpcEndpointInput) (*ec2.ModifyVpcEndpointOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ModifyVpcEndpointWithContext(aws.Context, *ec2.ModifyVpcEndpointInput, ...request.Option) (*ec2.ModifyVpcEndpointOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ModifyVpcEndpointRequest(*ec2.ModifyVpcEndpointInput) (*request.Request, *ec2.ModifyVpcEndpointOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ModifyVpcPeeringConnectionOptions(*ec2.ModifyVpcPeeringConnectionOptionsInput) (*ec2.ModifyVpcPeeringConnectionOptionsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ModifyVpcPeeringConnectionOptionsWithContext(aws.Context, *ec2.ModifyVpcPeeringConnectionOptionsInput, ...request.Option) (*ec2.ModifyVpcPeeringConnectionOptionsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ModifyVpcPeeringConnectionOptionsRequest(*ec2.ModifyVpcPeeringConnectionOptionsInput) (*request.Request, *ec2.ModifyVpcPeeringConnectionOptionsOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) MonitorInstances(*ec2.MonitorInstancesInput) (*ec2.MonitorInstancesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) MonitorInstancesWithContext(aws.Context, *ec2.MonitorInstancesInput, ...request.Option) (*ec2.MonitorInstancesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) MonitorInstancesRequest(*ec2.MonitorInstancesInput) (*request.Request, *ec2.MonitorInstancesOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) MoveAddressToVpc(*ec2.MoveAddressToVpcInput) (*ec2.MoveAddressToVpcOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) MoveAddressToVpcWithContext(aws.Context, *ec2.MoveAddressToVpcInput, ...request.Option) (*ec2.MoveAddressToVpcOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) MoveAddressToVpcRequest(*ec2.MoveAddressToVpcInput) (*request.Request, *ec2.MoveAddressToVpcOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) PurchaseHostReservation(*ec2.PurchaseHostReservationInput) (*ec2.PurchaseHostReservationOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) PurchaseHostReservationWithContext(aws.Context, *ec2.PurchaseHostReservationInput, ...request.Option) (*ec2.PurchaseHostReservationOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) PurchaseHostReservationRequest(*ec2.PurchaseHostReservationInput) (*request.Request, *ec2.PurchaseHostReservationOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) PurchaseReservedInstancesOffering(*ec2.PurchaseReservedInstancesOfferingInput) (*ec2.PurchaseReservedInstancesOfferingOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) PurchaseReservedInstancesOfferingWithContext(aws.Context, *ec2.PurchaseReservedInstancesOfferingInput, ...request.Option) (*ec2.PurchaseReservedInstancesOfferingOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) PurchaseReservedInstancesOfferingRequest(*ec2.PurchaseReservedInstancesOfferingInput) (*request.Request, *ec2.PurchaseReservedInstancesOfferingOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) PurchaseScheduledInstances(*ec2.PurchaseScheduledInstancesInput) (*ec2.PurchaseScheduledInstancesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) PurchaseScheduledInstancesWithContext(aws.Context, *ec2.PurchaseScheduledInstancesInput, ...request.Option) (*ec2.PurchaseScheduledInstancesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) PurchaseScheduledInstancesRequest(*ec2.PurchaseScheduledInstancesInput) (*request.Request, *ec2.PurchaseScheduledInstancesOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) RebootInstances(*ec2.RebootInstancesInput) (*ec2.RebootInstancesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) RebootInstancesWithContext(aws.Context, *ec2.RebootInstancesInput, ...request.Option) (*ec2.RebootInstancesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) RebootInstancesRequest(*ec2.RebootInstancesInput) (*request.Request, *ec2.RebootInstancesOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) RegisterImage(*ec2.RegisterImageInput) (*ec2.RegisterImageOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) RegisterImageWithContext(aws.Context, *ec2.RegisterImageInput, ...request.Option) (*ec2.RegisterImageOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) RegisterImageRequest(*ec2.RegisterImageInput) (*request.Request, *ec2.RegisterImageOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) RejectVpcPeeringConnection(*ec2.RejectVpcPeeringConnectionInput) (*ec2.RejectVpcPeeringConnectionOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) RejectVpcPeeringConnectionWithContext(aws.Context, *ec2.RejectVpcPeeringConnectionInput, ...request.Option) (*ec2.RejectVpcPeeringConnectionOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) RejectVpcPeeringConnectionRequest(*ec2.RejectVpcPeeringConnectionInput) (*request.Request, *ec2.RejectVpcPeeringConnectionOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ReleaseHosts(*ec2.ReleaseHostsInput) (*ec2.ReleaseHostsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ReleaseHostsWithContext(aws.Context, *ec2.ReleaseHostsInput, ...request.Option) (*ec2.ReleaseHostsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ReleaseHostsRequest(*ec2.ReleaseHostsInput) (*request.Request, *ec2.ReleaseHostsOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ReplaceIamInstanceProfileAssociation(*ec2.ReplaceIamInstanceProfileAssociationInput) (*ec2.ReplaceIamInstanceProfileAssociationOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ReplaceIamInstanceProfileAssociationWithContext(aws.Context, *ec2.ReplaceIamInstanceProfileAssociationInput, ...request.Option) (*ec2.ReplaceIamInstanceProfileAssociationOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ReplaceIamInstanceProfileAssociationRequest(*ec2.ReplaceIamInstanceProfileAssociationInput) (*request.Request, *ec2.ReplaceIamInstanceProfileAssociationOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ReplaceNetworkAclAssociation(*ec2.ReplaceNetworkAclAssociationInput) (*ec2.ReplaceNetworkAclAssociationOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ReplaceNetworkAclAssociationWithContext(aws.Context, *ec2.ReplaceNetworkAclAssociationInput, ...request.Option) (*ec2.ReplaceNetworkAclAssociationOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ReplaceNetworkAclAssociationRequest(*ec2.ReplaceNetworkAclAssociationInput) (*request.Request, *ec2.ReplaceNetworkAclAssociationOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ReplaceNetworkAclEntry(*ec2.ReplaceNetworkAclEntryInput) (*ec2.ReplaceNetworkAclEntryOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ReplaceNetworkAclEntryWithContext(aws.Context, *ec2.ReplaceNetworkAclEntryInput, ...request.Option) (*ec2.ReplaceNetworkAclEntryOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ReplaceNetworkAclEntryRequest(*ec2.ReplaceNetworkAclEntryInput) (*request.Request, *ec2.ReplaceNetworkAclEntryOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ReplaceRoute(*ec2.ReplaceRouteInput) (*ec2.ReplaceRouteOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ReplaceRouteWithContext(aws.Context, *ec2.ReplaceRouteInput, ...request.Option) (*ec2.ReplaceRouteOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ReplaceRouteRequest(*ec2.ReplaceRouteInput) (*request.Request, *ec2.ReplaceRouteOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ReplaceRouteTableAssociation(*ec2.ReplaceRouteTableAssociationInput) (*ec2.ReplaceRouteTableAssociationOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ReplaceRouteTableAssociationWithContext(aws.Context, *ec2.ReplaceRouteTableAssociationInput, ...request.Option) (*ec2.ReplaceRouteTableAssociationOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ReplaceRouteTableAssociationRequest(*ec2.ReplaceRouteTableAssociationInput) (*request.Request, *ec2.ReplaceRouteTableAssociationOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ReportInstanceStatus(*ec2.ReportInstanceStatusInput) (*ec2.ReportInstanceStatusOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ReportInstanceStatusWithContext(aws.Context, *ec2.ReportInstanceStatusInput, ...request.Option) (*ec2.ReportInstanceStatusOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ReportInstanceStatusRequest(*ec2.ReportInstanceStatusInput) (*request.Request, *ec2.ReportInstanceStatusOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) RequestSpotFleet(*ec2.RequestSpotFleetInput) (*ec2.RequestSpotFleetOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) RequestSpotFleetWithContext(aws.Context, *ec2.RequestSpotFleetInput, ...request.Option) (*ec2.RequestSpotFleetOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) RequestSpotFleetRequest(*ec2.RequestSpotFleetInput) (*request.Request, *ec2.RequestSpotFleetOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) RequestSpotInstances(*ec2.RequestSpotInstancesInput) (*ec2.RequestSpotInstancesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) RequestSpotInstancesWithContext(aws.Context, *ec2.RequestSpotInstancesInput, ...request.Option) (*ec2.RequestSpotInstancesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) RequestSpotInstancesRequest(*ec2.RequestSpotInstancesInput) (*request.Request, *ec2.RequestSpotInstancesOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ResetImageAttribute(*ec2.ResetImageAttributeInput) (*ec2.ResetImageAttributeOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ResetImageAttributeWithContext(aws.Context, *ec2.ResetImageAttributeInput, ...request.Option) (*ec2.ResetImageAttributeOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ResetImageAttributeRequest(*ec2.ResetImageAttributeInput) (*request.Request, *ec2.ResetImageAttributeOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ResetInstanceAttribute(*ec2.ResetInstanceAttributeInput) (*ec2.ResetInstanceAttributeOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ResetInstanceAttributeWithContext(aws.Context, *ec2.ResetInstanceAttributeInput, ...request.Option) (*ec2.ResetInstanceAttributeOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ResetInstanceAttributeRequest(*ec2.ResetInstanceAttributeInput) (*request.Request, *ec2.ResetInstanceAttributeOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ResetNetworkInterfaceAttribute(*ec2.ResetNetworkInterfaceAttributeInput) (*ec2.ResetNetworkInterfaceAttributeOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ResetNetworkInterfaceAttributeWithContext(aws.Context, *ec2.ResetNetworkInterfaceAttributeInput, ...request.Option) (*ec2.ResetNetworkInterfaceAttributeOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ResetNetworkInterfaceAttributeRequest(*ec2.ResetNetworkInterfaceAttributeInput) (*request.Request, *ec2.ResetNetworkInterfaceAttributeOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ResetSnapshotAttribute(*ec2.ResetSnapshotAttributeInput) (*ec2.ResetSnapshotAttributeOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ResetSnapshotAttributeWithContext(aws.Context, *ec2.ResetSnapshotAttributeInput, ...request.Option) (*ec2.ResetSnapshotAttributeOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ResetSnapshotAttributeRequest(*ec2.ResetSnapshotAttributeInput) (*request.Request, *ec2.ResetSnapshotAttributeOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) RestoreAddressToClassic(*ec2.RestoreAddressToClassicInput) (*ec2.RestoreAddressToClassicOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) RestoreAddressToClassicWithContext(aws.Context, *ec2.RestoreAddressToClassicInput, ...request.Option) (*ec2.RestoreAddressToClassicOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) RestoreAddressToClassicRequest(*ec2.RestoreAddressToClassicInput) (*request.Request, *ec2.RestoreAddressToClassicOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) RunInstances(*ec2.RunInstancesInput) (*ec2.Reservation, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) RunInstancesWithContext(aws.Context, *ec2.RunInstancesInput, ...request.Option) (*ec2.Reservation, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) RunInstancesRequest(*ec2.RunInstancesInput) (*request.Request, *ec2.Reservation) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) RunScheduledInstances(*ec2.RunScheduledInstancesInput) (*ec2.RunScheduledInstancesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) RunScheduledInstancesWithContext(aws.Context, *ec2.RunScheduledInstancesInput, ...request.Option) (*ec2.RunScheduledInstancesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) RunScheduledInstancesRequest(*ec2.RunScheduledInstancesInput) (*request.Request, *ec2.RunScheduledInstancesOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) StartInstances(*ec2.StartInstancesInput) (*ec2.StartInstancesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) StartInstancesWithContext(aws.Context, *ec2.StartInstancesInput, ...request.Option) (*ec2.StartInstancesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) StartInstancesRequest(*ec2.StartInstancesInput) (*request.Request, *ec2.StartInstancesOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) StopInstances(*ec2.StopInstancesInput) (*ec2.StopInstancesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) StopInstancesWithContext(aws.Context, *ec2.StopInstancesInput, ...request.Option) (*ec2.StopInstancesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) StopInstancesRequest(*ec2.StopInstancesInput) (*request.Request, *ec2.StopInstancesOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) TerminateInstances(*ec2.TerminateInstancesInput) (*ec2.TerminateInstancesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) TerminateInstancesWithContext(aws.Context, *ec2.TerminateInstancesInput, ...request.Option) (*ec2.TerminateInstancesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) TerminateInstancesRequest(*ec2.TerminateInstancesInput) (*request.Request, *ec2.TerminateInstancesOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) UnassignIpv6Addresses(*ec2.UnassignIpv6AddressesInput) (*ec2.UnassignIpv6AddressesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) UnassignIpv6AddressesWithContext(aws.Context, *ec2.UnassignIpv6AddressesInput, ...request.Option) (*ec2.UnassignIpv6AddressesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) UnassignIpv6AddressesRequest(*ec2.UnassignIpv6AddressesInput) (*request.Request, *ec2.UnassignIpv6AddressesOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) UnassignPrivateIpAddresses(*ec2.UnassignPrivateIpAddressesInput) (*ec2.UnassignPrivateIpAddressesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) UnassignPrivateIpAddressesWithContext(aws.Context, *ec2.UnassignPrivateIpAddressesInput, ...request.Option) (*ec2.UnassignPrivateIpAddressesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) UnassignPrivateIpAddressesRequest(*ec2.UnassignPrivateIpAddressesInput) (*request.Request, *ec2.UnassignPrivateIpAddressesOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) UnmonitorInstances(*ec2.UnmonitorInstancesInput) (*ec2.UnmonitorInstancesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) UnmonitorInstancesWithContext(aws.Context, *ec2.UnmonitorInstancesInput, ...request.Option) (*ec2.UnmonitorInstancesOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) UnmonitorInstancesRequest(*ec2.UnmonitorInstancesInput) (*request.Request, *ec2.UnmonitorInstancesOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) WaitUntilBundleTaskComplete(*ec2.DescribeBundleTasksInput) error {
	panic("Not implemented")
	return nil
}
func (m *MockEC2) WaitUntilBundleTaskCompleteWithContext(aws.Context, *ec2.DescribeBundleTasksInput, ...request.WaiterOption) error {
	panic("Not implemented")
	return nil
}

func (m *MockEC2) WaitUntilConversionTaskCancelled(*ec2.DescribeConversionTasksInput) error {
	panic("Not implemented")
	return nil
}
func (m *MockEC2) WaitUntilConversionTaskCancelledWithContext(aws.Context, *ec2.DescribeConversionTasksInput, ...request.WaiterOption) error {
	panic("Not implemented")
	return nil
}

func (m *MockEC2) WaitUntilConversionTaskCompleted(*ec2.DescribeConversionTasksInput) error {
	panic("Not implemented")
	return nil
}
func (m *MockEC2) WaitUntilConversionTaskCompletedWithContext(aws.Context, *ec2.DescribeConversionTasksInput, ...request.WaiterOption) error {
	panic("Not implemented")
	return nil
}

func (m *MockEC2) WaitUntilConversionTaskDeleted(*ec2.DescribeConversionTasksInput) error {
	panic("Not implemented")
	return nil
}
func (m *MockEC2) WaitUntilConversionTaskDeletedWithContext(aws.Context, *ec2.DescribeConversionTasksInput, ...request.WaiterOption) error {
	panic("Not implemented")
	return nil
}

func (m *MockEC2) WaitUntilCustomerGatewayAvailable(*ec2.DescribeCustomerGatewaysInput) error {
	panic("Not implemented")
	return nil
}
func (m *MockEC2) WaitUntilCustomerGatewayAvailableWithContext(aws.Context, *ec2.DescribeCustomerGatewaysInput, ...request.WaiterOption) error {
	panic("Not implemented")
	return nil
}

func (m *MockEC2) WaitUntilExportTaskCancelled(*ec2.DescribeExportTasksInput) error {
	panic("Not implemented")
	return nil
}
func (m *MockEC2) WaitUntilExportTaskCancelledWithContext(aws.Context, *ec2.DescribeExportTasksInput, ...request.WaiterOption) error {
	panic("Not implemented")
	return nil
}

func (m *MockEC2) WaitUntilExportTaskCompleted(*ec2.DescribeExportTasksInput) error {
	panic("Not implemented")
	return nil
}
func (m *MockEC2) WaitUntilExportTaskCompletedWithContext(aws.Context, *ec2.DescribeExportTasksInput, ...request.WaiterOption) error {
	panic("Not implemented")
	return nil
}

func (m *MockEC2) WaitUntilImageAvailable(*ec2.DescribeImagesInput) error {
	panic("Not implemented")
	return nil
}
func (m *MockEC2) WaitUntilImageAvailableWithContext(aws.Context, *ec2.DescribeImagesInput, ...request.WaiterOption) error {
	panic("Not implemented")
	return nil
}

func (m *MockEC2) WaitUntilImageExists(*ec2.DescribeImagesInput) error {
	panic("Not implemented")
	return nil
}
func (m *MockEC2) WaitUntilImageExistsWithContext(aws.Context, *ec2.DescribeImagesInput, ...request.WaiterOption) error {
	panic("Not implemented")
	return nil
}

func (m *MockEC2) WaitUntilInstanceExists(*ec2.DescribeInstancesInput) error {
	panic("Not implemented")
	return nil
}
func (m *MockEC2) WaitUntilInstanceExistsWithContext(aws.Context, *ec2.DescribeInstancesInput, ...request.WaiterOption) error {
	panic("Not implemented")
	return nil
}

func (m *MockEC2) WaitUntilInstanceRunning(*ec2.DescribeInstancesInput) error {
	panic("Not implemented")
	return nil
}
func (m *MockEC2) WaitUntilInstanceRunningWithContext(aws.Context, *ec2.DescribeInstancesInput, ...request.WaiterOption) error {
	panic("Not implemented")
	return nil
}

func (m *MockEC2) WaitUntilInstanceStatusOk(*ec2.DescribeInstanceStatusInput) error {
	panic("Not implemented")
	return nil
}
func (m *MockEC2) WaitUntilInstanceStatusOkWithContext(aws.Context, *ec2.DescribeInstanceStatusInput, ...request.WaiterOption) error {
	panic("Not implemented")
	return nil
}

func (m *MockEC2) WaitUntilInstanceStopped(*ec2.DescribeInstancesInput) error {
	panic("Not implemented")
	return nil
}
func (m *MockEC2) WaitUntilInstanceStoppedWithContext(aws.Context, *ec2.DescribeInstancesInput, ...request.WaiterOption) error {
	panic("Not implemented")
	return nil
}

func (m *MockEC2) WaitUntilInstanceTerminated(*ec2.DescribeInstancesInput) error {
	panic("Not implemented")
	return nil
}
func (m *MockEC2) WaitUntilInstanceTerminatedWithContext(aws.Context, *ec2.DescribeInstancesInput, ...request.WaiterOption) error {
	panic("Not implemented")
	return nil
}

func (m *MockEC2) WaitUntilKeyPairExists(*ec2.DescribeKeyPairsInput) error {
	panic("Not implemented")
	return nil
}
func (m *MockEC2) WaitUntilKeyPairExistsWithContext(aws.Context, *ec2.DescribeKeyPairsInput, ...request.WaiterOption) error {
	panic("Not implemented")
	return nil
}

func (m *MockEC2) WaitUntilNetworkInterfaceAvailable(*ec2.DescribeNetworkInterfacesInput) error {
	panic("Not implemented")
	return nil
}
func (m *MockEC2) WaitUntilNetworkInterfaceAvailableWithContext(aws.Context, *ec2.DescribeNetworkInterfacesInput, ...request.WaiterOption) error {
	panic("Not implemented")
	return nil
}

func (m *MockEC2) WaitUntilPasswordDataAvailable(*ec2.GetPasswordDataInput) error {
	panic("Not implemented")
	return nil
}
func (m *MockEC2) WaitUntilPasswordDataAvailableWithContext(aws.Context, *ec2.GetPasswordDataInput, ...request.WaiterOption) error {
	panic("Not implemented")
	return nil
}

func (m *MockEC2) WaitUntilSnapshotCompleted(*ec2.DescribeSnapshotsInput) error {
	panic("Not implemented")
	return nil
}
func (m *MockEC2) WaitUntilSnapshotCompletedWithContext(aws.Context, *ec2.DescribeSnapshotsInput, ...request.WaiterOption) error {
	panic("Not implemented")
	return nil
}

func (m *MockEC2) WaitUntilSpotInstanceRequestFulfilled(*ec2.DescribeSpotInstanceRequestsInput) error {
	panic("Not implemented")
	return nil
}
func (m *MockEC2) WaitUntilSpotInstanceRequestFulfilledWithContext(aws.Context, *ec2.DescribeSpotInstanceRequestsInput, ...request.WaiterOption) error {
	panic("Not implemented")
	return nil
}

func (m *MockEC2) WaitUntilSubnetAvailable(*ec2.DescribeSubnetsInput) error {
	panic("Not implemented")
	return nil
}
func (m *MockEC2) WaitUntilSubnetAvailableWithContext(aws.Context, *ec2.DescribeSubnetsInput, ...request.WaiterOption) error {
	panic("Not implemented")
	return nil
}

func (m *MockEC2) WaitUntilSystemStatusOk(*ec2.DescribeInstanceStatusInput) error {
	panic("Not implemented")
	return nil
}
func (m *MockEC2) WaitUntilSystemStatusOkWithContext(aws.Context, *ec2.DescribeInstanceStatusInput, ...request.WaiterOption) error {
	panic("Not implemented")
	return nil
}

func (m *MockEC2) WaitUntilVolumeAvailable(*ec2.DescribeVolumesInput) error {
	panic("Not implemented")
	return nil
}
func (m *MockEC2) WaitUntilVolumeAvailableWithContext(aws.Context, *ec2.DescribeVolumesInput, ...request.WaiterOption) error {
	panic("Not implemented")
	return nil
}

func (m *MockEC2) WaitUntilVolumeDeleted(*ec2.DescribeVolumesInput) error {
	panic("Not implemented")
	return nil
}
func (m *MockEC2) WaitUntilVolumeDeletedWithContext(aws.Context, *ec2.DescribeVolumesInput, ...request.WaiterOption) error {
	panic("Not implemented")
	return nil
}

func (m *MockEC2) WaitUntilVolumeInUse(*ec2.DescribeVolumesInput) error {
	panic("Not implemented")
	return nil
}
func (m *MockEC2) WaitUntilVolumeInUseWithContext(aws.Context, *ec2.DescribeVolumesInput, ...request.WaiterOption) error {
	panic("Not implemented")
	return nil
}

func (m *MockEC2) WaitUntilVpcAvailable(*ec2.DescribeVpcsInput) error {
	panic("Not implemented")
	return nil
}
func (m *MockEC2) WaitUntilVpcAvailableWithContext(aws.Context, *ec2.DescribeVpcsInput, ...request.WaiterOption) error {
	panic("Not implemented")
	return nil
}

func (m *MockEC2) WaitUntilVpcExists(*ec2.DescribeVpcsInput) error {
	panic("Not implemented")
	return nil
}
func (m *MockEC2) WaitUntilVpcExistsWithContext(aws.Context, *ec2.DescribeVpcsInput, ...request.WaiterOption) error {
	panic("Not implemented")
	return nil
}

func (m *MockEC2) WaitUntilVpcPeeringConnectionDeleted(*ec2.DescribeVpcPeeringConnectionsInput) error {
	panic("Not implemented")
	return nil
}
func (m *MockEC2) WaitUntilVpcPeeringConnectionDeletedWithContext(aws.Context, *ec2.DescribeVpcPeeringConnectionsInput, ...request.WaiterOption) error {
	panic("Not implemented")
	return nil
}

func (m *MockEC2) WaitUntilVpcPeeringConnectionExists(*ec2.DescribeVpcPeeringConnectionsInput) error {
	panic("Not implemented")
	return nil
}
func (m *MockEC2) WaitUntilVpcPeeringConnectionExistsWithContext(aws.Context, *ec2.DescribeVpcPeeringConnectionsInput, ...request.WaiterOption) error {
	panic("Not implemented")
	return nil
}

func (m *MockEC2) WaitUntilVpnConnectionAvailable(*ec2.DescribeVpnConnectionsInput) error {
	panic("Not implemented")
	return nil
}
func (m *MockEC2) WaitUntilVpnConnectionAvailableWithContext(aws.Context, *ec2.DescribeVpnConnectionsInput, ...request.WaiterOption) error {
	panic("Not implemented")
	return nil
}

func (m *MockEC2) WaitUntilVpnConnectionDeleted(*ec2.DescribeVpnConnectionsInput) error {
	panic("Not implemented")
	return nil
}
func (m *MockEC2) WaitUntilVpnConnectionDeletedWithContext(aws.Context, *ec2.DescribeVpnConnectionsInput, ...request.WaiterOption) error {
	panic("Not implemented")
	return nil
}

func (m *MockEC2) AcceptVpcEndpointConnections(*ec2.AcceptVpcEndpointConnectionsInput) (*ec2.AcceptVpcEndpointConnectionsOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) AcceptVpcEndpointConnectionsWithContext(aws.Context, *ec2.AcceptVpcEndpointConnectionsInput, ...request.Option) (*ec2.AcceptVpcEndpointConnectionsOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) AcceptVpcEndpointConnectionsRequest(*ec2.AcceptVpcEndpointConnectionsInput) (*request.Request, *ec2.AcceptVpcEndpointConnectionsOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CreateDefaultSubnet(*ec2.CreateDefaultSubnetInput) (*ec2.CreateDefaultSubnetOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CreateDefaultSubnetWithContext(aws.Context, *ec2.CreateDefaultSubnetInput, ...request.Option) (*ec2.CreateDefaultSubnetOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CreateDefaultSubnetRequest(*ec2.CreateDefaultSubnetInput) (*request.Request, *ec2.CreateDefaultSubnetOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CreateLaunchTemplate(*ec2.CreateLaunchTemplateInput) (*ec2.CreateLaunchTemplateOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CreateLaunchTemplateWithContext(aws.Context, *ec2.CreateLaunchTemplateInput, ...request.Option) (*ec2.CreateLaunchTemplateOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CreateLaunchTemplateRequest(*ec2.CreateLaunchTemplateInput) (*request.Request, *ec2.CreateLaunchTemplateOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CreateLaunchTemplateVersion(*ec2.CreateLaunchTemplateVersionInput) (*ec2.CreateLaunchTemplateVersionOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CreateLaunchTemplateVersionWithContext(aws.Context, *ec2.CreateLaunchTemplateVersionInput, ...request.Option) (*ec2.CreateLaunchTemplateVersionOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CreateLaunchTemplateVersionRequest(*ec2.CreateLaunchTemplateVersionInput) (*request.Request, *ec2.CreateLaunchTemplateVersionOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CreateVpcEndpointConnectionNotification(*ec2.CreateVpcEndpointConnectionNotificationInput) (*ec2.CreateVpcEndpointConnectionNotificationOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CreateVpcEndpointConnectionNotificationWithContext(aws.Context, *ec2.CreateVpcEndpointConnectionNotificationInput, ...request.Option) (*ec2.CreateVpcEndpointConnectionNotificationOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CreateVpcEndpointConnectionNotificationRequest(*ec2.CreateVpcEndpointConnectionNotificationInput) (*request.Request, *ec2.CreateVpcEndpointConnectionNotificationOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CreateVpcEndpointServiceConfiguration(*ec2.CreateVpcEndpointServiceConfigurationInput) (*ec2.CreateVpcEndpointServiceConfigurationOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CreateVpcEndpointServiceConfigurationWithContext(aws.Context, *ec2.CreateVpcEndpointServiceConfigurationInput, ...request.Option) (*ec2.CreateVpcEndpointServiceConfigurationOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CreateVpcEndpointServiceConfigurationRequest(*ec2.CreateVpcEndpointServiceConfigurationInput) (*request.Request, *ec2.CreateVpcEndpointServiceConfigurationOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DeleteLaunchTemplate(*ec2.DeleteLaunchTemplateInput) (*ec2.DeleteLaunchTemplateOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DeleteLaunchTemplateWithContext(aws.Context, *ec2.DeleteLaunchTemplateInput, ...request.Option) (*ec2.DeleteLaunchTemplateOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DeleteLaunchTemplateRequest(*ec2.DeleteLaunchTemplateInput) (*request.Request, *ec2.DeleteLaunchTemplateOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DeleteLaunchTemplateVersions(*ec2.DeleteLaunchTemplateVersionsInput) (*ec2.DeleteLaunchTemplateVersionsOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DeleteLaunchTemplateVersionsWithContext(aws.Context, *ec2.DeleteLaunchTemplateVersionsInput, ...request.Option) (*ec2.DeleteLaunchTemplateVersionsOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DeleteLaunchTemplateVersionsRequest(*ec2.DeleteLaunchTemplateVersionsInput) (*request.Request, *ec2.DeleteLaunchTemplateVersionsOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DeleteVpcEndpointConnectionNotifications(*ec2.DeleteVpcEndpointConnectionNotificationsInput) (*ec2.DeleteVpcEndpointConnectionNotificationsOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DeleteVpcEndpointConnectionNotificationsWithContext(aws.Context, *ec2.DeleteVpcEndpointConnectionNotificationsInput, ...request.Option) (*ec2.DeleteVpcEndpointConnectionNotificationsOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DeleteVpcEndpointConnectionNotificationsRequest(*ec2.DeleteVpcEndpointConnectionNotificationsInput) (*request.Request, *ec2.DeleteVpcEndpointConnectionNotificationsOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DeleteVpcEndpointServiceConfigurations(*ec2.DeleteVpcEndpointServiceConfigurationsInput) (*ec2.DeleteVpcEndpointServiceConfigurationsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeleteVpcEndpointServiceConfigurationsWithContext(aws.Context, *ec2.DeleteVpcEndpointServiceConfigurationsInput, ...request.Option) (*ec2.DeleteVpcEndpointServiceConfigurationsOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DeleteVpcEndpointServiceConfigurationsRequest(*ec2.DeleteVpcEndpointServiceConfigurationsInput) (*request.Request, *ec2.DeleteVpcEndpointServiceConfigurationsOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeInstanceCreditSpecifications(*ec2.DescribeInstanceCreditSpecificationsInput) (*ec2.DescribeInstanceCreditSpecificationsOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeInstanceCreditSpecificationsWithContext(aws.Context, *ec2.DescribeInstanceCreditSpecificationsInput, ...request.Option) (*ec2.DescribeInstanceCreditSpecificationsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeInstanceCreditSpecificationsRequest(*ec2.DescribeInstanceCreditSpecificationsInput) (*request.Request, *ec2.DescribeInstanceCreditSpecificationsOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeLaunchTemplateVersions(*ec2.DescribeLaunchTemplateVersionsInput) (*ec2.DescribeLaunchTemplateVersionsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeLaunchTemplateVersionsWithContext(aws.Context, *ec2.DescribeLaunchTemplateVersionsInput, ...request.Option) (*ec2.DescribeLaunchTemplateVersionsOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeLaunchTemplateVersionsRequest(*ec2.DescribeLaunchTemplateVersionsInput) (*request.Request, *ec2.DescribeLaunchTemplateVersionsOutput) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeLaunchTemplates(*ec2.DescribeLaunchTemplatesInput) (*ec2.DescribeLaunchTemplatesOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeLaunchTemplatesWithContext(aws.Context, *ec2.DescribeLaunchTemplatesInput, ...request.Option) (*ec2.DescribeLaunchTemplatesOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeLaunchTemplatesRequest(*ec2.DescribeLaunchTemplatesInput) (*request.Request, *ec2.DescribeLaunchTemplatesOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeVpcEndpointConnectionNotifications(*ec2.DescribeVpcEndpointConnectionNotificationsInput) (*ec2.DescribeVpcEndpointConnectionNotificationsOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeVpcEndpointConnectionNotificationsWithContext(aws.Context, *ec2.DescribeVpcEndpointConnectionNotificationsInput, ...request.Option) (*ec2.DescribeVpcEndpointConnectionNotificationsOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeVpcEndpointConnectionNotificationsRequest(*ec2.DescribeVpcEndpointConnectionNotificationsInput) (*request.Request, *ec2.DescribeVpcEndpointConnectionNotificationsOutput) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeVpcEndpointConnections(*ec2.DescribeVpcEndpointConnectionsInput) (*ec2.DescribeVpcEndpointConnectionsOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeVpcEndpointConnectionsWithContext(aws.Context, *ec2.DescribeVpcEndpointConnectionsInput, ...request.Option) (*ec2.DescribeVpcEndpointConnectionsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeVpcEndpointConnectionsRequest(*ec2.DescribeVpcEndpointConnectionsInput) (*request.Request, *ec2.DescribeVpcEndpointConnectionsOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeVpcEndpointServiceConfigurations(*ec2.DescribeVpcEndpointServiceConfigurationsInput) (*ec2.DescribeVpcEndpointServiceConfigurationsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeVpcEndpointServiceConfigurationsWithContext(aws.Context, *ec2.DescribeVpcEndpointServiceConfigurationsInput, ...request.Option) (*ec2.DescribeVpcEndpointServiceConfigurationsOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeVpcEndpointServiceConfigurationsRequest(*ec2.DescribeVpcEndpointServiceConfigurationsInput) (*request.Request, *ec2.DescribeVpcEndpointServiceConfigurationsOutput) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeVpcEndpointServicePermissions(*ec2.DescribeVpcEndpointServicePermissionsInput) (*ec2.DescribeVpcEndpointServicePermissionsOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeVpcEndpointServicePermissionsWithContext(aws.Context, *ec2.DescribeVpcEndpointServicePermissionsInput, ...request.Option) (*ec2.DescribeVpcEndpointServicePermissionsOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeVpcEndpointServicePermissionsRequest(*ec2.DescribeVpcEndpointServicePermissionsInput) (*request.Request, *ec2.DescribeVpcEndpointServicePermissionsOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) GetLaunchTemplateData(*ec2.GetLaunchTemplateDataInput) (*ec2.GetLaunchTemplateDataOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) GetLaunchTemplateDataWithContext(aws.Context, *ec2.GetLaunchTemplateDataInput, ...request.Option) (*ec2.GetLaunchTemplateDataOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) GetLaunchTemplateDataRequest(*ec2.GetLaunchTemplateDataInput) (*request.Request, *ec2.GetLaunchTemplateDataOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ModifyInstanceCreditSpecification(*ec2.ModifyInstanceCreditSpecificationInput) (*ec2.ModifyInstanceCreditSpecificationOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ModifyInstanceCreditSpecificationWithContext(aws.Context, *ec2.ModifyInstanceCreditSpecificationInput, ...request.Option) (*ec2.ModifyInstanceCreditSpecificationOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ModifyInstanceCreditSpecificationRequest(*ec2.ModifyInstanceCreditSpecificationInput) (*request.Request, *ec2.ModifyInstanceCreditSpecificationOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ModifyLaunchTemplate(*ec2.ModifyLaunchTemplateInput) (*ec2.ModifyLaunchTemplateOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ModifyLaunchTemplateWithContext(aws.Context, *ec2.ModifyLaunchTemplateInput, ...request.Option) (*ec2.ModifyLaunchTemplateOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ModifyLaunchTemplateRequest(*ec2.ModifyLaunchTemplateInput) (*request.Request, *ec2.ModifyLaunchTemplateOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ModifyVpcEndpointConnectionNotification(*ec2.ModifyVpcEndpointConnectionNotificationInput) (*ec2.ModifyVpcEndpointConnectionNotificationOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ModifyVpcEndpointConnectionNotificationWithContext(aws.Context, *ec2.ModifyVpcEndpointConnectionNotificationInput, ...request.Option) (*ec2.ModifyVpcEndpointConnectionNotificationOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ModifyVpcEndpointConnectionNotificationRequest(*ec2.ModifyVpcEndpointConnectionNotificationInput) (*request.Request, *ec2.ModifyVpcEndpointConnectionNotificationOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ModifyVpcEndpointServiceConfiguration(*ec2.ModifyVpcEndpointServiceConfigurationInput) (*ec2.ModifyVpcEndpointServiceConfigurationOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ModifyVpcEndpointServiceConfigurationWithContext(aws.Context, *ec2.ModifyVpcEndpointServiceConfigurationInput, ...request.Option) (*ec2.ModifyVpcEndpointServiceConfigurationOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ModifyVpcEndpointServiceConfigurationRequest(*ec2.ModifyVpcEndpointServiceConfigurationInput) (*request.Request, *ec2.ModifyVpcEndpointServiceConfigurationOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ModifyVpcEndpointServicePermissions(*ec2.ModifyVpcEndpointServicePermissionsInput) (*ec2.ModifyVpcEndpointServicePermissionsOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ModifyVpcEndpointServicePermissionsWithContext(aws.Context, *ec2.ModifyVpcEndpointServicePermissionsInput, ...request.Option) (*ec2.ModifyVpcEndpointServicePermissionsOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ModifyVpcEndpointServicePermissionsRequest(*ec2.ModifyVpcEndpointServicePermissionsInput) (*request.Request, *ec2.ModifyVpcEndpointServicePermissionsOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) RejectVpcEndpointConnections(*ec2.RejectVpcEndpointConnectionsInput) (*ec2.RejectVpcEndpointConnectionsOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) RejectVpcEndpointConnectionsWithContext(aws.Context, *ec2.RejectVpcEndpointConnectionsInput, ...request.Option) (*ec2.RejectVpcEndpointConnectionsOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) RejectVpcEndpointConnectionsRequest(*ec2.RejectVpcEndpointConnectionsInput) (*request.Request, *ec2.RejectVpcEndpointConnectionsOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CopyFpgaImage(*ec2.CopyFpgaImageInput) (*ec2.CopyFpgaImageOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CopyFpgaImageWithContext(aws.Context, *ec2.CopyFpgaImageInput, ...request.Option) (*ec2.CopyFpgaImageOutput, error) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) CopyFpgaImageRequest(*ec2.CopyFpgaImageInput) (*request.Request, *ec2.CopyFpgaImageOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DescribeFpgaImageAttribute(*ec2.DescribeFpgaImageAttributeInput) (*ec2.DescribeFpgaImageAttributeOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeFpgaImageAttributeWithContext(aws.Context, *ec2.DescribeFpgaImageAttributeInput, ...request.Option) (*ec2.DescribeFpgaImageAttributeOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DescribeFpgaImageAttributeRequest(*ec2.DescribeFpgaImageAttributeInput) (*request.Request, *ec2.DescribeFpgaImageAttributeOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ModifyFpgaImageAttribute(*ec2.ModifyFpgaImageAttributeInput) (*ec2.ModifyFpgaImageAttributeOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ModifyFpgaImageAttributeWithContext(aws.Context, *ec2.ModifyFpgaImageAttributeInput, ...request.Option) (*ec2.ModifyFpgaImageAttributeOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ModifyFpgaImageAttributeRequest(*ec2.ModifyFpgaImageAttributeInput) (*request.Request, *ec2.ModifyFpgaImageAttributeOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ResetFpgaImageAttribute(*ec2.ResetFpgaImageAttributeInput) (*ec2.ResetFpgaImageAttributeOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ResetFpgaImageAttributeWithContext(aws.Context, *ec2.ResetFpgaImageAttributeInput, ...request.Option) (*ec2.ResetFpgaImageAttributeOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ResetFpgaImageAttributeRequest(*ec2.ResetFpgaImageAttributeInput) (*request.Request, *ec2.ResetFpgaImageAttributeOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) DeleteFpgaImage(*ec2.DeleteFpgaImageInput) (*ec2.DeleteFpgaImageOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeleteFpgaImageWithContext(aws.Context, *ec2.DeleteFpgaImageInput, ...request.Option) (*ec2.DeleteFpgaImageOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) DeleteFpgaImageRequest(*ec2.DeleteFpgaImageInput) (*request.Request, *ec2.DeleteFpgaImageOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) ModifyVpcTenancy(*ec2.ModifyVpcTenancyInput) (*ec2.ModifyVpcTenancyOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ModifyVpcTenancyWithContext(aws.Context, *ec2.ModifyVpcTenancyInput, ...request.Option) (*ec2.ModifyVpcTenancyOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) ModifyVpcTenancyRequest(*ec2.ModifyVpcTenancyInput) (*request.Request, *ec2.ModifyVpcTenancyOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) UpdateSecurityGroupRuleDescriptionsEgress(*ec2.UpdateSecurityGroupRuleDescriptionsEgressInput) (*ec2.UpdateSecurityGroupRuleDescriptionsEgressOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) UpdateSecurityGroupRuleDescriptionsEgressWithContext(aws.Context, *ec2.UpdateSecurityGroupRuleDescriptionsEgressInput, ...request.Option) (*ec2.UpdateSecurityGroupRuleDescriptionsEgressOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) UpdateSecurityGroupRuleDescriptionsEgressRequest(*ec2.UpdateSecurityGroupRuleDescriptionsEgressInput) (*request.Request, *ec2.UpdateSecurityGroupRuleDescriptionsEgressOutput) {
	panic("Not implemented")
	return nil, nil
}

func (m *MockEC2) UpdateSecurityGroupRuleDescriptionsIngress(*ec2.UpdateSecurityGroupRuleDescriptionsIngressInput) (*ec2.UpdateSecurityGroupRuleDescriptionsIngressOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) UpdateSecurityGroupRuleDescriptionsIngressWithContext(aws.Context, *ec2.UpdateSecurityGroupRuleDescriptionsIngressInput, ...request.Option) (*ec2.UpdateSecurityGroupRuleDescriptionsIngressOutput, error) {
	panic("Not implemented")
	return nil, nil
}
func (m *MockEC2) UpdateSecurityGroupRuleDescriptionsIngressRequest(*ec2.UpdateSecurityGroupRuleDescriptionsIngressInput) (*request.Request, *ec2.UpdateSecurityGroupRuleDescriptionsIngressOutput) {
	panic("Not implemented")
	return nil, nil
}
