
<!--- This file is automatically generated by make gen-cli-docs; changes should be made in the go CLI command code (under cmd/kops) -->

## kops completion

Output shell completion code for the given shell (bash or zsh).

### Synopsis


Output shell completion code for the specified shell (bash or zsh). The shell code must be evaluated to provide interactive completion of kops commands.  This can be done by sourcing it from the .bash _profile. 

Note: this requires the bash-completion framework, which is not installed by default on Mac. Once installed, bash completion must be evaluated.  This can be done by adding the following line to the .bash profile 

Note for zsh users: zsh completions are only supported in versions of zsh >= 5.2

```
kops completion
```

### Examples

```
  # For OSX users install bash completion using homebrew
  brew install bash-completion
  source $(brew --prefix)/etc/bash_completion
  
  # Bash completion support
  printf "source $(brew --prefix)/etc/bash_completion\n" >> $HOME/.bash_profile
  source $HOME/.bash_profile
  source <(kops completion bash)
  kops completion bash > ~/.kops/completion.bash.inc
  chmod +x $HOME/.kops/completion.bash.inc
  
  # kops shell completion
  printf "$HOME/.kops/completion.bash.inc\n" >> $HOME/.bash_profile
  source $HOME/.bash_profile
  
  # Load the kops completion code for zsh[1] into the current shell
  source <(kops completion zsh)
```

### Options

```
      --shell string   target shell (bash).
```

### Options inherited from parent commands

```
      --alsologtostderr                  log to standard error as well as files
      --config string                    config file (default is $HOME/.kops.yaml)
      --log_backtrace_at traceLocation   when logging hits line file:N, emit a stack trace (default :0)
      --log_dir string                   If non-empty, write log files in this directory
      --logtostderr                      log to standard error instead of files (default false)
      --name string                      Name of cluster. Overrides KOPS_CLUSTER_NAME environment variable
      --state string                     Location of state storage. Overrides KOPS_STATE_STORE environment variable
      --stderrthreshold severity         logs at or above this threshold go to stderr (default 2)
  -v, --v Level                          log level for V logs
      --vmodule moduleSpec               comma-separated list of pattern=N settings for file-filtered logging
```

### SEE ALSO
* [kops](kops.md)	 - kops is Kubernetes ops.

