
<!--- This file is automatically generated by make gen-cli-docs; changes should be made in the go CLI command code (under cmd/kops) -->

## kops create

Create a resource by command line, filename or stdin.

### Synopsis


Create a resource:
  
  * cluster  
  * instancegroup  
  * secret  

Create a cluster, instancegroup or secret using command line parameters or YAML configuration specification files. (Note: secrets cannot be created from YAML config files yet).

```
kops create -f FILENAME
```

### Examples

```
  # Create a cluster from the configuration specification in a YAML file
  kops create -f my-cluster.yaml
  
  # Create secret from secret spec file
  kops create -f secret.yaml
  
  # Create a cluster in AWS
  kops create cluster --name=kubernetes-cluster.example.com \
  --state=s3://kops-state-1234 --zones=eu-west-1a \
  --node-count=2 --node-size=t2.micro --master-size=t2.micro \
  --dns-zone=example.com
  
  # Create an instancegroup for the k8s-cluster.example.com cluster.
  kops create ig --name=k8s-cluster.example.com node-example \
  --role node --subnet my-subnet-name
  
  # Create an new ssh public key called admin.
  kops create secret sshpublickey admin -i ~/.ssh/id_rsa.pub \
  --name k8s-cluster.example.com --state s3://example.com
```

### Options

```
  -f, --filename stringSlice   Filename to use to create the resource
```

### Options inherited from parent commands

```
      --alsologtostderr                  log to standard error as well as files
      --config string                    config file (default is $HOME/.kops.yaml)
      --log_backtrace_at traceLocation   when logging hits line file:N, emit a stack trace (default :0)
      --log_dir string                   If non-empty, write log files in this directory
      --logtostderr                      log to standard error instead of files (default false)
      --name string                      Name of cluster. Overrides KOPS_CLUSTER_NAME environment variable
      --state string                     Location of state storage. Overrides KOPS_STATE_STORE environment variable
      --stderrthreshold severity         logs at or above this threshold go to stderr (default 2)
  -v, --v Level                          log level for V logs
      --vmodule moduleSpec               comma-separated list of pattern=N settings for file-filtered logging
```

### SEE ALSO
* [kops](kops.md)	 - kops is Kubernetes ops.
* [kops create cluster](kops_create_cluster.md)	 - Create a Kubernetes cluster.
* [kops create instancegroup](kops_create_instancegroup.md)	 - Create an instancegroup.
* [kops create secret](kops_create_secret.md)	 - Create a secret.

