
# Significant changes

* flannel now has a `backend` property in the manifest, which can be either `udp` or `vxlan`.  `udp`
  is not recommended, but will be the default value for existing clusters or clusters created via manifests.
  `kops create cluster` with `--networking flannel` will use `vxlan`, `--networking flannel-vxlan`
  or `--networking flannel-udp` can be specified to explicitly choose a backend mode.

* IAM lockdown on new clusters: we define the existing policy as `legacy`, it defaults to true for existing clusters;
  new clusters will have `legacy: false` which will mean that only IAM policies needed by kops / k8s are guaranteed to be
  set.  If you are using IAM credentials for your application workload, please either set `legacy: true`, or use your own
  IAM roles (direct credentials or kube2iam)

* New AWS instance types: P3, C5, M5, H1.  Please note that NVME volumes are not supported on the default jessie
  image, so masters will not boot on M5 and C5 instance types unless a stretch image is chosen (change stretch to jessie in the image name).
  Also note that kubernetes will not support mounting persistent volumes on NVME instances until Kubernetes v1.9.

* While Aggregated API Servers are supported, there are known issues in kubernetes
  such as (#55022)[https://github.com/kubernetes/kubernetes/issues/55022].  Note that this includes metrics-server and kopeio
  authentication.  Please consider waiting for 1.8.5 / 1.9.0 before deploying into production.

* Includes fix for kube-dns CVE-2017-14491 (was also included in kops 1.7.1)

# Required Actions

* Existing Calico users on clusters that were created prior to kops 1.8.0
  need to be updated for the new "DefaultDeny" behavior for Kubernetes NetworkPolicies.
  See the *Changes to k8s-policy* section in the
  [Calico release notes](https://github.com/projectcalico/calico/releases/tag/v2.4.0)
  for help.
* Due to `ThirdPartyResources` becoming fully deprecated in Kubernetes v1.8 (replaced by `CustomResourceDefinitions`), existing Canal users upgrading their Clusters to Kubernetes v1.8 must follow the below TPR->CRD migration steps:
  1. Run: `kubectl apply -f https://raw.githubusercontent.com/projectcalico/calico/v2.6.2/upgrade/v2.5/manifests/upgrade-job.yaml`
  2. Retrieve the pod name from describing the job: `kubectl describe job/calico-upgrade-v2.5`
  3. Validate the last log line from the pod reports that it completed successfully: `kubectl logs calico-upgrade-v2.5-<random-id>`
  4. Update the `KubernetesVersion` within your ClusterSpec to v1.8 (or above), performing an update & rolling-update to all nodes (will involve downtime)
  5. Confirm cluster is back up and all canal pods are running successfully: `kops validate cluster` (this may take a few minutes for the cluster to fully validate)
  6. Delete the upgrade job as it is no longer required: `kubectl delete job calico-upgrade-v2.5` (you can also safely delete the `clusterrole`, `clusterrolebinding` and `serviceaccount` resources that were created by the above manifest file)

# Highlighted changes

* Support for etcd3 for new clusters, also allow etcd TLS to be enabled for new clusters.  etcd peer port is also locked down.

* Support for custom metrics.  Please exercise caution enabling before kubernetes 1.8.5 due to aggregation known issues.

* Add `kops create secret dockerconfig`

* `kops replace --create` will now replace-or-create, which is useful for CI / automated workflows

* `--watch-ingress` flag on dns-controller can now be configured through `cluster.spec.externalDns.watchIngress: true`

* kubelet security can be enabled with `cluster.spec.kubelet.anonymousAuth: true`.  Will likely be default in kops 1.9

* Improved logic around when a rolling-update is needed

* Better support and [documentation](../node_resource_handling.md) for node resources

* Enhanced cluster hooks support

* Support for clusters where network access must use an HTTP proxy

* We now automatically add a default NodeLabel with the InstanceGroup name

* Addons: added external-dns, kube-state-metrics addon.  Updates for autoscaler, dashboard, heapster, 

* Networking: initial support for kube-router & romana.  Updates for weave, kopeio-networking, flannel, canal, calico.

* Docker: Docker 1.13.1 will be used with kubernetes 1.8 (overrides for 17.03.2 and 17.09 possible).

* Debian 9 (stretch) now supported.  AMIs updated with 4.4.102 kernel.  A stretch based AMI is available, but jessie
remains the default.  We will likely change the default to stretch in kops 1.9 or kops 1.10.

* CoreOS: logrotate support & docker fixes

* Don't store unneeded secrets on the node

* ExperimentalCriticalPodAnnotation now enabled by default.  Updated critical pod annotations to avoid eviction of system pods

* Ensure iptables forwarding is enabled, avoiding breaking CNI plugins if Docker or the OS sets a different default.

*AWS*:

* New instance types: P3, C5, M5, H1.  Please note that NVME volumes are not supported on the default jessie
image, so masters will not boot on M5 and C5 instance types unless a stretch image is chosen (change stretch to jessie in the image name).
Also kubernetes will not support mounting persistent volumes on NVME instances until Kubernetes v1.9.
* Support for root provisioned IOPS.
* Properly tag public and private subnets for ELB creation in advanced network topologies
* Use SSL in ELB API server health check

*GCE*:

* Checks that networks are in auto mode, not legacy mode.  You can either switch your network (`gcloud compute networks switch-mode`)
or specify a different network (current using `--vpc` flag)
* Supports rolling updates and the containerized mounter.
* Sets bucket permissions, so your state bucket and compute can be in different projects.

*Early support for*:

* DigitalOcean
* OpenStack
* Templating with `kops toolbox template`
* cloud-controller-manager
* encryption-at-rest for the kube-apiserver
* Mirroring assets to a private S3 bucket, for airgapped installs
* Mirroring configuration so that kops-state store need not be cluster-accessible (for use with kops-server)
* Phases, to allow separation of networking, security & compute management
* Audit Policy
* CA keypair rotation
* Additional Subject Alternate Names
* building code using bazel


# All PRs


### to beta.1

* Fix typo in the apireference README [@jphuynh](https://github.com/jphuynh) [#3056](https://github.com/kubernetes/kops/pull/3056)
* Adding remainder of 1.7 relnotes [@justinsb](https://github.com/justinsb) [#3059](https://github.com/kubernetes/kops/pull/3059)
* raising logging levels and removing dead code [@chrislovecnm](https://github.com/chrislovecnm) [#3051](https://github.com/kubernetes/kops/pull/3051)
* Node Secrets [@gambol99](https://github.com/gambol99) [#3058](https://github.com/kubernetes/kops/pull/3058)
* Striking unnecessary conversion-gen instruction [@AlexB138](https://github.com/AlexB138) [#3084](https://github.com/kubernetes/kops/pull/3084)
* Fix small typo [@PaulCapestany](https://github.com/PaulCapestany) [#3100](https://github.com/kubernetes/kops/pull/3100)
* AWS: root volume provisioned IOPS support [@yoz2326](https://github.com/yoz2326) [#3102](https://github.com/kubernetes/kops/pull/3102)
* Update update_kops.md [@DevipriyaSarkar](https://github.com/DevipriyaSarkar) [#3108](https://github.com/kubernetes/kops/pull/3108)
* Fix Wildcard domains returned as ASCII in dns-controller [@mikesplain](https://github.com/mikesplain) [#3110](https://github.com/kubernetes/kops/pull/3110)
* remove source/destination check requirement for kube-router from docs [@murali-reddy](https://github.com/murali-reddy) [#3107](https://github.com/kubernetes/kops/pull/3107)
* docs/topology - Fix the rolling-update command [@msvbhat](https://github.com/msvbhat) [#3095](https://github.com/kubernetes/kops/pull/3095)
* Updated Heapster for kubernetes 1.7.0 [@Globegitter](https://github.com/Globegitter) [#3074](https://github.com/kubernetes/kops/pull/3074)
* Vetting / Formatting / Cleanup [@gambol99](https://github.com/gambol99) [#3078](https://github.com/kubernetes/kops/pull/3078)
* Sync image version [@bhack](https://github.com/bhack) [#3128](https://github.com/kubernetes/kops/pull/3128)
* Add `kops create secret dockerconfig` feature [@blakebarnett](https://github.com/blakebarnett) [#3087](https://github.com/kubernetes/kops/pull/3087)
* added wider toleration to calico-node daemonset (#2857) [@igorcanadi](https://github.com/igorcanadi) [#3097](https://github.com/kubernetes/kops/pull/3097)
* Update kube-proxy to handle aws returning multiple hostnames [@erickt](https://github.com/erickt) [#3067](https://github.com/kubernetes/kops/pull/3067)
* adding warning about --full [@chrislovecnm](https://github.com/chrislovecnm) [#2950](https://github.com/kubernetes/kops/pull/2950)
* Configure docker on CoreOS/ContainerOS [@johanneswuerbach](https://github.com/johanneswuerbach) [#3098](https://github.com/kubernetes/kops/pull/3098)
* added missing command in documentation [@gekart](https://github.com/gekart) [#3116](https://github.com/kubernetes/kops/pull/3116)
* Add k8s dashbard v1.6.2 [@Globegitter](https://github.com/Globegitter) [#3075](https://github.com/kubernetes/kops/pull/3075)
* Kube Proxy Feature Gates [@gambol99](https://github.com/gambol99) [#3130](https://github.com/kubernetes/kops/pull/3130)
* Update aws.md for SSH Key pair generation instructions [@sathiyas](https://github.com/sathiyas) [#3138](https://github.com/kubernetes/kops/pull/3138)
* MVP of templating  [@mad01](https://github.com/mad01) [#3040](https://github.com/kubernetes/kops/pull/3040)
* Rename OWNERS assignees: to approvers: [@spiffxp](https://github.com/spiffxp) [#3133](https://github.com/kubernetes/kops/pull/3133)
* CoreOS: Ensure docker configuration is loaded [@johanneswuerbach](https://github.com/johanneswuerbach) [#3134](https://github.com/kubernetes/kops/pull/3134)
* Fixing clusterautoscaler rbac [@BradErz](https://github.com/BradErz) [#3145](https://github.com/kubernetes/kops/pull/3145)
* Fix for Canal Taints and Tolerations [@prachetasp](https://github.com/prachetasp) [#3142](https://github.com/kubernetes/kops/pull/3142)
* Etcd TLS Options [@gambol99](https://github.com/gambol99) [#3114](https://github.com/kubernetes/kops/pull/3114)
* Kops Replace Command - create unprovisioned [@gambol99](https://github.com/gambol99) [#3089](https://github.com/kubernetes/kops/pull/3089)
* Add support for cluster using http forward proxy #2481 [@DerekV](https://github.com/DerekV) [#2777](https://github.com/kubernetes/kops/pull/2777)
* Fix Typo to improve GoReportCard [@asifdxtreme](https://github.com/asifdxtreme) [#3156](https://github.com/kubernetes/kops/pull/3156)
* Update alpha channel with update image & versions [@justinsb](https://github.com/justinsb) [#3103](https://github.com/kubernetes/kops/pull/3103)
* Fix dropped error in kops cmd package [@alrs](https://github.com/alrs) [#3175](https://github.com/kubernetes/kops/pull/3175)
* Use SSL in ELB API server health check [@johanneswuerbach](https://github.com/johanneswuerbach) [#3151](https://github.com/kubernetes/kops/pull/3151)
* Specify initial period in gossip-based cluster name pattern [@neocortical](https://github.com/neocortical) [#3173](https://github.com/kubernetes/kops/pull/3173)
* Clarify docs: rename spec/specification into desired configuration  [@kenden](https://github.com/kenden) [#2542](https://github.com/kubernetes/kops/pull/2542)
* Kubelet API Certificate [@gambol99](https://github.com/gambol99) [#3125](https://github.com/kubernetes/kops/pull/3125)
* better error messages with docker api [@chrislovecnm](https://github.com/chrislovecnm) [#3034](https://github.com/kubernetes/kops/pull/3034)
* Add cluster spec to node user data so component config changes are detected [@KashifSaadat](https://github.com/KashifSaadat) [#3120](https://github.com/kubernetes/kops/pull/3120)
* Tighten down S3 IAM policy statements [@KashifSaadat](https://github.com/KashifSaadat) [#3158](https://github.com/kubernetes/kops/pull/3158)
* Initial cloud interface for DigitalOcean [@andrewsykim](https://github.com/andrewsykim) [#3188](https://github.com/kubernetes/kops/pull/3188)
* Etcd v3 Support [@gambol99](https://github.com/gambol99) [#3176](https://github.com/kubernetes/kops/pull/3176)
* Fix Typo in Contributor Code of Conduct [@mbssaiakhil](https://github.com/mbssaiakhil) [#3192](https://github.com/kubernetes/kops/pull/3192)
* Cluster Hooks Enhancement [@gambol99](https://github.com/gambol99) [#3063](https://github.com/kubernetes/kops/pull/3063)
* Add documentation on handling node resources [@itskingori](https://github.com/itskingori) [#2992](https://github.com/kubernetes/kops/pull/2992)
* resolve #3169 [@orrchen](https://github.com/orrchen) [#3193](https://github.com/kubernetes/kops/pull/3193)
* Update Code of Conduct [@mbssaiakhil](https://github.com/mbssaiakhil) [#3204](https://github.com/kubernetes/kops/pull/3204)
* Bump version to 1.7.1-beta.1 [@justinsb](https://github.com/justinsb) [#3216](https://github.com/kubernetes/kops/pull/3216)
* Fix quote typo on dev-build [@mikesplain](https://github.com/mikesplain) [#3214](https://github.com/kubernetes/kops/pull/3214)
* fix typo in boot-sequence.md [@lichuqiang](https://github.com/lichuqiang) [#3212](https://github.com/kubernetes/kops/pull/3212)
* s/addding/adding/ in ssh logs [@krzyzacy](https://github.com/krzyzacy) [#3209](https://github.com/kubernetes/kops/pull/3209)
* Fix typo in link (lables.md -> labels.md) [@lsowen](https://github.com/lsowen) [#3213](https://github.com/kubernetes/kops/pull/3213)
* Fix docs to reference kubernetesApiAccess, not apiAccess [@justinsb](https://github.com/justinsb) [#3113](https://github.com/kubernetes/kops/pull/3113)
* fix typo in bastion.md [@lichuqiang](https://github.com/lichuqiang) [#3217](https://github.com/kubernetes/kops/pull/3217)
* Correctly set lifecycle on LB resources [@KashifSaadat](https://github.com/KashifSaadat) [#3226](https://github.com/kubernetes/kops/pull/3226)
* Rework legacy validation to use field error helpers [@justinsb](https://github.com/justinsb) [#3148](https://github.com/kubernetes/kops/pull/3148)
* fix kops_completion.md doc [@lichuqiang](https://github.com/lichuqiang) [#3228](https://github.com/kubernetes/kops/pull/3228)
* Changes on CoreOS related documentation. [@tigerlinux](https://github.com/tigerlinux) [#3205](https://github.com/kubernetes/kops/pull/3205)
* Update Canal to the latest [@tmjd](https://github.com/tmjd) [#3187](https://github.com/kubernetes/kops/pull/3187)
* Update to Calico 2.4.1 [@tmjd](https://github.com/tmjd) [#3162](https://github.com/kubernetes/kops/pull/3162)
* adding socat with rhel family [@chrislovecnm](https://github.com/chrislovecnm) [#3231](https://github.com/kubernetes/kops/pull/3231)
* fix typo in docs/node_resource_handling.md [@lichuqiang](https://github.com/lichuqiang) [#3233](https://github.com/kubernetes/kops/pull/3233)
* Add hooks to bootstrapscript output [@KashifSaadat](https://github.com/KashifSaadat) [#3195](https://github.com/kubernetes/kops/pull/3195)
* Don't force ig image change on cluster upgrade if it is custom. [@KashifSaadat](https://github.com/KashifSaadat) [#3232](https://github.com/kubernetes/kops/pull/3232)
* Add iptables to docker-xenial dependencies [@justinsb](https://github.com/justinsb) [#3092](https://github.com/kubernetes/kops/pull/3092)
* Add integration tests for shared subnet & VPC [@justinsb](https://github.com/justinsb) [#3041](https://github.com/kubernetes/kops/pull/3041)
* starting work on file assets builder [@chrislovecnm](https://github.com/chrislovecnm) [#3085](https://github.com/kubernetes/kops/pull/3085)
* Bump alpha channel: 1.7.4 and 1.6.7 [@justinsb](https://github.com/justinsb) [#3239](https://github.com/kubernetes/kops/pull/3239)
* Implement DigitalOcean Volume FI Task [@andrewsykim](https://github.com/andrewsykim) [#3244](https://github.com/kubernetes/kops/pull/3244)
* Set lifecycle on ElasticIP and NAT Gateway tasks to avoid spurious changes [@KashifSaadat](https://github.com/KashifSaadat) [#3242](https://github.com/kubernetes/kops/pull/3242)
* Delete old tags when cloudLabels / labels / taints are removed [@KashifSaadat](https://github.com/KashifSaadat) [#3207](https://github.com/kubernetes/kops/pull/3207)
* Improving etcd volume detection logic, ensuring that root volumes are not mounted [@chrislovecnm](https://github.com/chrislovecnm) [#3208](https://github.com/kubernetes/kops/pull/3208)
* Add proxy client support [@tsandall](https://github.com/tsandall) [#3165](https://github.com/kubernetes/kops/pull/3165)
* Fix minor typo [@Rajadeepan](https://github.com/Rajadeepan) [#3241](https://github.com/kubernetes/kops/pull/3241)
* Create cluster requirements for DigitalOcean [@andrewsykim](https://github.com/andrewsykim) [#3248](https://github.com/kubernetes/kops/pull/3248)
* inventory assets - mapping and uploading kubernetes containers [@chrislovecnm](https://github.com/chrislovecnm) [#3025](https://github.com/kubernetes/kops/pull/3025)
* Cluster / InstanceGroup File Assets [@gambol99](https://github.com/gambol99) [#3090](https://github.com/kubernetes/kops/pull/3090)
* Allow the strict IAM policies to be optional [@KashifSaadat](https://github.com/KashifSaadat) [#3210](https://github.com/kubernetes/kops/pull/3210)
* Promote alpha to stable channel [@justinsb](https://github.com/justinsb) [#3238](https://github.com/kubernetes/kops/pull/3238)
* Fix README.md fragment links [@poweld](https://github.com/poweld) [#3260](https://github.com/kubernetes/kops/pull/3260)
* Fix heading on 1.7 notes [@justinsb](https://github.com/justinsb) [#3237](https://github.com/kubernetes/kops/pull/3237)
* Add hints to CF integration test [@justinsb](https://github.com/justinsb) [#3139](https://github.com/kubernetes/kops/pull/3139)
* Add documentaion to kube-router section of docs/networking [@murali-reddy](https://github.com/murali-reddy) [#3262](https://github.com/kubernetes/kops/pull/3262)
* Update images in CI tests [@justinsb](https://github.com/justinsb) [#3264](https://github.com/kubernetes/kops/pull/3264)
* Validate AWS machine type on cluster ig update [@KashifSaadat](https://github.com/KashifSaadat) [#3257](https://github.com/kubernetes/kops/pull/3257)
* Docker Default Ulimits [@gambol99](https://github.com/gambol99) [#3259](https://github.com/kubernetes/kops/pull/3259)
* Read the channel from the local filesystem during tests [@justinsb](https://github.com/justinsb) [#3183](https://github.com/kubernetes/kops/pull/3183)
* Started release notes for 1.7.1 [@tmjd](https://github.com/tmjd) [#3261](https://github.com/kubernetes/kops/pull/3261)
* Inline Component Configuration Fix [@gambol99](https://github.com/gambol99) [#3267](https://github.com/kubernetes/kops/pull/3267)
* Adding support for adding ssh public key from file [@mad01](https://github.com/mad01) [#3245](https://github.com/kubernetes/kops/pull/3245)
* Fix Broken Link [@Rajadeepan](https://github.com/Rajadeepan) [#3266](https://github.com/kubernetes/kops/pull/3266)
* Explicit CreateCluster & UpdateCluster functions [@justinsb](https://github.com/justinsb) [#3240](https://github.com/kubernetes/kops/pull/3240)
* remove --cluster-cidr from kube-router's manifest. [@murali-reddy](https://github.com/murali-reddy) [#3263](https://github.com/kubernetes/kops/pull/3263)
* Replace deprecated aws session.New() with session.NewSession() [@alrs](https://github.com/alrs) [#3255](https://github.com/kubernetes/kops/pull/3255)
* Kops command fixes [@alrs](https://github.com/alrs) [#3277](https://github.com/kubernetes/kops/pull/3277)
* Update go-ini dep to v1.28.2 [@justinsb](https://github.com/justinsb) [#3283](https://github.com/kubernetes/kops/pull/3283)
* Add go1.9 target to travis [@justinsb](https://github.com/justinsb) [#3279](https://github.com/kubernetes/kops/pull/3279)
* Refactor apiserver templates [@georgebuckerfield](https://github.com/georgebuckerfield) [#3284](https://github.com/kubernetes/kops/pull/3284)
* Kops Secrets on Nodes [@gambol99](https://github.com/gambol99) [#3270](https://github.com/kubernetes/kops/pull/3270)
* Add Initializers admission controller [@justinsb](https://github.com/justinsb) [#3289](https://github.com/kubernetes/kops/pull/3289)
* Limit the IAM EC2 policy for the master nodes [@KashifSaadat](https://github.com/KashifSaadat) [#3186](https://github.com/kubernetes/kops/pull/3186)
* Allow user defined endpoint to host action for Canal [@KashifSaadat](https://github.com/KashifSaadat) [#3272](https://github.com/kubernetes/kops/pull/3272)
* Fix space in rolling-update cluster help [@justinsb](https://github.com/justinsb) [#3285](https://github.com/kubernetes/kops/pull/3285)
* AWS: Always use verbose errors [@justinsb](https://github.com/justinsb) [#3281](https://github.com/kubernetes/kops/pull/3281)
* Fixes reading /root/.docker/config.json on debian [@blakebarnett](https://github.com/blakebarnett) [#3198](https://github.com/kubernetes/kops/pull/3198)
* Implementing GCE as an interface - modelling aws cloud provider [@chrislovecnm](https://github.com/chrislovecnm) [#3292](https://github.com/kubernetes/kops/pull/3292)
* Add missed error handling on session.NewSession [@justinsb](https://github.com/justinsb) [#3280](https://github.com/kubernetes/kops/pull/3280)
* Refactor PKI classes into their own package [@justinsb](https://github.com/justinsb) [#3288](https://github.com/kubernetes/kops/pull/3288)
* baremetal: relax validation on subnets & networking [@justinsb](https://github.com/justinsb) [#3301](https://github.com/kubernetes/kops/pull/3301)
* Update aws.md pointing links to the k8s slack directly [@krishna-mk](https://github.com/krishna-mk) [#3306](https://github.com/kubernetes/kops/pull/3306)
* Kubelet Readonly Port [@gambol99](https://github.com/gambol99) [#3303](https://github.com/kubernetes/kops/pull/3303)
* Additional Kubelet Options [@gambol99](https://github.com/gambol99) [#3302](https://github.com/kubernetes/kops/pull/3302)
* Misc go vet fixes [@justinsb](https://github.com/justinsb) [#3307](https://github.com/kubernetes/kops/pull/3307)
* Adds DNSControllerSpec and WatchIngress flag [@geojaz](https://github.com/geojaz) [#2504](https://github.com/kubernetes/kops/pull/2504)
* Fixes #3317 allowing to spawn flannel on all nodes in the cluster [@BradErz](https://github.com/BradErz) [#3318](https://github.com/kubernetes/kops/pull/3318)
* Fix broken link in aws.md [@BlueMonday](https://github.com/BlueMonday) [#3324](https://github.com/kubernetes/kops/pull/3324)
* refactor resource tracker to be usable across packages [@andrewsykim](https://github.com/andrewsykim) [#3331](https://github.com/kubernetes/kops/pull/3331)
* Fix RenderGCE issue on Address [@justinsb](https://github.com/justinsb) [#3338](https://github.com/kubernetes/kops/pull/3338)
* Extract UserData from CloudFormation output during testing [@justinsb](https://github.com/justinsb) [#3299](https://github.com/kubernetes/kops/pull/3299)
* Create Keyset API type [@justinsb](https://github.com/justinsb) [#3286](https://github.com/kubernetes/kops/pull/3286)
* Check actual EbsOptimized status during cluster update [@Pharb](https://github.com/Pharb) [#3314](https://github.com/kubernetes/kops/pull/3314)
* Makefile clean [@alrs](https://github.com/alrs) [#3332](https://github.com/kubernetes/kops/pull/3332)
* nodePortAccess, experimental spec override flag [@justinsb](https://github.com/justinsb) [#3336](https://github.com/kubernetes/kops/pull/3336)
* Toolbox template [@gambol99](https://github.com/gambol99) [#3287](https://github.com/kubernetes/kops/pull/3287)
* docs: fix broken vSphere doc link [@PI-Victor](https://github.com/PI-Victor) [#3361](https://github.com/kubernetes/kops/pull/3361)
* Prevent Docker build environments from creating root-owned artifacts [@alrs](https://github.com/alrs) [#3354](https://github.com/kubernetes/kops/pull/3354)
* Add CreateSecurityGroup permission [@justinsb](https://github.com/justinsb) [#3362](https://github.com/kubernetes/kops/pull/3362)
* Flannel: change default backend type [@justinsb](https://github.com/justinsb) [#3190](https://github.com/kubernetes/kops/pull/3190)
* Warn if SSH fingerprint is obviously bad [@justinsb](https://github.com/justinsb) [#3300](https://github.com/kubernetes/kops/pull/3300)
* Other regions require LocationConstraint [@reenl](https://github.com/reenl) [#3337](https://github.com/kubernetes/kops/pull/3337)
* Skeleton bare-metal provider [@justinsb](https://github.com/justinsb) [#3291](https://github.com/kubernetes/kops/pull/3291)
* switch monitoring-standalone to v1.7.0 [@fvasco](https://github.com/fvasco) [#3372](https://github.com/kubernetes/kops/pull/3372)
* Added ability to set --service-node-port-range [@robinpercy](https://github.com/robinpercy) [#3333](https://github.com/kubernetes/kops/pull/3333)
* small docs improvement [@RichardBronosky](https://github.com/RichardBronosky) [#3377](https://github.com/kubernetes/kops/pull/3377)
* add autoscaling:DescribeLaunchConfigurations permission [@rushtehrani](https://github.com/rushtehrani) [#3346](https://github.com/kubernetes/kops/pull/3346)
* Add a doc to describe how to use kops in AWS China [@qqshfox](https://github.com/qqshfox) [#3360](https://github.com/kubernetes/kops/pull/3360)
* Allow cluster autoscaler addon to read statefulsets [@johanhubens](https://github.com/johanhubens) [#3364](https://github.com/kubernetes/kops/pull/3364)
* Support for deleting tokens & keypairs [@justinsb](https://github.com/justinsb) [#3359](https://github.com/kubernetes/kops/pull/3359)
* Makefile improvements [@alrs](https://github.com/alrs) [#3369](https://github.com/kubernetes/kops/pull/3369)
* Add romana to built-in CNI options [@cgilmour](https://github.com/cgilmour) [#3290](https://github.com/kubernetes/kops/pull/3290)
* Correct typo in Hooks Spec examples [@KashifSaadat](https://github.com/KashifSaadat) [#3381](https://github.com/kubernetes/kops/pull/3381)
* Honor ServiceNodePortRange when opening NodePort access [@justinsb](https://github.com/justinsb) [#3379](https://github.com/kubernetes/kops/pull/3379)
* More Makefile improvements [@alrs](https://github.com/alrs) [#3380](https://github.com/kubernetes/kops/pull/3380)
* Revision to IAM Policies created by Kops [@chrislovecnm](https://github.com/chrislovecnm) [#3343](https://github.com/kubernetes/kops/pull/3343)
* Add file assets to node user data scripts, fingerprint fileAssets and hooks content. [@KashifSaadat](https://github.com/KashifSaadat) [#3323](https://github.com/kubernetes/kops/pull/3323)
* Makefile remove redundant logic [@alrs](https://github.com/alrs) [#3390](https://github.com/kubernetes/kops/pull/3390)
* Makefile: build kops in dev-mode by default [@justinsb](https://github.com/justinsb) [#3402](https://github.com/kubernetes/kops/pull/3402)
* GCS: Don't reuse same error message [@justinsb](https://github.com/justinsb) [#3396](https://github.com/kubernetes/kops/pull/3396)
* Create minimal mock GCECloud, first test [@justinsb](https://github.com/justinsb) [#3391](https://github.com/kubernetes/kops/pull/3391)
* GCE: Fix logic around change detection [@justinsb](https://github.com/justinsb) [#3401](https://github.com/kubernetes/kops/pull/3401)
* baremetal: more wiring up [@justinsb](https://github.com/justinsb) [#3407](https://github.com/kubernetes/kops/pull/3407)
* cluster-autoscaler should use dnsPolicy Default [@andrewsykim](https://github.com/andrewsykim) [#3395](https://github.com/kubernetes/kops/pull/3395)
* Update provisioned iops doc example [@afalko](https://github.com/afalko) [#3417](https://github.com/kubernetes/kops/pull/3417)
* GCE: Prevent instancetemplate spurious mismatches [@justinsb](https://github.com/justinsb) [#3404](https://github.com/kubernetes/kops/pull/3404)
* Makefile: use hack/.packages instead of go list [@justinsb](https://github.com/justinsb) [#3400](https://github.com/kubernetes/kops/pull/3400)
* Allow specifying a SSH key name for AWS [@johnzeringue](https://github.com/johnzeringue) [#3215](https://github.com/kubernetes/kops/pull/3215)
* Allow cluster-autoscaler to list/watch StatefulSets [@carlossg](https://github.com/carlossg) [#3202](https://github.com/kubernetes/kops/pull/3202)
* SecretStore and CAStore implementations backed by API [@justinsb](https://github.com/justinsb) [#3409](https://github.com/kubernetes/kops/pull/3409)
* GCE: move file assets to writeable location [@justinsb](https://github.com/justinsb) [#3399](https://github.com/kubernetes/kops/pull/3399)
* GCE: Don't open NodePort range to all by default [@justinsb](https://github.com/justinsb) [#3403](https://github.com/kubernetes/kops/pull/3403)
* Support additional config options for Canal Networking [@KashifSaadat](https://github.com/KashifSaadat) [#3421](https://github.com/kubernetes/kops/pull/3421)
* Changed the s3 bucket creation command. [@timothyjosefik](https://github.com/timothyjosefik) [#3422](https://github.com/kubernetes/kops/pull/3422)
* Remove unused GCE/AWS options [@justinsb](https://github.com/justinsb) [#3405](https://github.com/kubernetes/kops/pull/3405)
* Makefile kops-install default [@alrs](https://github.com/alrs) [#3426](https://github.com/kubernetes/kops/pull/3426)
* Dump invalid HCL if we hit it [@justinsb](https://github.com/justinsb) [#3393](https://github.com/kubernetes/kops/pull/3393)
* DNS Controller Limitation [@gambol99](https://github.com/gambol99) [#3330](https://github.com/kubernetes/kops/pull/3330)
* Add apimachinery changes to enable cloud controller manager [@wlan0](https://github.com/wlan0) [#3408](https://github.com/kubernetes/kops/pull/3408)
* Support for using hostPort when using calico [@felipejfc](https://github.com/felipejfc) [#3206](https://github.com/kubernetes/kops/pull/3206)
* improve documentation for secrets [@smelchior](https://github.com/smelchior) [#2925](https://github.com/kubernetes/kops/pull/2925)
* GCE: Don't remove (shared) DNS Zone [@justinsb](https://github.com/justinsb) [#3398](https://github.com/kubernetes/kops/pull/3398)
* Support encryption-at-rest for the kube-apiserver [@georgebuckerfield](https://github.com/georgebuckerfield) [#3368](https://github.com/kubernetes/kops/pull/3368)
* Add function to get etcd status [@justinsb](https://github.com/justinsb) [#3147](https://github.com/kubernetes/kops/pull/3147)
* Makefile: use go install [@justinsb](https://github.com/justinsb) [#3430](https://github.com/kubernetes/kops/pull/3430)
* Makefile: add missing deps to gobindata [@justinsb](https://github.com/justinsb) [#3431](https://github.com/kubernetes/kops/pull/3431)
* Fix a few typos and clean up hooks section [@orangejulius](https://github.com/orangejulius) [#3429](https://github.com/kubernetes/kops/pull/3429)
* Makefile: was not exiting on test failures [@justinsb](https://github.com/justinsb) [#3434](https://github.com/kubernetes/kops/pull/3434)
* Create GCE networks in auto mode, not legacy mode [@justinsb](https://github.com/justinsb) [#3435](https://github.com/kubernetes/kops/pull/3435)
* baremetal: fill out more of the baremetal mappings [@justinsb](https://github.com/justinsb) [#3406](https://github.com/kubernetes/kops/pull/3406)
* AWS mock provider should use the AWS cloudprovider id [@justinsb](https://github.com/justinsb) [#3436](https://github.com/kubernetes/kops/pull/3436)
* getting rid of uneeded logging in ux [@chrislovecnm](https://github.com/chrislovecnm) [#3437](https://github.com/kubernetes/kops/pull/3437)
* promoting drain and validate by setting feature flag to true [@chrislovecnm](https://github.com/chrislovecnm) [#3329](https://github.com/kubernetes/kops/pull/3329)
* bump channels dashboard to 1.6.3 [@so0k](https://github.com/so0k) [#3444](https://github.com/kubernetes/kops/pull/3444)
* GCE: Avoid nil dereference on new GCE networks [@justinsb](https://github.com/justinsb) [#3447](https://github.com/kubernetes/kops/pull/3447)
* Enable ExperimentalCriticalPodAnnotation feature gate [@andreychernih](https://github.com/andreychernih) [#3345](https://github.com/kubernetes/kops/pull/3345)
* Fix version comparison: mask out pre & build fields [@justinsb](https://github.com/justinsb) [#3449](https://github.com/kubernetes/kops/pull/3449)
* Add external-dns as addon. [@haad](https://github.com/haad) [#3383](https://github.com/kubernetes/kops/pull/3383)
* ETCD container mount /etc/hosts file [@catherinetcai](https://github.com/catherinetcai) [#3423](https://github.com/kubernetes/kops/pull/3423)
* Fix integration test [@justinsb](https://github.com/justinsb) [#3451](https://github.com/kubernetes/kops/pull/3451)
* Add permissions for cluster autoscaler addon to scale down [@johanhubens](https://github.com/johanhubens) [#3419](https://github.com/kubernetes/kops/pull/3419)
* Manifest files [@gambol99](https://github.com/gambol99) [#3229](https://github.com/kubernetes/kops/pull/3229)
* Doc updates to clarify and fix typos in rolling-update cmd. [@jlaswell](https://github.com/jlaswell) [#3458](https://github.com/kubernetes/kops/pull/3458)
* GCE: Ignore Lifecycle in forwarding rule [@justinsb](https://github.com/justinsb) [#3456](https://github.com/kubernetes/kops/pull/3456)
* baremetal: error if NetworkCIDR set [@justinsb](https://github.com/justinsb) [#3495](https://github.com/kubernetes/kops/pull/3495)
* Set critical pod annotations [@julianvmodesto](https://github.com/julianvmodesto) [#3481](https://github.com/kubernetes/kops/pull/3481)
* Refactoring to use cloud method for getting cloud groups [@chrislovecnm](https://github.com/chrislovecnm) [#3446](https://github.com/kubernetes/kops/pull/3446)
* Support GCE MIGs of size 0 [@justinsb](https://github.com/justinsb) [#3480](https://github.com/kubernetes/kops/pull/3480)
* using same disk sizes for gce [@chrislovecnm](https://github.com/chrislovecnm) [#3478](https://github.com/kubernetes/kops/pull/3478)
* Debian 9 (stretch) support [@justinsb](https://github.com/justinsb) [#3491](https://github.com/kubernetes/kops/pull/3491)
* Minor cleanups to #3446 [@justinsb](https://github.com/justinsb) [#3493](https://github.com/kubernetes/kops/pull/3493)
* Add docs that debian 9 images should work [@justinsb](https://github.com/justinsb) [#3497](https://github.com/kubernetes/kops/pull/3497)
* Add Zones field to InstanceGroup [@justinsb](https://github.com/justinsb) [#3439](https://github.com/kubernetes/kops/pull/3439)
* GCE: fix makefile push-gce-run [@justinsb](https://github.com/justinsb) [#3484](https://github.com/kubernetes/kops/pull/3484)
* Reduce log severity of not-unexpected nodeup log message [@justinsb](https://github.com/justinsb) [#3485](https://github.com/kubernetes/kops/pull/3485)
* Clean up comment on MaxTaskDuration [@justinsb](https://github.com/justinsb) [#3487](https://github.com/kubernetes/kops/pull/3487)
* golint: rename two receievers for awsCloudImplementation [@justinsb](https://github.com/justinsb) [#3492](https://github.com/kubernetes/kops/pull/3492)
* makefile: add 3 PHONY targets [@justinsb](https://github.com/justinsb) [#3483](https://github.com/kubernetes/kops/pull/3483)
* Use IsKubernetesGTE helper instead of reparsing semver [@justinsb](https://github.com/justinsb) [#3486](https://github.com/kubernetes/kops/pull/3486)
* Add critical pod annotations to our system pods [@justinsb](https://github.com/justinsb) [#3494](https://github.com/kubernetes/kops/pull/3494)
* Mirror keystore & secretstore [@justinsb](https://github.com/justinsb) [#3411](https://github.com/kubernetes/kops/pull/3411)
* Makefile basic debugging in Travis [@alrs](https://github.com/alrs) [#3506](https://github.com/kubernetes/kops/pull/3506)
* Update dependencies to match kubernetes 1.8 [@justinsb](https://github.com/justinsb) [#3508](https://github.com/kubernetes/kops/pull/3508)
* Update kube-dns to 1.14.5 for CVE-2017-14491 [@mikesplain](https://github.com/mikesplain) [#3511](https://github.com/kubernetes/kops/pull/3511)
* Fix silly typo [@mikesplain](https://github.com/mikesplain) [#3513](https://github.com/kubernetes/kops/pull/3513)
* docs: clean up installation instructions [@justinsb](https://github.com/justinsb) [#3517](https://github.com/kubernetes/kops/pull/3517)
* Tweak signature in #3478 [@justinsb](https://github.com/justinsb) [#3496](https://github.com/kubernetes/kops/pull/3496)
* rolling-update - initial GCE support [@justinsb](https://github.com/justinsb) [#3507](https://github.com/kubernetes/kops/pull/3507)
* Support wget for download, not just curl [@justinsb](https://github.com/justinsb) [#3490](https://github.com/kubernetes/kops/pull/3490)
* Initial bazel support [@justinsb](https://github.com/justinsb) [#3510](https://github.com/kubernetes/kops/pull/3510)
* bazel: tweaks to get build & test working [@justinsb](https://github.com/justinsb) [#3523](https://github.com/kubernetes/kops/pull/3523)
* bumping k8s versions in test files [@chrislovecnm](https://github.com/chrislovecnm) [#3477](https://github.com/kubernetes/kops/pull/3477)
* Map docker 1.13.1 & 17.03.1, default 1.8 to 1.13.1 [@justinsb](https://github.com/justinsb) [#3462](https://github.com/kubernetes/kops/pull/3462)
* bazel: fix overlapping file paths in update cluster test [@justinsb](https://github.com/justinsb) [#3525](https://github.com/kubernetes/kops/pull/3525)
* GCE: strip prefixes from Zone & MIG Name [@justinsb](https://github.com/justinsb) [#3531](https://github.com/kubernetes/kops/pull/3531)
* GCE: use recreateInstance when rolling a MIG [@justinsb](https://github.com/justinsb) [#3533](https://github.com/kubernetes/kops/pull/3533)
* Update Google COS image [@justinsb](https://github.com/justinsb) [#3460](https://github.com/kubernetes/kops/pull/3460)
* Added documentation on best practices for creating clusters with HA m… [@jatan28](https://github.com/jatan28) [#3540](https://github.com/kubernetes/kops/pull/3540)
* Minor spelling fix [@thomaschaaf](https://github.com/thomaschaaf) [#3542](https://github.com/kubernetes/kops/pull/3542)
* nodeup: warn if no docker version matched [@justinsb](https://github.com/justinsb) [#3532](https://github.com/kubernetes/kops/pull/3532)
* Fix CVE for kube-dns pre k8s 1.6 [@mikesplain](https://github.com/mikesplain) [#3538](https://github.com/kubernetes/kops/pull/3538)
* First tutorial page: getting started with GCE [@justinsb](https://github.com/justinsb) [#3528](https://github.com/kubernetes/kops/pull/3528)
* setting variable in func instead inside of func call [@chrislovecnm](https://github.com/chrislovecnm) [#3548](https://github.com/kubernetes/kops/pull/3548)
* updating paths in Makefile for docker oddness [@chrislovecnm](https://github.com/chrislovecnm) [#3556](https://github.com/kubernetes/kops/pull/3556)
* Newer versions of docker do not follow Semantic Versioning [@brdude](https://github.com/brdude) [#3559](https://github.com/kubernetes/kops/pull/3559)
* updating kops version so that we do not get warnings, fixing cf tests [@chrislovecnm](https://github.com/chrislovecnm) [#3547](https://github.com/kubernetes/kops/pull/3547)
* Fixing stdout on tests - cleaning house [@chrislovecnm](https://github.com/chrislovecnm) [#3474](https://github.com/kubernetes/kops/pull/3474)
* Add unit test for model helper functions [@justinsb](https://github.com/justinsb) [#3448](https://github.com/kubernetes/kops/pull/3448)
* GCE: Fix subnets vs zones formatting of instance groups [@justinsb](https://github.com/justinsb) [#3524](https://github.com/kubernetes/kops/pull/3524)
* GCE: install containerized mounter on COS [@justinsb](https://github.com/justinsb) [#3482](https://github.com/kubernetes/kops/pull/3482)
* GCS paths; retry on error [@justinsb](https://github.com/justinsb) [#3461](https://github.com/kubernetes/kops/pull/3461)
* CVE-2017-14491 Documentation Hot Fixes and kops fixes [@chrislovecnm](https://github.com/chrislovecnm) [#3563](https://github.com/kubernetes/kops/pull/3563)
* Enable logrotate for Kubernetes configs on CoreOS [@julianvmodesto](https://github.com/julianvmodesto) [#3488](https://github.com/kubernetes/kops/pull/3488)
* Etcd V3 & TLS Support [@gambol99](https://github.com/gambol99) [#3514](https://github.com/kubernetes/kops/pull/3514)
* Use system:kube-router User for clusterrole binding [@murali-reddy](https://github.com/murali-reddy) [#3522](https://github.com/kubernetes/kops/pull/3522)
* thinning out issue template [@chrislovecnm](https://github.com/chrislovecnm) [#3479](https://github.com/kubernetes/kops/pull/3479)
* Makefile: fix order of directory creation [@justinsb](https://github.com/justinsb) [#3569](https://github.com/kubernetes/kops/pull/3569)
* Add missing hack/make-gendocs.sh script [@justinsb](https://github.com/justinsb) [#3567](https://github.com/kubernetes/kops/pull/3567)
* Move old 1.7.1 release notes to 1.8.0 to expedite hotfix release [@mikesplain](https://github.com/mikesplain) [#3572](https://github.com/kubernetes/kops/pull/3572)
* 1.7.1 Release notes for master [@mikesplain](https://github.com/mikesplain) [#3573](https://github.com/kubernetes/kops/pull/3573)
* Added PolicyConfigMap and PolicyConfigMapNamespace to KubeSchedulerConfig [@whs](https://github.com/whs) [#3546](https://github.com/kubernetes/kops/pull/3546)
* Document Enabling custom metrics API using kops [@RahulMahale](https://github.com/RahulMahale) [#3570](https://github.com/kubernetes/kops/pull/3570)
* Replace logrotate crontab with systemd timer [@julianvmodesto](https://github.com/julianvmodesto) [#3568](https://github.com/kubernetes/kops/pull/3568)
* Update gce storage url [@enxebre](https://github.com/enxebre) [#3582](https://github.com/kubernetes/kops/pull/3582)
* mounting kubectl from the host instead to installing in protokube [@chrislovecnm](https://github.com/chrislovecnm) [#3550](https://github.com/kubernetes/kops/pull/3550)
* update kubernetes-dashboard image version to v1.7.0 [@zouyee](https://github.com/zouyee) [#3459](https://github.com/kubernetes/kops/pull/3459)
* Docs tweak - specify flag, not kube-up env var [@justinsb](https://github.com/justinsb) [#3583](https://github.com/kubernetes/kops/pull/3583)
* Release docs update git push command [@justinsb](https://github.com/justinsb) [#3584](https://github.com/kubernetes/kops/pull/3584)
* Create logrotate service where not installed by default [@justinsb](https://github.com/justinsb) [#3590](https://github.com/kubernetes/kops/pull/3590)
* Mock kops version in tests [@justinsb](https://github.com/justinsb) [#3594](https://github.com/kubernetes/kops/pull/3594)
* Update homebrew release docs. [@mikesplain](https://github.com/mikesplain) [#3596](https://github.com/kubernetes/kops/pull/3596)
* Fix old custom build instructions [@justinsb](https://github.com/justinsb) [#3585](https://github.com/kubernetes/kops/pull/3585)
* bazel versions of test, build, push-aws-run & push-gce-run [@justinsb](https://github.com/justinsb) [#3591](https://github.com/kubernetes/kops/pull/3591)
* Fix .PHONY [@mikesplain](https://github.com/mikesplain) [#3598](https://github.com/kubernetes/kops/pull/3598)
* GCE: Limit length of InstanceTemplate names [@justinsb](https://github.com/justinsb) [#3593](https://github.com/kubernetes/kops/pull/3593)
* Sort terraform literals in ELB task [@justinsb](https://github.com/justinsb) [#3588](https://github.com/kubernetes/kops/pull/3588)
* Promote alpha channel to stable, update alpha channel with latest [@justinsb](https://github.com/justinsb) [#3586](https://github.com/kubernetes/kops/pull/3586)
* updating cve advisory for kops-1.7.1 release [@chrislovecnm](https://github.com/chrislovecnm) [#3580](https://github.com/kubernetes/kops/pull/3580)
* `kops get ...` should exit with non-zero if the resource don't exist [@erickt](https://github.com/erickt) [#3610](https://github.com/kubernetes/kops/pull/3610)
* Update Weave Net to version 2.0.5 [@bboreham](https://github.com/bboreham) [#3614](https://github.com/kubernetes/kops/pull/3614)
* Add permissions to cluster autoscaler to get statefulsets [@carlossg](https://github.com/carlossg) [#3624](https://github.com/kubernetes/kops/pull/3624)
* Modified OS detection logic when updating http proxy settings. [@KashifSaadat](https://github.com/KashifSaadat) [#3587](https://github.com/kubernetes/kops/pull/3587)
* Reduce log level in protokube [@justinsb](https://github.com/justinsb) [#3622](https://github.com/kubernetes/kops/pull/3622)
* updating bazel test to output failed tests [@chrislovecnm](https://github.com/chrislovecnm) [#3627](https://github.com/kubernetes/kops/pull/3627)
* Simplify protokube mounter using nsenter executor [@justinsb](https://github.com/justinsb) [#3621](https://github.com/kubernetes/kops/pull/3621)
* Docker dependencies for docker 1.12.6 on RHEL [@justinsb](https://github.com/justinsb) [#3628](https://github.com/kubernetes/kops/pull/3628)
* GCE: Install correct storage class [@justinsb](https://github.com/justinsb) [#3629](https://github.com/kubernetes/kops/pull/3629)
* adding missing lifecycle to route table task [@chrislovecnm](https://github.com/chrislovecnm) [#3616](https://github.com/kubernetes/kops/pull/3616)
* Phase integration tests [@chrislovecnm](https://github.com/chrislovecnm) [#3619](https://github.com/kubernetes/kops/pull/3619)
* kopeio-vxlan: mark critical, remove cpu limit [@justinsb](https://github.com/justinsb) [#3632](https://github.com/kubernetes/kops/pull/3632)
* Weave Net: add critical-pod annotation and toleration for rescheduler [@bboreham](https://github.com/bboreham) [#3638](https://github.com/kubernetes/kops/pull/3638)
* Add missing "-nanny" in image name. [@willaustin](https://github.com/willaustin) [#3640](https://github.com/kubernetes/kops/pull/3640)
* Add Calico v2.5 support for Kubernetes v1.8+ [@KashifSaadat](https://github.com/KashifSaadat) [#3623](https://github.com/kubernetes/kops/pull/3623)
* link to cve Advisory release doc fixed [@alifa20](https://github.com/alifa20) [#3648](https://github.com/kubernetes/kops/pull/3648)
* fixing bazel missed BUILD stuff [@chrislovecnm](https://github.com/chrislovecnm) [#3641](https://github.com/kubernetes/kops/pull/3641)
* Avoid spurious mirror tasks in plan [@justinsb](https://github.com/justinsb) [#3656](https://github.com/kubernetes/kops/pull/3656)
* Fix misssing bazel dependency [@justinsb](https://github.com/justinsb) [#3657](https://github.com/kubernetes/kops/pull/3657)
* Add kops toolbox template docs [@kenden](https://github.com/kenden) [#3655](https://github.com/kubernetes/kops/pull/3655)
* simplified AWS tutorial instruction to export AWS env variables [@choang](https://github.com/choang) [#3662](https://github.com/kubernetes/kops/pull/3662)
* fixing bazel testing for upup [@chrislovecnm](https://github.com/chrislovecnm) [#3660](https://github.com/kubernetes/kops/pull/3660)
* Add HorizontalPodAutoscalerSyncPeriod for kubeControllerManager [@mikesplain](https://github.com/mikesplain) [#3673](https://github.com/kubernetes/kops/pull/3673)
* Added example output from a 1.4.12 cluster [@r4j4h](https://github.com/r4j4h) [#3674](https://github.com/kubernetes/kops/pull/3674)
* Add Cloud Controller Manager addon [@wlan0](https://github.com/wlan0) [#3630](https://github.com/kubernetes/kops/pull/3630)
* Add etcd settings to nodeup and protokube [@mschurenko](https://github.com/mschurenko) [#3675](https://github.com/kubernetes/kops/pull/3675)
* Add myself as a reviewer [@andrewsykim](https://github.com/andrewsykim) [#3667](https://github.com/kubernetes/kops/pull/3667)
* update kubernetes-dashboard image version to v1.7.1 [@tallaxes](https://github.com/tallaxes) [#3652](https://github.com/kubernetes/kops/pull/3652)
* Bump channels version of dashboard to 1.7.1 [@so0k](https://github.com/so0k) [#3681](https://github.com/kubernetes/kops/pull/3681)
* [AWS] Properly tag public and private subnets for ELB creation [@geojaz](https://github.com/geojaz) [#3682](https://github.com/kubernetes/kops/pull/3682)
* Kops Toolbox Template Missing Variables [@gambol99](https://github.com/gambol99) [#3680](https://github.com/kubernetes/kops/pull/3680)
* Delete firewall rules on GCE [@justinsb](https://github.com/justinsb) [#3684](https://github.com/kubernetes/kops/pull/3684)
* Fix typo in SessionAffinity terraform field [@justinsb](https://github.com/justinsb) [#3685](https://github.com/kubernetes/kops/pull/3685)
* Grant kubelets system:node role in 1.8 [@justinsb](https://github.com/justinsb) [#3683](https://github.com/kubernetes/kops/pull/3683)
* bazel: Add missing dep on k8s.io/kubernetes/pkg/cloudprovider/providers/aws [@justinsb](https://github.com/justinsb) [#3687](https://github.com/kubernetes/kops/pull/3687)
* Rename flag from network-plugin-dir -> cni-bin-dir [@justinsb](https://github.com/justinsb) [#3688](https://github.com/kubernetes/kops/pull/3688)
* Bump kopeio networking to 20171015 [@justinsb](https://github.com/justinsb) [#3637](https://github.com/kubernetes/kops/pull/3637)
* Add IAM Permissions so nodes can access AWS ECR [@KashifSaadat](https://github.com/KashifSaadat) [#3690](https://github.com/kubernetes/kops/pull/3690)
* Add a v1.7.0 storage addon resource. [@mikesplain](https://github.com/mikesplain) [#3677](https://github.com/kubernetes/kops/pull/3677)
* Initial aggregation work [@justinsb](https://github.com/justinsb) [#3679](https://github.com/kubernetes/kops/pull/3679)
* kops-server: ig short-name [@justinsb](https://github.com/justinsb) [#3686](https://github.com/kubernetes/kops/pull/3686)
* bazel updates to generate go-bindata [@chrislovecnm](https://github.com/chrislovecnm) [#3689](https://github.com/kubernetes/kops/pull/3689)
* Renaming IAM Phase to Security [@chrislovecnm](https://github.com/chrislovecnm) [#3639](https://github.com/kubernetes/kops/pull/3639)
* Fixing phases for security groups and elbs [@chrislovecnm](https://github.com/chrislovecnm) [#3704](https://github.com/kubernetes/kops/pull/3704)
* etcd using asset builder [@chrislovecnm](https://github.com/chrislovecnm) [#3661](https://github.com/kubernetes/kops/pull/3661)
* adding kubernetes core rate limiter handlers [@chrislovecnm](https://github.com/chrislovecnm) [#3472](https://github.com/kubernetes/kops/pull/3472)
* UsePolicyConfigMap for kube-scheduler [@whs](https://github.com/whs) [#3581](https://github.com/kubernetes/kops/pull/3581)
* Allow disabling kube-proxy [@brdude](https://github.com/brdude) [#3699](https://github.com/kubernetes/kops/pull/3699)
* Implement DigitalOcean Droplet FI Task [@andrewsykim](https://github.com/andrewsykim) [#3707](https://github.com/kubernetes/kops/pull/3707)
* update to imports that apimachinery is doing now automatically [@chrislovecnm](https://github.com/chrislovecnm) [#3710](https://github.com/kubernetes/kops/pull/3710)
* Updates from running gazelle [@justinsb](https://github.com/justinsb) [#3713](https://github.com/kubernetes/kops/pull/3713)
* GCE: Set up permissions for cross-project configurations [@justinsb](https://github.com/justinsb) [#3712](https://github.com/kubernetes/kops/pull/3712)
* Updates for p3 machine type [@dvavili](https://github.com/dvavili) [#3715](https://github.com/kubernetes/kops/pull/3715)
* API docs updates [@chrislovecnm](https://github.com/chrislovecnm) [#3520](https://github.com/kubernetes/kops/pull/3520)
* Use compute API to fetch default service account directly [@justinsb](https://github.com/justinsb) [#3718](https://github.com/kubernetes/kops/pull/3718)
* Audit Policy File [@gambol99](https://github.com/gambol99) [#3692](https://github.com/kubernetes/kops/pull/3692)
* Refactor toolbox dump & dump structured instances [@justinsb](https://github.com/justinsb) [#3719](https://github.com/kubernetes/kops/pull/3719)
* Apply goimports formatting to upup/pkg/fi/cloudup/gcetasks/ [@justinsb](https://github.com/justinsb) [#3725](https://github.com/kubernetes/kops/pull/3725)
* Fix comment on Lifecycle constant [@justinsb](https://github.com/justinsb) [#3724](https://github.com/kubernetes/kops/pull/3724)
* Fix error message in StorageBucketIam task [@justinsb](https://github.com/justinsb) [#3723](https://github.com/kubernetes/kops/pull/3723)
* Move DeleteResources into pkg/resources/utils [@justinsb](https://github.com/justinsb) [#3720](https://github.com/kubernetes/kops/pull/3720)
* Refactor gce resources into pkg/resources/gce [@justinsb](https://github.com/justinsb) [#3721](https://github.com/kubernetes/kops/pull/3721)
* Add initial docs for how to rotate a CA keypair [@justinsb](https://github.com/justinsb) [#3727](https://github.com/kubernetes/kops/pull/3727)
* GCS: Use ACLs for GCE permissions [@justinsb](https://github.com/justinsb) [#3726](https://github.com/kubernetes/kops/pull/3726)
* Kops Template YAML Formatting [@gambol99](https://github.com/gambol99) [#3706](https://github.com/kubernetes/kops/pull/3706)
* Tolerate errors from Find for tasks with WarnIfInsufficientAccess [@justinsb](https://github.com/justinsb) [#3728](https://github.com/kubernetes/kops/pull/3728)
* GCE Dump: Include instance IPs [@justinsb](https://github.com/justinsb) [#3722](https://github.com/kubernetes/kops/pull/3722)
* Route53 based example [@tigerlinux](https://github.com/tigerlinux) [#3367](https://github.com/kubernetes/kops/pull/3367)
* Update IAM roles documentation based on recent changes. [@KashifSaadat](https://github.com/KashifSaadat) [#3732](https://github.com/kubernetes/kops/pull/3732)
* GCE: log the service account & scopes in use [@justinsb](https://github.com/justinsb) [#3742](https://github.com/kubernetes/kops/pull/3742)
* Add comment on purpose of kops keypair [@justinsb](https://github.com/justinsb) [#3741](https://github.com/kubernetes/kops/pull/3741)
* Fix log messages from storage acl tasks [@justinsb](https://github.com/justinsb) [#3737](https://github.com/kubernetes/kops/pull/3737)
* Generate gazelle [@justinsb](https://github.com/justinsb) [#3738](https://github.com/kubernetes/kops/pull/3738)
* Clarify comment on ReadTree [@justinsb](https://github.com/justinsb) [#3740](https://github.com/kubernetes/kops/pull/3740)
* fix typo in comment: mananging [@justinsb](https://github.com/justinsb) [#3739](https://github.com/kubernetes/kops/pull/3739)
* GCE: Use CloudPlatformScope when requesting a token [@justinsb](https://github.com/justinsb) [#3736](https://github.com/kubernetes/kops/pull/3736)
* Audit Policy Docs [@gambol99](https://github.com/gambol99) [#3747](https://github.com/kubernetes/kops/pull/3747)
* update gophercloud to the newest version [@zengchen1024](https://github.com/zengchen1024) [#3744](https://github.com/kubernetes/kops/pull/3744)
* Fix shared subnet/vpc tags [@justinsb](https://github.com/justinsb) [#3184](https://github.com/kubernetes/kops/pull/3184)
* GCE: log when loading from GOOGLE_APPLICATION_CREDENTIALS [@justinsb](https://github.com/justinsb) [#3748](https://github.com/kubernetes/kops/pull/3748)
* updating files for goimports - and fixed a unit test [@chrislovecnm](https://github.com/chrislovecnm) [#3752](https://github.com/kubernetes/kops/pull/3752)
* Adding back to the approvers [@geojaz](https://github.com/geojaz) [#3756](https://github.com/kubernetes/kops/pull/3756)
* Template Fixes [@gambol99](https://github.com/gambol99) [#3731](https://github.com/kubernetes/kops/pull/3731)
* Add node-to-master IPIP to kuberouter [@iterion](https://github.com/iterion) [#3730](https://github.com/kubernetes/kops/pull/3730)
* Enable IAM Container Registry permissions by default when creating a cluster (#3760). [@KashifSaadat](https://github.com/KashifSaadat) [#3761](https://github.com/kubernetes/kops/pull/3761)
* [Add-on] Add kube-state-metrics add-on [@tuannvm](https://github.com/tuannvm) [#3653](https://github.com/kubernetes/kops/pull/3653)
* Add makefile target to check markdown links [@aledbf](https://github.com/aledbf) [#3758](https://github.com/kubernetes/kops/pull/3758)
* Add service account for elasticsearch and fluentd [@thoslin](https://github.com/thoslin) [#3743](https://github.com/kubernetes/kops/pull/3743)
* Implement vfs with openstack swift [@zengchen1024](https://github.com/zengchen1024) [#3708](https://github.com/kubernetes/kops/pull/3708)
* Spelling fixes [@justinsb](https://github.com/justinsb) [#3700](https://github.com/kubernetes/kops/pull/3700)
* goimports cleanup && basel files [@chrislovecnm](https://github.com/chrislovecnm) [#3764](https://github.com/kubernetes/kops/pull/3764)
* Create YAML or JSON Clusterspec without creating the cluster [@chrislovecnm](https://github.com/chrislovecnm) [#2954](https://github.com/kubernetes/kops/pull/2954)
* deprecated API values that are no longer used with kube-dns [@chrislovecnm](https://github.com/chrislovecnm) [#3771](https://github.com/kubernetes/kops/pull/3771)
* Rationalize timeouts for rolling-update [@justinsb](https://github.com/justinsb) [#3658](https://github.com/kubernetes/kops/pull/3658)
* windows kops.exe binary support [@chrislovecnm](https://github.com/chrislovecnm) [#3770](https://github.com/kubernetes/kops/pull/3770)
* updating to bazel 0.0.7 and adding verify scripts [@chrislovecnm](https://github.com/chrislovecnm) [#3769](https://github.com/kubernetes/kops/pull/3769)
* adding -y [@chrislovecnm](https://github.com/chrislovecnm) [#3767](https://github.com/kubernetes/kops/pull/3767)
* updating api documentation [@chrislovecnm](https://github.com/chrislovecnm) [#3774](https://github.com/kubernetes/kops/pull/3774)
* removing windows from shipbot [@chrislovecnm](https://github.com/chrislovecnm) [#3775](https://github.com/kubernetes/kops/pull/3775)
* Fix Sirupsen/logrus submodule path error [@liranp](https://github.com/liranp) [#3779](https://github.com/kubernetes/kops/pull/3779)
* Add additional Describe permissions required for Romana CNI [@cgilmour](https://github.com/cgilmour) [#3778](https://github.com/kubernetes/kops/pull/3778)
* gazelle updates with new bazel version [@chrislovecnm](https://github.com/chrislovecnm) [#3776](https://github.com/kubernetes/kops/pull/3776)
* fixing panic with iam unit tests [@chrislovecnm](https://github.com/chrislovecnm) [#3782](https://github.com/kubernetes/kops/pull/3782)
* Updates for latest bazel / vendor [@justinsb](https://github.com/justinsb) [#3781](https://github.com/kubernetes/kops/pull/3781)
* Allows additional Subject Alternate Names [@pdh](https://github.com/pdh) [#2063](https://github.com/kubernetes/kops/pull/2063)
* Add --master-public-name argument to kops create_cluster [@mdavidsen](https://github.com/mdavidsen),[@justinsb](https://github.com/justinsb) [#3385](https://github.com/kubernetes/kops/pull/3385)

### beta.1 to beta.2

* Add PRs to 1.8 release notes [@justinsb](https://github.com/justinsb) [#3785](https://github.com/kubernetes/kops/pull/3785)
* Update Canal to use Calico v2.6.2. [@KashifSaadat](https://github.com/KashifSaadat) [#3786](https://github.com/kubernetes/kops/pull/3786)
* Toolbox Templating Docs [@gambol99](https://github.com/gambol99) [#3800](https://github.com/kubernetes/kops/pull/3800)
* DNS Controller Watch Command line [@gambol99](https://github.com/gambol99) [#3798](https://github.com/kubernetes/kops/pull/3798)
* Update tolerations in Canal spec so the pods can run on all nodes. [@KashifSaadat](https://github.com/KashifSaadat) [#3802](https://github.com/kubernetes/kops/pull/3802)
* Bugfix kops update always detecting changes when using ExecContainerAction. [@KashifSaadat](https://github.com/KashifSaadat) [#3790](https://github.com/kubernetes/kops/pull/3790)
* Allow passing in extra user-data to cloud-init [@brdude](https://github.com/brdude) [#3633](https://github.com/kubernetes/kops/pull/3633)
* Consolidate two separate CNI sections [@ahrkrak](https://github.com/ahrkrak) [#3811](https://github.com/kubernetes/kops/pull/3811)
* Update docs for 1.7.1 [@mikesplain](https://github.com/mikesplain) [#3810](https://github.com/kubernetes/kops/pull/3810)
* updating bazel build version [@chrislovecnm](https://github.com/chrislovecnm) [#3814](https://github.com/kubernetes/kops/pull/3814)
* Debian Stretch versions for Docker to support K8s 1.8 [@mikn](https://github.com/mikn) [#3807](https://github.com/kubernetes/kops/pull/3807)
* Add Node IAM permissions to access kube-router key in S3. [@KashifSaadat](https://github.com/KashifSaadat) [#3795](https://github.com/kubernetes/kops/pull/3795)
* Add a default NodeLabel with the InstanceGroup name [@georgebuckerfield](https://github.com/georgebuckerfield) [#3783](https://github.com/kubernetes/kops/pull/3783)
* Bump alpha and stable to latest [@pierreozoux](https://github.com/pierreozoux) [#3797](https://github.com/kubernetes/kops/pull/3797)
* Add support for C5 instance family [@shamil](https://github.com/shamil) [#3794](https://github.com/kubernetes/kops/pull/3794)
* san api update [@chrislovecnm](https://github.com/chrislovecnm) [#3815](https://github.com/kubernetes/kops/pull/3815)
* FeatureGates support in all the components [@diegows](https://github.com/diegows) [#3805](https://github.com/kubernetes/kops/pull/3805)
* kube-router: remove beta annotation versions (deprectated in 1.8) of init container [@murali-reddy](https://github.com/murali-reddy) [#3620](https://github.com/kubernetes/kops/pull/3620)
* Fixed the broken link for aws doc. [@shashanktomar](https://github.com/shashanktomar) [#3831](https://github.com/kubernetes/kops/pull/3831)
* Bump alpha channel for 1.8 [@justinsb](https://github.com/justinsb) [#3825](https://github.com/kubernetes/kops/pull/3825)
* Fix resources for etcd-events [@justinsb](https://github.com/justinsb) [#3843](https://github.com/kubernetes/kops/pull/3843)
* Fix CNI CPU allocations [@justinsb](https://github.com/justinsb) [#3844](https://github.com/kubernetes/kops/pull/3844)
* Update bazel build files [@justinsb](https://github.com/justinsb) [#3842](https://github.com/kubernetes/kops/pull/3842)
* Fix CoreOS logrotate service failure. [@KashifSaadat](https://github.com/KashifSaadat) [#3846](https://github.com/kubernetes/kops/pull/3846)
* Update calico template [@itajaja](https://github.com/itajaja) [#3803](https://github.com/kubernetes/kops/pull/3803)
* Fix error message when not specify --cloud or --zones [@justinsb](https://github.com/justinsb) [#3841](https://github.com/kubernetes/kops/pull/3841)
* Add HPA up/downscale delay [@discordianfish](https://github.com/discordianfish) [#3847](https://github.com/kubernetes/kops/pull/3847)
* Updating API documentation [@chrislovecnm](https://github.com/chrislovecnm) [#3827](https://github.com/kubernetes/kops/pull/3827)
* Add edit flag so create instancegroup command is usable on scripts [@jchanam](https://github.com/jchanam) [#3787](https://github.com/kubernetes/kops/pull/3787)
* add openstack cloud provider [@zengchen1024](https://github.com/zengchen1024) [#3820](https://github.com/kubernetes/kops/pull/3820)
* Fix gazelle [@justinsb](https://github.com/justinsb) [#3850](https://github.com/kubernetes/kops/pull/3850)
* Tweak kops create ig flag to edit, not editor [@justinsb](https://github.com/justinsb) [#3849](https://github.com/kubernetes/kops/pull/3849)
* Apply gossip dns changes to 1.8 calico version also [@marshallbrekka](https://github.com/marshallbrekka),[@justinsb](https://github.com/justinsb) [#3851](https://github.com/kubernetes/kops/pull/3851)
* Update Additional user-data per #3853 [@dgem](https://github.com/dgem) [#3854](https://github.com/kubernetes/kops/pull/3854)
* updating api docs [@chrislovecnm](https://github.com/chrislovecnm) [#3856](https://github.com/kubernetes/kops/pull/3856)
* Verify that no extra records remain after a reconnection [@justinsb](https://github.com/justinsb) [#3858](https://github.com/kubernetes/kops/pull/3858)
* Use upsert when applying DNS records [@justinsb](https://github.com/justinsb) [#3859](https://github.com/kubernetes/kops/pull/3859)
* Fix Autoscaling flag on Controller Manager Config [@david92rl](https://github.com/david92rl) [#3872](https://github.com/kubernetes/kops/pull/3872)
* Include encryptionConfig setting within userdata for masters. [@KashifSaadat](https://github.com/KashifSaadat) [#3874](https://github.com/kubernetes/kops/pull/3874)
* Add Exemple for instance group tagging [@sergeohl](https://github.com/sergeohl) [#3879](https://github.com/kubernetes/kops/pull/3879)
* README and issue template updates [@chrislovecnm](https://github.com/chrislovecnm) [#3818](https://github.com/kubernetes/kops/pull/3818)
* Kops Template Config Value [@gambol99](https://github.com/gambol99) [#3863](https://github.com/kubernetes/kops/pull/3863)
* Fix spelling [@jonstacks](https://github.com/jonstacks) [#3864](https://github.com/kubernetes/kops/pull/3864)
* Improving UX for placeholder IP Address [@chrislovecnm](https://github.com/chrislovecnm) [#3709](https://github.com/kubernetes/kops/pull/3709)
* Bump all flannel versions to latest release - v0.9.1 [@tomdee](https://github.com/tomdee) [#3880](https://github.com/kubernetes/kops/pull/3880)
* Add support for docker 17.09.0 version [@dvavili](https://github.com/dvavili) [#3881](https://github.com/kubernetes/kops/pull/3881)
* upscale-delay flag in two more places [@justinsb](https://github.com/justinsb) [#3890](https://github.com/kubernetes/kops/pull/3890)
* Changing the prefix of the ResourceTag condition [@ftoresan](https://github.com/ftoresan) [#3889](https://github.com/kubernetes/kops/pull/3889)
* Support replacing kops secrets via force flag [@KashifSaadat](https://github.com/KashifSaadat) [#3899](https://github.com/kubernetes/kops/pull/3899)
* Implement volume task for Openstack platform [@zengchen1024](https://github.com/zengchen1024) [#3893](https://github.com/kubernetes/kops/pull/3893)
* fix: paths in cluster_template.md [@Moshe-Immerman](https://github.com/Moshe-Immerman) [#3897](https://github.com/kubernetes/kops/pull/3897)
* Respect the shared tag when deleting route tables [@georgebuckerfield](https://github.com/georgebuckerfield) [#3887](https://github.com/kubernetes/kops/pull/3887)
* generate gazelle for cinder volume tasks [@zengchen1024](https://github.com/zengchen1024) [#3904](https://github.com/kubernetes/kops/pull/3904)
* Owners files [@gambol99](https://github.com/gambol99) [#3906](https://github.com/kubernetes/kops/pull/3906)
* Version and validation updates for romana networking. [@cgilmour](https://github.com/cgilmour) [#3892](https://github.com/kubernetes/kops/pull/3892)
* Add homebrew devel and HEAD notes to docs. [@mikesplain](https://github.com/mikesplain) [#3826](https://github.com/kubernetes/kops/pull/3826)
* Updated 1.8 release notes to cover Canal manual upgrade steps. [@KashifSaadat](https://github.com/KashifSaadat) [#3908](https://github.com/kubernetes/kops/pull/3908)
* Updating Calico manifests to Calico release 2.6.2 [@chrislovecnm](https://github.com/chrislovecnm) [#3869](https://github.com/kubernetes/kops/pull/3869)
* Set SleepDelay function in AWS [@justinsb](https://github.com/justinsb) [#3913](https://github.com/kubernetes/kops/pull/3913)
* bazel: fix tests/ directory [@justinsb](https://github.com/justinsb) [#3922](https://github.com/kubernetes/kops/pull/3922)
* Avoid generating a CA keypair on-demand [@justinsb](https://github.com/justinsb) [#3925](https://github.com/kubernetes/kops/pull/3925)
* Added .service to hooks unit files [@aleerizw](https://github.com/aleerizw) [#3920](https://github.com/kubernetes/kops/pull/3920)
* DNS Controller Optional [@gambol99](https://github.com/gambol99) [#3822](https://github.com/kubernetes/kops/pull/3822)
* Use EnsureTask so we don't have to track directories as closely [@justinsb](https://github.com/justinsb) [#3926](https://github.com/kubernetes/kops/pull/3926)
* Block etcd peer port from nodes [@justinsb](https://github.com/justinsb) [#3923](https://github.com/kubernetes/kops/pull/3923)
* Don't add .service extension if already there [@aleerizw](https://github.com/aleerizw),[@justinsb](https://github.com/justinsb) [#3929](https://github.com/kubernetes/kops/pull/3929)
* Promote 1.5.8 and 1.6.11 to stable channel [@justinsb](https://github.com/justinsb) [#3931](https://github.com/kubernetes/kops/pull/3931)
* Put the 1.8 image into the alpha channel [@justinsb](https://github.com/justinsb) [#3930](https://github.com/kubernetes/kops/pull/3930)
* Bump alpha channel k8s versions [@justinsb](https://github.com/justinsb) [#3932](https://github.com/kubernetes/kops/pull/3932)
* Update kopeio auth [@justinsb](https://github.com/justinsb) [#3928](https://github.com/kubernetes/kops/pull/3928)
* Map horizontal-pod-autoscaler-use-rest-clients flag [@itskingori](https://github.com/itskingori) [#3939](https://github.com/kubernetes/kops/pull/3939)
* Bump all our base docker images [@justinsb](https://github.com/justinsb) [#3940](https://github.com/kubernetes/kops/pull/3940)

## beta.2 to 1.8.0

* Add Dashboard v1.8.0 deployment [@maciaszczykm](https://github.com/maciaszczykm) [#3936](https://github.com/kubernetes/kops/pull/3936)
* Rename dashboard manifest so it has extension [@justinsb](https://github.com/justinsb) [#3946](https://github.com/kubernetes/kops/pull/3946)
* Fix flannel version [@mikesplain](https://github.com/mikesplain) [#3953](https://github.com/kubernetes/kops/pull/3953)
* Fix flannel error on starting [@mikesplain](https://github.com/mikesplain) [#3956](https://github.com/kubernetes/kops/pull/3956)
* Fix brew docs typo [@mikesplain](https://github.com/mikesplain) [#3949](https://github.com/kubernetes/kops/pull/3949)
* kops not Kops [@chrislovecnm](https://github.com/chrislovecnm) [#3960](https://github.com/kubernetes/kops/pull/3960)
* openapi doc updates [@chrislovecnm](https://github.com/chrislovecnm) [#3948](https://github.com/kubernetes/kops/pull/3948)
* Add kubernetes-dashboard addon version constraint [@so0k](https://github.com/so0k) [#3959](https://github.com/kubernetes/kops/pull/3959)
* Initial support for nvme [@justinsb](https://github.com/justinsb) [#3969](https://github.com/kubernetes/kops/pull/3969)
* Fix typo in kops get cluster --full hint [@justinsb](https://github.com/justinsb) [#3968](https://github.com/kubernetes/kops/pull/3968)
* Ensure iptables forwarding is enabled [@justinsb](https://github.com/justinsb) [#3977](https://github.com/kubernetes/kops/pull/3977)
* Put latest AMIs into alpha channel [@justinsb](https://github.com/justinsb) [#3979](https://github.com/kubernetes/kops/pull/3979)
* Fix segfault when updating non-existent object [@justinsb](https://github.com/justinsb) [#3980](https://github.com/kubernetes/kops/pull/3980)
* Guard against nil pointers in tryResourceAsString [@justinsb](https://github.com/justinsb) [#3982](https://github.com/kubernetes/kops/pull/3982)
* Allow GCE network to be reconfigured [@justinsb](https://github.com/justinsb) [#3988](https://github.com/kubernetes/kops/pull/3988)
* Fix kubernetes version selectors on alpha channel [@justinsb](https://github.com/justinsb) [#3984](https://github.com/kubernetes/kops/pull/3984)
* Provide better message if GCE network is in legacy mode [@justinsb](https://github.com/justinsb) [#3989](https://github.com/kubernetes/kops/pull/3989)
* Add support for M5 and H1 instance families [@ripta](https://github.com/ripta) [#3990](https://github.com/kubernetes/kops/pull/3990)
* Bump image in alpha channel: ENA in jessie [@justinsb](https://github.com/justinsb) [#3992](https://github.com/kubernetes/kops/pull/3992)
