// +build !ignore_autogenerated

/*
Copyright 2018 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// This file was autogenerated by conversion-gen. Do not edit it manually!

package v1alpha1

import (
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
	kops "k8s.io/kops/pkg/apis/kops"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(scheme *runtime.Scheme) error {
	return scheme.AddGeneratedConversionFuncs(
		Convert_v1alpha1_AccessSpec_To_kops_AccessSpec,
		Convert_kops_AccessSpec_To_v1alpha1_AccessSpec,
		Convert_v1alpha1_AddonSpec_To_kops_AddonSpec,
		Convert_kops_AddonSpec_To_v1alpha1_AddonSpec,
		Convert_v1alpha1_AlwaysAllowAuthorizationSpec_To_kops_AlwaysAllowAuthorizationSpec,
		Convert_kops_AlwaysAllowAuthorizationSpec_To_v1alpha1_AlwaysAllowAuthorizationSpec,
		Convert_v1alpha1_AmazonVPCNetworkingSpec_To_kops_AmazonVPCNetworkingSpec,
		Convert_kops_AmazonVPCNetworkingSpec_To_v1alpha1_AmazonVPCNetworkingSpec,
		Convert_v1alpha1_Assets_To_kops_Assets,
		Convert_kops_Assets_To_v1alpha1_Assets,
		Convert_v1alpha1_AuthenticationSpec_To_kops_AuthenticationSpec,
		Convert_kops_AuthenticationSpec_To_v1alpha1_AuthenticationSpec,
		Convert_v1alpha1_AuthorizationSpec_To_kops_AuthorizationSpec,
		Convert_kops_AuthorizationSpec_To_v1alpha1_AuthorizationSpec,
		Convert_v1alpha1_CNINetworkingSpec_To_kops_CNINetworkingSpec,
		Convert_kops_CNINetworkingSpec_To_v1alpha1_CNINetworkingSpec,
		Convert_v1alpha1_CalicoNetworkingSpec_To_kops_CalicoNetworkingSpec,
		Convert_kops_CalicoNetworkingSpec_To_v1alpha1_CalicoNetworkingSpec,
		Convert_v1alpha1_CanalNetworkingSpec_To_kops_CanalNetworkingSpec,
		Convert_kops_CanalNetworkingSpec_To_v1alpha1_CanalNetworkingSpec,
		Convert_v1alpha1_CiliumNetworkingSpec_To_kops_CiliumNetworkingSpec,
		Convert_kops_CiliumNetworkingSpec_To_v1alpha1_CiliumNetworkingSpec,
		Convert_v1alpha1_ClassicNetworkingSpec_To_kops_ClassicNetworkingSpec,
		Convert_kops_ClassicNetworkingSpec_To_v1alpha1_ClassicNetworkingSpec,
		Convert_v1alpha1_CloudConfiguration_To_kops_CloudConfiguration,
		Convert_kops_CloudConfiguration_To_v1alpha1_CloudConfiguration,
		Convert_v1alpha1_CloudControllerManagerConfig_To_kops_CloudControllerManagerConfig,
		Convert_kops_CloudControllerManagerConfig_To_v1alpha1_CloudControllerManagerConfig,
		Convert_v1alpha1_Cluster_To_kops_Cluster,
		Convert_kops_Cluster_To_v1alpha1_Cluster,
		Convert_v1alpha1_ClusterList_To_kops_ClusterList,
		Convert_kops_ClusterList_To_v1alpha1_ClusterList,
		Convert_v1alpha1_ClusterSpec_To_kops_ClusterSpec,
		Convert_kops_ClusterSpec_To_v1alpha1_ClusterSpec,
		Convert_v1alpha1_DNSAccessSpec_To_kops_DNSAccessSpec,
		Convert_kops_DNSAccessSpec_To_v1alpha1_DNSAccessSpec,
		Convert_v1alpha1_DNSSpec_To_kops_DNSSpec,
		Convert_kops_DNSSpec_To_v1alpha1_DNSSpec,
		Convert_v1alpha1_DockerConfig_To_kops_DockerConfig,
		Convert_kops_DockerConfig_To_v1alpha1_DockerConfig,
		Convert_v1alpha1_EgressProxySpec_To_kops_EgressProxySpec,
		Convert_kops_EgressProxySpec_To_v1alpha1_EgressProxySpec,
		Convert_v1alpha1_EtcdBackupSpec_To_kops_EtcdBackupSpec,
		Convert_kops_EtcdBackupSpec_To_v1alpha1_EtcdBackupSpec,
		Convert_v1alpha1_EtcdClusterSpec_To_kops_EtcdClusterSpec,
		Convert_kops_EtcdClusterSpec_To_v1alpha1_EtcdClusterSpec,
		Convert_v1alpha1_EtcdMemberSpec_To_kops_EtcdMemberSpec,
		Convert_kops_EtcdMemberSpec_To_v1alpha1_EtcdMemberSpec,
		Convert_v1alpha1_ExecContainerAction_To_kops_ExecContainerAction,
		Convert_kops_ExecContainerAction_To_v1alpha1_ExecContainerAction,
		Convert_v1alpha1_ExternalDNSConfig_To_kops_ExternalDNSConfig,
		Convert_kops_ExternalDNSConfig_To_v1alpha1_ExternalDNSConfig,
		Convert_v1alpha1_ExternalNetworkingSpec_To_kops_ExternalNetworkingSpec,
		Convert_kops_ExternalNetworkingSpec_To_v1alpha1_ExternalNetworkingSpec,
		Convert_v1alpha1_FileAssetSpec_To_kops_FileAssetSpec,
		Convert_kops_FileAssetSpec_To_v1alpha1_FileAssetSpec,
		Convert_v1alpha1_FlannelNetworkingSpec_To_kops_FlannelNetworkingSpec,
		Convert_kops_FlannelNetworkingSpec_To_v1alpha1_FlannelNetworkingSpec,
		Convert_v1alpha1_HTTPProxy_To_kops_HTTPProxy,
		Convert_kops_HTTPProxy_To_v1alpha1_HTTPProxy,
		Convert_v1alpha1_HookSpec_To_kops_HookSpec,
		Convert_kops_HookSpec_To_v1alpha1_HookSpec,
		Convert_v1alpha1_IAMSpec_To_kops_IAMSpec,
		Convert_kops_IAMSpec_To_v1alpha1_IAMSpec,
		Convert_v1alpha1_InstanceGroup_To_kops_InstanceGroup,
		Convert_kops_InstanceGroup_To_v1alpha1_InstanceGroup,
		Convert_v1alpha1_InstanceGroupList_To_kops_InstanceGroupList,
		Convert_kops_InstanceGroupList_To_v1alpha1_InstanceGroupList,
		Convert_v1alpha1_InstanceGroupSpec_To_kops_InstanceGroupSpec,
		Convert_kops_InstanceGroupSpec_To_v1alpha1_InstanceGroupSpec,
		Convert_v1alpha1_KopeioAuthenticationSpec_To_kops_KopeioAuthenticationSpec,
		Convert_kops_KopeioAuthenticationSpec_To_v1alpha1_KopeioAuthenticationSpec,
		Convert_v1alpha1_KopeioNetworkingSpec_To_kops_KopeioNetworkingSpec,
		Convert_kops_KopeioNetworkingSpec_To_v1alpha1_KopeioNetworkingSpec,
		Convert_v1alpha1_KubeAPIServerConfig_To_kops_KubeAPIServerConfig,
		Convert_kops_KubeAPIServerConfig_To_v1alpha1_KubeAPIServerConfig,
		Convert_v1alpha1_KubeControllerManagerConfig_To_kops_KubeControllerManagerConfig,
		Convert_kops_KubeControllerManagerConfig_To_v1alpha1_KubeControllerManagerConfig,
		Convert_v1alpha1_KubeDNSConfig_To_kops_KubeDNSConfig,
		Convert_kops_KubeDNSConfig_To_v1alpha1_KubeDNSConfig,
		Convert_v1alpha1_KubeProxyConfig_To_kops_KubeProxyConfig,
		Convert_kops_KubeProxyConfig_To_v1alpha1_KubeProxyConfig,
		Convert_v1alpha1_KubeSchedulerConfig_To_kops_KubeSchedulerConfig,
		Convert_kops_KubeSchedulerConfig_To_v1alpha1_KubeSchedulerConfig,
		Convert_v1alpha1_KubeletConfigSpec_To_kops_KubeletConfigSpec,
		Convert_kops_KubeletConfigSpec_To_v1alpha1_KubeletConfigSpec,
		Convert_v1alpha1_KubenetNetworkingSpec_To_kops_KubenetNetworkingSpec,
		Convert_kops_KubenetNetworkingSpec_To_v1alpha1_KubenetNetworkingSpec,
		Convert_v1alpha1_KuberouterNetworkingSpec_To_kops_KuberouterNetworkingSpec,
		Convert_kops_KuberouterNetworkingSpec_To_v1alpha1_KuberouterNetworkingSpec,
		Convert_v1alpha1_LeaderElectionConfiguration_To_kops_LeaderElectionConfiguration,
		Convert_kops_LeaderElectionConfiguration_To_v1alpha1_LeaderElectionConfiguration,
		Convert_v1alpha1_LoadBalancerAccessSpec_To_kops_LoadBalancerAccessSpec,
		Convert_kops_LoadBalancerAccessSpec_To_v1alpha1_LoadBalancerAccessSpec,
		Convert_v1alpha1_NetworkingSpec_To_kops_NetworkingSpec,
		Convert_kops_NetworkingSpec_To_v1alpha1_NetworkingSpec,
		Convert_v1alpha1_RBACAuthorizationSpec_To_kops_RBACAuthorizationSpec,
		Convert_kops_RBACAuthorizationSpec_To_v1alpha1_RBACAuthorizationSpec,
		Convert_v1alpha1_RomanaNetworkingSpec_To_kops_RomanaNetworkingSpec,
		Convert_kops_RomanaNetworkingSpec_To_v1alpha1_RomanaNetworkingSpec,
		Convert_v1alpha1_SSHCredential_To_kops_SSHCredential,
		Convert_kops_SSHCredential_To_v1alpha1_SSHCredential,
		Convert_v1alpha1_SSHCredentialList_To_kops_SSHCredentialList,
		Convert_kops_SSHCredentialList_To_v1alpha1_SSHCredentialList,
		Convert_v1alpha1_SSHCredentialSpec_To_kops_SSHCredentialSpec,
		Convert_kops_SSHCredentialSpec_To_v1alpha1_SSHCredentialSpec,
		Convert_v1alpha1_TargetSpec_To_kops_TargetSpec,
		Convert_kops_TargetSpec_To_v1alpha1_TargetSpec,
		Convert_v1alpha1_TerraformSpec_To_kops_TerraformSpec,
		Convert_kops_TerraformSpec_To_v1alpha1_TerraformSpec,
		Convert_v1alpha1_UserData_To_kops_UserData,
		Convert_kops_UserData_To_v1alpha1_UserData,
		Convert_v1alpha1_WeaveNetworkingSpec_To_kops_WeaveNetworkingSpec,
		Convert_kops_WeaveNetworkingSpec_To_v1alpha1_WeaveNetworkingSpec,
	)
}

func autoConvert_v1alpha1_AccessSpec_To_kops_AccessSpec(in *AccessSpec, out *kops.AccessSpec, s conversion.Scope) error {
	if in.DNS != nil {
		in, out := &in.DNS, &out.DNS
		*out = new(kops.DNSAccessSpec)
		if err := Convert_v1alpha1_DNSAccessSpec_To_kops_DNSAccessSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.DNS = nil
	}
	if in.LoadBalancer != nil {
		in, out := &in.LoadBalancer, &out.LoadBalancer
		*out = new(kops.LoadBalancerAccessSpec)
		if err := Convert_v1alpha1_LoadBalancerAccessSpec_To_kops_LoadBalancerAccessSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.LoadBalancer = nil
	}
	return nil
}

// Convert_v1alpha1_AccessSpec_To_kops_AccessSpec is an autogenerated conversion function.
func Convert_v1alpha1_AccessSpec_To_kops_AccessSpec(in *AccessSpec, out *kops.AccessSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_AccessSpec_To_kops_AccessSpec(in, out, s)
}

func autoConvert_kops_AccessSpec_To_v1alpha1_AccessSpec(in *kops.AccessSpec, out *AccessSpec, s conversion.Scope) error {
	if in.DNS != nil {
		in, out := &in.DNS, &out.DNS
		*out = new(DNSAccessSpec)
		if err := Convert_kops_DNSAccessSpec_To_v1alpha1_DNSAccessSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.DNS = nil
	}
	if in.LoadBalancer != nil {
		in, out := &in.LoadBalancer, &out.LoadBalancer
		*out = new(LoadBalancerAccessSpec)
		if err := Convert_kops_LoadBalancerAccessSpec_To_v1alpha1_LoadBalancerAccessSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.LoadBalancer = nil
	}
	return nil
}

// Convert_kops_AccessSpec_To_v1alpha1_AccessSpec is an autogenerated conversion function.
func Convert_kops_AccessSpec_To_v1alpha1_AccessSpec(in *kops.AccessSpec, out *AccessSpec, s conversion.Scope) error {
	return autoConvert_kops_AccessSpec_To_v1alpha1_AccessSpec(in, out, s)
}

func autoConvert_v1alpha1_AddonSpec_To_kops_AddonSpec(in *AddonSpec, out *kops.AddonSpec, s conversion.Scope) error {
	out.Manifest = in.Manifest
	return nil
}

// Convert_v1alpha1_AddonSpec_To_kops_AddonSpec is an autogenerated conversion function.
func Convert_v1alpha1_AddonSpec_To_kops_AddonSpec(in *AddonSpec, out *kops.AddonSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_AddonSpec_To_kops_AddonSpec(in, out, s)
}

func autoConvert_kops_AddonSpec_To_v1alpha1_AddonSpec(in *kops.AddonSpec, out *AddonSpec, s conversion.Scope) error {
	out.Manifest = in.Manifest
	return nil
}

// Convert_kops_AddonSpec_To_v1alpha1_AddonSpec is an autogenerated conversion function.
func Convert_kops_AddonSpec_To_v1alpha1_AddonSpec(in *kops.AddonSpec, out *AddonSpec, s conversion.Scope) error {
	return autoConvert_kops_AddonSpec_To_v1alpha1_AddonSpec(in, out, s)
}

func autoConvert_v1alpha1_AlwaysAllowAuthorizationSpec_To_kops_AlwaysAllowAuthorizationSpec(in *AlwaysAllowAuthorizationSpec, out *kops.AlwaysAllowAuthorizationSpec, s conversion.Scope) error {
	return nil
}

// Convert_v1alpha1_AlwaysAllowAuthorizationSpec_To_kops_AlwaysAllowAuthorizationSpec is an autogenerated conversion function.
func Convert_v1alpha1_AlwaysAllowAuthorizationSpec_To_kops_AlwaysAllowAuthorizationSpec(in *AlwaysAllowAuthorizationSpec, out *kops.AlwaysAllowAuthorizationSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_AlwaysAllowAuthorizationSpec_To_kops_AlwaysAllowAuthorizationSpec(in, out, s)
}

func autoConvert_kops_AlwaysAllowAuthorizationSpec_To_v1alpha1_AlwaysAllowAuthorizationSpec(in *kops.AlwaysAllowAuthorizationSpec, out *AlwaysAllowAuthorizationSpec, s conversion.Scope) error {
	return nil
}

// Convert_kops_AlwaysAllowAuthorizationSpec_To_v1alpha1_AlwaysAllowAuthorizationSpec is an autogenerated conversion function.
func Convert_kops_AlwaysAllowAuthorizationSpec_To_v1alpha1_AlwaysAllowAuthorizationSpec(in *kops.AlwaysAllowAuthorizationSpec, out *AlwaysAllowAuthorizationSpec, s conversion.Scope) error {
	return autoConvert_kops_AlwaysAllowAuthorizationSpec_To_v1alpha1_AlwaysAllowAuthorizationSpec(in, out, s)
}

func autoConvert_v1alpha1_AmazonVPCNetworkingSpec_To_kops_AmazonVPCNetworkingSpec(in *AmazonVPCNetworkingSpec, out *kops.AmazonVPCNetworkingSpec, s conversion.Scope) error {
	return nil
}

// Convert_v1alpha1_AmazonVPCNetworkingSpec_To_kops_AmazonVPCNetworkingSpec is an autogenerated conversion function.
func Convert_v1alpha1_AmazonVPCNetworkingSpec_To_kops_AmazonVPCNetworkingSpec(in *AmazonVPCNetworkingSpec, out *kops.AmazonVPCNetworkingSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_AmazonVPCNetworkingSpec_To_kops_AmazonVPCNetworkingSpec(in, out, s)
}

func autoConvert_kops_AmazonVPCNetworkingSpec_To_v1alpha1_AmazonVPCNetworkingSpec(in *kops.AmazonVPCNetworkingSpec, out *AmazonVPCNetworkingSpec, s conversion.Scope) error {
	return nil
}

// Convert_kops_AmazonVPCNetworkingSpec_To_v1alpha1_AmazonVPCNetworkingSpec is an autogenerated conversion function.
func Convert_kops_AmazonVPCNetworkingSpec_To_v1alpha1_AmazonVPCNetworkingSpec(in *kops.AmazonVPCNetworkingSpec, out *AmazonVPCNetworkingSpec, s conversion.Scope) error {
	return autoConvert_kops_AmazonVPCNetworkingSpec_To_v1alpha1_AmazonVPCNetworkingSpec(in, out, s)
}

func autoConvert_v1alpha1_Assets_To_kops_Assets(in *Assets, out *kops.Assets, s conversion.Scope) error {
	out.ContainerRegistry = in.ContainerRegistry
	out.FileRepository = in.FileRepository
	return nil
}

// Convert_v1alpha1_Assets_To_kops_Assets is an autogenerated conversion function.
func Convert_v1alpha1_Assets_To_kops_Assets(in *Assets, out *kops.Assets, s conversion.Scope) error {
	return autoConvert_v1alpha1_Assets_To_kops_Assets(in, out, s)
}

func autoConvert_kops_Assets_To_v1alpha1_Assets(in *kops.Assets, out *Assets, s conversion.Scope) error {
	out.ContainerRegistry = in.ContainerRegistry
	out.FileRepository = in.FileRepository
	return nil
}

// Convert_kops_Assets_To_v1alpha1_Assets is an autogenerated conversion function.
func Convert_kops_Assets_To_v1alpha1_Assets(in *kops.Assets, out *Assets, s conversion.Scope) error {
	return autoConvert_kops_Assets_To_v1alpha1_Assets(in, out, s)
}

func autoConvert_v1alpha1_AuthenticationSpec_To_kops_AuthenticationSpec(in *AuthenticationSpec, out *kops.AuthenticationSpec, s conversion.Scope) error {
	if in.Kopeio != nil {
		in, out := &in.Kopeio, &out.Kopeio
		*out = new(kops.KopeioAuthenticationSpec)
		if err := Convert_v1alpha1_KopeioAuthenticationSpec_To_kops_KopeioAuthenticationSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Kopeio = nil
	}
	return nil
}

// Convert_v1alpha1_AuthenticationSpec_To_kops_AuthenticationSpec is an autogenerated conversion function.
func Convert_v1alpha1_AuthenticationSpec_To_kops_AuthenticationSpec(in *AuthenticationSpec, out *kops.AuthenticationSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_AuthenticationSpec_To_kops_AuthenticationSpec(in, out, s)
}

func autoConvert_kops_AuthenticationSpec_To_v1alpha1_AuthenticationSpec(in *kops.AuthenticationSpec, out *AuthenticationSpec, s conversion.Scope) error {
	if in.Kopeio != nil {
		in, out := &in.Kopeio, &out.Kopeio
		*out = new(KopeioAuthenticationSpec)
		if err := Convert_kops_KopeioAuthenticationSpec_To_v1alpha1_KopeioAuthenticationSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Kopeio = nil
	}
	return nil
}

// Convert_kops_AuthenticationSpec_To_v1alpha1_AuthenticationSpec is an autogenerated conversion function.
func Convert_kops_AuthenticationSpec_To_v1alpha1_AuthenticationSpec(in *kops.AuthenticationSpec, out *AuthenticationSpec, s conversion.Scope) error {
	return autoConvert_kops_AuthenticationSpec_To_v1alpha1_AuthenticationSpec(in, out, s)
}

func autoConvert_v1alpha1_AuthorizationSpec_To_kops_AuthorizationSpec(in *AuthorizationSpec, out *kops.AuthorizationSpec, s conversion.Scope) error {
	if in.AlwaysAllow != nil {
		in, out := &in.AlwaysAllow, &out.AlwaysAllow
		*out = new(kops.AlwaysAllowAuthorizationSpec)
		if err := Convert_v1alpha1_AlwaysAllowAuthorizationSpec_To_kops_AlwaysAllowAuthorizationSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.AlwaysAllow = nil
	}
	if in.RBAC != nil {
		in, out := &in.RBAC, &out.RBAC
		*out = new(kops.RBACAuthorizationSpec)
		if err := Convert_v1alpha1_RBACAuthorizationSpec_To_kops_RBACAuthorizationSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.RBAC = nil
	}
	return nil
}

// Convert_v1alpha1_AuthorizationSpec_To_kops_AuthorizationSpec is an autogenerated conversion function.
func Convert_v1alpha1_AuthorizationSpec_To_kops_AuthorizationSpec(in *AuthorizationSpec, out *kops.AuthorizationSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_AuthorizationSpec_To_kops_AuthorizationSpec(in, out, s)
}

func autoConvert_kops_AuthorizationSpec_To_v1alpha1_AuthorizationSpec(in *kops.AuthorizationSpec, out *AuthorizationSpec, s conversion.Scope) error {
	if in.AlwaysAllow != nil {
		in, out := &in.AlwaysAllow, &out.AlwaysAllow
		*out = new(AlwaysAllowAuthorizationSpec)
		if err := Convert_kops_AlwaysAllowAuthorizationSpec_To_v1alpha1_AlwaysAllowAuthorizationSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.AlwaysAllow = nil
	}
	if in.RBAC != nil {
		in, out := &in.RBAC, &out.RBAC
		*out = new(RBACAuthorizationSpec)
		if err := Convert_kops_RBACAuthorizationSpec_To_v1alpha1_RBACAuthorizationSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.RBAC = nil
	}
	return nil
}

// Convert_kops_AuthorizationSpec_To_v1alpha1_AuthorizationSpec is an autogenerated conversion function.
func Convert_kops_AuthorizationSpec_To_v1alpha1_AuthorizationSpec(in *kops.AuthorizationSpec, out *AuthorizationSpec, s conversion.Scope) error {
	return autoConvert_kops_AuthorizationSpec_To_v1alpha1_AuthorizationSpec(in, out, s)
}

func autoConvert_v1alpha1_CNINetworkingSpec_To_kops_CNINetworkingSpec(in *CNINetworkingSpec, out *kops.CNINetworkingSpec, s conversion.Scope) error {
	return nil
}

// Convert_v1alpha1_CNINetworkingSpec_To_kops_CNINetworkingSpec is an autogenerated conversion function.
func Convert_v1alpha1_CNINetworkingSpec_To_kops_CNINetworkingSpec(in *CNINetworkingSpec, out *kops.CNINetworkingSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_CNINetworkingSpec_To_kops_CNINetworkingSpec(in, out, s)
}

func autoConvert_kops_CNINetworkingSpec_To_v1alpha1_CNINetworkingSpec(in *kops.CNINetworkingSpec, out *CNINetworkingSpec, s conversion.Scope) error {
	return nil
}

// Convert_kops_CNINetworkingSpec_To_v1alpha1_CNINetworkingSpec is an autogenerated conversion function.
func Convert_kops_CNINetworkingSpec_To_v1alpha1_CNINetworkingSpec(in *kops.CNINetworkingSpec, out *CNINetworkingSpec, s conversion.Scope) error {
	return autoConvert_kops_CNINetworkingSpec_To_v1alpha1_CNINetworkingSpec(in, out, s)
}

func autoConvert_v1alpha1_CalicoNetworkingSpec_To_kops_CalicoNetworkingSpec(in *CalicoNetworkingSpec, out *kops.CalicoNetworkingSpec, s conversion.Scope) error {
	out.CrossSubnet = in.CrossSubnet
	out.PrometheusMetricsEnabled = in.PrometheusMetricsEnabled
	out.PrometheusMetricsPort = in.PrometheusMetricsPort
	out.PrometheusGoMetricsEnabled = in.PrometheusGoMetricsEnabled
	out.PrometheusProcessMetricsEnabled = in.PrometheusProcessMetricsEnabled
	return nil
}

// Convert_v1alpha1_CalicoNetworkingSpec_To_kops_CalicoNetworkingSpec is an autogenerated conversion function.
func Convert_v1alpha1_CalicoNetworkingSpec_To_kops_CalicoNetworkingSpec(in *CalicoNetworkingSpec, out *kops.CalicoNetworkingSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_CalicoNetworkingSpec_To_kops_CalicoNetworkingSpec(in, out, s)
}

func autoConvert_kops_CalicoNetworkingSpec_To_v1alpha1_CalicoNetworkingSpec(in *kops.CalicoNetworkingSpec, out *CalicoNetworkingSpec, s conversion.Scope) error {
	out.CrossSubnet = in.CrossSubnet
	out.PrometheusMetricsEnabled = in.PrometheusMetricsEnabled
	out.PrometheusMetricsPort = in.PrometheusMetricsPort
	out.PrometheusGoMetricsEnabled = in.PrometheusGoMetricsEnabled
	out.PrometheusProcessMetricsEnabled = in.PrometheusProcessMetricsEnabled
	return nil
}

// Convert_kops_CalicoNetworkingSpec_To_v1alpha1_CalicoNetworkingSpec is an autogenerated conversion function.
func Convert_kops_CalicoNetworkingSpec_To_v1alpha1_CalicoNetworkingSpec(in *kops.CalicoNetworkingSpec, out *CalicoNetworkingSpec, s conversion.Scope) error {
	return autoConvert_kops_CalicoNetworkingSpec_To_v1alpha1_CalicoNetworkingSpec(in, out, s)
}

func autoConvert_v1alpha1_CanalNetworkingSpec_To_kops_CanalNetworkingSpec(in *CanalNetworkingSpec, out *kops.CanalNetworkingSpec, s conversion.Scope) error {
	out.DefaultEndpointToHostAction = in.DefaultEndpointToHostAction
	out.ChainInsertMode = in.ChainInsertMode
	out.PrometheusMetricsEnabled = in.PrometheusMetricsEnabled
	out.PrometheusMetricsPort = in.PrometheusMetricsPort
	out.PrometheusGoMetricsEnabled = in.PrometheusGoMetricsEnabled
	out.PrometheusProcessMetricsEnabled = in.PrometheusProcessMetricsEnabled
	return nil
}

// Convert_v1alpha1_CanalNetworkingSpec_To_kops_CanalNetworkingSpec is an autogenerated conversion function.
func Convert_v1alpha1_CanalNetworkingSpec_To_kops_CanalNetworkingSpec(in *CanalNetworkingSpec, out *kops.CanalNetworkingSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_CanalNetworkingSpec_To_kops_CanalNetworkingSpec(in, out, s)
}

func autoConvert_kops_CanalNetworkingSpec_To_v1alpha1_CanalNetworkingSpec(in *kops.CanalNetworkingSpec, out *CanalNetworkingSpec, s conversion.Scope) error {
	out.DefaultEndpointToHostAction = in.DefaultEndpointToHostAction
	out.ChainInsertMode = in.ChainInsertMode
	out.PrometheusMetricsEnabled = in.PrometheusMetricsEnabled
	out.PrometheusMetricsPort = in.PrometheusMetricsPort
	out.PrometheusGoMetricsEnabled = in.PrometheusGoMetricsEnabled
	out.PrometheusProcessMetricsEnabled = in.PrometheusProcessMetricsEnabled
	return nil
}

// Convert_kops_CanalNetworkingSpec_To_v1alpha1_CanalNetworkingSpec is an autogenerated conversion function.
func Convert_kops_CanalNetworkingSpec_To_v1alpha1_CanalNetworkingSpec(in *kops.CanalNetworkingSpec, out *CanalNetworkingSpec, s conversion.Scope) error {
	return autoConvert_kops_CanalNetworkingSpec_To_v1alpha1_CanalNetworkingSpec(in, out, s)
}

func autoConvert_v1alpha1_CiliumNetworkingSpec_To_kops_CiliumNetworkingSpec(in *CiliumNetworkingSpec, out *kops.CiliumNetworkingSpec, s conversion.Scope) error {
	out.Debug = in.Debug
	out.Tunnel = in.Tunnel
	return nil
}

// Convert_v1alpha1_CiliumNetworkingSpec_To_kops_CiliumNetworkingSpec is an autogenerated conversion function.
func Convert_v1alpha1_CiliumNetworkingSpec_To_kops_CiliumNetworkingSpec(in *CiliumNetworkingSpec, out *kops.CiliumNetworkingSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_CiliumNetworkingSpec_To_kops_CiliumNetworkingSpec(in, out, s)
}

func autoConvert_kops_CiliumNetworkingSpec_To_v1alpha1_CiliumNetworkingSpec(in *kops.CiliumNetworkingSpec, out *CiliumNetworkingSpec, s conversion.Scope) error {
	out.Debug = in.Debug
	out.Tunnel = in.Tunnel
	return nil
}

// Convert_kops_CiliumNetworkingSpec_To_v1alpha1_CiliumNetworkingSpec is an autogenerated conversion function.
func Convert_kops_CiliumNetworkingSpec_To_v1alpha1_CiliumNetworkingSpec(in *kops.CiliumNetworkingSpec, out *CiliumNetworkingSpec, s conversion.Scope) error {
	return autoConvert_kops_CiliumNetworkingSpec_To_v1alpha1_CiliumNetworkingSpec(in, out, s)
}

func autoConvert_v1alpha1_ClassicNetworkingSpec_To_kops_ClassicNetworkingSpec(in *ClassicNetworkingSpec, out *kops.ClassicNetworkingSpec, s conversion.Scope) error {
	return nil
}

// Convert_v1alpha1_ClassicNetworkingSpec_To_kops_ClassicNetworkingSpec is an autogenerated conversion function.
func Convert_v1alpha1_ClassicNetworkingSpec_To_kops_ClassicNetworkingSpec(in *ClassicNetworkingSpec, out *kops.ClassicNetworkingSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_ClassicNetworkingSpec_To_kops_ClassicNetworkingSpec(in, out, s)
}

func autoConvert_kops_ClassicNetworkingSpec_To_v1alpha1_ClassicNetworkingSpec(in *kops.ClassicNetworkingSpec, out *ClassicNetworkingSpec, s conversion.Scope) error {
	return nil
}

// Convert_kops_ClassicNetworkingSpec_To_v1alpha1_ClassicNetworkingSpec is an autogenerated conversion function.
func Convert_kops_ClassicNetworkingSpec_To_v1alpha1_ClassicNetworkingSpec(in *kops.ClassicNetworkingSpec, out *ClassicNetworkingSpec, s conversion.Scope) error {
	return autoConvert_kops_ClassicNetworkingSpec_To_v1alpha1_ClassicNetworkingSpec(in, out, s)
}

func autoConvert_v1alpha1_CloudConfiguration_To_kops_CloudConfiguration(in *CloudConfiguration, out *kops.CloudConfiguration, s conversion.Scope) error {
	out.Multizone = in.Multizone
	out.NodeTags = in.NodeTags
	out.NodeInstancePrefix = in.NodeInstancePrefix
	out.DisableSecurityGroupIngress = in.DisableSecurityGroupIngress
	out.ElbSecurityGroup = in.ElbSecurityGroup
	out.VSphereUsername = in.VSphereUsername
	out.VSpherePassword = in.VSpherePassword
	out.VSphereServer = in.VSphereServer
	out.VSphereDatacenter = in.VSphereDatacenter
	out.VSphereResourcePool = in.VSphereResourcePool
	out.VSphereDatastore = in.VSphereDatastore
	out.VSphereCoreDNSServer = in.VSphereCoreDNSServer
	return nil
}

// Convert_v1alpha1_CloudConfiguration_To_kops_CloudConfiguration is an autogenerated conversion function.
func Convert_v1alpha1_CloudConfiguration_To_kops_CloudConfiguration(in *CloudConfiguration, out *kops.CloudConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha1_CloudConfiguration_To_kops_CloudConfiguration(in, out, s)
}

func autoConvert_kops_CloudConfiguration_To_v1alpha1_CloudConfiguration(in *kops.CloudConfiguration, out *CloudConfiguration, s conversion.Scope) error {
	out.Multizone = in.Multizone
	out.NodeTags = in.NodeTags
	out.NodeInstancePrefix = in.NodeInstancePrefix
	out.DisableSecurityGroupIngress = in.DisableSecurityGroupIngress
	out.ElbSecurityGroup = in.ElbSecurityGroup
	out.VSphereUsername = in.VSphereUsername
	out.VSpherePassword = in.VSpherePassword
	out.VSphereServer = in.VSphereServer
	out.VSphereDatacenter = in.VSphereDatacenter
	out.VSphereResourcePool = in.VSphereResourcePool
	out.VSphereDatastore = in.VSphereDatastore
	out.VSphereCoreDNSServer = in.VSphereCoreDNSServer
	return nil
}

// Convert_kops_CloudConfiguration_To_v1alpha1_CloudConfiguration is an autogenerated conversion function.
func Convert_kops_CloudConfiguration_To_v1alpha1_CloudConfiguration(in *kops.CloudConfiguration, out *CloudConfiguration, s conversion.Scope) error {
	return autoConvert_kops_CloudConfiguration_To_v1alpha1_CloudConfiguration(in, out, s)
}

func autoConvert_v1alpha1_CloudControllerManagerConfig_To_kops_CloudControllerManagerConfig(in *CloudControllerManagerConfig, out *kops.CloudControllerManagerConfig, s conversion.Scope) error {
	out.Master = in.Master
	out.LogLevel = in.LogLevel
	out.Image = in.Image
	out.CloudProvider = in.CloudProvider
	out.ClusterName = in.ClusterName
	out.ClusterCIDR = in.ClusterCIDR
	out.AllocateNodeCIDRs = in.AllocateNodeCIDRs
	out.ConfigureCloudRoutes = in.ConfigureCloudRoutes
	out.CIDRAllocatorType = in.CIDRAllocatorType
	if in.LeaderElection != nil {
		in, out := &in.LeaderElection, &out.LeaderElection
		*out = new(kops.LeaderElectionConfiguration)
		if err := Convert_v1alpha1_LeaderElectionConfiguration_To_kops_LeaderElectionConfiguration(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.LeaderElection = nil
	}
	out.UseServiceAccountCredentials = in.UseServiceAccountCredentials
	return nil
}

// Convert_v1alpha1_CloudControllerManagerConfig_To_kops_CloudControllerManagerConfig is an autogenerated conversion function.
func Convert_v1alpha1_CloudControllerManagerConfig_To_kops_CloudControllerManagerConfig(in *CloudControllerManagerConfig, out *kops.CloudControllerManagerConfig, s conversion.Scope) error {
	return autoConvert_v1alpha1_CloudControllerManagerConfig_To_kops_CloudControllerManagerConfig(in, out, s)
}

func autoConvert_kops_CloudControllerManagerConfig_To_v1alpha1_CloudControllerManagerConfig(in *kops.CloudControllerManagerConfig, out *CloudControllerManagerConfig, s conversion.Scope) error {
	out.Master = in.Master
	out.LogLevel = in.LogLevel
	out.Image = in.Image
	out.CloudProvider = in.CloudProvider
	out.ClusterName = in.ClusterName
	out.ClusterCIDR = in.ClusterCIDR
	out.AllocateNodeCIDRs = in.AllocateNodeCIDRs
	out.ConfigureCloudRoutes = in.ConfigureCloudRoutes
	out.CIDRAllocatorType = in.CIDRAllocatorType
	if in.LeaderElection != nil {
		in, out := &in.LeaderElection, &out.LeaderElection
		*out = new(LeaderElectionConfiguration)
		if err := Convert_kops_LeaderElectionConfiguration_To_v1alpha1_LeaderElectionConfiguration(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.LeaderElection = nil
	}
	out.UseServiceAccountCredentials = in.UseServiceAccountCredentials
	return nil
}

// Convert_kops_CloudControllerManagerConfig_To_v1alpha1_CloudControllerManagerConfig is an autogenerated conversion function.
func Convert_kops_CloudControllerManagerConfig_To_v1alpha1_CloudControllerManagerConfig(in *kops.CloudControllerManagerConfig, out *CloudControllerManagerConfig, s conversion.Scope) error {
	return autoConvert_kops_CloudControllerManagerConfig_To_v1alpha1_CloudControllerManagerConfig(in, out, s)
}

func autoConvert_v1alpha1_Cluster_To_kops_Cluster(in *Cluster, out *kops.Cluster, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha1_ClusterSpec_To_kops_ClusterSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_Cluster_To_kops_Cluster is an autogenerated conversion function.
func Convert_v1alpha1_Cluster_To_kops_Cluster(in *Cluster, out *kops.Cluster, s conversion.Scope) error {
	return autoConvert_v1alpha1_Cluster_To_kops_Cluster(in, out, s)
}

func autoConvert_kops_Cluster_To_v1alpha1_Cluster(in *kops.Cluster, out *Cluster, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_kops_ClusterSpec_To_v1alpha1_ClusterSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_kops_Cluster_To_v1alpha1_Cluster is an autogenerated conversion function.
func Convert_kops_Cluster_To_v1alpha1_Cluster(in *kops.Cluster, out *Cluster, s conversion.Scope) error {
	return autoConvert_kops_Cluster_To_v1alpha1_Cluster(in, out, s)
}

func autoConvert_v1alpha1_ClusterList_To_kops_ClusterList(in *ClusterList, out *kops.ClusterList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]kops.Cluster, len(*in))
		for i := range *in {
			if err := Convert_v1alpha1_Cluster_To_kops_Cluster(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha1_ClusterList_To_kops_ClusterList is an autogenerated conversion function.
func Convert_v1alpha1_ClusterList_To_kops_ClusterList(in *ClusterList, out *kops.ClusterList, s conversion.Scope) error {
	return autoConvert_v1alpha1_ClusterList_To_kops_ClusterList(in, out, s)
}

func autoConvert_kops_ClusterList_To_v1alpha1_ClusterList(in *kops.ClusterList, out *ClusterList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Cluster, len(*in))
		for i := range *in {
			if err := Convert_kops_Cluster_To_v1alpha1_Cluster(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_kops_ClusterList_To_v1alpha1_ClusterList is an autogenerated conversion function.
func Convert_kops_ClusterList_To_v1alpha1_ClusterList(in *kops.ClusterList, out *ClusterList, s conversion.Scope) error {
	return autoConvert_kops_ClusterList_To_v1alpha1_ClusterList(in, out, s)
}

func autoConvert_v1alpha1_ClusterSpec_To_kops_ClusterSpec(in *ClusterSpec, out *kops.ClusterSpec, s conversion.Scope) error {
	out.Channel = in.Channel
	if in.Addons != nil {
		in, out := &in.Addons, &out.Addons
		*out = make([]kops.AddonSpec, len(*in))
		for i := range *in {
			if err := Convert_v1alpha1_AddonSpec_To_kops_AddonSpec(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Addons = nil
	}
	out.ConfigBase = in.ConfigBase
	out.CloudProvider = in.CloudProvider
	out.KubernetesVersion = in.KubernetesVersion
	// WARNING: in.Zones requires manual conversion: does not exist in peer-type
	out.Project = in.Project
	out.MasterPublicName = in.MasterPublicName
	out.MasterInternalName = in.MasterInternalName
	out.NetworkCIDR = in.NetworkCIDR
	out.AdditionalNetworkCIDRs = in.AdditionalNetworkCIDRs
	out.NetworkID = in.NetworkID
	if in.Topology != nil {
		in, out := &in.Topology, &out.Topology
		*out = new(kops.TopologySpec)
		if err := Convert_v1alpha1_TopologySpec_To_kops_TopologySpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Topology = nil
	}
	out.SecretStore = in.SecretStore
	out.KeyStore = in.KeyStore
	out.ConfigStore = in.ConfigStore
	out.DNSZone = in.DNSZone
	out.AdditionalSANs = in.AdditionalSANs
	out.ClusterDNSDomain = in.ClusterDNSDomain
	// WARNING: in.Multizone requires manual conversion: does not exist in peer-type
	out.ServiceClusterIPRange = in.ServiceClusterIPRange
	out.NonMasqueradeCIDR = in.NonMasqueradeCIDR
	// WARNING: in.AdminAccess requires manual conversion: does not exist in peer-type
	out.IsolateMasters = in.IsolateMasters
	out.UpdatePolicy = in.UpdatePolicy
	out.AdditionalPolicies = in.AdditionalPolicies
	if in.FileAssets != nil {
		in, out := &in.FileAssets, &out.FileAssets
		*out = make([]kops.FileAssetSpec, len(*in))
		for i := range *in {
			if err := Convert_v1alpha1_FileAssetSpec_To_kops_FileAssetSpec(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.FileAssets = nil
	}
	if in.EgressProxy != nil {
		in, out := &in.EgressProxy, &out.EgressProxy
		*out = new(kops.EgressProxySpec)
		if err := Convert_v1alpha1_EgressProxySpec_To_kops_EgressProxySpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.EgressProxy = nil
	}
	out.SSHKeyName = in.SSHKeyName
	if in.EtcdClusters != nil {
		in, out := &in.EtcdClusters, &out.EtcdClusters
		*out = make([]*kops.EtcdClusterSpec, len(*in))
		for i := range *in {
			// TODO: Inefficient conversion - can we improve it?
			if err := s.Convert(&(*in)[i], &(*out)[i], 0); err != nil {
				return err
			}
		}
	} else {
		out.EtcdClusters = nil
	}
	if in.Docker != nil {
		in, out := &in.Docker, &out.Docker
		*out = new(kops.DockerConfig)
		if err := Convert_v1alpha1_DockerConfig_To_kops_DockerConfig(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Docker = nil
	}
	if in.KubeDNS != nil {
		in, out := &in.KubeDNS, &out.KubeDNS
		*out = new(kops.KubeDNSConfig)
		if err := Convert_v1alpha1_KubeDNSConfig_To_kops_KubeDNSConfig(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.KubeDNS = nil
	}
	if in.KubeAPIServer != nil {
		in, out := &in.KubeAPIServer, &out.KubeAPIServer
		*out = new(kops.KubeAPIServerConfig)
		if err := Convert_v1alpha1_KubeAPIServerConfig_To_kops_KubeAPIServerConfig(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.KubeAPIServer = nil
	}
	if in.KubeControllerManager != nil {
		in, out := &in.KubeControllerManager, &out.KubeControllerManager
		*out = new(kops.KubeControllerManagerConfig)
		if err := Convert_v1alpha1_KubeControllerManagerConfig_To_kops_KubeControllerManagerConfig(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.KubeControllerManager = nil
	}
	if in.ExternalCloudControllerManager != nil {
		in, out := &in.ExternalCloudControllerManager, &out.ExternalCloudControllerManager
		*out = new(kops.CloudControllerManagerConfig)
		if err := Convert_v1alpha1_CloudControllerManagerConfig_To_kops_CloudControllerManagerConfig(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ExternalCloudControllerManager = nil
	}
	if in.KubeScheduler != nil {
		in, out := &in.KubeScheduler, &out.KubeScheduler
		*out = new(kops.KubeSchedulerConfig)
		if err := Convert_v1alpha1_KubeSchedulerConfig_To_kops_KubeSchedulerConfig(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.KubeScheduler = nil
	}
	if in.KubeProxy != nil {
		in, out := &in.KubeProxy, &out.KubeProxy
		*out = new(kops.KubeProxyConfig)
		if err := Convert_v1alpha1_KubeProxyConfig_To_kops_KubeProxyConfig(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.KubeProxy = nil
	}
	if in.Kubelet != nil {
		in, out := &in.Kubelet, &out.Kubelet
		*out = new(kops.KubeletConfigSpec)
		if err := Convert_v1alpha1_KubeletConfigSpec_To_kops_KubeletConfigSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Kubelet = nil
	}
	if in.MasterKubelet != nil {
		in, out := &in.MasterKubelet, &out.MasterKubelet
		*out = new(kops.KubeletConfigSpec)
		if err := Convert_v1alpha1_KubeletConfigSpec_To_kops_KubeletConfigSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.MasterKubelet = nil
	}
	if in.CloudConfig != nil {
		in, out := &in.CloudConfig, &out.CloudConfig
		*out = new(kops.CloudConfiguration)
		if err := Convert_v1alpha1_CloudConfiguration_To_kops_CloudConfiguration(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.CloudConfig = nil
	}
	if in.ExternalDNS != nil {
		in, out := &in.ExternalDNS, &out.ExternalDNS
		*out = new(kops.ExternalDNSConfig)
		if err := Convert_v1alpha1_ExternalDNSConfig_To_kops_ExternalDNSConfig(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ExternalDNS = nil
	}
	if in.Networking != nil {
		in, out := &in.Networking, &out.Networking
		*out = new(kops.NetworkingSpec)
		if err := Convert_v1alpha1_NetworkingSpec_To_kops_NetworkingSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Networking = nil
	}
	if in.API != nil {
		in, out := &in.API, &out.API
		*out = new(kops.AccessSpec)
		if err := Convert_v1alpha1_AccessSpec_To_kops_AccessSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.API = nil
	}
	if in.Authentication != nil {
		in, out := &in.Authentication, &out.Authentication
		*out = new(kops.AuthenticationSpec)
		if err := Convert_v1alpha1_AuthenticationSpec_To_kops_AuthenticationSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Authentication = nil
	}
	if in.Authorization != nil {
		in, out := &in.Authorization, &out.Authorization
		*out = new(kops.AuthorizationSpec)
		if err := Convert_v1alpha1_AuthorizationSpec_To_kops_AuthorizationSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Authorization = nil
	}
	out.CloudLabels = in.CloudLabels
	if in.Hooks != nil {
		in, out := &in.Hooks, &out.Hooks
		*out = make([]kops.HookSpec, len(*in))
		for i := range *in {
			if err := Convert_v1alpha1_HookSpec_To_kops_HookSpec(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Hooks = nil
	}
	if in.Assets != nil {
		in, out := &in.Assets, &out.Assets
		*out = new(kops.Assets)
		if err := Convert_v1alpha1_Assets_To_kops_Assets(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Assets = nil
	}
	if in.IAM != nil {
		in, out := &in.IAM, &out.IAM
		*out = new(kops.IAMSpec)
		if err := Convert_v1alpha1_IAMSpec_To_kops_IAMSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.IAM = nil
	}
	out.EncryptionConfig = in.EncryptionConfig
	if in.Target != nil {
		in, out := &in.Target, &out.Target
		*out = new(kops.TargetSpec)
		if err := Convert_v1alpha1_TargetSpec_To_kops_TargetSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Target = nil
	}
	return nil
}

func autoConvert_kops_ClusterSpec_To_v1alpha1_ClusterSpec(in *kops.ClusterSpec, out *ClusterSpec, s conversion.Scope) error {
	out.Channel = in.Channel
	if in.Addons != nil {
		in, out := &in.Addons, &out.Addons
		*out = make([]AddonSpec, len(*in))
		for i := range *in {
			if err := Convert_kops_AddonSpec_To_v1alpha1_AddonSpec(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Addons = nil
	}
	out.ConfigBase = in.ConfigBase
	out.CloudProvider = in.CloudProvider
	out.KubernetesVersion = in.KubernetesVersion
	// WARNING: in.Subnets requires manual conversion: does not exist in peer-type
	out.Project = in.Project
	out.MasterPublicName = in.MasterPublicName
	out.MasterInternalName = in.MasterInternalName
	out.NetworkCIDR = in.NetworkCIDR
	out.AdditionalNetworkCIDRs = in.AdditionalNetworkCIDRs
	out.NetworkID = in.NetworkID
	if in.Topology != nil {
		in, out := &in.Topology, &out.Topology
		*out = new(TopologySpec)
		if err := Convert_kops_TopologySpec_To_v1alpha1_TopologySpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Topology = nil
	}
	out.SecretStore = in.SecretStore
	out.KeyStore = in.KeyStore
	out.ConfigStore = in.ConfigStore
	out.DNSZone = in.DNSZone
	out.AdditionalSANs = in.AdditionalSANs
	out.ClusterDNSDomain = in.ClusterDNSDomain
	out.ServiceClusterIPRange = in.ServiceClusterIPRange
	out.NonMasqueradeCIDR = in.NonMasqueradeCIDR
	// WARNING: in.SSHAccess requires manual conversion: does not exist in peer-type
	// WARNING: in.NodePortAccess requires manual conversion: does not exist in peer-type
	if in.EgressProxy != nil {
		in, out := &in.EgressProxy, &out.EgressProxy
		*out = new(EgressProxySpec)
		if err := Convert_kops_EgressProxySpec_To_v1alpha1_EgressProxySpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.EgressProxy = nil
	}
	out.SSHKeyName = in.SSHKeyName
	// WARNING: in.KubernetesAPIAccess requires manual conversion: does not exist in peer-type
	out.IsolateMasters = in.IsolateMasters
	out.UpdatePolicy = in.UpdatePolicy
	out.AdditionalPolicies = in.AdditionalPolicies
	if in.FileAssets != nil {
		in, out := &in.FileAssets, &out.FileAssets
		*out = make([]FileAssetSpec, len(*in))
		for i := range *in {
			if err := Convert_kops_FileAssetSpec_To_v1alpha1_FileAssetSpec(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.FileAssets = nil
	}
	if in.EtcdClusters != nil {
		in, out := &in.EtcdClusters, &out.EtcdClusters
		*out = make([]*EtcdClusterSpec, len(*in))
		for i := range *in {
			// TODO: Inefficient conversion - can we improve it?
			if err := s.Convert(&(*in)[i], &(*out)[i], 0); err != nil {
				return err
			}
		}
	} else {
		out.EtcdClusters = nil
	}
	if in.Docker != nil {
		in, out := &in.Docker, &out.Docker
		*out = new(DockerConfig)
		if err := Convert_kops_DockerConfig_To_v1alpha1_DockerConfig(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Docker = nil
	}
	if in.KubeDNS != nil {
		in, out := &in.KubeDNS, &out.KubeDNS
		*out = new(KubeDNSConfig)
		if err := Convert_kops_KubeDNSConfig_To_v1alpha1_KubeDNSConfig(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.KubeDNS = nil
	}
	if in.KubeAPIServer != nil {
		in, out := &in.KubeAPIServer, &out.KubeAPIServer
		*out = new(KubeAPIServerConfig)
		if err := Convert_kops_KubeAPIServerConfig_To_v1alpha1_KubeAPIServerConfig(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.KubeAPIServer = nil
	}
	if in.KubeControllerManager != nil {
		in, out := &in.KubeControllerManager, &out.KubeControllerManager
		*out = new(KubeControllerManagerConfig)
		if err := Convert_kops_KubeControllerManagerConfig_To_v1alpha1_KubeControllerManagerConfig(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.KubeControllerManager = nil
	}
	if in.ExternalCloudControllerManager != nil {
		in, out := &in.ExternalCloudControllerManager, &out.ExternalCloudControllerManager
		*out = new(CloudControllerManagerConfig)
		if err := Convert_kops_CloudControllerManagerConfig_To_v1alpha1_CloudControllerManagerConfig(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ExternalCloudControllerManager = nil
	}
	if in.KubeScheduler != nil {
		in, out := &in.KubeScheduler, &out.KubeScheduler
		*out = new(KubeSchedulerConfig)
		if err := Convert_kops_KubeSchedulerConfig_To_v1alpha1_KubeSchedulerConfig(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.KubeScheduler = nil
	}
	if in.KubeProxy != nil {
		in, out := &in.KubeProxy, &out.KubeProxy
		*out = new(KubeProxyConfig)
		if err := Convert_kops_KubeProxyConfig_To_v1alpha1_KubeProxyConfig(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.KubeProxy = nil
	}
	if in.Kubelet != nil {
		in, out := &in.Kubelet, &out.Kubelet
		*out = new(KubeletConfigSpec)
		if err := Convert_kops_KubeletConfigSpec_To_v1alpha1_KubeletConfigSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Kubelet = nil
	}
	if in.MasterKubelet != nil {
		in, out := &in.MasterKubelet, &out.MasterKubelet
		*out = new(KubeletConfigSpec)
		if err := Convert_kops_KubeletConfigSpec_To_v1alpha1_KubeletConfigSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.MasterKubelet = nil
	}
	if in.CloudConfig != nil {
		in, out := &in.CloudConfig, &out.CloudConfig
		*out = new(CloudConfiguration)
		if err := Convert_kops_CloudConfiguration_To_v1alpha1_CloudConfiguration(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.CloudConfig = nil
	}
	if in.ExternalDNS != nil {
		in, out := &in.ExternalDNS, &out.ExternalDNS
		*out = new(ExternalDNSConfig)
		if err := Convert_kops_ExternalDNSConfig_To_v1alpha1_ExternalDNSConfig(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ExternalDNS = nil
	}
	if in.Networking != nil {
		in, out := &in.Networking, &out.Networking
		*out = new(NetworkingSpec)
		if err := Convert_kops_NetworkingSpec_To_v1alpha1_NetworkingSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Networking = nil
	}
	if in.API != nil {
		in, out := &in.API, &out.API
		*out = new(AccessSpec)
		if err := Convert_kops_AccessSpec_To_v1alpha1_AccessSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.API = nil
	}
	if in.Authentication != nil {
		in, out := &in.Authentication, &out.Authentication
		*out = new(AuthenticationSpec)
		if err := Convert_kops_AuthenticationSpec_To_v1alpha1_AuthenticationSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Authentication = nil
	}
	if in.Authorization != nil {
		in, out := &in.Authorization, &out.Authorization
		*out = new(AuthorizationSpec)
		if err := Convert_kops_AuthorizationSpec_To_v1alpha1_AuthorizationSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Authorization = nil
	}
	out.CloudLabels = in.CloudLabels
	if in.Hooks != nil {
		in, out := &in.Hooks, &out.Hooks
		*out = make([]HookSpec, len(*in))
		for i := range *in {
			if err := Convert_kops_HookSpec_To_v1alpha1_HookSpec(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Hooks = nil
	}
	if in.Assets != nil {
		in, out := &in.Assets, &out.Assets
		*out = new(Assets)
		if err := Convert_kops_Assets_To_v1alpha1_Assets(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Assets = nil
	}
	if in.IAM != nil {
		in, out := &in.IAM, &out.IAM
		*out = new(IAMSpec)
		if err := Convert_kops_IAMSpec_To_v1alpha1_IAMSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.IAM = nil
	}
	out.EncryptionConfig = in.EncryptionConfig
	if in.Target != nil {
		in, out := &in.Target, &out.Target
		*out = new(TargetSpec)
		if err := Convert_kops_TargetSpec_To_v1alpha1_TargetSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Target = nil
	}
	return nil
}

func autoConvert_v1alpha1_DNSAccessSpec_To_kops_DNSAccessSpec(in *DNSAccessSpec, out *kops.DNSAccessSpec, s conversion.Scope) error {
	return nil
}

// Convert_v1alpha1_DNSAccessSpec_To_kops_DNSAccessSpec is an autogenerated conversion function.
func Convert_v1alpha1_DNSAccessSpec_To_kops_DNSAccessSpec(in *DNSAccessSpec, out *kops.DNSAccessSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_DNSAccessSpec_To_kops_DNSAccessSpec(in, out, s)
}

func autoConvert_kops_DNSAccessSpec_To_v1alpha1_DNSAccessSpec(in *kops.DNSAccessSpec, out *DNSAccessSpec, s conversion.Scope) error {
	return nil
}

// Convert_kops_DNSAccessSpec_To_v1alpha1_DNSAccessSpec is an autogenerated conversion function.
func Convert_kops_DNSAccessSpec_To_v1alpha1_DNSAccessSpec(in *kops.DNSAccessSpec, out *DNSAccessSpec, s conversion.Scope) error {
	return autoConvert_kops_DNSAccessSpec_To_v1alpha1_DNSAccessSpec(in, out, s)
}

func autoConvert_v1alpha1_DNSSpec_To_kops_DNSSpec(in *DNSSpec, out *kops.DNSSpec, s conversion.Scope) error {
	out.Type = kops.DNSType(in.Type)
	return nil
}

// Convert_v1alpha1_DNSSpec_To_kops_DNSSpec is an autogenerated conversion function.
func Convert_v1alpha1_DNSSpec_To_kops_DNSSpec(in *DNSSpec, out *kops.DNSSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_DNSSpec_To_kops_DNSSpec(in, out, s)
}

func autoConvert_kops_DNSSpec_To_v1alpha1_DNSSpec(in *kops.DNSSpec, out *DNSSpec, s conversion.Scope) error {
	out.Type = DNSType(in.Type)
	return nil
}

// Convert_kops_DNSSpec_To_v1alpha1_DNSSpec is an autogenerated conversion function.
func Convert_kops_DNSSpec_To_v1alpha1_DNSSpec(in *kops.DNSSpec, out *DNSSpec, s conversion.Scope) error {
	return autoConvert_kops_DNSSpec_To_v1alpha1_DNSSpec(in, out, s)
}

func autoConvert_v1alpha1_DockerConfig_To_kops_DockerConfig(in *DockerConfig, out *kops.DockerConfig, s conversion.Scope) error {
	out.AuthorizationPlugins = in.AuthorizationPlugins
	out.Bridge = in.Bridge
	out.BridgeIP = in.BridgeIP
	out.DefaultUlimit = in.DefaultUlimit
	out.Hosts = in.Hosts
	out.IPMasq = in.IPMasq
	out.IPTables = in.IPTables
	out.InsecureRegistry = in.InsecureRegistry
	out.LiveRestore = in.LiveRestore
	if err := v1.Convert_Pointer_string_To_string(&in.LogDriver, &out.LogDriver, s); err != nil {
		return err
	}
	out.LogLevel = in.LogLevel
	out.LogOpt = in.LogOpt
	out.MTU = in.MTU
	out.RegistryMirrors = in.RegistryMirrors
	out.Storage = in.Storage
	out.StorageOpts = in.StorageOpts
	out.Version = in.Version
	return nil
}

// Convert_v1alpha1_DockerConfig_To_kops_DockerConfig is an autogenerated conversion function.
func Convert_v1alpha1_DockerConfig_To_kops_DockerConfig(in *DockerConfig, out *kops.DockerConfig, s conversion.Scope) error {
	return autoConvert_v1alpha1_DockerConfig_To_kops_DockerConfig(in, out, s)
}

func autoConvert_kops_DockerConfig_To_v1alpha1_DockerConfig(in *kops.DockerConfig, out *DockerConfig, s conversion.Scope) error {
	out.AuthorizationPlugins = in.AuthorizationPlugins
	out.Bridge = in.Bridge
	out.BridgeIP = in.BridgeIP
	out.DefaultUlimit = in.DefaultUlimit
	out.Hosts = in.Hosts
	out.IPMasq = in.IPMasq
	out.IPTables = in.IPTables
	out.InsecureRegistry = in.InsecureRegistry
	out.LiveRestore = in.LiveRestore
	if err := v1.Convert_string_To_Pointer_string(&in.LogDriver, &out.LogDriver, s); err != nil {
		return err
	}
	out.LogLevel = in.LogLevel
	out.LogOpt = in.LogOpt
	out.MTU = in.MTU
	out.RegistryMirrors = in.RegistryMirrors
	out.Storage = in.Storage
	out.StorageOpts = in.StorageOpts
	out.Version = in.Version
	return nil
}

// Convert_kops_DockerConfig_To_v1alpha1_DockerConfig is an autogenerated conversion function.
func Convert_kops_DockerConfig_To_v1alpha1_DockerConfig(in *kops.DockerConfig, out *DockerConfig, s conversion.Scope) error {
	return autoConvert_kops_DockerConfig_To_v1alpha1_DockerConfig(in, out, s)
}

func autoConvert_v1alpha1_EgressProxySpec_To_kops_EgressProxySpec(in *EgressProxySpec, out *kops.EgressProxySpec, s conversion.Scope) error {
	if err := Convert_v1alpha1_HTTPProxy_To_kops_HTTPProxy(&in.HTTPProxy, &out.HTTPProxy, s); err != nil {
		return err
	}
	out.ProxyExcludes = in.ProxyExcludes
	return nil
}

// Convert_v1alpha1_EgressProxySpec_To_kops_EgressProxySpec is an autogenerated conversion function.
func Convert_v1alpha1_EgressProxySpec_To_kops_EgressProxySpec(in *EgressProxySpec, out *kops.EgressProxySpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_EgressProxySpec_To_kops_EgressProxySpec(in, out, s)
}

func autoConvert_kops_EgressProxySpec_To_v1alpha1_EgressProxySpec(in *kops.EgressProxySpec, out *EgressProxySpec, s conversion.Scope) error {
	if err := Convert_kops_HTTPProxy_To_v1alpha1_HTTPProxy(&in.HTTPProxy, &out.HTTPProxy, s); err != nil {
		return err
	}
	out.ProxyExcludes = in.ProxyExcludes
	return nil
}

// Convert_kops_EgressProxySpec_To_v1alpha1_EgressProxySpec is an autogenerated conversion function.
func Convert_kops_EgressProxySpec_To_v1alpha1_EgressProxySpec(in *kops.EgressProxySpec, out *EgressProxySpec, s conversion.Scope) error {
	return autoConvert_kops_EgressProxySpec_To_v1alpha1_EgressProxySpec(in, out, s)
}

func autoConvert_v1alpha1_EtcdBackupSpec_To_kops_EtcdBackupSpec(in *EtcdBackupSpec, out *kops.EtcdBackupSpec, s conversion.Scope) error {
	out.BackupStore = in.BackupStore
	out.Image = in.Image
	return nil
}

// Convert_v1alpha1_EtcdBackupSpec_To_kops_EtcdBackupSpec is an autogenerated conversion function.
func Convert_v1alpha1_EtcdBackupSpec_To_kops_EtcdBackupSpec(in *EtcdBackupSpec, out *kops.EtcdBackupSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_EtcdBackupSpec_To_kops_EtcdBackupSpec(in, out, s)
}

func autoConvert_kops_EtcdBackupSpec_To_v1alpha1_EtcdBackupSpec(in *kops.EtcdBackupSpec, out *EtcdBackupSpec, s conversion.Scope) error {
	out.BackupStore = in.BackupStore
	out.Image = in.Image
	return nil
}

// Convert_kops_EtcdBackupSpec_To_v1alpha1_EtcdBackupSpec is an autogenerated conversion function.
func Convert_kops_EtcdBackupSpec_To_v1alpha1_EtcdBackupSpec(in *kops.EtcdBackupSpec, out *EtcdBackupSpec, s conversion.Scope) error {
	return autoConvert_kops_EtcdBackupSpec_To_v1alpha1_EtcdBackupSpec(in, out, s)
}

func autoConvert_v1alpha1_EtcdClusterSpec_To_kops_EtcdClusterSpec(in *EtcdClusterSpec, out *kops.EtcdClusterSpec, s conversion.Scope) error {
	out.Name = in.Name
	if in.Members != nil {
		in, out := &in.Members, &out.Members
		*out = make([]*kops.EtcdMemberSpec, len(*in))
		for i := range *in {
			// TODO: Inefficient conversion - can we improve it?
			if err := s.Convert(&(*in)[i], &(*out)[i], 0); err != nil {
				return err
			}
		}
	} else {
		out.Members = nil
	}
	out.EnableTLSAuth = in.EnableTLSAuth
	out.EnableEtcdTLS = in.EnableEtcdTLS
	out.Version = in.Version
	out.LeaderElectionTimeout = in.LeaderElectionTimeout
	out.HeartbeatInterval = in.HeartbeatInterval
	out.Image = in.Image
	if in.Backups != nil {
		in, out := &in.Backups, &out.Backups
		*out = new(kops.EtcdBackupSpec)
		if err := Convert_v1alpha1_EtcdBackupSpec_To_kops_EtcdBackupSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Backups = nil
	}
	return nil
}

// Convert_v1alpha1_EtcdClusterSpec_To_kops_EtcdClusterSpec is an autogenerated conversion function.
func Convert_v1alpha1_EtcdClusterSpec_To_kops_EtcdClusterSpec(in *EtcdClusterSpec, out *kops.EtcdClusterSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_EtcdClusterSpec_To_kops_EtcdClusterSpec(in, out, s)
}

func autoConvert_kops_EtcdClusterSpec_To_v1alpha1_EtcdClusterSpec(in *kops.EtcdClusterSpec, out *EtcdClusterSpec, s conversion.Scope) error {
	out.Name = in.Name
	if in.Members != nil {
		in, out := &in.Members, &out.Members
		*out = make([]*EtcdMemberSpec, len(*in))
		for i := range *in {
			// TODO: Inefficient conversion - can we improve it?
			if err := s.Convert(&(*in)[i], &(*out)[i], 0); err != nil {
				return err
			}
		}
	} else {
		out.Members = nil
	}
	out.EnableEtcdTLS = in.EnableEtcdTLS
	out.EnableTLSAuth = in.EnableTLSAuth
	out.Version = in.Version
	out.LeaderElectionTimeout = in.LeaderElectionTimeout
	out.HeartbeatInterval = in.HeartbeatInterval
	out.Image = in.Image
	if in.Backups != nil {
		in, out := &in.Backups, &out.Backups
		*out = new(EtcdBackupSpec)
		if err := Convert_kops_EtcdBackupSpec_To_v1alpha1_EtcdBackupSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Backups = nil
	}
	return nil
}

// Convert_kops_EtcdClusterSpec_To_v1alpha1_EtcdClusterSpec is an autogenerated conversion function.
func Convert_kops_EtcdClusterSpec_To_v1alpha1_EtcdClusterSpec(in *kops.EtcdClusterSpec, out *EtcdClusterSpec, s conversion.Scope) error {
	return autoConvert_kops_EtcdClusterSpec_To_v1alpha1_EtcdClusterSpec(in, out, s)
}

func autoConvert_v1alpha1_EtcdMemberSpec_To_kops_EtcdMemberSpec(in *EtcdMemberSpec, out *kops.EtcdMemberSpec, s conversion.Scope) error {
	out.Name = in.Name
	// WARNING: in.Zone requires manual conversion: does not exist in peer-type
	out.VolumeType = in.VolumeType
	out.VolumeIops = in.VolumeIops
	out.VolumeSize = in.VolumeSize
	out.KmsKeyId = in.KmsKeyId
	out.EncryptedVolume = in.EncryptedVolume
	return nil
}

func autoConvert_kops_EtcdMemberSpec_To_v1alpha1_EtcdMemberSpec(in *kops.EtcdMemberSpec, out *EtcdMemberSpec, s conversion.Scope) error {
	out.Name = in.Name
	// WARNING: in.InstanceGroup requires manual conversion: does not exist in peer-type
	out.VolumeType = in.VolumeType
	out.VolumeIops = in.VolumeIops
	out.VolumeSize = in.VolumeSize
	out.KmsKeyId = in.KmsKeyId
	out.EncryptedVolume = in.EncryptedVolume
	return nil
}

func autoConvert_v1alpha1_ExecContainerAction_To_kops_ExecContainerAction(in *ExecContainerAction, out *kops.ExecContainerAction, s conversion.Scope) error {
	out.Image = in.Image
	out.Command = in.Command
	out.Environment = in.Environment
	return nil
}

// Convert_v1alpha1_ExecContainerAction_To_kops_ExecContainerAction is an autogenerated conversion function.
func Convert_v1alpha1_ExecContainerAction_To_kops_ExecContainerAction(in *ExecContainerAction, out *kops.ExecContainerAction, s conversion.Scope) error {
	return autoConvert_v1alpha1_ExecContainerAction_To_kops_ExecContainerAction(in, out, s)
}

func autoConvert_kops_ExecContainerAction_To_v1alpha1_ExecContainerAction(in *kops.ExecContainerAction, out *ExecContainerAction, s conversion.Scope) error {
	out.Image = in.Image
	out.Command = in.Command
	out.Environment = in.Environment
	return nil
}

// Convert_kops_ExecContainerAction_To_v1alpha1_ExecContainerAction is an autogenerated conversion function.
func Convert_kops_ExecContainerAction_To_v1alpha1_ExecContainerAction(in *kops.ExecContainerAction, out *ExecContainerAction, s conversion.Scope) error {
	return autoConvert_kops_ExecContainerAction_To_v1alpha1_ExecContainerAction(in, out, s)
}

func autoConvert_v1alpha1_ExternalDNSConfig_To_kops_ExternalDNSConfig(in *ExternalDNSConfig, out *kops.ExternalDNSConfig, s conversion.Scope) error {
	out.Disable = in.Disable
	out.WatchIngress = in.WatchIngress
	out.WatchNamespace = in.WatchNamespace
	return nil
}

// Convert_v1alpha1_ExternalDNSConfig_To_kops_ExternalDNSConfig is an autogenerated conversion function.
func Convert_v1alpha1_ExternalDNSConfig_To_kops_ExternalDNSConfig(in *ExternalDNSConfig, out *kops.ExternalDNSConfig, s conversion.Scope) error {
	return autoConvert_v1alpha1_ExternalDNSConfig_To_kops_ExternalDNSConfig(in, out, s)
}

func autoConvert_kops_ExternalDNSConfig_To_v1alpha1_ExternalDNSConfig(in *kops.ExternalDNSConfig, out *ExternalDNSConfig, s conversion.Scope) error {
	out.Disable = in.Disable
	out.WatchIngress = in.WatchIngress
	out.WatchNamespace = in.WatchNamespace
	return nil
}

// Convert_kops_ExternalDNSConfig_To_v1alpha1_ExternalDNSConfig is an autogenerated conversion function.
func Convert_kops_ExternalDNSConfig_To_v1alpha1_ExternalDNSConfig(in *kops.ExternalDNSConfig, out *ExternalDNSConfig, s conversion.Scope) error {
	return autoConvert_kops_ExternalDNSConfig_To_v1alpha1_ExternalDNSConfig(in, out, s)
}

func autoConvert_v1alpha1_ExternalNetworkingSpec_To_kops_ExternalNetworkingSpec(in *ExternalNetworkingSpec, out *kops.ExternalNetworkingSpec, s conversion.Scope) error {
	return nil
}

// Convert_v1alpha1_ExternalNetworkingSpec_To_kops_ExternalNetworkingSpec is an autogenerated conversion function.
func Convert_v1alpha1_ExternalNetworkingSpec_To_kops_ExternalNetworkingSpec(in *ExternalNetworkingSpec, out *kops.ExternalNetworkingSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_ExternalNetworkingSpec_To_kops_ExternalNetworkingSpec(in, out, s)
}

func autoConvert_kops_ExternalNetworkingSpec_To_v1alpha1_ExternalNetworkingSpec(in *kops.ExternalNetworkingSpec, out *ExternalNetworkingSpec, s conversion.Scope) error {
	return nil
}

// Convert_kops_ExternalNetworkingSpec_To_v1alpha1_ExternalNetworkingSpec is an autogenerated conversion function.
func Convert_kops_ExternalNetworkingSpec_To_v1alpha1_ExternalNetworkingSpec(in *kops.ExternalNetworkingSpec, out *ExternalNetworkingSpec, s conversion.Scope) error {
	return autoConvert_kops_ExternalNetworkingSpec_To_v1alpha1_ExternalNetworkingSpec(in, out, s)
}

func autoConvert_v1alpha1_FileAssetSpec_To_kops_FileAssetSpec(in *FileAssetSpec, out *kops.FileAssetSpec, s conversion.Scope) error {
	out.Name = in.Name
	out.Path = in.Path
	if in.Roles != nil {
		in, out := &in.Roles, &out.Roles
		*out = make([]kops.InstanceGroupRole, len(*in))
		for i := range *in {
			(*out)[i] = kops.InstanceGroupRole((*in)[i])
		}
	} else {
		out.Roles = nil
	}
	out.Content = in.Content
	out.IsBase64 = in.IsBase64
	return nil
}

// Convert_v1alpha1_FileAssetSpec_To_kops_FileAssetSpec is an autogenerated conversion function.
func Convert_v1alpha1_FileAssetSpec_To_kops_FileAssetSpec(in *FileAssetSpec, out *kops.FileAssetSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_FileAssetSpec_To_kops_FileAssetSpec(in, out, s)
}

func autoConvert_kops_FileAssetSpec_To_v1alpha1_FileAssetSpec(in *kops.FileAssetSpec, out *FileAssetSpec, s conversion.Scope) error {
	out.Name = in.Name
	out.Path = in.Path
	if in.Roles != nil {
		in, out := &in.Roles, &out.Roles
		*out = make([]InstanceGroupRole, len(*in))
		for i := range *in {
			(*out)[i] = InstanceGroupRole((*in)[i])
		}
	} else {
		out.Roles = nil
	}
	out.Content = in.Content
	out.IsBase64 = in.IsBase64
	return nil
}

// Convert_kops_FileAssetSpec_To_v1alpha1_FileAssetSpec is an autogenerated conversion function.
func Convert_kops_FileAssetSpec_To_v1alpha1_FileAssetSpec(in *kops.FileAssetSpec, out *FileAssetSpec, s conversion.Scope) error {
	return autoConvert_kops_FileAssetSpec_To_v1alpha1_FileAssetSpec(in, out, s)
}

func autoConvert_v1alpha1_FlannelNetworkingSpec_To_kops_FlannelNetworkingSpec(in *FlannelNetworkingSpec, out *kops.FlannelNetworkingSpec, s conversion.Scope) error {
	out.Backend = in.Backend
	return nil
}

// Convert_v1alpha1_FlannelNetworkingSpec_To_kops_FlannelNetworkingSpec is an autogenerated conversion function.
func Convert_v1alpha1_FlannelNetworkingSpec_To_kops_FlannelNetworkingSpec(in *FlannelNetworkingSpec, out *kops.FlannelNetworkingSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_FlannelNetworkingSpec_To_kops_FlannelNetworkingSpec(in, out, s)
}

func autoConvert_kops_FlannelNetworkingSpec_To_v1alpha1_FlannelNetworkingSpec(in *kops.FlannelNetworkingSpec, out *FlannelNetworkingSpec, s conversion.Scope) error {
	out.Backend = in.Backend
	return nil
}

// Convert_kops_FlannelNetworkingSpec_To_v1alpha1_FlannelNetworkingSpec is an autogenerated conversion function.
func Convert_kops_FlannelNetworkingSpec_To_v1alpha1_FlannelNetworkingSpec(in *kops.FlannelNetworkingSpec, out *FlannelNetworkingSpec, s conversion.Scope) error {
	return autoConvert_kops_FlannelNetworkingSpec_To_v1alpha1_FlannelNetworkingSpec(in, out, s)
}

func autoConvert_v1alpha1_HTTPProxy_To_kops_HTTPProxy(in *HTTPProxy, out *kops.HTTPProxy, s conversion.Scope) error {
	out.Host = in.Host
	out.Port = in.Port
	return nil
}

// Convert_v1alpha1_HTTPProxy_To_kops_HTTPProxy is an autogenerated conversion function.
func Convert_v1alpha1_HTTPProxy_To_kops_HTTPProxy(in *HTTPProxy, out *kops.HTTPProxy, s conversion.Scope) error {
	return autoConvert_v1alpha1_HTTPProxy_To_kops_HTTPProxy(in, out, s)
}

func autoConvert_kops_HTTPProxy_To_v1alpha1_HTTPProxy(in *kops.HTTPProxy, out *HTTPProxy, s conversion.Scope) error {
	out.Host = in.Host
	out.Port = in.Port
	return nil
}

// Convert_kops_HTTPProxy_To_v1alpha1_HTTPProxy is an autogenerated conversion function.
func Convert_kops_HTTPProxy_To_v1alpha1_HTTPProxy(in *kops.HTTPProxy, out *HTTPProxy, s conversion.Scope) error {
	return autoConvert_kops_HTTPProxy_To_v1alpha1_HTTPProxy(in, out, s)
}

func autoConvert_v1alpha1_HookSpec_To_kops_HookSpec(in *HookSpec, out *kops.HookSpec, s conversion.Scope) error {
	out.Name = in.Name
	out.Disabled = in.Disabled
	if in.Roles != nil {
		in, out := &in.Roles, &out.Roles
		*out = make([]kops.InstanceGroupRole, len(*in))
		for i := range *in {
			(*out)[i] = kops.InstanceGroupRole((*in)[i])
		}
	} else {
		out.Roles = nil
	}
	out.Requires = in.Requires
	out.Before = in.Before
	if in.ExecContainer != nil {
		in, out := &in.ExecContainer, &out.ExecContainer
		*out = new(kops.ExecContainerAction)
		if err := Convert_v1alpha1_ExecContainerAction_To_kops_ExecContainerAction(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ExecContainer = nil
	}
	out.Manifest = in.Manifest
	return nil
}

// Convert_v1alpha1_HookSpec_To_kops_HookSpec is an autogenerated conversion function.
func Convert_v1alpha1_HookSpec_To_kops_HookSpec(in *HookSpec, out *kops.HookSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_HookSpec_To_kops_HookSpec(in, out, s)
}

func autoConvert_kops_HookSpec_To_v1alpha1_HookSpec(in *kops.HookSpec, out *HookSpec, s conversion.Scope) error {
	out.Name = in.Name
	out.Disabled = in.Disabled
	if in.Roles != nil {
		in, out := &in.Roles, &out.Roles
		*out = make([]InstanceGroupRole, len(*in))
		for i := range *in {
			(*out)[i] = InstanceGroupRole((*in)[i])
		}
	} else {
		out.Roles = nil
	}
	out.Requires = in.Requires
	out.Before = in.Before
	if in.ExecContainer != nil {
		in, out := &in.ExecContainer, &out.ExecContainer
		*out = new(ExecContainerAction)
		if err := Convert_kops_ExecContainerAction_To_v1alpha1_ExecContainerAction(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ExecContainer = nil
	}
	out.Manifest = in.Manifest
	return nil
}

// Convert_kops_HookSpec_To_v1alpha1_HookSpec is an autogenerated conversion function.
func Convert_kops_HookSpec_To_v1alpha1_HookSpec(in *kops.HookSpec, out *HookSpec, s conversion.Scope) error {
	return autoConvert_kops_HookSpec_To_v1alpha1_HookSpec(in, out, s)
}

func autoConvert_v1alpha1_IAMSpec_To_kops_IAMSpec(in *IAMSpec, out *kops.IAMSpec, s conversion.Scope) error {
	out.Legacy = in.Legacy
	out.AllowContainerRegistry = in.AllowContainerRegistry
	return nil
}

// Convert_v1alpha1_IAMSpec_To_kops_IAMSpec is an autogenerated conversion function.
func Convert_v1alpha1_IAMSpec_To_kops_IAMSpec(in *IAMSpec, out *kops.IAMSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_IAMSpec_To_kops_IAMSpec(in, out, s)
}

func autoConvert_kops_IAMSpec_To_v1alpha1_IAMSpec(in *kops.IAMSpec, out *IAMSpec, s conversion.Scope) error {
	out.Legacy = in.Legacy
	out.AllowContainerRegistry = in.AllowContainerRegistry
	return nil
}

// Convert_kops_IAMSpec_To_v1alpha1_IAMSpec is an autogenerated conversion function.
func Convert_kops_IAMSpec_To_v1alpha1_IAMSpec(in *kops.IAMSpec, out *IAMSpec, s conversion.Scope) error {
	return autoConvert_kops_IAMSpec_To_v1alpha1_IAMSpec(in, out, s)
}

func autoConvert_v1alpha1_InstanceGroup_To_kops_InstanceGroup(in *InstanceGroup, out *kops.InstanceGroup, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha1_InstanceGroupSpec_To_kops_InstanceGroupSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_InstanceGroup_To_kops_InstanceGroup is an autogenerated conversion function.
func Convert_v1alpha1_InstanceGroup_To_kops_InstanceGroup(in *InstanceGroup, out *kops.InstanceGroup, s conversion.Scope) error {
	return autoConvert_v1alpha1_InstanceGroup_To_kops_InstanceGroup(in, out, s)
}

func autoConvert_kops_InstanceGroup_To_v1alpha1_InstanceGroup(in *kops.InstanceGroup, out *InstanceGroup, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_kops_InstanceGroupSpec_To_v1alpha1_InstanceGroupSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_kops_InstanceGroup_To_v1alpha1_InstanceGroup is an autogenerated conversion function.
func Convert_kops_InstanceGroup_To_v1alpha1_InstanceGroup(in *kops.InstanceGroup, out *InstanceGroup, s conversion.Scope) error {
	return autoConvert_kops_InstanceGroup_To_v1alpha1_InstanceGroup(in, out, s)
}

func autoConvert_v1alpha1_InstanceGroupList_To_kops_InstanceGroupList(in *InstanceGroupList, out *kops.InstanceGroupList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]kops.InstanceGroup, len(*in))
		for i := range *in {
			if err := Convert_v1alpha1_InstanceGroup_To_kops_InstanceGroup(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha1_InstanceGroupList_To_kops_InstanceGroupList is an autogenerated conversion function.
func Convert_v1alpha1_InstanceGroupList_To_kops_InstanceGroupList(in *InstanceGroupList, out *kops.InstanceGroupList, s conversion.Scope) error {
	return autoConvert_v1alpha1_InstanceGroupList_To_kops_InstanceGroupList(in, out, s)
}

func autoConvert_kops_InstanceGroupList_To_v1alpha1_InstanceGroupList(in *kops.InstanceGroupList, out *InstanceGroupList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]InstanceGroup, len(*in))
		for i := range *in {
			if err := Convert_kops_InstanceGroup_To_v1alpha1_InstanceGroup(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_kops_InstanceGroupList_To_v1alpha1_InstanceGroupList is an autogenerated conversion function.
func Convert_kops_InstanceGroupList_To_v1alpha1_InstanceGroupList(in *kops.InstanceGroupList, out *InstanceGroupList, s conversion.Scope) error {
	return autoConvert_kops_InstanceGroupList_To_v1alpha1_InstanceGroupList(in, out, s)
}

func autoConvert_v1alpha1_InstanceGroupSpec_To_kops_InstanceGroupSpec(in *InstanceGroupSpec, out *kops.InstanceGroupSpec, s conversion.Scope) error {
	out.Role = kops.InstanceGroupRole(in.Role)
	out.Image = in.Image
	out.MinSize = in.MinSize
	out.MaxSize = in.MaxSize
	out.MachineType = in.MachineType
	out.RootVolumeSize = in.RootVolumeSize
	out.RootVolumeType = in.RootVolumeType
	out.RootVolumeIops = in.RootVolumeIops
	out.RootVolumeOptimization = in.RootVolumeOptimization
	if in.Hooks != nil {
		in, out := &in.Hooks, &out.Hooks
		*out = make([]kops.HookSpec, len(*in))
		for i := range *in {
			if err := Convert_v1alpha1_HookSpec_To_kops_HookSpec(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Hooks = nil
	}
	out.MaxPrice = in.MaxPrice
	out.AssociatePublicIP = in.AssociatePublicIP
	out.AdditionalSecurityGroups = in.AdditionalSecurityGroups
	out.CloudLabels = in.CloudLabels
	out.NodeLabels = in.NodeLabels
	if in.FileAssets != nil {
		in, out := &in.FileAssets, &out.FileAssets
		*out = make([]kops.FileAssetSpec, len(*in))
		for i := range *in {
			if err := Convert_v1alpha1_FileAssetSpec_To_kops_FileAssetSpec(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.FileAssets = nil
	}
	out.Tenancy = in.Tenancy
	if in.Kubelet != nil {
		in, out := &in.Kubelet, &out.Kubelet
		*out = new(kops.KubeletConfigSpec)
		if err := Convert_v1alpha1_KubeletConfigSpec_To_kops_KubeletConfigSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Kubelet = nil
	}
	out.Taints = in.Taints
	if in.AdditionalUserData != nil {
		in, out := &in.AdditionalUserData, &out.AdditionalUserData
		*out = make([]kops.UserData, len(*in))
		for i := range *in {
			if err := Convert_v1alpha1_UserData_To_kops_UserData(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.AdditionalUserData = nil
	}
	out.Zones = in.Zones
	out.SuspendProcesses = in.SuspendProcesses
	out.DetailedInstanceMonitoring = in.DetailedInstanceMonitoring
	return nil
}

func autoConvert_kops_InstanceGroupSpec_To_v1alpha1_InstanceGroupSpec(in *kops.InstanceGroupSpec, out *InstanceGroupSpec, s conversion.Scope) error {
	out.Role = InstanceGroupRole(in.Role)
	out.Image = in.Image
	out.MinSize = in.MinSize
	out.MaxSize = in.MaxSize
	out.MachineType = in.MachineType
	out.RootVolumeSize = in.RootVolumeSize
	out.RootVolumeType = in.RootVolumeType
	out.RootVolumeIops = in.RootVolumeIops
	out.RootVolumeOptimization = in.RootVolumeOptimization
	// WARNING: in.Subnets requires manual conversion: does not exist in peer-type
	out.Zones = in.Zones
	if in.Hooks != nil {
		in, out := &in.Hooks, &out.Hooks
		*out = make([]HookSpec, len(*in))
		for i := range *in {
			if err := Convert_kops_HookSpec_To_v1alpha1_HookSpec(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Hooks = nil
	}
	out.MaxPrice = in.MaxPrice
	out.AssociatePublicIP = in.AssociatePublicIP
	out.AdditionalSecurityGroups = in.AdditionalSecurityGroups
	out.CloudLabels = in.CloudLabels
	out.NodeLabels = in.NodeLabels
	if in.FileAssets != nil {
		in, out := &in.FileAssets, &out.FileAssets
		*out = make([]FileAssetSpec, len(*in))
		for i := range *in {
			if err := Convert_kops_FileAssetSpec_To_v1alpha1_FileAssetSpec(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.FileAssets = nil
	}
	out.Tenancy = in.Tenancy
	if in.Kubelet != nil {
		in, out := &in.Kubelet, &out.Kubelet
		*out = new(KubeletConfigSpec)
		if err := Convert_kops_KubeletConfigSpec_To_v1alpha1_KubeletConfigSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Kubelet = nil
	}
	out.Taints = in.Taints
	if in.AdditionalUserData != nil {
		in, out := &in.AdditionalUserData, &out.AdditionalUserData
		*out = make([]UserData, len(*in))
		for i := range *in {
			if err := Convert_kops_UserData_To_v1alpha1_UserData(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.AdditionalUserData = nil
	}
	out.SuspendProcesses = in.SuspendProcesses
	out.DetailedInstanceMonitoring = in.DetailedInstanceMonitoring
	return nil
}

func autoConvert_v1alpha1_KopeioAuthenticationSpec_To_kops_KopeioAuthenticationSpec(in *KopeioAuthenticationSpec, out *kops.KopeioAuthenticationSpec, s conversion.Scope) error {
	return nil
}

// Convert_v1alpha1_KopeioAuthenticationSpec_To_kops_KopeioAuthenticationSpec is an autogenerated conversion function.
func Convert_v1alpha1_KopeioAuthenticationSpec_To_kops_KopeioAuthenticationSpec(in *KopeioAuthenticationSpec, out *kops.KopeioAuthenticationSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_KopeioAuthenticationSpec_To_kops_KopeioAuthenticationSpec(in, out, s)
}

func autoConvert_kops_KopeioAuthenticationSpec_To_v1alpha1_KopeioAuthenticationSpec(in *kops.KopeioAuthenticationSpec, out *KopeioAuthenticationSpec, s conversion.Scope) error {
	return nil
}

// Convert_kops_KopeioAuthenticationSpec_To_v1alpha1_KopeioAuthenticationSpec is an autogenerated conversion function.
func Convert_kops_KopeioAuthenticationSpec_To_v1alpha1_KopeioAuthenticationSpec(in *kops.KopeioAuthenticationSpec, out *KopeioAuthenticationSpec, s conversion.Scope) error {
	return autoConvert_kops_KopeioAuthenticationSpec_To_v1alpha1_KopeioAuthenticationSpec(in, out, s)
}

func autoConvert_v1alpha1_KopeioNetworkingSpec_To_kops_KopeioNetworkingSpec(in *KopeioNetworkingSpec, out *kops.KopeioNetworkingSpec, s conversion.Scope) error {
	return nil
}

// Convert_v1alpha1_KopeioNetworkingSpec_To_kops_KopeioNetworkingSpec is an autogenerated conversion function.
func Convert_v1alpha1_KopeioNetworkingSpec_To_kops_KopeioNetworkingSpec(in *KopeioNetworkingSpec, out *kops.KopeioNetworkingSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_KopeioNetworkingSpec_To_kops_KopeioNetworkingSpec(in, out, s)
}

func autoConvert_kops_KopeioNetworkingSpec_To_v1alpha1_KopeioNetworkingSpec(in *kops.KopeioNetworkingSpec, out *KopeioNetworkingSpec, s conversion.Scope) error {
	return nil
}

// Convert_kops_KopeioNetworkingSpec_To_v1alpha1_KopeioNetworkingSpec is an autogenerated conversion function.
func Convert_kops_KopeioNetworkingSpec_To_v1alpha1_KopeioNetworkingSpec(in *kops.KopeioNetworkingSpec, out *KopeioNetworkingSpec, s conversion.Scope) error {
	return autoConvert_kops_KopeioNetworkingSpec_To_v1alpha1_KopeioNetworkingSpec(in, out, s)
}

func autoConvert_v1alpha1_KubeAPIServerConfig_To_kops_KubeAPIServerConfig(in *KubeAPIServerConfig, out *kops.KubeAPIServerConfig, s conversion.Scope) error {
	out.Image = in.Image
	out.LogLevel = in.LogLevel
	out.CloudProvider = in.CloudProvider
	out.SecurePort = in.SecurePort
	out.InsecurePort = in.InsecurePort
	out.Address = in.Address
	out.AdmissionControl = in.AdmissionControl
	out.ServiceClusterIPRange = in.ServiceClusterIPRange
	out.ServiceNodePortRange = in.ServiceNodePortRange
	out.EtcdServers = in.EtcdServers
	out.EtcdServersOverrides = in.EtcdServersOverrides
	out.EtcdCAFile = in.EtcdCAFile
	out.EtcdCertFile = in.EtcdCertFile
	out.EtcdKeyFile = in.EtcdKeyFile
	out.BasicAuthFile = in.BasicAuthFile
	out.ClientCAFile = in.ClientCAFile
	out.TLSCertFile = in.TLSCertFile
	out.TLSPrivateKeyFile = in.TLSPrivateKeyFile
	out.TokenAuthFile = in.TokenAuthFile
	out.AllowPrivileged = in.AllowPrivileged
	out.APIServerCount = in.APIServerCount
	out.RuntimeConfig = in.RuntimeConfig
	out.KubeletClientCertificate = in.KubeletClientCertificate
	out.KubeletClientKey = in.KubeletClientKey
	out.AnonymousAuth = in.AnonymousAuth
	out.KubeletPreferredAddressTypes = in.KubeletPreferredAddressTypes
	out.StorageBackend = in.StorageBackend
	out.OIDCUsernameClaim = in.OIDCUsernameClaim
	out.OIDCUsernamePrefix = in.OIDCUsernamePrefix
	out.OIDCGroupsClaim = in.OIDCGroupsClaim
	out.OIDCGroupsPrefix = in.OIDCGroupsPrefix
	out.OIDCIssuerURL = in.OIDCIssuerURL
	out.OIDCClientID = in.OIDCClientID
	out.OIDCCAFile = in.OIDCCAFile
	out.ProxyClientCertFile = in.ProxyClientCertFile
	out.ProxyClientKeyFile = in.ProxyClientKeyFile
	out.AuditLogFormat = in.AuditLogFormat
	out.AuditLogPath = in.AuditLogPath
	out.AuditLogMaxAge = in.AuditLogMaxAge
	out.AuditLogMaxBackups = in.AuditLogMaxBackups
	out.AuditLogMaxSize = in.AuditLogMaxSize
	out.AuditPolicyFile = in.AuditPolicyFile
	out.AuthenticationTokenWebhookConfigFile = in.AuthenticationTokenWebhookConfigFile
	out.AuthenticationTokenWebhookCacheTTL = in.AuthenticationTokenWebhookCacheTTL
	out.AuthorizationMode = in.AuthorizationMode
	out.AuthorizationRBACSuperUser = in.AuthorizationRBACSuperUser
	out.ExperimentalEncryptionProviderConfig = in.ExperimentalEncryptionProviderConfig
	out.RequestheaderUsernameHeaders = in.RequestheaderUsernameHeaders
	out.RequestheaderGroupHeaders = in.RequestheaderGroupHeaders
	out.RequestheaderExtraHeaderPrefixes = in.RequestheaderExtraHeaderPrefixes
	out.RequestheaderClientCAFile = in.RequestheaderClientCAFile
	out.RequestheaderAllowedNames = in.RequestheaderAllowedNames
	out.FeatureGates = in.FeatureGates
	out.MaxRequestsInflight = in.MaxRequestsInflight
	out.EtcdQuorumRead = in.EtcdQuorumRead
	return nil
}

// Convert_v1alpha1_KubeAPIServerConfig_To_kops_KubeAPIServerConfig is an autogenerated conversion function.
func Convert_v1alpha1_KubeAPIServerConfig_To_kops_KubeAPIServerConfig(in *KubeAPIServerConfig, out *kops.KubeAPIServerConfig, s conversion.Scope) error {
	return autoConvert_v1alpha1_KubeAPIServerConfig_To_kops_KubeAPIServerConfig(in, out, s)
}

func autoConvert_kops_KubeAPIServerConfig_To_v1alpha1_KubeAPIServerConfig(in *kops.KubeAPIServerConfig, out *KubeAPIServerConfig, s conversion.Scope) error {
	out.Image = in.Image
	out.LogLevel = in.LogLevel
	out.CloudProvider = in.CloudProvider
	out.SecurePort = in.SecurePort
	out.InsecurePort = in.InsecurePort
	out.Address = in.Address
	out.AdmissionControl = in.AdmissionControl
	out.ServiceClusterIPRange = in.ServiceClusterIPRange
	out.ServiceNodePortRange = in.ServiceNodePortRange
	out.EtcdServers = in.EtcdServers
	out.EtcdServersOverrides = in.EtcdServersOverrides
	out.EtcdCAFile = in.EtcdCAFile
	out.EtcdCertFile = in.EtcdCertFile
	out.EtcdKeyFile = in.EtcdKeyFile
	out.BasicAuthFile = in.BasicAuthFile
	out.ClientCAFile = in.ClientCAFile
	out.TLSCertFile = in.TLSCertFile
	out.TLSPrivateKeyFile = in.TLSPrivateKeyFile
	out.TokenAuthFile = in.TokenAuthFile
	out.AllowPrivileged = in.AllowPrivileged
	out.APIServerCount = in.APIServerCount
	out.RuntimeConfig = in.RuntimeConfig
	out.KubeletClientCertificate = in.KubeletClientCertificate
	out.KubeletClientKey = in.KubeletClientKey
	out.AnonymousAuth = in.AnonymousAuth
	out.KubeletPreferredAddressTypes = in.KubeletPreferredAddressTypes
	out.StorageBackend = in.StorageBackend
	out.OIDCUsernameClaim = in.OIDCUsernameClaim
	out.OIDCUsernamePrefix = in.OIDCUsernamePrefix
	out.OIDCGroupsClaim = in.OIDCGroupsClaim
	out.OIDCGroupsPrefix = in.OIDCGroupsPrefix
	out.OIDCIssuerURL = in.OIDCIssuerURL
	out.OIDCClientID = in.OIDCClientID
	out.OIDCCAFile = in.OIDCCAFile
	out.ProxyClientCertFile = in.ProxyClientCertFile
	out.ProxyClientKeyFile = in.ProxyClientKeyFile
	out.AuditLogFormat = in.AuditLogFormat
	out.AuditLogPath = in.AuditLogPath
	out.AuditLogMaxAge = in.AuditLogMaxAge
	out.AuditLogMaxBackups = in.AuditLogMaxBackups
	out.AuditLogMaxSize = in.AuditLogMaxSize
	out.AuditPolicyFile = in.AuditPolicyFile
	out.AuthenticationTokenWebhookConfigFile = in.AuthenticationTokenWebhookConfigFile
	out.AuthenticationTokenWebhookCacheTTL = in.AuthenticationTokenWebhookCacheTTL
	out.AuthorizationMode = in.AuthorizationMode
	out.AuthorizationRBACSuperUser = in.AuthorizationRBACSuperUser
	out.ExperimentalEncryptionProviderConfig = in.ExperimentalEncryptionProviderConfig
	out.RequestheaderUsernameHeaders = in.RequestheaderUsernameHeaders
	out.RequestheaderGroupHeaders = in.RequestheaderGroupHeaders
	out.RequestheaderExtraHeaderPrefixes = in.RequestheaderExtraHeaderPrefixes
	out.RequestheaderClientCAFile = in.RequestheaderClientCAFile
	out.RequestheaderAllowedNames = in.RequestheaderAllowedNames
	out.FeatureGates = in.FeatureGates
	out.MaxRequestsInflight = in.MaxRequestsInflight
	out.EtcdQuorumRead = in.EtcdQuorumRead
	return nil
}

// Convert_kops_KubeAPIServerConfig_To_v1alpha1_KubeAPIServerConfig is an autogenerated conversion function.
func Convert_kops_KubeAPIServerConfig_To_v1alpha1_KubeAPIServerConfig(in *kops.KubeAPIServerConfig, out *KubeAPIServerConfig, s conversion.Scope) error {
	return autoConvert_kops_KubeAPIServerConfig_To_v1alpha1_KubeAPIServerConfig(in, out, s)
}

func autoConvert_v1alpha1_KubeControllerManagerConfig_To_kops_KubeControllerManagerConfig(in *KubeControllerManagerConfig, out *kops.KubeControllerManagerConfig, s conversion.Scope) error {
	out.Master = in.Master
	out.LogLevel = in.LogLevel
	out.ServiceAccountPrivateKeyFile = in.ServiceAccountPrivateKeyFile
	out.Image = in.Image
	out.CloudProvider = in.CloudProvider
	out.ClusterName = in.ClusterName
	out.ClusterCIDR = in.ClusterCIDR
	out.AllocateNodeCIDRs = in.AllocateNodeCIDRs
	out.ConfigureCloudRoutes = in.ConfigureCloudRoutes
	out.CIDRAllocatorType = in.CIDRAllocatorType
	out.RootCAFile = in.RootCAFile
	if in.LeaderElection != nil {
		in, out := &in.LeaderElection, &out.LeaderElection
		*out = new(kops.LeaderElectionConfiguration)
		if err := Convert_v1alpha1_LeaderElectionConfiguration_To_kops_LeaderElectionConfiguration(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.LeaderElection = nil
	}
	out.AttachDetachReconcileSyncPeriod = in.AttachDetachReconcileSyncPeriod
	out.TerminatedPodGCThreshold = in.TerminatedPodGCThreshold
	out.NodeMonitorPeriod = in.NodeMonitorPeriod
	out.NodeMonitorGracePeriod = in.NodeMonitorGracePeriod
	out.PodEvictionTimeout = in.PodEvictionTimeout
	out.UseServiceAccountCredentials = in.UseServiceAccountCredentials
	out.HorizontalPodAutoscalerSyncPeriod = in.HorizontalPodAutoscalerSyncPeriod
	out.HorizontalPodAutoscalerDownscaleDelay = in.HorizontalPodAutoscalerDownscaleDelay
	out.HorizontalPodAutoscalerUpscaleDelay = in.HorizontalPodAutoscalerUpscaleDelay
	out.HorizontalPodAutoscalerUseRestClients = in.HorizontalPodAutoscalerUseRestClients
	out.FeatureGates = in.FeatureGates
	return nil
}

// Convert_v1alpha1_KubeControllerManagerConfig_To_kops_KubeControllerManagerConfig is an autogenerated conversion function.
func Convert_v1alpha1_KubeControllerManagerConfig_To_kops_KubeControllerManagerConfig(in *KubeControllerManagerConfig, out *kops.KubeControllerManagerConfig, s conversion.Scope) error {
	return autoConvert_v1alpha1_KubeControllerManagerConfig_To_kops_KubeControllerManagerConfig(in, out, s)
}

func autoConvert_kops_KubeControllerManagerConfig_To_v1alpha1_KubeControllerManagerConfig(in *kops.KubeControllerManagerConfig, out *KubeControllerManagerConfig, s conversion.Scope) error {
	out.Master = in.Master
	out.LogLevel = in.LogLevel
	out.ServiceAccountPrivateKeyFile = in.ServiceAccountPrivateKeyFile
	out.Image = in.Image
	out.CloudProvider = in.CloudProvider
	out.ClusterName = in.ClusterName
	out.ClusterCIDR = in.ClusterCIDR
	out.AllocateNodeCIDRs = in.AllocateNodeCIDRs
	out.ConfigureCloudRoutes = in.ConfigureCloudRoutes
	out.CIDRAllocatorType = in.CIDRAllocatorType
	out.RootCAFile = in.RootCAFile
	if in.LeaderElection != nil {
		in, out := &in.LeaderElection, &out.LeaderElection
		*out = new(LeaderElectionConfiguration)
		if err := Convert_kops_LeaderElectionConfiguration_To_v1alpha1_LeaderElectionConfiguration(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.LeaderElection = nil
	}
	out.AttachDetachReconcileSyncPeriod = in.AttachDetachReconcileSyncPeriod
	out.TerminatedPodGCThreshold = in.TerminatedPodGCThreshold
	out.NodeMonitorPeriod = in.NodeMonitorPeriod
	out.NodeMonitorGracePeriod = in.NodeMonitorGracePeriod
	out.PodEvictionTimeout = in.PodEvictionTimeout
	out.UseServiceAccountCredentials = in.UseServiceAccountCredentials
	out.HorizontalPodAutoscalerSyncPeriod = in.HorizontalPodAutoscalerSyncPeriod
	out.HorizontalPodAutoscalerDownscaleDelay = in.HorizontalPodAutoscalerDownscaleDelay
	out.HorizontalPodAutoscalerUpscaleDelay = in.HorizontalPodAutoscalerUpscaleDelay
	out.HorizontalPodAutoscalerUseRestClients = in.HorizontalPodAutoscalerUseRestClients
	out.FeatureGates = in.FeatureGates
	return nil
}

// Convert_kops_KubeControllerManagerConfig_To_v1alpha1_KubeControllerManagerConfig is an autogenerated conversion function.
func Convert_kops_KubeControllerManagerConfig_To_v1alpha1_KubeControllerManagerConfig(in *kops.KubeControllerManagerConfig, out *KubeControllerManagerConfig, s conversion.Scope) error {
	return autoConvert_kops_KubeControllerManagerConfig_To_v1alpha1_KubeControllerManagerConfig(in, out, s)
}

func autoConvert_v1alpha1_KubeDNSConfig_To_kops_KubeDNSConfig(in *KubeDNSConfig, out *kops.KubeDNSConfig, s conversion.Scope) error {
	out.Image = in.Image
	out.Replicas = in.Replicas
	out.Domain = in.Domain
	out.ServerIP = in.ServerIP
	return nil
}

// Convert_v1alpha1_KubeDNSConfig_To_kops_KubeDNSConfig is an autogenerated conversion function.
func Convert_v1alpha1_KubeDNSConfig_To_kops_KubeDNSConfig(in *KubeDNSConfig, out *kops.KubeDNSConfig, s conversion.Scope) error {
	return autoConvert_v1alpha1_KubeDNSConfig_To_kops_KubeDNSConfig(in, out, s)
}

func autoConvert_kops_KubeDNSConfig_To_v1alpha1_KubeDNSConfig(in *kops.KubeDNSConfig, out *KubeDNSConfig, s conversion.Scope) error {
	out.Image = in.Image
	out.Replicas = in.Replicas
	out.Domain = in.Domain
	out.ServerIP = in.ServerIP
	return nil
}

// Convert_kops_KubeDNSConfig_To_v1alpha1_KubeDNSConfig is an autogenerated conversion function.
func Convert_kops_KubeDNSConfig_To_v1alpha1_KubeDNSConfig(in *kops.KubeDNSConfig, out *KubeDNSConfig, s conversion.Scope) error {
	return autoConvert_kops_KubeDNSConfig_To_v1alpha1_KubeDNSConfig(in, out, s)
}

func autoConvert_v1alpha1_KubeProxyConfig_To_kops_KubeProxyConfig(in *KubeProxyConfig, out *kops.KubeProxyConfig, s conversion.Scope) error {
	out.Image = in.Image
	out.CPURequest = in.CPURequest
	out.CPULimit = in.CPULimit
	out.MemoryRequest = in.MemoryRequest
	out.MemoryLimit = in.MemoryLimit
	out.LogLevel = in.LogLevel
	out.ClusterCIDR = in.ClusterCIDR
	out.HostnameOverride = in.HostnameOverride
	out.Master = in.Master
	out.Enabled = in.Enabled
	out.FeatureGates = in.FeatureGates
	return nil
}

// Convert_v1alpha1_KubeProxyConfig_To_kops_KubeProxyConfig is an autogenerated conversion function.
func Convert_v1alpha1_KubeProxyConfig_To_kops_KubeProxyConfig(in *KubeProxyConfig, out *kops.KubeProxyConfig, s conversion.Scope) error {
	return autoConvert_v1alpha1_KubeProxyConfig_To_kops_KubeProxyConfig(in, out, s)
}

func autoConvert_kops_KubeProxyConfig_To_v1alpha1_KubeProxyConfig(in *kops.KubeProxyConfig, out *KubeProxyConfig, s conversion.Scope) error {
	out.Image = in.Image
	out.CPURequest = in.CPURequest
	out.CPULimit = in.CPULimit
	out.MemoryRequest = in.MemoryRequest
	out.MemoryLimit = in.MemoryLimit
	out.LogLevel = in.LogLevel
	out.ClusterCIDR = in.ClusterCIDR
	out.HostnameOverride = in.HostnameOverride
	out.Master = in.Master
	out.Enabled = in.Enabled
	out.FeatureGates = in.FeatureGates
	return nil
}

// Convert_kops_KubeProxyConfig_To_v1alpha1_KubeProxyConfig is an autogenerated conversion function.
func Convert_kops_KubeProxyConfig_To_v1alpha1_KubeProxyConfig(in *kops.KubeProxyConfig, out *KubeProxyConfig, s conversion.Scope) error {
	return autoConvert_kops_KubeProxyConfig_To_v1alpha1_KubeProxyConfig(in, out, s)
}

func autoConvert_v1alpha1_KubeSchedulerConfig_To_kops_KubeSchedulerConfig(in *KubeSchedulerConfig, out *kops.KubeSchedulerConfig, s conversion.Scope) error {
	out.Master = in.Master
	out.LogLevel = in.LogLevel
	out.Image = in.Image
	if in.LeaderElection != nil {
		in, out := &in.LeaderElection, &out.LeaderElection
		*out = new(kops.LeaderElectionConfiguration)
		if err := Convert_v1alpha1_LeaderElectionConfiguration_To_kops_LeaderElectionConfiguration(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.LeaderElection = nil
	}
	out.UsePolicyConfigMap = in.UsePolicyConfigMap
	out.FeatureGates = in.FeatureGates
	return nil
}

// Convert_v1alpha1_KubeSchedulerConfig_To_kops_KubeSchedulerConfig is an autogenerated conversion function.
func Convert_v1alpha1_KubeSchedulerConfig_To_kops_KubeSchedulerConfig(in *KubeSchedulerConfig, out *kops.KubeSchedulerConfig, s conversion.Scope) error {
	return autoConvert_v1alpha1_KubeSchedulerConfig_To_kops_KubeSchedulerConfig(in, out, s)
}

func autoConvert_kops_KubeSchedulerConfig_To_v1alpha1_KubeSchedulerConfig(in *kops.KubeSchedulerConfig, out *KubeSchedulerConfig, s conversion.Scope) error {
	out.Master = in.Master
	out.LogLevel = in.LogLevel
	out.Image = in.Image
	if in.LeaderElection != nil {
		in, out := &in.LeaderElection, &out.LeaderElection
		*out = new(LeaderElectionConfiguration)
		if err := Convert_kops_LeaderElectionConfiguration_To_v1alpha1_LeaderElectionConfiguration(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.LeaderElection = nil
	}
	out.UsePolicyConfigMap = in.UsePolicyConfigMap
	out.FeatureGates = in.FeatureGates
	return nil
}

// Convert_kops_KubeSchedulerConfig_To_v1alpha1_KubeSchedulerConfig is an autogenerated conversion function.
func Convert_kops_KubeSchedulerConfig_To_v1alpha1_KubeSchedulerConfig(in *kops.KubeSchedulerConfig, out *KubeSchedulerConfig, s conversion.Scope) error {
	return autoConvert_kops_KubeSchedulerConfig_To_v1alpha1_KubeSchedulerConfig(in, out, s)
}

func autoConvert_v1alpha1_KubeletConfigSpec_To_kops_KubeletConfigSpec(in *KubeletConfigSpec, out *kops.KubeletConfigSpec, s conversion.Scope) error {
	out.APIServers = in.APIServers
	out.AnonymousAuth = in.AnonymousAuth
	out.ClientCAFile = in.ClientCAFile
	out.KubeconfigPath = in.KubeconfigPath
	out.RequireKubeconfig = in.RequireKubeconfig
	out.LogLevel = in.LogLevel
	out.PodManifestPath = in.PodManifestPath
	out.HostnameOverride = in.HostnameOverride
	out.PodInfraContainerImage = in.PodInfraContainerImage
	out.SeccompProfileRoot = in.SeccompProfileRoot
	out.AllowPrivileged = in.AllowPrivileged
	out.EnableDebuggingHandlers = in.EnableDebuggingHandlers
	out.RegisterNode = in.RegisterNode
	out.NodeStatusUpdateFrequency = in.NodeStatusUpdateFrequency
	out.ClusterDomain = in.ClusterDomain
	out.ClusterDNS = in.ClusterDNS
	out.NetworkPluginName = in.NetworkPluginName
	out.CloudProvider = in.CloudProvider
	out.KubeletCgroups = in.KubeletCgroups
	out.RuntimeCgroups = in.RuntimeCgroups
	out.ReadOnlyPort = in.ReadOnlyPort
	out.SystemCgroups = in.SystemCgroups
	out.CgroupRoot = in.CgroupRoot
	out.ConfigureCBR0 = in.ConfigureCBR0
	out.HairpinMode = in.HairpinMode
	out.BabysitDaemons = in.BabysitDaemons
	out.MaxPods = in.MaxPods
	out.NvidiaGPUs = in.NvidiaGPUs
	out.PodCIDR = in.PodCIDR
	out.ResolverConfig = in.ResolverConfig
	out.ReconcileCIDR = in.ReconcileCIDR
	out.RegisterSchedulable = in.RegisterSchedulable
	out.SerializeImagePulls = in.SerializeImagePulls
	out.NodeLabels = in.NodeLabels
	out.NonMasqueradeCIDR = in.NonMasqueradeCIDR
	out.EnableCustomMetrics = in.EnableCustomMetrics
	out.NetworkPluginMTU = in.NetworkPluginMTU
	out.ImageGCHighThresholdPercent = in.ImageGCHighThresholdPercent
	out.ImageGCLowThresholdPercent = in.ImageGCLowThresholdPercent
	out.ImagePullProgressDeadline = in.ImagePullProgressDeadline
	out.EvictionHard = in.EvictionHard
	out.EvictionSoft = in.EvictionSoft
	out.EvictionSoftGracePeriod = in.EvictionSoftGracePeriod
	out.EvictionPressureTransitionPeriod = in.EvictionPressureTransitionPeriod
	out.EvictionMaxPodGracePeriod = in.EvictionMaxPodGracePeriod
	out.EvictionMinimumReclaim = in.EvictionMinimumReclaim
	out.VolumePluginDirectory = in.VolumePluginDirectory
	out.Taints = in.Taints
	out.FeatureGates = in.FeatureGates
	out.KubeReserved = in.KubeReserved
	out.KubeReservedCgroup = in.KubeReservedCgroup
	out.SystemReserved = in.SystemReserved
	out.SystemReservedCgroup = in.SystemReservedCgroup
	out.EnforceNodeAllocatable = in.EnforceNodeAllocatable
	out.RuntimeRequestTimeout = in.RuntimeRequestTimeout
	out.VolumeStatsAggPeriod = in.VolumeStatsAggPeriod
	out.FailSwapOn = in.FailSwapOn
	return nil
}

// Convert_v1alpha1_KubeletConfigSpec_To_kops_KubeletConfigSpec is an autogenerated conversion function.
func Convert_v1alpha1_KubeletConfigSpec_To_kops_KubeletConfigSpec(in *KubeletConfigSpec, out *kops.KubeletConfigSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_KubeletConfigSpec_To_kops_KubeletConfigSpec(in, out, s)
}

func autoConvert_kops_KubeletConfigSpec_To_v1alpha1_KubeletConfigSpec(in *kops.KubeletConfigSpec, out *KubeletConfigSpec, s conversion.Scope) error {
	out.APIServers = in.APIServers
	out.AnonymousAuth = in.AnonymousAuth
	out.ClientCAFile = in.ClientCAFile
	out.KubeconfigPath = in.KubeconfigPath
	out.RequireKubeconfig = in.RequireKubeconfig
	out.LogLevel = in.LogLevel
	out.PodManifestPath = in.PodManifestPath
	out.HostnameOverride = in.HostnameOverride
	out.PodInfraContainerImage = in.PodInfraContainerImage
	out.SeccompProfileRoot = in.SeccompProfileRoot
	out.AllowPrivileged = in.AllowPrivileged
	out.EnableDebuggingHandlers = in.EnableDebuggingHandlers
	out.RegisterNode = in.RegisterNode
	out.NodeStatusUpdateFrequency = in.NodeStatusUpdateFrequency
	out.ClusterDomain = in.ClusterDomain
	out.ClusterDNS = in.ClusterDNS
	out.NetworkPluginName = in.NetworkPluginName
	out.CloudProvider = in.CloudProvider
	out.KubeletCgroups = in.KubeletCgroups
	out.RuntimeCgroups = in.RuntimeCgroups
	out.ReadOnlyPort = in.ReadOnlyPort
	out.SystemCgroups = in.SystemCgroups
	out.CgroupRoot = in.CgroupRoot
	out.ConfigureCBR0 = in.ConfigureCBR0
	out.HairpinMode = in.HairpinMode
	out.BabysitDaemons = in.BabysitDaemons
	out.MaxPods = in.MaxPods
	out.NvidiaGPUs = in.NvidiaGPUs
	out.PodCIDR = in.PodCIDR
	out.ResolverConfig = in.ResolverConfig
	out.ReconcileCIDR = in.ReconcileCIDR
	out.RegisterSchedulable = in.RegisterSchedulable
	out.SerializeImagePulls = in.SerializeImagePulls
	out.NodeLabels = in.NodeLabels
	out.NonMasqueradeCIDR = in.NonMasqueradeCIDR
	out.EnableCustomMetrics = in.EnableCustomMetrics
	out.NetworkPluginMTU = in.NetworkPluginMTU
	out.ImageGCHighThresholdPercent = in.ImageGCHighThresholdPercent
	out.ImageGCLowThresholdPercent = in.ImageGCLowThresholdPercent
	out.ImagePullProgressDeadline = in.ImagePullProgressDeadline
	out.EvictionHard = in.EvictionHard
	out.EvictionSoft = in.EvictionSoft
	out.EvictionSoftGracePeriod = in.EvictionSoftGracePeriod
	out.EvictionPressureTransitionPeriod = in.EvictionPressureTransitionPeriod
	out.EvictionMaxPodGracePeriod = in.EvictionMaxPodGracePeriod
	out.EvictionMinimumReclaim = in.EvictionMinimumReclaim
	out.VolumePluginDirectory = in.VolumePluginDirectory
	out.Taints = in.Taints
	out.FeatureGates = in.FeatureGates
	out.KubeReserved = in.KubeReserved
	out.KubeReservedCgroup = in.KubeReservedCgroup
	out.SystemReserved = in.SystemReserved
	out.SystemReservedCgroup = in.SystemReservedCgroup
	out.EnforceNodeAllocatable = in.EnforceNodeAllocatable
	out.RuntimeRequestTimeout = in.RuntimeRequestTimeout
	out.VolumeStatsAggPeriod = in.VolumeStatsAggPeriod
	out.FailSwapOn = in.FailSwapOn
	return nil
}

// Convert_kops_KubeletConfigSpec_To_v1alpha1_KubeletConfigSpec is an autogenerated conversion function.
func Convert_kops_KubeletConfigSpec_To_v1alpha1_KubeletConfigSpec(in *kops.KubeletConfigSpec, out *KubeletConfigSpec, s conversion.Scope) error {
	return autoConvert_kops_KubeletConfigSpec_To_v1alpha1_KubeletConfigSpec(in, out, s)
}

func autoConvert_v1alpha1_KubenetNetworkingSpec_To_kops_KubenetNetworkingSpec(in *KubenetNetworkingSpec, out *kops.KubenetNetworkingSpec, s conversion.Scope) error {
	return nil
}

// Convert_v1alpha1_KubenetNetworkingSpec_To_kops_KubenetNetworkingSpec is an autogenerated conversion function.
func Convert_v1alpha1_KubenetNetworkingSpec_To_kops_KubenetNetworkingSpec(in *KubenetNetworkingSpec, out *kops.KubenetNetworkingSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_KubenetNetworkingSpec_To_kops_KubenetNetworkingSpec(in, out, s)
}

func autoConvert_kops_KubenetNetworkingSpec_To_v1alpha1_KubenetNetworkingSpec(in *kops.KubenetNetworkingSpec, out *KubenetNetworkingSpec, s conversion.Scope) error {
	return nil
}

// Convert_kops_KubenetNetworkingSpec_To_v1alpha1_KubenetNetworkingSpec is an autogenerated conversion function.
func Convert_kops_KubenetNetworkingSpec_To_v1alpha1_KubenetNetworkingSpec(in *kops.KubenetNetworkingSpec, out *KubenetNetworkingSpec, s conversion.Scope) error {
	return autoConvert_kops_KubenetNetworkingSpec_To_v1alpha1_KubenetNetworkingSpec(in, out, s)
}

func autoConvert_v1alpha1_KuberouterNetworkingSpec_To_kops_KuberouterNetworkingSpec(in *KuberouterNetworkingSpec, out *kops.KuberouterNetworkingSpec, s conversion.Scope) error {
	return nil
}

// Convert_v1alpha1_KuberouterNetworkingSpec_To_kops_KuberouterNetworkingSpec is an autogenerated conversion function.
func Convert_v1alpha1_KuberouterNetworkingSpec_To_kops_KuberouterNetworkingSpec(in *KuberouterNetworkingSpec, out *kops.KuberouterNetworkingSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_KuberouterNetworkingSpec_To_kops_KuberouterNetworkingSpec(in, out, s)
}

func autoConvert_kops_KuberouterNetworkingSpec_To_v1alpha1_KuberouterNetworkingSpec(in *kops.KuberouterNetworkingSpec, out *KuberouterNetworkingSpec, s conversion.Scope) error {
	return nil
}

// Convert_kops_KuberouterNetworkingSpec_To_v1alpha1_KuberouterNetworkingSpec is an autogenerated conversion function.
func Convert_kops_KuberouterNetworkingSpec_To_v1alpha1_KuberouterNetworkingSpec(in *kops.KuberouterNetworkingSpec, out *KuberouterNetworkingSpec, s conversion.Scope) error {
	return autoConvert_kops_KuberouterNetworkingSpec_To_v1alpha1_KuberouterNetworkingSpec(in, out, s)
}

func autoConvert_v1alpha1_LeaderElectionConfiguration_To_kops_LeaderElectionConfiguration(in *LeaderElectionConfiguration, out *kops.LeaderElectionConfiguration, s conversion.Scope) error {
	out.LeaderElect = in.LeaderElect
	return nil
}

// Convert_v1alpha1_LeaderElectionConfiguration_To_kops_LeaderElectionConfiguration is an autogenerated conversion function.
func Convert_v1alpha1_LeaderElectionConfiguration_To_kops_LeaderElectionConfiguration(in *LeaderElectionConfiguration, out *kops.LeaderElectionConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha1_LeaderElectionConfiguration_To_kops_LeaderElectionConfiguration(in, out, s)
}

func autoConvert_kops_LeaderElectionConfiguration_To_v1alpha1_LeaderElectionConfiguration(in *kops.LeaderElectionConfiguration, out *LeaderElectionConfiguration, s conversion.Scope) error {
	out.LeaderElect = in.LeaderElect
	return nil
}

// Convert_kops_LeaderElectionConfiguration_To_v1alpha1_LeaderElectionConfiguration is an autogenerated conversion function.
func Convert_kops_LeaderElectionConfiguration_To_v1alpha1_LeaderElectionConfiguration(in *kops.LeaderElectionConfiguration, out *LeaderElectionConfiguration, s conversion.Scope) error {
	return autoConvert_kops_LeaderElectionConfiguration_To_v1alpha1_LeaderElectionConfiguration(in, out, s)
}

func autoConvert_v1alpha1_LoadBalancerAccessSpec_To_kops_LoadBalancerAccessSpec(in *LoadBalancerAccessSpec, out *kops.LoadBalancerAccessSpec, s conversion.Scope) error {
	out.Type = kops.LoadBalancerType(in.Type)
	out.IdleTimeoutSeconds = in.IdleTimeoutSeconds
	out.AdditionalSecurityGroups = in.AdditionalSecurityGroups
	return nil
}

// Convert_v1alpha1_LoadBalancerAccessSpec_To_kops_LoadBalancerAccessSpec is an autogenerated conversion function.
func Convert_v1alpha1_LoadBalancerAccessSpec_To_kops_LoadBalancerAccessSpec(in *LoadBalancerAccessSpec, out *kops.LoadBalancerAccessSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_LoadBalancerAccessSpec_To_kops_LoadBalancerAccessSpec(in, out, s)
}

func autoConvert_kops_LoadBalancerAccessSpec_To_v1alpha1_LoadBalancerAccessSpec(in *kops.LoadBalancerAccessSpec, out *LoadBalancerAccessSpec, s conversion.Scope) error {
	out.Type = LoadBalancerType(in.Type)
	out.IdleTimeoutSeconds = in.IdleTimeoutSeconds
	out.AdditionalSecurityGroups = in.AdditionalSecurityGroups
	return nil
}

// Convert_kops_LoadBalancerAccessSpec_To_v1alpha1_LoadBalancerAccessSpec is an autogenerated conversion function.
func Convert_kops_LoadBalancerAccessSpec_To_v1alpha1_LoadBalancerAccessSpec(in *kops.LoadBalancerAccessSpec, out *LoadBalancerAccessSpec, s conversion.Scope) error {
	return autoConvert_kops_LoadBalancerAccessSpec_To_v1alpha1_LoadBalancerAccessSpec(in, out, s)
}

func autoConvert_v1alpha1_NetworkingSpec_To_kops_NetworkingSpec(in *NetworkingSpec, out *kops.NetworkingSpec, s conversion.Scope) error {
	if in.Classic != nil {
		in, out := &in.Classic, &out.Classic
		*out = new(kops.ClassicNetworkingSpec)
		if err := Convert_v1alpha1_ClassicNetworkingSpec_To_kops_ClassicNetworkingSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Classic = nil
	}
	if in.Kubenet != nil {
		in, out := &in.Kubenet, &out.Kubenet
		*out = new(kops.KubenetNetworkingSpec)
		if err := Convert_v1alpha1_KubenetNetworkingSpec_To_kops_KubenetNetworkingSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Kubenet = nil
	}
	if in.External != nil {
		in, out := &in.External, &out.External
		*out = new(kops.ExternalNetworkingSpec)
		if err := Convert_v1alpha1_ExternalNetworkingSpec_To_kops_ExternalNetworkingSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.External = nil
	}
	if in.CNI != nil {
		in, out := &in.CNI, &out.CNI
		*out = new(kops.CNINetworkingSpec)
		if err := Convert_v1alpha1_CNINetworkingSpec_To_kops_CNINetworkingSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.CNI = nil
	}
	if in.Kopeio != nil {
		in, out := &in.Kopeio, &out.Kopeio
		*out = new(kops.KopeioNetworkingSpec)
		if err := Convert_v1alpha1_KopeioNetworkingSpec_To_kops_KopeioNetworkingSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Kopeio = nil
	}
	if in.Weave != nil {
		in, out := &in.Weave, &out.Weave
		*out = new(kops.WeaveNetworkingSpec)
		if err := Convert_v1alpha1_WeaveNetworkingSpec_To_kops_WeaveNetworkingSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Weave = nil
	}
	if in.Flannel != nil {
		in, out := &in.Flannel, &out.Flannel
		*out = new(kops.FlannelNetworkingSpec)
		if err := Convert_v1alpha1_FlannelNetworkingSpec_To_kops_FlannelNetworkingSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Flannel = nil
	}
	if in.Calico != nil {
		in, out := &in.Calico, &out.Calico
		*out = new(kops.CalicoNetworkingSpec)
		if err := Convert_v1alpha1_CalicoNetworkingSpec_To_kops_CalicoNetworkingSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Calico = nil
	}
	if in.Canal != nil {
		in, out := &in.Canal, &out.Canal
		*out = new(kops.CanalNetworkingSpec)
		if err := Convert_v1alpha1_CanalNetworkingSpec_To_kops_CanalNetworkingSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Canal = nil
	}
	if in.Kuberouter != nil {
		in, out := &in.Kuberouter, &out.Kuberouter
		*out = new(kops.KuberouterNetworkingSpec)
		if err := Convert_v1alpha1_KuberouterNetworkingSpec_To_kops_KuberouterNetworkingSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Kuberouter = nil
	}
	if in.Romana != nil {
		in, out := &in.Romana, &out.Romana
		*out = new(kops.RomanaNetworkingSpec)
		if err := Convert_v1alpha1_RomanaNetworkingSpec_To_kops_RomanaNetworkingSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Romana = nil
	}
	if in.AmazonVPC != nil {
		in, out := &in.AmazonVPC, &out.AmazonVPC
		*out = new(kops.AmazonVPCNetworkingSpec)
		if err := Convert_v1alpha1_AmazonVPCNetworkingSpec_To_kops_AmazonVPCNetworkingSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.AmazonVPC = nil
	}
	if in.Cilium != nil {
		in, out := &in.Cilium, &out.Cilium
		*out = new(kops.CiliumNetworkingSpec)
		if err := Convert_v1alpha1_CiliumNetworkingSpec_To_kops_CiliumNetworkingSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Cilium = nil
	}
	return nil
}

// Convert_v1alpha1_NetworkingSpec_To_kops_NetworkingSpec is an autogenerated conversion function.
func Convert_v1alpha1_NetworkingSpec_To_kops_NetworkingSpec(in *NetworkingSpec, out *kops.NetworkingSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_NetworkingSpec_To_kops_NetworkingSpec(in, out, s)
}

func autoConvert_kops_NetworkingSpec_To_v1alpha1_NetworkingSpec(in *kops.NetworkingSpec, out *NetworkingSpec, s conversion.Scope) error {
	if in.Classic != nil {
		in, out := &in.Classic, &out.Classic
		*out = new(ClassicNetworkingSpec)
		if err := Convert_kops_ClassicNetworkingSpec_To_v1alpha1_ClassicNetworkingSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Classic = nil
	}
	if in.Kubenet != nil {
		in, out := &in.Kubenet, &out.Kubenet
		*out = new(KubenetNetworkingSpec)
		if err := Convert_kops_KubenetNetworkingSpec_To_v1alpha1_KubenetNetworkingSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Kubenet = nil
	}
	if in.External != nil {
		in, out := &in.External, &out.External
		*out = new(ExternalNetworkingSpec)
		if err := Convert_kops_ExternalNetworkingSpec_To_v1alpha1_ExternalNetworkingSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.External = nil
	}
	if in.CNI != nil {
		in, out := &in.CNI, &out.CNI
		*out = new(CNINetworkingSpec)
		if err := Convert_kops_CNINetworkingSpec_To_v1alpha1_CNINetworkingSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.CNI = nil
	}
	if in.Kopeio != nil {
		in, out := &in.Kopeio, &out.Kopeio
		*out = new(KopeioNetworkingSpec)
		if err := Convert_kops_KopeioNetworkingSpec_To_v1alpha1_KopeioNetworkingSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Kopeio = nil
	}
	if in.Weave != nil {
		in, out := &in.Weave, &out.Weave
		*out = new(WeaveNetworkingSpec)
		if err := Convert_kops_WeaveNetworkingSpec_To_v1alpha1_WeaveNetworkingSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Weave = nil
	}
	if in.Flannel != nil {
		in, out := &in.Flannel, &out.Flannel
		*out = new(FlannelNetworkingSpec)
		if err := Convert_kops_FlannelNetworkingSpec_To_v1alpha1_FlannelNetworkingSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Flannel = nil
	}
	if in.Calico != nil {
		in, out := &in.Calico, &out.Calico
		*out = new(CalicoNetworkingSpec)
		if err := Convert_kops_CalicoNetworkingSpec_To_v1alpha1_CalicoNetworkingSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Calico = nil
	}
	if in.Canal != nil {
		in, out := &in.Canal, &out.Canal
		*out = new(CanalNetworkingSpec)
		if err := Convert_kops_CanalNetworkingSpec_To_v1alpha1_CanalNetworkingSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Canal = nil
	}
	if in.Kuberouter != nil {
		in, out := &in.Kuberouter, &out.Kuberouter
		*out = new(KuberouterNetworkingSpec)
		if err := Convert_kops_KuberouterNetworkingSpec_To_v1alpha1_KuberouterNetworkingSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Kuberouter = nil
	}
	if in.Romana != nil {
		in, out := &in.Romana, &out.Romana
		*out = new(RomanaNetworkingSpec)
		if err := Convert_kops_RomanaNetworkingSpec_To_v1alpha1_RomanaNetworkingSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Romana = nil
	}
	if in.AmazonVPC != nil {
		in, out := &in.AmazonVPC, &out.AmazonVPC
		*out = new(AmazonVPCNetworkingSpec)
		if err := Convert_kops_AmazonVPCNetworkingSpec_To_v1alpha1_AmazonVPCNetworkingSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.AmazonVPC = nil
	}
	if in.Cilium != nil {
		in, out := &in.Cilium, &out.Cilium
		*out = new(CiliumNetworkingSpec)
		if err := Convert_kops_CiliumNetworkingSpec_To_v1alpha1_CiliumNetworkingSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Cilium = nil
	}
	return nil
}

// Convert_kops_NetworkingSpec_To_v1alpha1_NetworkingSpec is an autogenerated conversion function.
func Convert_kops_NetworkingSpec_To_v1alpha1_NetworkingSpec(in *kops.NetworkingSpec, out *NetworkingSpec, s conversion.Scope) error {
	return autoConvert_kops_NetworkingSpec_To_v1alpha1_NetworkingSpec(in, out, s)
}

func autoConvert_v1alpha1_RBACAuthorizationSpec_To_kops_RBACAuthorizationSpec(in *RBACAuthorizationSpec, out *kops.RBACAuthorizationSpec, s conversion.Scope) error {
	return nil
}

// Convert_v1alpha1_RBACAuthorizationSpec_To_kops_RBACAuthorizationSpec is an autogenerated conversion function.
func Convert_v1alpha1_RBACAuthorizationSpec_To_kops_RBACAuthorizationSpec(in *RBACAuthorizationSpec, out *kops.RBACAuthorizationSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_RBACAuthorizationSpec_To_kops_RBACAuthorizationSpec(in, out, s)
}

func autoConvert_kops_RBACAuthorizationSpec_To_v1alpha1_RBACAuthorizationSpec(in *kops.RBACAuthorizationSpec, out *RBACAuthorizationSpec, s conversion.Scope) error {
	return nil
}

// Convert_kops_RBACAuthorizationSpec_To_v1alpha1_RBACAuthorizationSpec is an autogenerated conversion function.
func Convert_kops_RBACAuthorizationSpec_To_v1alpha1_RBACAuthorizationSpec(in *kops.RBACAuthorizationSpec, out *RBACAuthorizationSpec, s conversion.Scope) error {
	return autoConvert_kops_RBACAuthorizationSpec_To_v1alpha1_RBACAuthorizationSpec(in, out, s)
}

func autoConvert_v1alpha1_RomanaNetworkingSpec_To_kops_RomanaNetworkingSpec(in *RomanaNetworkingSpec, out *kops.RomanaNetworkingSpec, s conversion.Scope) error {
	out.DaemonServiceIP = in.DaemonServiceIP
	out.EtcdServiceIP = in.EtcdServiceIP
	return nil
}

// Convert_v1alpha1_RomanaNetworkingSpec_To_kops_RomanaNetworkingSpec is an autogenerated conversion function.
func Convert_v1alpha1_RomanaNetworkingSpec_To_kops_RomanaNetworkingSpec(in *RomanaNetworkingSpec, out *kops.RomanaNetworkingSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_RomanaNetworkingSpec_To_kops_RomanaNetworkingSpec(in, out, s)
}

func autoConvert_kops_RomanaNetworkingSpec_To_v1alpha1_RomanaNetworkingSpec(in *kops.RomanaNetworkingSpec, out *RomanaNetworkingSpec, s conversion.Scope) error {
	out.DaemonServiceIP = in.DaemonServiceIP
	out.EtcdServiceIP = in.EtcdServiceIP
	return nil
}

// Convert_kops_RomanaNetworkingSpec_To_v1alpha1_RomanaNetworkingSpec is an autogenerated conversion function.
func Convert_kops_RomanaNetworkingSpec_To_v1alpha1_RomanaNetworkingSpec(in *kops.RomanaNetworkingSpec, out *RomanaNetworkingSpec, s conversion.Scope) error {
	return autoConvert_kops_RomanaNetworkingSpec_To_v1alpha1_RomanaNetworkingSpec(in, out, s)
}

func autoConvert_v1alpha1_SSHCredential_To_kops_SSHCredential(in *SSHCredential, out *kops.SSHCredential, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha1_SSHCredentialSpec_To_kops_SSHCredentialSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_SSHCredential_To_kops_SSHCredential is an autogenerated conversion function.
func Convert_v1alpha1_SSHCredential_To_kops_SSHCredential(in *SSHCredential, out *kops.SSHCredential, s conversion.Scope) error {
	return autoConvert_v1alpha1_SSHCredential_To_kops_SSHCredential(in, out, s)
}

func autoConvert_kops_SSHCredential_To_v1alpha1_SSHCredential(in *kops.SSHCredential, out *SSHCredential, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_kops_SSHCredentialSpec_To_v1alpha1_SSHCredentialSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_kops_SSHCredential_To_v1alpha1_SSHCredential is an autogenerated conversion function.
func Convert_kops_SSHCredential_To_v1alpha1_SSHCredential(in *kops.SSHCredential, out *SSHCredential, s conversion.Scope) error {
	return autoConvert_kops_SSHCredential_To_v1alpha1_SSHCredential(in, out, s)
}

func autoConvert_v1alpha1_SSHCredentialList_To_kops_SSHCredentialList(in *SSHCredentialList, out *kops.SSHCredentialList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]kops.SSHCredential, len(*in))
		for i := range *in {
			if err := Convert_v1alpha1_SSHCredential_To_kops_SSHCredential(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha1_SSHCredentialList_To_kops_SSHCredentialList is an autogenerated conversion function.
func Convert_v1alpha1_SSHCredentialList_To_kops_SSHCredentialList(in *SSHCredentialList, out *kops.SSHCredentialList, s conversion.Scope) error {
	return autoConvert_v1alpha1_SSHCredentialList_To_kops_SSHCredentialList(in, out, s)
}

func autoConvert_kops_SSHCredentialList_To_v1alpha1_SSHCredentialList(in *kops.SSHCredentialList, out *SSHCredentialList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]SSHCredential, len(*in))
		for i := range *in {
			if err := Convert_kops_SSHCredential_To_v1alpha1_SSHCredential(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_kops_SSHCredentialList_To_v1alpha1_SSHCredentialList is an autogenerated conversion function.
func Convert_kops_SSHCredentialList_To_v1alpha1_SSHCredentialList(in *kops.SSHCredentialList, out *SSHCredentialList, s conversion.Scope) error {
	return autoConvert_kops_SSHCredentialList_To_v1alpha1_SSHCredentialList(in, out, s)
}

func autoConvert_v1alpha1_SSHCredentialSpec_To_kops_SSHCredentialSpec(in *SSHCredentialSpec, out *kops.SSHCredentialSpec, s conversion.Scope) error {
	out.PublicKey = in.PublicKey
	return nil
}

// Convert_v1alpha1_SSHCredentialSpec_To_kops_SSHCredentialSpec is an autogenerated conversion function.
func Convert_v1alpha1_SSHCredentialSpec_To_kops_SSHCredentialSpec(in *SSHCredentialSpec, out *kops.SSHCredentialSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_SSHCredentialSpec_To_kops_SSHCredentialSpec(in, out, s)
}

func autoConvert_kops_SSHCredentialSpec_To_v1alpha1_SSHCredentialSpec(in *kops.SSHCredentialSpec, out *SSHCredentialSpec, s conversion.Scope) error {
	out.PublicKey = in.PublicKey
	return nil
}

// Convert_kops_SSHCredentialSpec_To_v1alpha1_SSHCredentialSpec is an autogenerated conversion function.
func Convert_kops_SSHCredentialSpec_To_v1alpha1_SSHCredentialSpec(in *kops.SSHCredentialSpec, out *SSHCredentialSpec, s conversion.Scope) error {
	return autoConvert_kops_SSHCredentialSpec_To_v1alpha1_SSHCredentialSpec(in, out, s)
}

func autoConvert_v1alpha1_TargetSpec_To_kops_TargetSpec(in *TargetSpec, out *kops.TargetSpec, s conversion.Scope) error {
	if in.Terraform != nil {
		in, out := &in.Terraform, &out.Terraform
		*out = new(kops.TerraformSpec)
		if err := Convert_v1alpha1_TerraformSpec_To_kops_TerraformSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Terraform = nil
	}
	return nil
}

// Convert_v1alpha1_TargetSpec_To_kops_TargetSpec is an autogenerated conversion function.
func Convert_v1alpha1_TargetSpec_To_kops_TargetSpec(in *TargetSpec, out *kops.TargetSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_TargetSpec_To_kops_TargetSpec(in, out, s)
}

func autoConvert_kops_TargetSpec_To_v1alpha1_TargetSpec(in *kops.TargetSpec, out *TargetSpec, s conversion.Scope) error {
	if in.Terraform != nil {
		in, out := &in.Terraform, &out.Terraform
		*out = new(TerraformSpec)
		if err := Convert_kops_TerraformSpec_To_v1alpha1_TerraformSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Terraform = nil
	}
	return nil
}

// Convert_kops_TargetSpec_To_v1alpha1_TargetSpec is an autogenerated conversion function.
func Convert_kops_TargetSpec_To_v1alpha1_TargetSpec(in *kops.TargetSpec, out *TargetSpec, s conversion.Scope) error {
	return autoConvert_kops_TargetSpec_To_v1alpha1_TargetSpec(in, out, s)
}

func autoConvert_v1alpha1_TerraformSpec_To_kops_TerraformSpec(in *TerraformSpec, out *kops.TerraformSpec, s conversion.Scope) error {
	out.ProviderExtraConfig = in.ProviderExtraConfig
	return nil
}

// Convert_v1alpha1_TerraformSpec_To_kops_TerraformSpec is an autogenerated conversion function.
func Convert_v1alpha1_TerraformSpec_To_kops_TerraformSpec(in *TerraformSpec, out *kops.TerraformSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_TerraformSpec_To_kops_TerraformSpec(in, out, s)
}

func autoConvert_kops_TerraformSpec_To_v1alpha1_TerraformSpec(in *kops.TerraformSpec, out *TerraformSpec, s conversion.Scope) error {
	out.ProviderExtraConfig = in.ProviderExtraConfig
	return nil
}

// Convert_kops_TerraformSpec_To_v1alpha1_TerraformSpec is an autogenerated conversion function.
func Convert_kops_TerraformSpec_To_v1alpha1_TerraformSpec(in *kops.TerraformSpec, out *TerraformSpec, s conversion.Scope) error {
	return autoConvert_kops_TerraformSpec_To_v1alpha1_TerraformSpec(in, out, s)
}

func autoConvert_v1alpha1_UserData_To_kops_UserData(in *UserData, out *kops.UserData, s conversion.Scope) error {
	out.Name = in.Name
	out.Type = in.Type
	out.Content = in.Content
	return nil
}

// Convert_v1alpha1_UserData_To_kops_UserData is an autogenerated conversion function.
func Convert_v1alpha1_UserData_To_kops_UserData(in *UserData, out *kops.UserData, s conversion.Scope) error {
	return autoConvert_v1alpha1_UserData_To_kops_UserData(in, out, s)
}

func autoConvert_kops_UserData_To_v1alpha1_UserData(in *kops.UserData, out *UserData, s conversion.Scope) error {
	out.Name = in.Name
	out.Type = in.Type
	out.Content = in.Content
	return nil
}

// Convert_kops_UserData_To_v1alpha1_UserData is an autogenerated conversion function.
func Convert_kops_UserData_To_v1alpha1_UserData(in *kops.UserData, out *UserData, s conversion.Scope) error {
	return autoConvert_kops_UserData_To_v1alpha1_UserData(in, out, s)
}

func autoConvert_v1alpha1_WeaveNetworkingSpec_To_kops_WeaveNetworkingSpec(in *WeaveNetworkingSpec, out *kops.WeaveNetworkingSpec, s conversion.Scope) error {
	out.MTU = in.MTU
	out.ConnLimit = in.ConnLimit
	return nil
}

// Convert_v1alpha1_WeaveNetworkingSpec_To_kops_WeaveNetworkingSpec is an autogenerated conversion function.
func Convert_v1alpha1_WeaveNetworkingSpec_To_kops_WeaveNetworkingSpec(in *WeaveNetworkingSpec, out *kops.WeaveNetworkingSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_WeaveNetworkingSpec_To_kops_WeaveNetworkingSpec(in, out, s)
}

func autoConvert_kops_WeaveNetworkingSpec_To_v1alpha1_WeaveNetworkingSpec(in *kops.WeaveNetworkingSpec, out *WeaveNetworkingSpec, s conversion.Scope) error {
	out.MTU = in.MTU
	out.ConnLimit = in.ConnLimit
	return nil
}

// Convert_kops_WeaveNetworkingSpec_To_v1alpha1_WeaveNetworkingSpec is an autogenerated conversion function.
func Convert_kops_WeaveNetworkingSpec_To_v1alpha1_WeaveNetworkingSpec(in *kops.WeaveNetworkingSpec, out *WeaveNetworkingSpec, s conversion.Scope) error {
	return autoConvert_kops_WeaveNetworkingSpec_To_v1alpha1_WeaveNetworkingSpec(in, out, s)
}
