// +build !ignore_autogenerated

/*
Copyright 2018 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// This file was autogenerated by deepcopy-gen. Do not edit it manually!

package kops

import (
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
)

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AccessSpec) DeepCopyInto(out *AccessSpec) {
	*out = *in
	if in.DNS != nil {
		in, out := &in.DNS, &out.DNS
		if *in == nil {
			*out = nil
		} else {
			*out = new(DNSAccessSpec)
			**out = **in
		}
	}
	if in.LoadBalancer != nil {
		in, out := &in.LoadBalancer, &out.LoadBalancer
		if *in == nil {
			*out = nil
		} else {
			*out = new(LoadBalancerAccessSpec)
			(*in).DeepCopyInto(*out)
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AccessSpec.
func (in *AccessSpec) DeepCopy() *AccessSpec {
	if in == nil {
		return nil
	}
	out := new(AccessSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AddonSpec) DeepCopyInto(out *AddonSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AddonSpec.
func (in *AddonSpec) DeepCopy() *AddonSpec {
	if in == nil {
		return nil
	}
	out := new(AddonSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AlwaysAllowAuthorizationSpec) DeepCopyInto(out *AlwaysAllowAuthorizationSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AlwaysAllowAuthorizationSpec.
func (in *AlwaysAllowAuthorizationSpec) DeepCopy() *AlwaysAllowAuthorizationSpec {
	if in == nil {
		return nil
	}
	out := new(AlwaysAllowAuthorizationSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AmazonVPCNetworkingSpec) DeepCopyInto(out *AmazonVPCNetworkingSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AmazonVPCNetworkingSpec.
func (in *AmazonVPCNetworkingSpec) DeepCopy() *AmazonVPCNetworkingSpec {
	if in == nil {
		return nil
	}
	out := new(AmazonVPCNetworkingSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ApiIngressStatus) DeepCopyInto(out *ApiIngressStatus) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ApiIngressStatus.
func (in *ApiIngressStatus) DeepCopy() *ApiIngressStatus {
	if in == nil {
		return nil
	}
	out := new(ApiIngressStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Assets) DeepCopyInto(out *Assets) {
	*out = *in
	if in.ContainerRegistry != nil {
		in, out := &in.ContainerRegistry, &out.ContainerRegistry
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.FileRepository != nil {
		in, out := &in.FileRepository, &out.FileRepository
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Assets.
func (in *Assets) DeepCopy() *Assets {
	if in == nil {
		return nil
	}
	out := new(Assets)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AuthenticationSpec) DeepCopyInto(out *AuthenticationSpec) {
	*out = *in
	if in.Kopeio != nil {
		in, out := &in.Kopeio, &out.Kopeio
		if *in == nil {
			*out = nil
		} else {
			*out = new(KopeioAuthenticationSpec)
			**out = **in
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AuthenticationSpec.
func (in *AuthenticationSpec) DeepCopy() *AuthenticationSpec {
	if in == nil {
		return nil
	}
	out := new(AuthenticationSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AuthorizationSpec) DeepCopyInto(out *AuthorizationSpec) {
	*out = *in
	if in.AlwaysAllow != nil {
		in, out := &in.AlwaysAllow, &out.AlwaysAllow
		if *in == nil {
			*out = nil
		} else {
			*out = new(AlwaysAllowAuthorizationSpec)
			**out = **in
		}
	}
	if in.RBAC != nil {
		in, out := &in.RBAC, &out.RBAC
		if *in == nil {
			*out = nil
		} else {
			*out = new(RBACAuthorizationSpec)
			**out = **in
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AuthorizationSpec.
func (in *AuthorizationSpec) DeepCopy() *AuthorizationSpec {
	if in == nil {
		return nil
	}
	out := new(AuthorizationSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BastionSpec) DeepCopyInto(out *BastionSpec) {
	*out = *in
	if in.IdleTimeoutSeconds != nil {
		in, out := &in.IdleTimeoutSeconds, &out.IdleTimeoutSeconds
		if *in == nil {
			*out = nil
		} else {
			*out = new(int64)
			**out = **in
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BastionSpec.
func (in *BastionSpec) DeepCopy() *BastionSpec {
	if in == nil {
		return nil
	}
	out := new(BastionSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CNINetworkingSpec) DeepCopyInto(out *CNINetworkingSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CNINetworkingSpec.
func (in *CNINetworkingSpec) DeepCopy() *CNINetworkingSpec {
	if in == nil {
		return nil
	}
	out := new(CNINetworkingSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CalicoNetworkingSpec) DeepCopyInto(out *CalicoNetworkingSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CalicoNetworkingSpec.
func (in *CalicoNetworkingSpec) DeepCopy() *CalicoNetworkingSpec {
	if in == nil {
		return nil
	}
	out := new(CalicoNetworkingSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CanalNetworkingSpec) DeepCopyInto(out *CanalNetworkingSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CanalNetworkingSpec.
func (in *CanalNetworkingSpec) DeepCopy() *CanalNetworkingSpec {
	if in == nil {
		return nil
	}
	out := new(CanalNetworkingSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Channel) DeepCopyInto(out *Channel) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Channel.
func (in *Channel) DeepCopy() *Channel {
	if in == nil {
		return nil
	}
	out := new(Channel)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ChannelImageSpec) DeepCopyInto(out *ChannelImageSpec) {
	*out = *in
	if in.Labels != nil {
		in, out := &in.Labels, &out.Labels
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ChannelImageSpec.
func (in *ChannelImageSpec) DeepCopy() *ChannelImageSpec {
	if in == nil {
		return nil
	}
	out := new(ChannelImageSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ChannelSpec) DeepCopyInto(out *ChannelSpec) {
	*out = *in
	if in.Images != nil {
		in, out := &in.Images, &out.Images
		*out = make([]*ChannelImageSpec, len(*in))
		for i := range *in {
			if (*in)[i] == nil {
				(*out)[i] = nil
			} else {
				(*out)[i] = new(ChannelImageSpec)
				(*in)[i].DeepCopyInto((*out)[i])
			}
		}
	}
	if in.Cluster != nil {
		in, out := &in.Cluster, &out.Cluster
		if *in == nil {
			*out = nil
		} else {
			*out = new(ClusterSpec)
			(*in).DeepCopyInto(*out)
		}
	}
	if in.KopsVersions != nil {
		in, out := &in.KopsVersions, &out.KopsVersions
		*out = make([]KopsVersionSpec, len(*in))
		copy(*out, *in)
	}
	if in.KubernetesVersions != nil {
		in, out := &in.KubernetesVersions, &out.KubernetesVersions
		*out = make([]KubernetesVersionSpec, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ChannelSpec.
func (in *ChannelSpec) DeepCopy() *ChannelSpec {
	if in == nil {
		return nil
	}
	out := new(ChannelSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CiliumNetworkingSpec) DeepCopyInto(out *CiliumNetworkingSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CiliumNetworkingSpec.
func (in *CiliumNetworkingSpec) DeepCopy() *CiliumNetworkingSpec {
	if in == nil {
		return nil
	}
	out := new(CiliumNetworkingSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClassicNetworkingSpec) DeepCopyInto(out *ClassicNetworkingSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClassicNetworkingSpec.
func (in *ClassicNetworkingSpec) DeepCopy() *ClassicNetworkingSpec {
	if in == nil {
		return nil
	}
	out := new(ClassicNetworkingSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CloudConfiguration) DeepCopyInto(out *CloudConfiguration) {
	*out = *in
	if in.Multizone != nil {
		in, out := &in.Multizone, &out.Multizone
		if *in == nil {
			*out = nil
		} else {
			*out = new(bool)
			**out = **in
		}
	}
	if in.NodeTags != nil {
		in, out := &in.NodeTags, &out.NodeTags
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.NodeInstancePrefix != nil {
		in, out := &in.NodeInstancePrefix, &out.NodeInstancePrefix
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.DisableSecurityGroupIngress != nil {
		in, out := &in.DisableSecurityGroupIngress, &out.DisableSecurityGroupIngress
		if *in == nil {
			*out = nil
		} else {
			*out = new(bool)
			**out = **in
		}
	}
	if in.ElbSecurityGroup != nil {
		in, out := &in.ElbSecurityGroup, &out.ElbSecurityGroup
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.VSphereUsername != nil {
		in, out := &in.VSphereUsername, &out.VSphereUsername
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.VSpherePassword != nil {
		in, out := &in.VSpherePassword, &out.VSpherePassword
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.VSphereServer != nil {
		in, out := &in.VSphereServer, &out.VSphereServer
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.VSphereDatacenter != nil {
		in, out := &in.VSphereDatacenter, &out.VSphereDatacenter
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.VSphereResourcePool != nil {
		in, out := &in.VSphereResourcePool, &out.VSphereResourcePool
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.VSphereDatastore != nil {
		in, out := &in.VSphereDatastore, &out.VSphereDatastore
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.VSphereCoreDNSServer != nil {
		in, out := &in.VSphereCoreDNSServer, &out.VSphereCoreDNSServer
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CloudConfiguration.
func (in *CloudConfiguration) DeepCopy() *CloudConfiguration {
	if in == nil {
		return nil
	}
	out := new(CloudConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CloudControllerManagerConfig) DeepCopyInto(out *CloudControllerManagerConfig) {
	*out = *in
	if in.AllocateNodeCIDRs != nil {
		in, out := &in.AllocateNodeCIDRs, &out.AllocateNodeCIDRs
		if *in == nil {
			*out = nil
		} else {
			*out = new(bool)
			**out = **in
		}
	}
	if in.ConfigureCloudRoutes != nil {
		in, out := &in.ConfigureCloudRoutes, &out.ConfigureCloudRoutes
		if *in == nil {
			*out = nil
		} else {
			*out = new(bool)
			**out = **in
		}
	}
	if in.CIDRAllocatorType != nil {
		in, out := &in.CIDRAllocatorType, &out.CIDRAllocatorType
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.LeaderElection != nil {
		in, out := &in.LeaderElection, &out.LeaderElection
		if *in == nil {
			*out = nil
		} else {
			*out = new(LeaderElectionConfiguration)
			(*in).DeepCopyInto(*out)
		}
	}
	if in.UseServiceAccountCredentials != nil {
		in, out := &in.UseServiceAccountCredentials, &out.UseServiceAccountCredentials
		if *in == nil {
			*out = nil
		} else {
			*out = new(bool)
			**out = **in
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CloudControllerManagerConfig.
func (in *CloudControllerManagerConfig) DeepCopy() *CloudControllerManagerConfig {
	if in == nil {
		return nil
	}
	out := new(CloudControllerManagerConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Cluster) DeepCopyInto(out *Cluster) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Cluster.
func (in *Cluster) DeepCopy() *Cluster {
	if in == nil {
		return nil
	}
	out := new(Cluster)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *Cluster) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterList) DeepCopyInto(out *ClusterList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Cluster, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterList.
func (in *ClusterList) DeepCopy() *ClusterList {
	if in == nil {
		return nil
	}
	out := new(ClusterList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *ClusterList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterSpec) DeepCopyInto(out *ClusterSpec) {
	*out = *in
	if in.Addons != nil {
		in, out := &in.Addons, &out.Addons
		*out = make([]AddonSpec, len(*in))
		copy(*out, *in)
	}
	if in.Subnets != nil {
		in, out := &in.Subnets, &out.Subnets
		*out = make([]ClusterSubnetSpec, len(*in))
		copy(*out, *in)
	}
	if in.AdditionalNetworkCIDRs != nil {
		in, out := &in.AdditionalNetworkCIDRs, &out.AdditionalNetworkCIDRs
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Topology != nil {
		in, out := &in.Topology, &out.Topology
		if *in == nil {
			*out = nil
		} else {
			*out = new(TopologySpec)
			(*in).DeepCopyInto(*out)
		}
	}
	if in.AdditionalSANs != nil {
		in, out := &in.AdditionalSANs, &out.AdditionalSANs
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.SSHAccess != nil {
		in, out := &in.SSHAccess, &out.SSHAccess
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.NodePortAccess != nil {
		in, out := &in.NodePortAccess, &out.NodePortAccess
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.EgressProxy != nil {
		in, out := &in.EgressProxy, &out.EgressProxy
		if *in == nil {
			*out = nil
		} else {
			*out = new(EgressProxySpec)
			**out = **in
		}
	}
	if in.KubernetesAPIAccess != nil {
		in, out := &in.KubernetesAPIAccess, &out.KubernetesAPIAccess
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.IsolateMasters != nil {
		in, out := &in.IsolateMasters, &out.IsolateMasters
		if *in == nil {
			*out = nil
		} else {
			*out = new(bool)
			**out = **in
		}
	}
	if in.UpdatePolicy != nil {
		in, out := &in.UpdatePolicy, &out.UpdatePolicy
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.AdditionalPolicies != nil {
		in, out := &in.AdditionalPolicies, &out.AdditionalPolicies
		if *in == nil {
			*out = nil
		} else {
			*out = new(map[string]string)
			if **in != nil {
				in, out := *in, *out
				*out = make(map[string]string, len(*in))
				for key, val := range *in {
					(*out)[key] = val
				}
			}
		}
	}
	if in.FileAssets != nil {
		in, out := &in.FileAssets, &out.FileAssets
		*out = make([]FileAssetSpec, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.EtcdClusters != nil {
		in, out := &in.EtcdClusters, &out.EtcdClusters
		*out = make([]*EtcdClusterSpec, len(*in))
		for i := range *in {
			if (*in)[i] == nil {
				(*out)[i] = nil
			} else {
				(*out)[i] = new(EtcdClusterSpec)
				(*in)[i].DeepCopyInto((*out)[i])
			}
		}
	}
	if in.Docker != nil {
		in, out := &in.Docker, &out.Docker
		if *in == nil {
			*out = nil
		} else {
			*out = new(DockerConfig)
			(*in).DeepCopyInto(*out)
		}
	}
	if in.KubeDNS != nil {
		in, out := &in.KubeDNS, &out.KubeDNS
		if *in == nil {
			*out = nil
		} else {
			*out = new(KubeDNSConfig)
			**out = **in
		}
	}
	if in.KubeAPIServer != nil {
		in, out := &in.KubeAPIServer, &out.KubeAPIServer
		if *in == nil {
			*out = nil
		} else {
			*out = new(KubeAPIServerConfig)
			(*in).DeepCopyInto(*out)
		}
	}
	if in.KubeControllerManager != nil {
		in, out := &in.KubeControllerManager, &out.KubeControllerManager
		if *in == nil {
			*out = nil
		} else {
			*out = new(KubeControllerManagerConfig)
			(*in).DeepCopyInto(*out)
		}
	}
	if in.ExternalCloudControllerManager != nil {
		in, out := &in.ExternalCloudControllerManager, &out.ExternalCloudControllerManager
		if *in == nil {
			*out = nil
		} else {
			*out = new(CloudControllerManagerConfig)
			(*in).DeepCopyInto(*out)
		}
	}
	if in.KubeScheduler != nil {
		in, out := &in.KubeScheduler, &out.KubeScheduler
		if *in == nil {
			*out = nil
		} else {
			*out = new(KubeSchedulerConfig)
			(*in).DeepCopyInto(*out)
		}
	}
	if in.KubeProxy != nil {
		in, out := &in.KubeProxy, &out.KubeProxy
		if *in == nil {
			*out = nil
		} else {
			*out = new(KubeProxyConfig)
			(*in).DeepCopyInto(*out)
		}
	}
	if in.Kubelet != nil {
		in, out := &in.Kubelet, &out.Kubelet
		if *in == nil {
			*out = nil
		} else {
			*out = new(KubeletConfigSpec)
			(*in).DeepCopyInto(*out)
		}
	}
	if in.MasterKubelet != nil {
		in, out := &in.MasterKubelet, &out.MasterKubelet
		if *in == nil {
			*out = nil
		} else {
			*out = new(KubeletConfigSpec)
			(*in).DeepCopyInto(*out)
		}
	}
	if in.CloudConfig != nil {
		in, out := &in.CloudConfig, &out.CloudConfig
		if *in == nil {
			*out = nil
		} else {
			*out = new(CloudConfiguration)
			(*in).DeepCopyInto(*out)
		}
	}
	if in.ExternalDNS != nil {
		in, out := &in.ExternalDNS, &out.ExternalDNS
		if *in == nil {
			*out = nil
		} else {
			*out = new(ExternalDNSConfig)
			(*in).DeepCopyInto(*out)
		}
	}
	if in.Networking != nil {
		in, out := &in.Networking, &out.Networking
		if *in == nil {
			*out = nil
		} else {
			*out = new(NetworkingSpec)
			(*in).DeepCopyInto(*out)
		}
	}
	if in.API != nil {
		in, out := &in.API, &out.API
		if *in == nil {
			*out = nil
		} else {
			*out = new(AccessSpec)
			(*in).DeepCopyInto(*out)
		}
	}
	if in.Authentication != nil {
		in, out := &in.Authentication, &out.Authentication
		if *in == nil {
			*out = nil
		} else {
			*out = new(AuthenticationSpec)
			(*in).DeepCopyInto(*out)
		}
	}
	if in.Authorization != nil {
		in, out := &in.Authorization, &out.Authorization
		if *in == nil {
			*out = nil
		} else {
			*out = new(AuthorizationSpec)
			(*in).DeepCopyInto(*out)
		}
	}
	if in.CloudLabels != nil {
		in, out := &in.CloudLabels, &out.CloudLabels
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Hooks != nil {
		in, out := &in.Hooks, &out.Hooks
		*out = make([]HookSpec, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Assets != nil {
		in, out := &in.Assets, &out.Assets
		if *in == nil {
			*out = nil
		} else {
			*out = new(Assets)
			(*in).DeepCopyInto(*out)
		}
	}
	if in.IAM != nil {
		in, out := &in.IAM, &out.IAM
		if *in == nil {
			*out = nil
		} else {
			*out = new(IAMSpec)
			**out = **in
		}
	}
	if in.EncryptionConfig != nil {
		in, out := &in.EncryptionConfig, &out.EncryptionConfig
		if *in == nil {
			*out = nil
		} else {
			*out = new(bool)
			**out = **in
		}
	}
	if in.Target != nil {
		in, out := &in.Target, &out.Target
		if *in == nil {
			*out = nil
		} else {
			*out = new(TargetSpec)
			(*in).DeepCopyInto(*out)
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterSpec.
func (in *ClusterSpec) DeepCopy() *ClusterSpec {
	if in == nil {
		return nil
	}
	out := new(ClusterSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterStatus) DeepCopyInto(out *ClusterStatus) {
	*out = *in
	if in.EtcdClusters != nil {
		in, out := &in.EtcdClusters, &out.EtcdClusters
		*out = make([]EtcdClusterStatus, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterStatus.
func (in *ClusterStatus) DeepCopy() *ClusterStatus {
	if in == nil {
		return nil
	}
	out := new(ClusterStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterSubnetSpec) DeepCopyInto(out *ClusterSubnetSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterSubnetSpec.
func (in *ClusterSubnetSpec) DeepCopy() *ClusterSubnetSpec {
	if in == nil {
		return nil
	}
	out := new(ClusterSubnetSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DNSAccessSpec) DeepCopyInto(out *DNSAccessSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DNSAccessSpec.
func (in *DNSAccessSpec) DeepCopy() *DNSAccessSpec {
	if in == nil {
		return nil
	}
	out := new(DNSAccessSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DNSSpec) DeepCopyInto(out *DNSSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DNSSpec.
func (in *DNSSpec) DeepCopy() *DNSSpec {
	if in == nil {
		return nil
	}
	out := new(DNSSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DockerConfig) DeepCopyInto(out *DockerConfig) {
	*out = *in
	if in.AuthorizationPlugins != nil {
		in, out := &in.AuthorizationPlugins, &out.AuthorizationPlugins
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Bridge != nil {
		in, out := &in.Bridge, &out.Bridge
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.BridgeIP != nil {
		in, out := &in.BridgeIP, &out.BridgeIP
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.DefaultUlimit != nil {
		in, out := &in.DefaultUlimit, &out.DefaultUlimit
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Hosts != nil {
		in, out := &in.Hosts, &out.Hosts
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.IPMasq != nil {
		in, out := &in.IPMasq, &out.IPMasq
		if *in == nil {
			*out = nil
		} else {
			*out = new(bool)
			**out = **in
		}
	}
	if in.IPTables != nil {
		in, out := &in.IPTables, &out.IPTables
		if *in == nil {
			*out = nil
		} else {
			*out = new(bool)
			**out = **in
		}
	}
	if in.InsecureRegistry != nil {
		in, out := &in.InsecureRegistry, &out.InsecureRegistry
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.LiveRestore != nil {
		in, out := &in.LiveRestore, &out.LiveRestore
		if *in == nil {
			*out = nil
		} else {
			*out = new(bool)
			**out = **in
		}
	}
	if in.LogLevel != nil {
		in, out := &in.LogLevel, &out.LogLevel
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.LogOpt != nil {
		in, out := &in.LogOpt, &out.LogOpt
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.MTU != nil {
		in, out := &in.MTU, &out.MTU
		if *in == nil {
			*out = nil
		} else {
			*out = new(int32)
			**out = **in
		}
	}
	if in.RegistryMirrors != nil {
		in, out := &in.RegistryMirrors, &out.RegistryMirrors
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Storage != nil {
		in, out := &in.Storage, &out.Storage
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.StorageOpts != nil {
		in, out := &in.StorageOpts, &out.StorageOpts
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Version != nil {
		in, out := &in.Version, &out.Version
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DockerConfig.
func (in *DockerConfig) DeepCopy() *DockerConfig {
	if in == nil {
		return nil
	}
	out := new(DockerConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EgressProxySpec) DeepCopyInto(out *EgressProxySpec) {
	*out = *in
	out.HTTPProxy = in.HTTPProxy
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EgressProxySpec.
func (in *EgressProxySpec) DeepCopy() *EgressProxySpec {
	if in == nil {
		return nil
	}
	out := new(EgressProxySpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EtcdBackupSpec) DeepCopyInto(out *EtcdBackupSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EtcdBackupSpec.
func (in *EtcdBackupSpec) DeepCopy() *EtcdBackupSpec {
	if in == nil {
		return nil
	}
	out := new(EtcdBackupSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EtcdClusterSpec) DeepCopyInto(out *EtcdClusterSpec) {
	*out = *in
	if in.Members != nil {
		in, out := &in.Members, &out.Members
		*out = make([]*EtcdMemberSpec, len(*in))
		for i := range *in {
			if (*in)[i] == nil {
				(*out)[i] = nil
			} else {
				(*out)[i] = new(EtcdMemberSpec)
				(*in)[i].DeepCopyInto((*out)[i])
			}
		}
	}
	if in.LeaderElectionTimeout != nil {
		in, out := &in.LeaderElectionTimeout, &out.LeaderElectionTimeout
		if *in == nil {
			*out = nil
		} else {
			*out = new(v1.Duration)
			**out = **in
		}
	}
	if in.HeartbeatInterval != nil {
		in, out := &in.HeartbeatInterval, &out.HeartbeatInterval
		if *in == nil {
			*out = nil
		} else {
			*out = new(v1.Duration)
			**out = **in
		}
	}
	if in.Backups != nil {
		in, out := &in.Backups, &out.Backups
		if *in == nil {
			*out = nil
		} else {
			*out = new(EtcdBackupSpec)
			**out = **in
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EtcdClusterSpec.
func (in *EtcdClusterSpec) DeepCopy() *EtcdClusterSpec {
	if in == nil {
		return nil
	}
	out := new(EtcdClusterSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EtcdClusterStatus) DeepCopyInto(out *EtcdClusterStatus) {
	*out = *in
	if in.Members != nil {
		in, out := &in.Members, &out.Members
		*out = make([]*EtcdMemberStatus, len(*in))
		for i := range *in {
			if (*in)[i] == nil {
				(*out)[i] = nil
			} else {
				(*out)[i] = new(EtcdMemberStatus)
				(*in)[i].DeepCopyInto((*out)[i])
			}
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EtcdClusterStatus.
func (in *EtcdClusterStatus) DeepCopy() *EtcdClusterStatus {
	if in == nil {
		return nil
	}
	out := new(EtcdClusterStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EtcdMemberSpec) DeepCopyInto(out *EtcdMemberSpec) {
	*out = *in
	if in.InstanceGroup != nil {
		in, out := &in.InstanceGroup, &out.InstanceGroup
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.VolumeType != nil {
		in, out := &in.VolumeType, &out.VolumeType
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.VolumeIops != nil {
		in, out := &in.VolumeIops, &out.VolumeIops
		if *in == nil {
			*out = nil
		} else {
			*out = new(int32)
			**out = **in
		}
	}
	if in.VolumeSize != nil {
		in, out := &in.VolumeSize, &out.VolumeSize
		if *in == nil {
			*out = nil
		} else {
			*out = new(int32)
			**out = **in
		}
	}
	if in.KmsKeyId != nil {
		in, out := &in.KmsKeyId, &out.KmsKeyId
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.EncryptedVolume != nil {
		in, out := &in.EncryptedVolume, &out.EncryptedVolume
		if *in == nil {
			*out = nil
		} else {
			*out = new(bool)
			**out = **in
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EtcdMemberSpec.
func (in *EtcdMemberSpec) DeepCopy() *EtcdMemberSpec {
	if in == nil {
		return nil
	}
	out := new(EtcdMemberSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EtcdMemberStatus) DeepCopyInto(out *EtcdMemberStatus) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EtcdMemberStatus.
func (in *EtcdMemberStatus) DeepCopy() *EtcdMemberStatus {
	if in == nil {
		return nil
	}
	out := new(EtcdMemberStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExecContainerAction) DeepCopyInto(out *ExecContainerAction) {
	*out = *in
	if in.Command != nil {
		in, out := &in.Command, &out.Command
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Environment != nil {
		in, out := &in.Environment, &out.Environment
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExecContainerAction.
func (in *ExecContainerAction) DeepCopy() *ExecContainerAction {
	if in == nil {
		return nil
	}
	out := new(ExecContainerAction)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExternalDNSConfig) DeepCopyInto(out *ExternalDNSConfig) {
	*out = *in
	if in.WatchIngress != nil {
		in, out := &in.WatchIngress, &out.WatchIngress
		if *in == nil {
			*out = nil
		} else {
			*out = new(bool)
			**out = **in
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExternalDNSConfig.
func (in *ExternalDNSConfig) DeepCopy() *ExternalDNSConfig {
	if in == nil {
		return nil
	}
	out := new(ExternalDNSConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExternalNetworkingSpec) DeepCopyInto(out *ExternalNetworkingSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExternalNetworkingSpec.
func (in *ExternalNetworkingSpec) DeepCopy() *ExternalNetworkingSpec {
	if in == nil {
		return nil
	}
	out := new(ExternalNetworkingSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FileAssetSpec) DeepCopyInto(out *FileAssetSpec) {
	*out = *in
	if in.Roles != nil {
		in, out := &in.Roles, &out.Roles
		*out = make([]InstanceGroupRole, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FileAssetSpec.
func (in *FileAssetSpec) DeepCopy() *FileAssetSpec {
	if in == nil {
		return nil
	}
	out := new(FileAssetSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FlannelNetworkingSpec) DeepCopyInto(out *FlannelNetworkingSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FlannelNetworkingSpec.
func (in *FlannelNetworkingSpec) DeepCopy() *FlannelNetworkingSpec {
	if in == nil {
		return nil
	}
	out := new(FlannelNetworkingSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *HTTPProxy) DeepCopyInto(out *HTTPProxy) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new HTTPProxy.
func (in *HTTPProxy) DeepCopy() *HTTPProxy {
	if in == nil {
		return nil
	}
	out := new(HTTPProxy)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *HookSpec) DeepCopyInto(out *HookSpec) {
	*out = *in
	if in.Roles != nil {
		in, out := &in.Roles, &out.Roles
		*out = make([]InstanceGroupRole, len(*in))
		copy(*out, *in)
	}
	if in.Requires != nil {
		in, out := &in.Requires, &out.Requires
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Before != nil {
		in, out := &in.Before, &out.Before
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.ExecContainer != nil {
		in, out := &in.ExecContainer, &out.ExecContainer
		if *in == nil {
			*out = nil
		} else {
			*out = new(ExecContainerAction)
			(*in).DeepCopyInto(*out)
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new HookSpec.
func (in *HookSpec) DeepCopy() *HookSpec {
	if in == nil {
		return nil
	}
	out := new(HookSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IAMSpec) DeepCopyInto(out *IAMSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IAMSpec.
func (in *IAMSpec) DeepCopy() *IAMSpec {
	if in == nil {
		return nil
	}
	out := new(IAMSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *InstanceGroup) DeepCopyInto(out *InstanceGroup) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new InstanceGroup.
func (in *InstanceGroup) DeepCopy() *InstanceGroup {
	if in == nil {
		return nil
	}
	out := new(InstanceGroup)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *InstanceGroup) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *InstanceGroupList) DeepCopyInto(out *InstanceGroupList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]InstanceGroup, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new InstanceGroupList.
func (in *InstanceGroupList) DeepCopy() *InstanceGroupList {
	if in == nil {
		return nil
	}
	out := new(InstanceGroupList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *InstanceGroupList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *InstanceGroupSpec) DeepCopyInto(out *InstanceGroupSpec) {
	*out = *in
	if in.MinSize != nil {
		in, out := &in.MinSize, &out.MinSize
		if *in == nil {
			*out = nil
		} else {
			*out = new(int32)
			**out = **in
		}
	}
	if in.MaxSize != nil {
		in, out := &in.MaxSize, &out.MaxSize
		if *in == nil {
			*out = nil
		} else {
			*out = new(int32)
			**out = **in
		}
	}
	if in.RootVolumeSize != nil {
		in, out := &in.RootVolumeSize, &out.RootVolumeSize
		if *in == nil {
			*out = nil
		} else {
			*out = new(int32)
			**out = **in
		}
	}
	if in.RootVolumeType != nil {
		in, out := &in.RootVolumeType, &out.RootVolumeType
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.RootVolumeIops != nil {
		in, out := &in.RootVolumeIops, &out.RootVolumeIops
		if *in == nil {
			*out = nil
		} else {
			*out = new(int32)
			**out = **in
		}
	}
	if in.RootVolumeOptimization != nil {
		in, out := &in.RootVolumeOptimization, &out.RootVolumeOptimization
		if *in == nil {
			*out = nil
		} else {
			*out = new(bool)
			**out = **in
		}
	}
	if in.Subnets != nil {
		in, out := &in.Subnets, &out.Subnets
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Zones != nil {
		in, out := &in.Zones, &out.Zones
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Hooks != nil {
		in, out := &in.Hooks, &out.Hooks
		*out = make([]HookSpec, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.MaxPrice != nil {
		in, out := &in.MaxPrice, &out.MaxPrice
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.AssociatePublicIP != nil {
		in, out := &in.AssociatePublicIP, &out.AssociatePublicIP
		if *in == nil {
			*out = nil
		} else {
			*out = new(bool)
			**out = **in
		}
	}
	if in.AdditionalSecurityGroups != nil {
		in, out := &in.AdditionalSecurityGroups, &out.AdditionalSecurityGroups
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.CloudLabels != nil {
		in, out := &in.CloudLabels, &out.CloudLabels
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.NodeLabels != nil {
		in, out := &in.NodeLabels, &out.NodeLabels
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.FileAssets != nil {
		in, out := &in.FileAssets, &out.FileAssets
		*out = make([]FileAssetSpec, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Kubelet != nil {
		in, out := &in.Kubelet, &out.Kubelet
		if *in == nil {
			*out = nil
		} else {
			*out = new(KubeletConfigSpec)
			(*in).DeepCopyInto(*out)
		}
	}
	if in.Taints != nil {
		in, out := &in.Taints, &out.Taints
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.AdditionalUserData != nil {
		in, out := &in.AdditionalUserData, &out.AdditionalUserData
		*out = make([]UserData, len(*in))
		copy(*out, *in)
	}
	if in.SuspendProcesses != nil {
		in, out := &in.SuspendProcesses, &out.SuspendProcesses
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.DetailedInstanceMonitoring != nil {
		in, out := &in.DetailedInstanceMonitoring, &out.DetailedInstanceMonitoring
		if *in == nil {
			*out = nil
		} else {
			*out = new(bool)
			**out = **in
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new InstanceGroupSpec.
func (in *InstanceGroupSpec) DeepCopy() *InstanceGroupSpec {
	if in == nil {
		return nil
	}
	out := new(InstanceGroupSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Keyset) DeepCopyInto(out *Keyset) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Keyset.
func (in *Keyset) DeepCopy() *Keyset {
	if in == nil {
		return nil
	}
	out := new(Keyset)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *Keyset) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KeysetItem) DeepCopyInto(out *KeysetItem) {
	*out = *in
	if in.PublicMaterial != nil {
		in, out := &in.PublicMaterial, &out.PublicMaterial
		*out = make([]byte, len(*in))
		copy(*out, *in)
	}
	if in.PrivateMaterial != nil {
		in, out := &in.PrivateMaterial, &out.PrivateMaterial
		*out = make([]byte, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KeysetItem.
func (in *KeysetItem) DeepCopy() *KeysetItem {
	if in == nil {
		return nil
	}
	out := new(KeysetItem)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KeysetList) DeepCopyInto(out *KeysetList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Keyset, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KeysetList.
func (in *KeysetList) DeepCopy() *KeysetList {
	if in == nil {
		return nil
	}
	out := new(KeysetList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *KeysetList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KeysetSpec) DeepCopyInto(out *KeysetSpec) {
	*out = *in
	if in.Keys != nil {
		in, out := &in.Keys, &out.Keys
		*out = make([]KeysetItem, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KeysetSpec.
func (in *KeysetSpec) DeepCopy() *KeysetSpec {
	if in == nil {
		return nil
	}
	out := new(KeysetSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KopeioAuthenticationSpec) DeepCopyInto(out *KopeioAuthenticationSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KopeioAuthenticationSpec.
func (in *KopeioAuthenticationSpec) DeepCopy() *KopeioAuthenticationSpec {
	if in == nil {
		return nil
	}
	out := new(KopeioAuthenticationSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KopeioNetworkingSpec) DeepCopyInto(out *KopeioNetworkingSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KopeioNetworkingSpec.
func (in *KopeioNetworkingSpec) DeepCopy() *KopeioNetworkingSpec {
	if in == nil {
		return nil
	}
	out := new(KopeioNetworkingSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KopsVersionSpec) DeepCopyInto(out *KopsVersionSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KopsVersionSpec.
func (in *KopsVersionSpec) DeepCopy() *KopsVersionSpec {
	if in == nil {
		return nil
	}
	out := new(KopsVersionSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubeAPIServerConfig) DeepCopyInto(out *KubeAPIServerConfig) {
	*out = *in
	if in.AdmissionControl != nil {
		in, out := &in.AdmissionControl, &out.AdmissionControl
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.EtcdServers != nil {
		in, out := &in.EtcdServers, &out.EtcdServers
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.EtcdServersOverrides != nil {
		in, out := &in.EtcdServersOverrides, &out.EtcdServersOverrides
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.AllowPrivileged != nil {
		in, out := &in.AllowPrivileged, &out.AllowPrivileged
		if *in == nil {
			*out = nil
		} else {
			*out = new(bool)
			**out = **in
		}
	}
	if in.APIServerCount != nil {
		in, out := &in.APIServerCount, &out.APIServerCount
		if *in == nil {
			*out = nil
		} else {
			*out = new(int32)
			**out = **in
		}
	}
	if in.RuntimeConfig != nil {
		in, out := &in.RuntimeConfig, &out.RuntimeConfig
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.AnonymousAuth != nil {
		in, out := &in.AnonymousAuth, &out.AnonymousAuth
		if *in == nil {
			*out = nil
		} else {
			*out = new(bool)
			**out = **in
		}
	}
	if in.KubeletPreferredAddressTypes != nil {
		in, out := &in.KubeletPreferredAddressTypes, &out.KubeletPreferredAddressTypes
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.StorageBackend != nil {
		in, out := &in.StorageBackend, &out.StorageBackend
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.OIDCUsernameClaim != nil {
		in, out := &in.OIDCUsernameClaim, &out.OIDCUsernameClaim
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.OIDCUsernamePrefix != nil {
		in, out := &in.OIDCUsernamePrefix, &out.OIDCUsernamePrefix
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.OIDCGroupsClaim != nil {
		in, out := &in.OIDCGroupsClaim, &out.OIDCGroupsClaim
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.OIDCGroupsPrefix != nil {
		in, out := &in.OIDCGroupsPrefix, &out.OIDCGroupsPrefix
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.OIDCIssuerURL != nil {
		in, out := &in.OIDCIssuerURL, &out.OIDCIssuerURL
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.OIDCClientID != nil {
		in, out := &in.OIDCClientID, &out.OIDCClientID
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.OIDCCAFile != nil {
		in, out := &in.OIDCCAFile, &out.OIDCCAFile
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.ProxyClientCertFile != nil {
		in, out := &in.ProxyClientCertFile, &out.ProxyClientCertFile
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.ProxyClientKeyFile != nil {
		in, out := &in.ProxyClientKeyFile, &out.ProxyClientKeyFile
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.AuditLogFormat != nil {
		in, out := &in.AuditLogFormat, &out.AuditLogFormat
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.AuditLogPath != nil {
		in, out := &in.AuditLogPath, &out.AuditLogPath
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.AuditLogMaxAge != nil {
		in, out := &in.AuditLogMaxAge, &out.AuditLogMaxAge
		if *in == nil {
			*out = nil
		} else {
			*out = new(int32)
			**out = **in
		}
	}
	if in.AuditLogMaxBackups != nil {
		in, out := &in.AuditLogMaxBackups, &out.AuditLogMaxBackups
		if *in == nil {
			*out = nil
		} else {
			*out = new(int32)
			**out = **in
		}
	}
	if in.AuditLogMaxSize != nil {
		in, out := &in.AuditLogMaxSize, &out.AuditLogMaxSize
		if *in == nil {
			*out = nil
		} else {
			*out = new(int32)
			**out = **in
		}
	}
	if in.AuthenticationTokenWebhookConfigFile != nil {
		in, out := &in.AuthenticationTokenWebhookConfigFile, &out.AuthenticationTokenWebhookConfigFile
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.AuthenticationTokenWebhookCacheTTL != nil {
		in, out := &in.AuthenticationTokenWebhookCacheTTL, &out.AuthenticationTokenWebhookCacheTTL
		if *in == nil {
			*out = nil
		} else {
			*out = new(v1.Duration)
			**out = **in
		}
	}
	if in.AuthorizationMode != nil {
		in, out := &in.AuthorizationMode, &out.AuthorizationMode
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.AuthorizationRBACSuperUser != nil {
		in, out := &in.AuthorizationRBACSuperUser, &out.AuthorizationRBACSuperUser
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.ExperimentalEncryptionProviderConfig != nil {
		in, out := &in.ExperimentalEncryptionProviderConfig, &out.ExperimentalEncryptionProviderConfig
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.RequestheaderUsernameHeaders != nil {
		in, out := &in.RequestheaderUsernameHeaders, &out.RequestheaderUsernameHeaders
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.RequestheaderGroupHeaders != nil {
		in, out := &in.RequestheaderGroupHeaders, &out.RequestheaderGroupHeaders
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.RequestheaderExtraHeaderPrefixes != nil {
		in, out := &in.RequestheaderExtraHeaderPrefixes, &out.RequestheaderExtraHeaderPrefixes
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.RequestheaderAllowedNames != nil {
		in, out := &in.RequestheaderAllowedNames, &out.RequestheaderAllowedNames
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.FeatureGates != nil {
		in, out := &in.FeatureGates, &out.FeatureGates
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.EtcdQuorumRead != nil {
		in, out := &in.EtcdQuorumRead, &out.EtcdQuorumRead
		if *in == nil {
			*out = nil
		} else {
			*out = new(bool)
			**out = **in
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubeAPIServerConfig.
func (in *KubeAPIServerConfig) DeepCopy() *KubeAPIServerConfig {
	if in == nil {
		return nil
	}
	out := new(KubeAPIServerConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubeControllerManagerConfig) DeepCopyInto(out *KubeControllerManagerConfig) {
	*out = *in
	if in.AllocateNodeCIDRs != nil {
		in, out := &in.AllocateNodeCIDRs, &out.AllocateNodeCIDRs
		if *in == nil {
			*out = nil
		} else {
			*out = new(bool)
			**out = **in
		}
	}
	if in.ConfigureCloudRoutes != nil {
		in, out := &in.ConfigureCloudRoutes, &out.ConfigureCloudRoutes
		if *in == nil {
			*out = nil
		} else {
			*out = new(bool)
			**out = **in
		}
	}
	if in.CIDRAllocatorType != nil {
		in, out := &in.CIDRAllocatorType, &out.CIDRAllocatorType
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.LeaderElection != nil {
		in, out := &in.LeaderElection, &out.LeaderElection
		if *in == nil {
			*out = nil
		} else {
			*out = new(LeaderElectionConfiguration)
			(*in).DeepCopyInto(*out)
		}
	}
	if in.AttachDetachReconcileSyncPeriod != nil {
		in, out := &in.AttachDetachReconcileSyncPeriod, &out.AttachDetachReconcileSyncPeriod
		if *in == nil {
			*out = nil
		} else {
			*out = new(v1.Duration)
			**out = **in
		}
	}
	if in.TerminatedPodGCThreshold != nil {
		in, out := &in.TerminatedPodGCThreshold, &out.TerminatedPodGCThreshold
		if *in == nil {
			*out = nil
		} else {
			*out = new(int32)
			**out = **in
		}
	}
	if in.NodeMonitorPeriod != nil {
		in, out := &in.NodeMonitorPeriod, &out.NodeMonitorPeriod
		if *in == nil {
			*out = nil
		} else {
			*out = new(v1.Duration)
			**out = **in
		}
	}
	if in.NodeMonitorGracePeriod != nil {
		in, out := &in.NodeMonitorGracePeriod, &out.NodeMonitorGracePeriod
		if *in == nil {
			*out = nil
		} else {
			*out = new(v1.Duration)
			**out = **in
		}
	}
	if in.PodEvictionTimeout != nil {
		in, out := &in.PodEvictionTimeout, &out.PodEvictionTimeout
		if *in == nil {
			*out = nil
		} else {
			*out = new(v1.Duration)
			**out = **in
		}
	}
	if in.UseServiceAccountCredentials != nil {
		in, out := &in.UseServiceAccountCredentials, &out.UseServiceAccountCredentials
		if *in == nil {
			*out = nil
		} else {
			*out = new(bool)
			**out = **in
		}
	}
	if in.HorizontalPodAutoscalerSyncPeriod != nil {
		in, out := &in.HorizontalPodAutoscalerSyncPeriod, &out.HorizontalPodAutoscalerSyncPeriod
		if *in == nil {
			*out = nil
		} else {
			*out = new(v1.Duration)
			**out = **in
		}
	}
	if in.HorizontalPodAutoscalerDownscaleDelay != nil {
		in, out := &in.HorizontalPodAutoscalerDownscaleDelay, &out.HorizontalPodAutoscalerDownscaleDelay
		if *in == nil {
			*out = nil
		} else {
			*out = new(v1.Duration)
			**out = **in
		}
	}
	if in.HorizontalPodAutoscalerUpscaleDelay != nil {
		in, out := &in.HorizontalPodAutoscalerUpscaleDelay, &out.HorizontalPodAutoscalerUpscaleDelay
		if *in == nil {
			*out = nil
		} else {
			*out = new(v1.Duration)
			**out = **in
		}
	}
	if in.HorizontalPodAutoscalerUseRestClients != nil {
		in, out := &in.HorizontalPodAutoscalerUseRestClients, &out.HorizontalPodAutoscalerUseRestClients
		if *in == nil {
			*out = nil
		} else {
			*out = new(bool)
			**out = **in
		}
	}
	if in.FeatureGates != nil {
		in, out := &in.FeatureGates, &out.FeatureGates
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubeControllerManagerConfig.
func (in *KubeControllerManagerConfig) DeepCopy() *KubeControllerManagerConfig {
	if in == nil {
		return nil
	}
	out := new(KubeControllerManagerConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubeDNSConfig) DeepCopyInto(out *KubeDNSConfig) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubeDNSConfig.
func (in *KubeDNSConfig) DeepCopy() *KubeDNSConfig {
	if in == nil {
		return nil
	}
	out := new(KubeDNSConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubeProxyConfig) DeepCopyInto(out *KubeProxyConfig) {
	*out = *in
	if in.Enabled != nil {
		in, out := &in.Enabled, &out.Enabled
		if *in == nil {
			*out = nil
		} else {
			*out = new(bool)
			**out = **in
		}
	}
	if in.FeatureGates != nil {
		in, out := &in.FeatureGates, &out.FeatureGates
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubeProxyConfig.
func (in *KubeProxyConfig) DeepCopy() *KubeProxyConfig {
	if in == nil {
		return nil
	}
	out := new(KubeProxyConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubeSchedulerConfig) DeepCopyInto(out *KubeSchedulerConfig) {
	*out = *in
	if in.LeaderElection != nil {
		in, out := &in.LeaderElection, &out.LeaderElection
		if *in == nil {
			*out = nil
		} else {
			*out = new(LeaderElectionConfiguration)
			(*in).DeepCopyInto(*out)
		}
	}
	if in.UsePolicyConfigMap != nil {
		in, out := &in.UsePolicyConfigMap, &out.UsePolicyConfigMap
		if *in == nil {
			*out = nil
		} else {
			*out = new(bool)
			**out = **in
		}
	}
	if in.FeatureGates != nil {
		in, out := &in.FeatureGates, &out.FeatureGates
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubeSchedulerConfig.
func (in *KubeSchedulerConfig) DeepCopy() *KubeSchedulerConfig {
	if in == nil {
		return nil
	}
	out := new(KubeSchedulerConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubeletConfigSpec) DeepCopyInto(out *KubeletConfigSpec) {
	*out = *in
	if in.AnonymousAuth != nil {
		in, out := &in.AnonymousAuth, &out.AnonymousAuth
		if *in == nil {
			*out = nil
		} else {
			*out = new(bool)
			**out = **in
		}
	}
	if in.RequireKubeconfig != nil {
		in, out := &in.RequireKubeconfig, &out.RequireKubeconfig
		if *in == nil {
			*out = nil
		} else {
			*out = new(bool)
			**out = **in
		}
	}
	if in.LogLevel != nil {
		in, out := &in.LogLevel, &out.LogLevel
		if *in == nil {
			*out = nil
		} else {
			*out = new(int32)
			**out = **in
		}
	}
	if in.SeccompProfileRoot != nil {
		in, out := &in.SeccompProfileRoot, &out.SeccompProfileRoot
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.AllowPrivileged != nil {
		in, out := &in.AllowPrivileged, &out.AllowPrivileged
		if *in == nil {
			*out = nil
		} else {
			*out = new(bool)
			**out = **in
		}
	}
	if in.EnableDebuggingHandlers != nil {
		in, out := &in.EnableDebuggingHandlers, &out.EnableDebuggingHandlers
		if *in == nil {
			*out = nil
		} else {
			*out = new(bool)
			**out = **in
		}
	}
	if in.RegisterNode != nil {
		in, out := &in.RegisterNode, &out.RegisterNode
		if *in == nil {
			*out = nil
		} else {
			*out = new(bool)
			**out = **in
		}
	}
	if in.NodeStatusUpdateFrequency != nil {
		in, out := &in.NodeStatusUpdateFrequency, &out.NodeStatusUpdateFrequency
		if *in == nil {
			*out = nil
		} else {
			*out = new(v1.Duration)
			**out = **in
		}
	}
	if in.ReadOnlyPort != nil {
		in, out := &in.ReadOnlyPort, &out.ReadOnlyPort
		if *in == nil {
			*out = nil
		} else {
			*out = new(int32)
			**out = **in
		}
	}
	if in.ConfigureCBR0 != nil {
		in, out := &in.ConfigureCBR0, &out.ConfigureCBR0
		if *in == nil {
			*out = nil
		} else {
			*out = new(bool)
			**out = **in
		}
	}
	if in.BabysitDaemons != nil {
		in, out := &in.BabysitDaemons, &out.BabysitDaemons
		if *in == nil {
			*out = nil
		} else {
			*out = new(bool)
			**out = **in
		}
	}
	if in.MaxPods != nil {
		in, out := &in.MaxPods, &out.MaxPods
		if *in == nil {
			*out = nil
		} else {
			*out = new(int32)
			**out = **in
		}
	}
	if in.ResolverConfig != nil {
		in, out := &in.ResolverConfig, &out.ResolverConfig
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.ReconcileCIDR != nil {
		in, out := &in.ReconcileCIDR, &out.ReconcileCIDR
		if *in == nil {
			*out = nil
		} else {
			*out = new(bool)
			**out = **in
		}
	}
	if in.RegisterSchedulable != nil {
		in, out := &in.RegisterSchedulable, &out.RegisterSchedulable
		if *in == nil {
			*out = nil
		} else {
			*out = new(bool)
			**out = **in
		}
	}
	if in.SerializeImagePulls != nil {
		in, out := &in.SerializeImagePulls, &out.SerializeImagePulls
		if *in == nil {
			*out = nil
		} else {
			*out = new(bool)
			**out = **in
		}
	}
	if in.NodeLabels != nil {
		in, out := &in.NodeLabels, &out.NodeLabels
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.EnableCustomMetrics != nil {
		in, out := &in.EnableCustomMetrics, &out.EnableCustomMetrics
		if *in == nil {
			*out = nil
		} else {
			*out = new(bool)
			**out = **in
		}
	}
	if in.NetworkPluginMTU != nil {
		in, out := &in.NetworkPluginMTU, &out.NetworkPluginMTU
		if *in == nil {
			*out = nil
		} else {
			*out = new(int32)
			**out = **in
		}
	}
	if in.ImageGCHighThresholdPercent != nil {
		in, out := &in.ImageGCHighThresholdPercent, &out.ImageGCHighThresholdPercent
		if *in == nil {
			*out = nil
		} else {
			*out = new(int32)
			**out = **in
		}
	}
	if in.ImageGCLowThresholdPercent != nil {
		in, out := &in.ImageGCLowThresholdPercent, &out.ImageGCLowThresholdPercent
		if *in == nil {
			*out = nil
		} else {
			*out = new(int32)
			**out = **in
		}
	}
	if in.ImagePullProgressDeadline != nil {
		in, out := &in.ImagePullProgressDeadline, &out.ImagePullProgressDeadline
		if *in == nil {
			*out = nil
		} else {
			*out = new(v1.Duration)
			**out = **in
		}
	}
	if in.EvictionHard != nil {
		in, out := &in.EvictionHard, &out.EvictionHard
		if *in == nil {
			*out = nil
		} else {
			*out = new(string)
			**out = **in
		}
	}
	if in.EvictionPressureTransitionPeriod != nil {
		in, out := &in.EvictionPressureTransitionPeriod, &out.EvictionPressureTransitionPeriod
		if *in == nil {
			*out = nil
		} else {
			*out = new(v1.Duration)
			**out = **in
		}
	}
	if in.Taints != nil {
		in, out := &in.Taints, &out.Taints
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.FeatureGates != nil {
		in, out := &in.FeatureGates, &out.FeatureGates
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.KubeReserved != nil {
		in, out := &in.KubeReserved, &out.KubeReserved
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.SystemReserved != nil {
		in, out := &in.SystemReserved, &out.SystemReserved
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.RuntimeRequestTimeout != nil {
		in, out := &in.RuntimeRequestTimeout, &out.RuntimeRequestTimeout
		if *in == nil {
			*out = nil
		} else {
			*out = new(v1.Duration)
			**out = **in
		}
	}
	if in.VolumeStatsAggPeriod != nil {
		in, out := &in.VolumeStatsAggPeriod, &out.VolumeStatsAggPeriod
		if *in == nil {
			*out = nil
		} else {
			*out = new(v1.Duration)
			**out = **in
		}
	}
	if in.FailSwapOn != nil {
		in, out := &in.FailSwapOn, &out.FailSwapOn
		if *in == nil {
			*out = nil
		} else {
			*out = new(bool)
			**out = **in
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubeletConfigSpec.
func (in *KubeletConfigSpec) DeepCopy() *KubeletConfigSpec {
	if in == nil {
		return nil
	}
	out := new(KubeletConfigSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubenetNetworkingSpec) DeepCopyInto(out *KubenetNetworkingSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubenetNetworkingSpec.
func (in *KubenetNetworkingSpec) DeepCopy() *KubenetNetworkingSpec {
	if in == nil {
		return nil
	}
	out := new(KubenetNetworkingSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubernetesVersionSpec) DeepCopyInto(out *KubernetesVersionSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubernetesVersionSpec.
func (in *KubernetesVersionSpec) DeepCopy() *KubernetesVersionSpec {
	if in == nil {
		return nil
	}
	out := new(KubernetesVersionSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KuberouterNetworkingSpec) DeepCopyInto(out *KuberouterNetworkingSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KuberouterNetworkingSpec.
func (in *KuberouterNetworkingSpec) DeepCopy() *KuberouterNetworkingSpec {
	if in == nil {
		return nil
	}
	out := new(KuberouterNetworkingSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LeaderElectionConfiguration) DeepCopyInto(out *LeaderElectionConfiguration) {
	*out = *in
	if in.LeaderElect != nil {
		in, out := &in.LeaderElect, &out.LeaderElect
		if *in == nil {
			*out = nil
		} else {
			*out = new(bool)
			**out = **in
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LeaderElectionConfiguration.
func (in *LeaderElectionConfiguration) DeepCopy() *LeaderElectionConfiguration {
	if in == nil {
		return nil
	}
	out := new(LeaderElectionConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LoadBalancerAccessSpec) DeepCopyInto(out *LoadBalancerAccessSpec) {
	*out = *in
	if in.IdleTimeoutSeconds != nil {
		in, out := &in.IdleTimeoutSeconds, &out.IdleTimeoutSeconds
		if *in == nil {
			*out = nil
		} else {
			*out = new(int64)
			**out = **in
		}
	}
	if in.AdditionalSecurityGroups != nil {
		in, out := &in.AdditionalSecurityGroups, &out.AdditionalSecurityGroups
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LoadBalancerAccessSpec.
func (in *LoadBalancerAccessSpec) DeepCopy() *LoadBalancerAccessSpec {
	if in == nil {
		return nil
	}
	out := new(LoadBalancerAccessSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NetworkingSpec) DeepCopyInto(out *NetworkingSpec) {
	*out = *in
	if in.Classic != nil {
		in, out := &in.Classic, &out.Classic
		if *in == nil {
			*out = nil
		} else {
			*out = new(ClassicNetworkingSpec)
			**out = **in
		}
	}
	if in.Kubenet != nil {
		in, out := &in.Kubenet, &out.Kubenet
		if *in == nil {
			*out = nil
		} else {
			*out = new(KubenetNetworkingSpec)
			**out = **in
		}
	}
	if in.External != nil {
		in, out := &in.External, &out.External
		if *in == nil {
			*out = nil
		} else {
			*out = new(ExternalNetworkingSpec)
			**out = **in
		}
	}
	if in.CNI != nil {
		in, out := &in.CNI, &out.CNI
		if *in == nil {
			*out = nil
		} else {
			*out = new(CNINetworkingSpec)
			**out = **in
		}
	}
	if in.Kopeio != nil {
		in, out := &in.Kopeio, &out.Kopeio
		if *in == nil {
			*out = nil
		} else {
			*out = new(KopeioNetworkingSpec)
			**out = **in
		}
	}
	if in.Weave != nil {
		in, out := &in.Weave, &out.Weave
		if *in == nil {
			*out = nil
		} else {
			*out = new(WeaveNetworkingSpec)
			(*in).DeepCopyInto(*out)
		}
	}
	if in.Flannel != nil {
		in, out := &in.Flannel, &out.Flannel
		if *in == nil {
			*out = nil
		} else {
			*out = new(FlannelNetworkingSpec)
			**out = **in
		}
	}
	if in.Calico != nil {
		in, out := &in.Calico, &out.Calico
		if *in == nil {
			*out = nil
		} else {
			*out = new(CalicoNetworkingSpec)
			**out = **in
		}
	}
	if in.Canal != nil {
		in, out := &in.Canal, &out.Canal
		if *in == nil {
			*out = nil
		} else {
			*out = new(CanalNetworkingSpec)
			**out = **in
		}
	}
	if in.Kuberouter != nil {
		in, out := &in.Kuberouter, &out.Kuberouter
		if *in == nil {
			*out = nil
		} else {
			*out = new(KuberouterNetworkingSpec)
			**out = **in
		}
	}
	if in.Romana != nil {
		in, out := &in.Romana, &out.Romana
		if *in == nil {
			*out = nil
		} else {
			*out = new(RomanaNetworkingSpec)
			**out = **in
		}
	}
	if in.AmazonVPC != nil {
		in, out := &in.AmazonVPC, &out.AmazonVPC
		if *in == nil {
			*out = nil
		} else {
			*out = new(AmazonVPCNetworkingSpec)
			**out = **in
		}
	}
	if in.Cilium != nil {
		in, out := &in.Cilium, &out.Cilium
		if *in == nil {
			*out = nil
		} else {
			*out = new(CiliumNetworkingSpec)
			**out = **in
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NetworkingSpec.
func (in *NetworkingSpec) DeepCopy() *NetworkingSpec {
	if in == nil {
		return nil
	}
	out := new(NetworkingSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NoopStatusStore) DeepCopyInto(out *NoopStatusStore) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NoopStatusStore.
func (in *NoopStatusStore) DeepCopy() *NoopStatusStore {
	if in == nil {
		return nil
	}
	out := new(NoopStatusStore)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RBACAuthorizationSpec) DeepCopyInto(out *RBACAuthorizationSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RBACAuthorizationSpec.
func (in *RBACAuthorizationSpec) DeepCopy() *RBACAuthorizationSpec {
	if in == nil {
		return nil
	}
	out := new(RBACAuthorizationSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RomanaNetworkingSpec) DeepCopyInto(out *RomanaNetworkingSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RomanaNetworkingSpec.
func (in *RomanaNetworkingSpec) DeepCopy() *RomanaNetworkingSpec {
	if in == nil {
		return nil
	}
	out := new(RomanaNetworkingSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SSHCredential) DeepCopyInto(out *SSHCredential) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	out.Spec = in.Spec
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SSHCredential.
func (in *SSHCredential) DeepCopy() *SSHCredential {
	if in == nil {
		return nil
	}
	out := new(SSHCredential)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *SSHCredential) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SSHCredentialList) DeepCopyInto(out *SSHCredentialList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]SSHCredential, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SSHCredentialList.
func (in *SSHCredentialList) DeepCopy() *SSHCredentialList {
	if in == nil {
		return nil
	}
	out := new(SSHCredentialList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *SSHCredentialList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SSHCredentialSpec) DeepCopyInto(out *SSHCredentialSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SSHCredentialSpec.
func (in *SSHCredentialSpec) DeepCopy() *SSHCredentialSpec {
	if in == nil {
		return nil
	}
	out := new(SSHCredentialSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TargetSpec) DeepCopyInto(out *TargetSpec) {
	*out = *in
	if in.Terraform != nil {
		in, out := &in.Terraform, &out.Terraform
		if *in == nil {
			*out = nil
		} else {
			*out = new(TerraformSpec)
			(*in).DeepCopyInto(*out)
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TargetSpec.
func (in *TargetSpec) DeepCopy() *TargetSpec {
	if in == nil {
		return nil
	}
	out := new(TargetSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TerraformSpec) DeepCopyInto(out *TerraformSpec) {
	*out = *in
	if in.ProviderExtraConfig != nil {
		in, out := &in.ProviderExtraConfig, &out.ProviderExtraConfig
		if *in == nil {
			*out = nil
		} else {
			*out = new(map[string]string)
			if **in != nil {
				in, out := *in, *out
				*out = make(map[string]string, len(*in))
				for key, val := range *in {
					(*out)[key] = val
				}
			}
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TerraformSpec.
func (in *TerraformSpec) DeepCopy() *TerraformSpec {
	if in == nil {
		return nil
	}
	out := new(TerraformSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TopologySpec) DeepCopyInto(out *TopologySpec) {
	*out = *in
	if in.Bastion != nil {
		in, out := &in.Bastion, &out.Bastion
		if *in == nil {
			*out = nil
		} else {
			*out = new(BastionSpec)
			(*in).DeepCopyInto(*out)
		}
	}
	if in.DNS != nil {
		in, out := &in.DNS, &out.DNS
		if *in == nil {
			*out = nil
		} else {
			*out = new(DNSSpec)
			**out = **in
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TopologySpec.
func (in *TopologySpec) DeepCopy() *TopologySpec {
	if in == nil {
		return nil
	}
	out := new(TopologySpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UserData) DeepCopyInto(out *UserData) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UserData.
func (in *UserData) DeepCopy() *UserData {
	if in == nil {
		return nil
	}
	out := new(UserData)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *WeaveNetworkingSpec) DeepCopyInto(out *WeaveNetworkingSpec) {
	*out = *in
	if in.MTU != nil {
		in, out := &in.MTU, &out.MTU
		if *in == nil {
			*out = nil
		} else {
			*out = new(int32)
			**out = **in
		}
	}
	if in.ConnLimit != nil {
		in, out := &in.ConnLimit, &out.ConnLimit
		if *in == nil {
			*out = nil
		} else {
			*out = new(int32)
			**out = **in
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new WeaveNetworkingSpec.
func (in *WeaveNetworkingSpec) DeepCopy() *WeaveNetworkingSpec {
	if in == nil {
		return nil
	}
	out := new(WeaveNetworkingSpec)
	in.DeepCopyInto(out)
	return out
}
