// Copyright (c) 2016, 2018, Oracle and/or its affiliates. All rights reserved.
// Code generated. DO NOT EDIT.

package identity

import (
	"github.com/oracle/oci-go-sdk/common"
	"net/http"
)

// GetUserGroupMembershipRequest wrapper for the GetUserGroupMembership operation
type GetUserGroupMembershipRequest struct {

	// The OCID of the userGroupMembership.
	UserGroupMembershipId *string `mandatory:"true" contributesTo:"path" name:"userGroupMembershipId"`
}

func (request GetUserGroupMembershipRequest) String() string {
	return common.PointerString(request)
}

// GetUserGroupMembershipResponse wrapper for the GetUserGroupMembership operation
type GetUserGroupMembershipResponse struct {

	// The underlying http response
	RawResponse *http.Response

	// The UserGroupMembership instance
	UserGroupMembership `presentIn:"body"`

	// Unique Oracle-assigned identifier for the request. If you need to contact Oracle about a
	// particular request, please provide the request ID.
	OpcRequestId *string `presentIn:"header" name:"opc-request-id"`

	// For optimistic concurrency control. See `if-match`.
	Etag *string `presentIn:"header" name:"etag"`
}

func (response GetUserGroupMembershipResponse) String() string {
	return common.PointerString(response)
}
