/*===========================================================================
  MakeLib.cpp:   Written by Yiping Cheng (Email: ypcheng@ustc.edu)
  
  The scenario is that we are given a dll and an .h interface file for the
  dll, and we wish to have a lib to allow implicit call of the dll.
  
  We achieve this by writing a trivial wrapper of the original dll
  so that the external behavior of the wrapper dll is the same as the 
  original one. Now as we have a DEF file and this source file, VC will
  generate a dll (which is the trivial wrapper) and a lib (which is what we
  want). The generated lib file can be used as if it is the lib of the 
  original dll.

  Normally the lib file is the only one we want to have. But in some cases
  you may want to intercept the calls to the original exported functions for 
  debugging or hacking purposes, then you can modify the implementation of 
  the wrapper functions, to do things before and/or after making
  calls to the original version.
  
  This application is free software; you can redistribute it and/or
  modify it under the terms of the Code Project Open License as
  set out at http://www.codeproject.com/info/EULA.aspx.

  Please email me to send suggestions and/or report bugs.
---------------------------------------------------------------------------*/

// Modified to libmwma57.cpp J. Currie October 2012

#include "libmwma57.h"

//Functions used by IPOPT
extern "C" FUNCDEF_MA57AD(MA57AD) {}
extern "C" FUNCDEF_MA57BD(MA57BD) {}
extern "C" FUNCDEF_MA57CD(MA57CD) {}
extern "C" FUNCDEF_MA57ED(MA57ED) {}
extern "C" FUNCDEF_MA57ID(MA57ID) {}
//Unused functions
extern "C" FUNCDEF_MA57DD(MA57DD) {}
extern "C" FUNCDEF_MA57LF(MA57LF) {}

