/*===========================================================================
  MacrosSample.h: Contains a number of useful macros
  Written by Yiping Cheng (Email: ypcheng@ustc.edu)
  
  This application is free software; you can redistribute it and/or
  modify it under the terms of the Code Project Open License as
  set out at http://www.codeproject.com/info/EULA.aspx.

  Please email me to send suggestions and/or report bugs.
---------------------------------------------------------------------------*/

// Modified to libmwma57.h J. Currie October 2012

#pragma once

//Allows 64bit integers on 64bit systems
typedef size_t ipfint;

/** Prototypes for MA57's Fortran subroutines */

/* MA57ID -- Initialize solver */
#define FUNCDEF_MA57ID(MA57ID) \
void  MA57ID (double *cntl, ipfint *icntl)

/* MA57AD -- Symbolic Factorization */
#define FUNCDEF_MA57AD(MA57AD) \
void  MA57AD (ipfint *n,  ipfint *ne, const ipfint *irn, const ipfint *jcn, ipfint *lkeep, ipfint *keep, ipfint *iwork, ipfint *icntl, ipfint *info, double *rinfo) 

/* MA57BD -- Numerical Factorization */
#define FUNCDEF_MA57BD(MA57BD) \
void  MA57BD (ipfint *n, ipfint *ne, double *a,  double *fact, ipfint *lfact, ipfint *ifact, ipfint *lifact, ipfint *lkeep, ipfint *keep, ipfint *iwork, ipfint *icntl, double *cntl, ipfint *info, double *rinfo)

/* MA57CD -- Solution */
#define FUNCDEF_MA57CD(MA57CD) \
void MA57CD (ipfint *job, ipfint *n, double *fact, ipfint *lfact, ipfint *ifact, ipfint *lifact, ipfint *nrhs, double *rhs, ipfint *lrhs, double *work, ipfint *lwork, ipfint *iwork, ipfint *icntl, ipfint *info)

/* MA57ED -- Copy arrays */
#define FUNCDEF_MA57ED(MA57ED) \
void  MA57ED(ipfint *n, ipfint *ic, ipfint *keep, double *fact, ipfint *lfact, double *newfac, ipfint *lnew, ipfint *ifact, ipfint *lifact, ipfint *newifc, ipfint *linew, ipfint *info)

/* MA57DD -- Solution with Iterative Refinement */
#define FUNCDEF_MA57DD(MA57DD) \
void MA57DD(ipfint *job, ipfint *n, ipfint *ne, double *a, ipfint *irn, ipfint *jcn, double *fact, ipfint *lfact, ipfint *ifact, ipfint *lifact, double *rhs, double *x, double *resid, double *work, ipfint *iwork, ipfint *icntl, double *cntl, ipfint *info, double *rinfo)

/* MA57LF -- Extract factors from BD (Internal Matlab LDL Use Only) */
#define FUNCDEF_MA57LF(MA57LF) \
void MA57LF(ipfint *n, double *fact, ipfint *lfact, ipfint *ifact, ipfint *lifact, ipfint *irn, ipfint *jcn, double *fl, ipfint *nnz, ipfint *id, ipfint *jd, double *d, ipfint *nnzd, ipfint *ivp, ipfint *iperm, double *s64, ipfint *info, ipfint *icntl)