# About

Gerardus is an ecclectic collection of Matlab toolboxes, bash scripts and C++ programs produced as a result
of research carried out by post docs and students who collaborate with Prof. Vicente Grau at the Institute of
Biomedical Engineering, University of Oxford, UK.

Our research is focused primarily on medical imaging and computational biology.

Gerardus started as Dr. Ramón Casero's personal project in Jan 2009 as a way to keep track of his research 
software while working as a post-doc in Oxford under Prof. Grau, Prof. Peter Kohl and Dr. Jürgen Schneider. 
The project started with some code that he had developed the previous years for his DPhil thesis at Oxford, 
and was intially hosted in a GoogleCode internal subversion repository. From Oct 2014, it became more of a 
group project with collaborations from other post-docs (Dr. Darryl McClymont, Dr. Valentina Carapella) and 
students (Joanne Bates, Christopher Kelly, Ben Villard, Tasos Papastylianou) in the group. In Apr 2015 the 
project migrated to github, as a repository in Ramón's account (https://github.com/rcasero/gerardus). 
Between Nov 2015 - Apr 2016 the project was led by Darryl, while Ramón was on leave. On 10 Jul 2016, the 
repository moved to the "vigente" organization account (https://github.com/vigente/gerardus), so that
it would be less of a personal project.

Trivia: Gerardus Mercator (1512–1594) was a Flemish cartographer, and the first to use the word 
"atlas" to describe a collection of maps.

# Contact

For questions, please open a new issue in the [issues list](https://github.com/vigente/gerardus/issues).

# Download and build

The latest version of the code can be pulled from the master branch of this GitHub repository.

Gerardus contains Matlab functions that can be run directly without building any code. There are also C++ programs and C++ MEX files that need to be compiled and installed before they can be run.

If you need the programs and/or MEX files, follow the [instructions to build and install Gerardus](https://github.com/rcasero/gerardus/wiki/Build-instructions).

See the most updated list of all available functions:

* [Matlab functions](matlab/README)
* [shell scripts](shell-script/README)
* [java code](java/README)
* [C++/ITK command line programs](cpp/README)

# Papers

The code for published papers can be found in the folder here: https://github.com/rcasero/gerardus/tree/papers

