/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/*                                                                           */
/*                  This file is part of the program and library             */
/*         SCIP --- Solving Constraint Integer Programs                      */
/*                                                                           */
/*    Copyright (C) 2002-2013 Konrad-Zuse-Zentrum                            */
/*                            fuer Informationstechnik Berlin                */
/*                                                                           */
/*  SCIP is distributed under the terms of the ZIB Academic License.         */
/*                                                                           */
/*  You should have received a copy of the ZIB Academic License              */
/*  along with SCIP; see the file COPYING. If not email to scip@zib.de.      */
/*                                                                           */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/**@file   reader_wbo.h
 * @ingroup FILEREADERS
 * @brief  WBO file reader (LP format with generic variables and row names)
 * @author Michael Winkler
 *
 * This file reader parses the @a wbo format by using the @a opb reader. For a detailed description of this format
 * see http://www.cril.univ-artois.fr/PB10/format.pdf .
 */

/*---+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0----+----1----+----2*/

#ifndef __SCIP_READER_WBO_H__
#define __SCIP_READER_WBO_H__


#include "scip/scip.h"

#ifdef __cplusplus
extern "C" {
#endif

/** includes the wbo file reader into SCIP */
EXTERN
SCIP_RETCODE SCIPincludeReaderWbo(
   SCIP*                 scip                /**< SCIP data structure */
   );

#ifdef __cplusplus
}
#endif

#endif
