function [ res ] = inverse_TV_2D( y )
%INVERSE_TV_D Inverse total variation of a 2D image
%   Returns the inverse of forward_TV_2D
%
%   Y is a concatenated array of partial derivatives generated by
%   forward_TV
%     
%   res is the residuals
%
%   If you need to actual residuals of the TV, do this:
%   [TV TV_grad] = forward_TV(I);
%   resids = inverse_TV(TV_grad/4);
%   Subtracting these residuals will essentially put every voxel midway
%   between its neighbours. The 4 is needed because each voxel has 4
%   neighbours, so it's like taking a mean of the difference between each of
%   them.

% Author: Darryl McClymont <darryl.mcclymont@gmail.com>
% Copyright  2014 University of Oxford
% Version: 0.1.1
% 
% University of Oxford means the Chancellor, Masters and Scholars of
% the University of Oxford, having an administrative office at
% Wellington Square, Oxford OX1 2JD, UK. 
%
% This file is part of Gerardus.
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details. The offer of this
% program under the terms of the License is subject to the License
% being interpreted in accordance with English Law and subject to any
% action against the University of Oxford being under the jurisdiction
% of the English Courts.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.

% check arguments
narginchk(1,1);
nargoutchk(0, 1);

res = adjDx(y(:,:,1)) + adjDy(y(:,:,2));


end

function res = adjDy(x)
    res = x(:,[1,1:end-1]) - x;
    res(:,1) = -x(:,1);
    res(:,end) = x(:,end-1);
end

function res = adjDx(x)
    res = x([1,1:end-1],:) - x;
    res(1,:) = -x(1,:);
    res(end,:) = x(end-1,:);
end
