function lnZ = computelnZ (L, w, nu, eta, xi, gamma, Phi, lnZconst)
  
  D = length(L);    % The number of documents.
  K = length(nu);   % The number of topics.
  W = length(eta);  % The size of the vocabulary.
  
  m   = computem(L,w,W,K,Phi);
  lnZ = lnZconst ...
        - sum(gammaln(sum(xi))) ...
        + sum(gammaln(xi(:))) ...
        - sum(gammaln(sum(gamma))) ...
        + sum(gammaln(gamma(:))) ...
        - sum(Phi(:) .* log(Phi(:))) ...
        + sum(sum((digamma(xi) - repmat(digamma(sum(xi)),W,1)) .* ...
                  (repmat(eta,1,K) + m - xi)));
  
  % Repeat for every document.
  is = 0;
  for d = 1:D
    is  = is(end) + (1:L(d));
    g   = gamma(:,d);
    lnZ = lnZ + sum((digamma(g) - digamma(sum(g))) ...
                    .* (nu + row_sum(Phi(:,is)) - g));
  end
