/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.viewreka.extras.editor;

import java.net.URL;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import jfxtras.scene.control.CalendarTextField;
import org.beryx.viewreka.core.DataException;
import org.beryx.viewreka.gui.editor.ParameterEditor;
import org.beryx.viewreka.parameter.DateConfiguration;
import org.beryx.viewreka.parameter.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeParameterEditor<T>
extends ParameterEditor<T> {
    private static final Logger log = LoggerFactory.getLogger(DateTimeParameterEditor.class);
    public static final String ATTR_SHOW_TIME = "show.time";
    private final DateConfiguration<T> dateConfig;
    @FXML
    private Label lbPrmName;
    @FXML
    private CalendarTextField calendarText;

    public DateTimeParameterEditor(Parameter<T> parameter, Map<String, String> attributes) {
        super(parameter, attributes);
        if (!(parameter instanceof DateConfiguration)) {
            throw new DataException("Parameter " + parameter.getName() + " does not implement DateConfiguration, therefore is not compatible with DateTimeParameterEditor.");
        }
        this.dateConfig = (DateConfiguration)parameter;
    }

    public <TT> void valueChanged(Parameter<TT> prm, TT oldValue) {
        throw new UnsupportedOperationException("A DateTimeParameterEditor cannot act as ParameterListener.");
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.check("lbPrmName", (Node)this.lbPrmName);
        this.check("calendarText", (Node)this.calendarText);
        log.debug("Initializing DateTimeParameterEditor({}). Editor attributes: {}", (Object)this.parameter, (Object)this.attributes);
        this.lbPrmName.setText(this.parameter.getName());
        Locale locale = this.dateConfig.getLocale();
        this.calendarText.setLocale(locale);
        this.calendarText.setDateFormat(this.dateConfig.getDateFormat());
        this.calendarText.setShowTime(Boolean.valueOf((String)this.attributes.get(ATTR_SHOW_TIME)));
        log.debug("locale: {}, datePattern: {}", (Object)locale, (Object)this.dateConfig.getDatePattern());
        this.calendarText.setAllowNull(this.parameter.isNullAllowed());
        String sVal = this.parameter.getValueAsString();
        if (sVal != null && !"null".equals(sVal)) {
            Calendar calendar = Calendar.getInstance(locale);
            try {
                Date date = this.dateConfig.getDateFormat().parse(sVal);
                calendar.setTime(date);
                this.calendarText.setCalendar(calendar);
            }
            catch (ParseException e) {
                throw new DataException("Parameter " + this.parameter.getName() + ": cannot parse '" + sVal + "' using the date format '" + this.dateConfig.getDatePattern() + "'");
            }
        }
        this.calendarText.calendarProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue == null) {
                this.parameter.setValue(null);
            } else {
                long millis = newValue.getTimeInMillis();
                this.parameter.setValue(this.dateConfig.fromMilliseconds(millis));
            }
            this.updateControls();
        });
        this.calendarText.textProperty().addListener((observable, oldValue, newValue) -> this.updateControls());
    }

    public void updateControls() {
    }
}

